/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result.slicer;

import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleSlicerFilter;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRanges;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import java.io.Serializable;
import java.util.ArrayList;

public class OlapAxisSlicerTupleFilter
extends OlapTupleSlicerFilter {
    private final OlapTupleSlicerFilter slicer;
    private final OlapAxisInstr axisForSlicerHierarchyUsageAssertion;
    private volatile boolean slicerHierarchyUsageAssertionDone;

    public OlapAxisSlicerTupleFilter(OlapAxisInstr axisInstr, OlapTupleSlicerFilter slicer) {
        this.slicer = slicer;
        this.axisForSlicerHierarchyUsageAssertion = axisInstr;
        this.slicerHierarchyUsageAssertionDone = false;
    }

    @Override
    public String getName() {
        return "slicer-axis-dimension";
    }

    @Override
    public boolean isFilteringHierarchy(OlapHierarchy hierarchy) {
        return this.slicer.isFilteringHierarchy(hierarchy);
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        if (!this.slicerHierarchyUsageAssertionDone) {
            this.assertSlicerHierarchyUsage(member);
        }
        return this.slicer.isAccepting(member);
    }

    @Override
    public boolean isAccepting(IOlapTuple tuple) {
        if (!this.slicerHierarchyUsageAssertionDone) {
            this.assertSlicerHierarchyUsage(tuple);
        }
        return this.slicer.isAccepting(tuple);
    }

    private void assertSlicerHierarchyUsage(IOlapTuple tuple) {
        int count = tuple.getMemberCount();
        for (int idx = 0; idx < count; ++idx) {
            OlapMember member = tuple.getMember(idx);
            if (!this.slicer.hasHierarchy(member.getHierarchy())) continue;
            this.throwException(member);
        }
        this.slicerHierarchyUsageAssertionDone = true;
    }

    private void throwException(OlapMember member) {
        OlapSlicerInstr slicerInstr = this.getSlicerInstr();
        ArrayList<OlapInstrLocationRange> ranges = new ArrayList<OlapInstrLocationRange>();
        if (this.axisForSlicerHierarchyUsageAssertion != null) {
            ranges.add(this.axisForSlicerHierarchyUsageAssertion.getLocationRange());
        }
        ranges.add(slicerInstr.getLocationRange());
        OlapInstrLocationRanges axisRanges = new OlapInstrLocationRanges(slicerInstr.getLocationRange().mdx(), slicerInstr.getLocationRange().mdxHash(), ranges);
        String hierarchyName = ONames.uname4Log(member.getHierarchy());
        OlapError<OlapInstrLocationRanges, OlapErrorCode> error = new OlapError<OlapInstrLocationRanges, OlapErrorCode>(axisRanges, OlapErrorCode.SLICER_AXIS_MULTIPLE_HIERARCHY, new Serializable[]{hierarchyName});
        throw new OlapEvaluationException(error);
    }

    @Override
    public boolean hasHierarchy(OlapHierarchy hierarchy) {
        return this.slicer.hasHierarchy(hierarchy);
    }

    @Override
    public OlapSlicerInstr getSlicerInstr() {
        return this.slicer.getSlicerInstr();
    }
}

