/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptInfo;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapPostProcessedMdxResult;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapResSelectStatementDataSetTpp
extends OlapResStatementDataSet<OlapMdxStatementEvalStatistics> {
    private final OlapMdxStatementExecutionContext context;
    private final OlapPostProcessedMdxResult postProcessedTable;

    public OlapResSelectStatementDataSetTpp(OlapMdxStatementExecutionContext context, OlapPostProcessedMdxResult postProcessedTable, String mdx) {
        super(postProcessedTable.getSchemaName(), mdx);
        this.context = context;
        this.postProcessedTable = postProcessedTable;
    }

    @Override
    @Nullable
    public String getCubeName() {
        return this.postProcessedTable.getCubeName();
    }

    @Override
    public boolean isMdxAudit() {
        return true;
    }

    @Override
    @Nullable
    public String getCubeNameForMdxAudit() {
        return this.postProcessedTable.getCubeName();
    }

    @Override
    public OlapResScriptInfo asScriptResultInfo(CdBabylonService babylon) {
        return new OlapResScriptInfo("select", "...");
    }

    @Override
    @Nullable
    public OlapMdxStatementEvalStatistics getEvalStatistics() {
        return this.context.getEvalStatistics();
    }

    @Override
    public OlapNameContext getNameContext() {
        return this.context.getNameContext();
    }

    @Override
    @Nullable
    public OlapMember lookupCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        return this.context.getCalcMemberManager().lookupCalculatedMember(nameContext, id);
    }

    @Override
    public boolean hasCellsOnError() {
        return this.getCellError() != null;
    }

    @Override
    @Nullable
    public OlapException getCellError() {
        return this.postProcessedTable.getCellError();
    }

    public OlapPostProcessedMdxResult getTable() {
        return this.postProcessedTable;
    }

    @Override
    public void log(Logger logger, long requestId) {
        logger.info((Object)("MDX " + requestId + "    cells: " + this.postProcessedTable.logCellCount()));
        logger.info((Object)("MDX " + requestId + "     axes: " + this.postProcessedTable.logAxesTupleCount()));
        logger.info((Object)("MDX " + requestId + "     rows: " + this.postProcessedTable.logRowCount()));
        logger.info((Object)("MDX " + requestId + " max-rows: " + this.postProcessedTable.getTidyMaxRowCount() + " [reached:" + this.postProcessedTable.isTidyMaxRowCountReached() + "]"));
    }

    @Override
    public String toString() {
        return "SELECT-RESULT";
    }

    public IOlapSerializedTidyResource serializeAsJson(OlapEngineRequestContext context, @Nullable OlapResultStoreInformation info) throws IOException {
        return this.postProcessedTable.serializeAsJson(context, info);
    }
}

