/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import org.jetbrains.annotations.Nullable;

public class OlapResIntrinsicScopedDimensionProperty
extends OlapResScopedDimensionProperty {
    private final OlapIntrinsicMemberProperty property;
    @Nullable
    private final OlapNameIdentifiableEntity scope;

    public OlapResIntrinsicScopedDimensionProperty(OlapIntrinsicMemberProperty property, @Nullable OlapNameIdentifiableEntity scope) {
        this.property = property;
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.property.getName();
    }

    @Override
    public String getXmlaName(OlapNameContext nameContext) {
        return this.property.getXmlaName(nameContext);
    }

    @Override
    public CdXmlaSchemaType getXmlaType() {
        return this.property.getXmlaType();
    }

    @Override
    public String getXmlaScopedUniqueName(OlapNameContext nameContext) {
        if (this.scope != null) {
            return this.scope.getUniqueName(nameContext) + ".[" + this.getName() + "]";
        }
        return "[" + this.getName() + "]";
    }

    @Override
    public boolean isKey() {
        return OlapIntrinsicMemberProperties.MEMBER_KEY.equals(this.property) || OlapIntrinsicMemberProperties.KEY.equals(this.property) || this.property.isKEYx();
    }

    @Override
    public boolean isCaption() {
        return this.property.isCaption();
    }

    public OlapMemberProperty getProperty() {
        return this.property;
    }

    @Override
    @Nullable
    public OlapNameIdentifiableEntity getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
        if (this.scope != null) {
            return OlapResIntrinsicScopedDimensionProperty.doEvalWithScope(context, this.property, this.scope, member);
        }
        return OlapResIntrinsicScopedDimensionProperty.doEvalWithNoScope(context, this.property, member);
    }

    private static OlapScalarEntity doEvalWithNoScope(OlapMemberPropertyEvalContext context, OlapMemberProperty property, OlapMember member) {
        if (property.isContextSensitive() && !property.isKEYx()) {
            throw new CdProgrammingException("Inconsistent usage of doEvalWithNoScope() for property [" + property.getName() + "]");
        }
        return property.eval(context, member);
    }

    @Nullable
    private static OlapScalarEntity doEvalWithScope(OlapMemberPropertyEvalContext context, OlapMemberProperty property, OlapNameIdentifiableEntity scope, OlapMember member) {
        if (!property.isIntrinsic() || !property.isContextSensitive()) {
            // empty if block
        }
        if (scope.isScoping(member)) {
            return property.eval(context, member);
        }
        return null;
    }

    @Override
    public String toString() {
        return (String)(this.scope == null ? "" : ONames.uname4Log(this.scope) + ".") + this.getName();
    }
}

