/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.common.xmla.CdXmlaCellOrdinalHelper;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.result.model.IResCellData;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapResCellData
implements IResCellData {
    public static final OlapResCellData EMPTY = new OlapResCellData();
    private final List<OlapCellProperty> requestedProperties;
    private final CdXmlaCellOrdinalHelper ordinals;
    private final OlapResCell[] cells;

    private OlapResCellData() {
        this(OlapIntrinsicCellProperties.DEFAULT, new CdXmlaCellOrdinalHelper(new int[0]){

            public int getCellCount() {
                return 0;
            }
        }, new OlapResCell[0]);
    }

    public OlapResCellData(List<OlapCellProperty> requestedProperties, CdXmlaCellOrdinalHelper ordinals, OlapResCell[] cells) {
        this.requestedProperties = requestedProperties;
        this.ordinals = ordinals;
        this.cells = cells;
    }

    @Override
    public List<OlapCellProperty> getRequestedProperties() {
        return this.requestedProperties;
    }

    @Override
    public int getCellCount() {
        return this.cells.length;
    }

    public CdXmlaCellOrdinalHelper getOrdinals() {
        return this.ordinals;
    }

    @Override
    public int getMaxOrdinal() {
        return this.ordinals.getCellCount() - 1;
    }

    @Override
    public OlapResCell getCell(int ordinal) {
        if (ordinal < 0 || ordinal > this.getMaxOrdinal()) {
            throw new IllegalArgumentException("Wrong ordinal [" + ordinal + "] (range:0:" + this.getMaxOrdinal() + ")");
        }
        return this.cells[ordinal];
    }

    public OlapResCell getCell(int ... Si) {
        int ordinal = this.ordinals.computeCellOrdinal(Si);
        return this.getCell(ordinal);
    }

    @Override
    public boolean hasErrors() {
        for (int idx = 0; idx < this.cells.length; ++idx) {
            OlapResCell cell = this.cells[idx];
            if (!cell.isOnError()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public OlapException getError() {
        for (int idx = 0; idx < this.cells.length; ++idx) {
            OlapResCell cell = this.cells[idx];
            OlapException error = cell.getException();
            if (error == null) continue;
            return error;
        }
        return null;
    }
}

