/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.result.model.IResCell;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapResCell
implements IResCell {
    public static final OlapScalarEntity[] NO_VALUES = new OlapScalarEntity[0];
    private final int ordinal;
    private final List<OlapCellProperty> requestedProperties;
    private final OlapScalarEntity[] values;
    @Nullable
    private OlapEvalResultCellValue cellMeasure;

    protected OlapResCell(int ordinal) {
        this(ordinal, Collections.emptyList(), NO_VALUES);
    }

    protected OlapResCell(int ordinal, List<OlapCellProperty> requestedProperties, OlapScalarEntity[] values) {
        this.ordinal = ordinal;
        this.requestedProperties = requestedProperties;
        this.values = values;
        if (requestedProperties.size() == 0 || requestedProperties.size() != values.length) {
            throw new CdProgrammingException("Inconsistent cell [properties:" + requestedProperties.size() + "][values:" + values.length + "]");
        }
        for (int idx = 0; idx < requestedProperties.size(); ++idx) {
            OlapCellProperty property = requestedProperties.get(idx);
            if (!property.isCellOrdinal()) continue;
            values[idx] = new OlapNumericEntity(OlapIntrinsicCellProperties.CELL_ORDINAL.getXmlaType(), ordinal);
        }
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean isOnError() {
        return false;
    }

    @Override
    @Nullable
    public OlapException getException() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public List<OlapCellProperty> getRequestedProperties() {
        return this.requestedProperties;
    }

    public OlapScalarEntity[] getRequestedPropertyValues() {
        return this.values;
    }

    @Override
    @Nullable
    public OlapScalarEntity getRequestPropertyValue(OlapCellProperty property) {
        for (int pos = 0; pos < this.requestedProperties.size(); ++pos) {
            OlapCellProperty xproperty = this.requestedProperties.get(pos);
            if (!xproperty.equals(property)) continue;
            return this.values[pos];
        }
        return null;
    }

    @Nullable
    public OlapScalarEntity getRequestPropertyValue(int property) {
        return this.values[property];
    }

    public void attachCellMeasure(OlapEvalResultCellValue cellMeasure) {
        this.cellMeasure = cellMeasure;
    }

    @Nullable
    public OlapEvalResultCellValue getAttachedCellMeasure() {
        return this.cellMeasure;
    }

    public abstract String toString();
}

