/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.result;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapResAxisName {
    public static final String TIDY_PAGING = "#MEASURES";
    @Nullable
    private final String role;
    @Nullable
    private final Builtin builtin;
    private final long number;

    public OlapResAxisName(long number) {
        this(null, number);
    }

    public OlapResAxisName(Builtin builtin) {
        this.role = null;
        this.builtin = builtin;
        this.number = builtin == Builtin.Axes ? -1L : (long)builtin.ordinal();
    }

    public OlapResAxisName(@Nullable String role, long number) {
        this.role = role;
        this.number = number;
        this.builtin = number == 0L ? Builtin.Columns : (number == 1L ? Builtin.Rows : (number == 2L ? Builtin.Pages : (number == 3L ? Builtin.Sections : (number == 4L ? Builtin.Chapters : null))));
    }

    public boolean isAxes() {
        return Builtin.Axes == this.builtin;
    }

    @Nullable
    public String getRole() {
        return this.role;
    }

    public boolean isTidyPaging() {
        return TIDY_PAGING.equalsIgnoreCase(this.role);
    }

    @Nullable
    public Builtin getBuiltin() {
        return this.builtin;
    }

    public long getNumber() {
        return this.number;
    }

    public String getXmlaName() {
        return "Axis" + this.number;
    }

    public String toString() {
        return this.builtin == null ? String.valueOf(this.number) : this.builtin.name() + "(" + this.number + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapResAxisName that = (OlapResAxisName)o;
        return this.number == that.number && Objects.equals(this.role, that.role) && this.builtin == that.builtin;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.builtin, this.number});
    }

    public static enum Builtin {
        Columns,
        Rows,
        Pages,
        Sections,
        Chapters,
        Axes;

    }
}

