/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.member;

import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;

public final class OlapUserDefinedMemberProperty
extends OlapMemberProperty {
    private final OlapLevel level;
    private final OlapBuilderInputType inputType;
    private final boolean autoExportedToReportingMF;
    private final boolean isAttribute;

    public OlapUserDefinedMemberProperty(OlapLevel level, String name, OlapBuilderInputType inputType) {
        this(level, name, inputType, false, false);
    }

    public OlapUserDefinedMemberProperty(OlapLevel level, String name, OlapBuilderInputType inputType, boolean autoExportedToReportingMF, boolean isAttribute) {
        super(name, inputType.getXmlaType(), false, false);
        this.level = level;
        this.inputType = inputType;
        this.autoExportedToReportingMF = autoExportedToReportingMF;
        this.isAttribute = isAttribute;
    }

    @Override
    public String getXmlaName(OlapNameContext nameContext) {
        return CdXmlUtils.escapeForTagName((String)(this.level.getUniqueName(nameContext) + ".[" + this.getName() + "]"));
    }

    @Override
    public boolean isUserDefined() {
        return true;
    }

    @Override
    public boolean isAutoExportedToReportingMF() {
        if (OlapMemberPropertyManager.IC3_PROPERTY_NAMES_EX.contains(this.getName())) {
            return false;
        }
        return this.autoExportedToReportingMF;
    }

    public OlapLevel getLevel() {
        return this.level;
    }

    public OlapBuilderInputType getInputType() {
        return this.inputType;
    }

    @Override
    public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
        OlapScalarEntity value = member.getPropertyValue(context.getSchemaPermissionsFilter(), this);
        if (value == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        return value;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }
}

