/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.member;

import crazydev.common.utils.CdLocaleUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapMemberPropertyManager {
    public static final String MEMBER_COLOR = "@Ic3Color";
    public static final String MEMBER_LATITUDE = "@Ic3Lat";
    public static final String MEMBER_LONGITUDE = "@Ic3Long";
    public static final String MEMBER_ISO2 = "@Ic3iso2";
    public static final String[] IC3_PROPERTY_NAMES = new String[]{"@Ic3Color", "@Ic3Lat", "@Ic3Long", "@Ic3iso2"};
    public static final Set<String> IC3_PROPERTY_NAMES_EX = Arrays.stream(IC3_PROPERTY_NAMES).collect(Collectors.toCollection(HashSet::new));
    public static final String MEMBER_RANKING = "IcMemberRanking";
    public static final String PROPERTY_UNARY_OPERATOR = "@UO";
    public static final String PROPERTY_MEMBER_CAPTION = "@MC_";
    @Nullable
    private final Locale fallbackLocale;
    private final Object2ObjectMap<OlapLevel, Map<String, OlapUserDefinedMemberProperty>> userDefinedProperties = new Object2ObjectOpenHashMap();
    private final Map<Locale, Map<OlapLevel, List<OlapUserDefinedMemberProperty>>> memberCaptionCache = new ConcurrentHashMap<Locale, Map<OlapLevel, List<OlapUserDefinedMemberProperty>>>();

    public OlapMemberPropertyManager(@Nullable Locale fallbackLocale) {
        this.fallbackLocale = fallbackLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object2ObjectMap<OlapLevel, Map<String, OlapUserDefinedMemberProperty>> object2ObjectMap = this.userDefinedProperties;
        synchronized (object2ObjectMap) {
            int count = 0;
            for (Map values : this.userDefinedProperties.values()) {
                count += values.size();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapMemberProperty getProperty(OlapLevel level, String name) {
        OlapIntrinsicMemberProperty property = this.getIntrinsicProperty(name);
        if (property != null) {
            return property;
        }
        Object2ObjectMap<OlapLevel, Map<String, OlapUserDefinedMemberProperty>> object2ObjectMap = this.userDefinedProperties;
        synchronized (object2ObjectMap) {
            Map levelProperties = (Map)this.userDefinedProperties.get((Object)level);
            if (levelProperties == null) {
                return null;
            }
            OlapUserDefinedMemberProperty userDefinedProperty = (OlapUserDefinedMemberProperty)levelProperties.get(name);
            return userDefinedProperty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapUserDefinedMemberProperty getUserDefinedProperty(OlapLevel level, String name) {
        Object2ObjectMap<OlapLevel, Map<String, OlapUserDefinedMemberProperty>> object2ObjectMap = this.userDefinedProperties;
        synchronized (object2ObjectMap) {
            Map levelProperties = (Map)this.userDefinedProperties.get((Object)level);
            if (levelProperties == null) {
                return null;
            }
            OlapUserDefinedMemberProperty userDefinedProperty = (OlapUserDefinedMemberProperty)levelProperties.get(name);
            return userDefinedProperty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<OlapUserDefinedMemberProperty> getUserDefinedProperties(IOlapHierarchyPermission permissions, OlapHierarchy hierarchy, String name) {
        Object2ObjectMap<OlapLevel, Map<String, OlapUserDefinedMemberProperty>> object2ObjectMap = this.userDefinedProperties;
        synchronized (object2ObjectMap) {
            ArrayList<OlapUserDefinedMemberProperty> properties = null;
            for (OlapLevel level : hierarchy.getLevels(permissions)) {
                OlapUserDefinedMemberProperty property;
                Map levelProperties = (Map)this.userDefinedProperties.get((Object)level);
                if (levelProperties == null || (property = (OlapUserDefinedMemberProperty)levelProperties.get(name)) == null) continue;
                if (properties == null) {
                    properties = new ArrayList<OlapUserDefinedMemberProperty>();
                }
                properties.add(property);
            }
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUserDefinedProperty(OlapNameContext nameContext, OlapUserDefinedMemberProperty property) {
        if (this.isIntrinsicProperty(property.getName())) {
            String qualifiedName = property.getLevel().getUniqueName(nameContext) + "." + property.getName();
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.PROPERTY_NAME_INTRINSIC_ONE, new Serializable[]{qualifiedName});
        }
        Object2ObjectMap<OlapLevel, Map<String, OlapUserDefinedMemberProperty>> object2ObjectMap = this.userDefinedProperties;
        synchronized (object2ObjectMap) {
            OlapLevel level = property.getLevel();
            Object levelProperties = (Map)this.userDefinedProperties.get((Object)level);
            if (levelProperties == null) {
                levelProperties = new CdCaseInsensitiveHashMap();
                this.userDefinedProperties.put((Object)level, levelProperties);
            }
            if (levelProperties.put(property.getName(), property) != null) {
                String qualifiedName = property.getLevel().getUniqueName(nameContext) + "." + property.getName();
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.PROPERTY_NAME_DUPLICATED, new Serializable[]{qualifiedName});
            }
            List<OlapLevel> hierarchyLevels = level.getHierarchy().getLevels();
            for (OlapLevel hierarchyLevel : hierarchyLevels) {
                OlapUserDefinedMemberProperty existing = this.getUserDefinedProperty(hierarchyLevel, property.getName());
                if (existing == null || existing.getXmlaType() == property.getXmlaType()) continue;
                String propertyUniqueName = property.getLevel().getUniqueName(nameContext) + "." + property.getName();
                String existingUniqueName = existing.getLevel().getUniqueName(nameContext) + "." + existing.getName();
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.PROPERTY_TYPE_MISMATCH, new Serializable[]{propertyUniqueName, property.getXmlaType(), existingUniqueName, existing.getXmlaType()});
            }
        }
    }

    public boolean isIntrinsicProperty(String name) {
        return this.getIntrinsicProperty(name) != null;
    }

    @Nullable
    public OlapIntrinsicMemberProperty getIntrinsicProperty(String name) {
        return OlapIntrinsicMemberProperties.getIntrinsicProperty(name);
    }

    @Nullable
    public OlapUserDefinedMemberProperty getUnaryOperatorProperty(OlapLevel level) {
        OlapUserDefinedMemberProperty property = this.getUserDefinedProperty(level, PROPERTY_UNARY_OPERATOR);
        return property;
    }

    public List<OlapUserDefinedMemberProperty> getMemberCaptionProperty(OlapLevel level, Locale locale) {
        List<OlapUserDefinedMemberProperty> levelCachedProperties;
        Map<OlapLevel, List<OlapUserDefinedMemberProperty>> localeCachedProperties = this.memberCaptionCache.get(locale);
        if (localeCachedProperties != null && (levelCachedProperties = localeCachedProperties.get(level)) != null) {
            return levelCachedProperties;
        }
        List<OlapUserDefinedMemberProperty> properties = this.createAndCacheMemberCaptionProperties(level, locale);
        return properties;
    }

    private List<OlapUserDefinedMemberProperty> createAndCacheMemberCaptionProperties(OlapLevel level, Locale locale) {
        Map<OlapLevel, List<OlapUserDefinedMemberProperty>> localeProperties = this.memberCaptionCache.get(locale);
        if (localeProperties == null) {
            localeProperties = new ConcurrentHashMap<OlapLevel, List<OlapUserDefinedMemberProperty>>();
            this.memberCaptionCache.put(locale, localeProperties);
        }
        ArrayList<OlapUserDefinedMemberProperty> levelProperties = new ArrayList<OlapUserDefinedMemberProperty>();
        this.doCreateAndCacheMemberCaptionProperties(levelProperties, level, locale);
        if (levelProperties.isEmpty() && this.fallbackLocale != null && CdLocaleUtils.isNotFallback((Locale)this.fallbackLocale, (Locale)locale)) {
            this.doCreateAndCacheMemberCaptionProperties(levelProperties, level, this.fallbackLocale);
        }
        localeProperties.put(level, levelProperties);
        return levelProperties;
    }

    private void doCreateAndCacheMemberCaptionProperties(List<OlapUserDefinedMemberProperty> levelProperties, OlapLevel level, Locale locale) {
        List localeNames = CdLocaleUtils.resolveNameForLocalizationLookup((Locale)locale);
        if (!localeNames.isEmpty()) {
            for (int ii = 0; ii < localeNames.size(); ++ii) {
                String localeName = (String)localeNames.get(ii);
                OlapUserDefinedMemberProperty property = this.getUserDefinedProperty(level, PROPERTY_MEMBER_CAPTION + localeName);
                if (property == null) continue;
                levelProperties.add(property);
            }
        }
    }
}

