/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.member;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsManager;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapMemberPropertyEvalContext {
    private final Locale locale;
    private final OlapNameContext nameContext;
    private final IOlapDimensionsPermission schemaPermissions;
    private final String cubeName;
    @Nullable
    private final OlapVisualTotalsManager visualTotalManager;

    public OlapMemberPropertyEvalContext(Locale locale, OlapNameContext nameContext, IOlapDimensionsPermission schemaPermissions, String cubeName) {
        this(locale, nameContext, schemaPermissions, cubeName, null);
    }

    public OlapMemberPropertyEvalContext(Locale locale, OlapNameContext nameContext, IOlapDimensionsPermission schemaPermissions, String cubeName, @Nullable OlapVisualTotalsManager visualTotalManager) {
        this.locale = locale;
        this.nameContext = nameContext;
        this.schemaPermissions = schemaPermissions;
        this.cubeName = cubeName;
        this.visualTotalManager = visualTotalManager;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public OlapNameContext getNameContext() {
        return this.nameContext;
    }

    @Nullable
    public OlapMemberFilter getSchemaPermissionsFilter() {
        return this.schemaPermissions.getMemberFilter();
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getVisualTotalCaption(OlapMember member, String currentCaption) {
        if (this.visualTotalManager == null) {
            return currentCaption;
        }
        return this.visualTotalManager.getCaption(member, currentCaption);
    }

    @Nullable
    public OlapVisualTotalsManager getVisualTotalManager() {
        return this.visualTotalManager;
    }
}

