/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.member;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.locale.CdLanguageIdentifierHelper;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import java.util.Locale;

public class OlapLCIDxMemberProperty
extends OlapIntrinsicMemberProperty {
    private final CdLanguageIdentifier localeId;

    public OlapLCIDxMemberProperty(CdLanguageIdentifier localeId) {
        super("LCID" + localeId.getPosition(), CdXmlaSchemaType.DBTYPE_WSTR);
        this.localeId = localeId;
    }

    @Override
    public String getXmlaName(OlapNameContext nameContext) {
        return "LCID" + this.localeId.getPosition();
    }

    public CdLanguageIdentifier getLocaleId() {
        return this.localeId;
    }

    @Override
    public OlapScalarEntity eval(OlapMemberPropertyEvalContext context, OlapMember member) {
        Locale locale = CdLanguageIdentifierHelper.getJavaLocale((CdLanguageIdentifier)this.localeId);
        OlapNameContext nameContext = context.getNameContext();
        String memberCaption = null;
        memberCaption = locale != null ? member.getCaption(locale, nameContext) : member.getName(nameContext);
        String caption = context.getVisualTotalCaption(member, memberCaption);
        return new OlapStringEntity(caption);
    }
}

