/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties.cell;

import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.locale.CdLanguageIdentifierHelper;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapUnsignedIntegerMdxCellPropertyValue;
import crazydev.iccube.olap.entity.scalar.OlapLanguageIdentifierNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import java.io.Serializable;

public class OlapLanguageMdxCellPropertyValue
extends OlapUnsignedIntegerMdxCellPropertyValue {
    public OlapLanguageMdxCellPropertyValue(OlapCellProperty property, String expression, OlapInstr value) {
        super(property, expression, value);
    }

    @Override
    protected OlapScalarEntity assertEntityType(IOlapEvaluationExceptionContext context, OlapEntity value) {
        OlapNumericEntity numericEntity;
        if (value instanceof OlapNumericEntity && (numericEntity = (OlapNumericEntity)value).isDecimal() && numericEntity.longValue() >= 0L) {
            numericEntity.resetXmlaType(this.property.getXmlaType());
            CdLanguageIdentifier id = this.getLanguageFromNumericValue(context, numericEntity.intValue());
            return new OlapLanguageIdentifierNumericEntity(id);
        }
        if (value instanceof OlapStringEntity) {
            OlapStringEntity stringEntity = (OlapStringEntity)value;
            CdLanguageIdentifier id = this.getLanguageFromStringValue(context, stringEntity.value());
            return new OlapLanguageIdentifierNumericEntity(id);
        }
        throw new OlapEvaluationException(context, OlapErrorCode.LANGUAGE_TYPE_MISMATCH, new Serializable[]{value.getFriendlyTypeName()});
    }

    private CdLanguageIdentifier getLanguageFromNumericValue(IOlapEvaluationExceptionContext context, int value) {
        CdLanguageIdentifier id = CdLanguageIdentifier.fromPosition((int)value);
        if (id == null) {
            throw new OlapEvaluationException(context, OlapErrorCode.LANGUAGE_IDENTIFIER_UNSUPPORTED, Integer.valueOf(value));
        }
        return id;
    }

    private CdLanguageIdentifier getLanguageFromStringValue(IOlapEvaluationExceptionContext context, String value) {
        CdLanguageIdentifier id = CdLanguageIdentifierHelper.getIdentifier((String)value);
        if (id == null) {
            throw new OlapEvaluationException(context, OlapErrorCode.LANGUAGE_IDENTIFIER_UNSUPPORTED, new Serializable[]{value});
        }
        return id;
    }
}

