/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapMemberPropertiesValues {
    private final Map<OlapUserDefinedMemberProperty, Object> map = new HashMap<OlapUserDefinedMemberProperty, Object>();

    public void put(OlapUserDefinedMemberProperty property, @Nullable Object value) {
        this.map.put(property, value);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public ArrayList<OlapUserDefinedMemberProperty> getProperties() {
        return new ArrayList<OlapUserDefinedMemberProperty>(this.map.keySet());
    }

    public int size() {
        return this.map.size();
    }

    @Nullable
    public Object get(OlapUserDefinedMemberProperty property) {
        return this.map.get(property);
    }

    @Nullable
    public OlapUserDefinedMemberProperty getProperty(String propertyName) {
        for (OlapUserDefinedMemberProperty property : this.map.keySet()) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public void assertMemberProperties(OlapMember member) {
        for (Map.Entry<OlapUserDefinedMemberProperty, Object> entry : this.map.entrySet()) {
            OlapUserDefinedMemberProperty prop = entry.getKey();
            Object value = entry.getValue();
            if (value == null || member.isSamePropertyValue(prop, value)) continue;
            OlapScalarEntity mValue = member.getPropertyValue(null, prop);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_PROPERTY_MISMATCH, new Serializable[]{member.getNameX(), value.toString(), prop.getName(), member.getLevel().getNameX(), member.getHierarchy().getNameX(), mValue});
        }
    }
}

