/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.properties;

import crazydev.common.utils.CdPeriodFormatter;
import crazydev.iccube.olap.entity.properties.OlapFormatter;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class OlapDurationFormatter
extends OlapFormatter {
    public static final String NAME = "duration";
    private final String pattern;
    private final CdPeriodFormatter formatter;

    public OlapDurationFormatter(Locale locale, String pattern) {
        this.pattern = pattern;
        this.formatter = new CdPeriodFormatter(pattern);
    }

    public static OlapDurationFormatter create(Locale locale, String pattern) {
        return new OlapDurationFormatter(locale, pattern);
    }

    @Override
    public String asStringImage() {
        return "formatter(duration," + this.pattern + ")";
    }

    @Override
    public OlapStringEntity format(GFCellPropertyEvalContext context, @Nullable OlapScalarEntity cellValue) {
        if (cellValue == null) {
            return this.asDefaultError();
        }
        if (cellValue.isMdxNull()) {
            return this.asDefaultNull();
        }
        if (cellValue instanceof OlapNumericEntity) {
            OlapNumericEntity value = (OlapNumericEntity)cellValue;
            long duration = value.longValue();
            String formatted = this.formatter.format(duration);
            return new OlapStringEntity(formatted);
        }
        return this.asNonFormatted(cellValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapDurationFormatter that = (OlapDurationFormatter)o;
        return this.pattern.equals(that.pattern);
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }
}

