/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory.autoexist;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.common.CdCompressedIntIntMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class OlapAutoExistImmutableContainer {
    private static final long SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)new OlapAutoExistImmutableContainer());
    private CdCompressedIntIntMap memberIdxToPos;
    private byte[] array;

    private OlapAutoExistImmutableContainer() {
    }

    public OlapAutoExistImmutableContainer(Set<Integer> keySet, IntFunction<ImmutableRoaringBitmap> provider) {
        this.build(keySet, provider);
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF;
        size += this.memberIdxToPos == null ? 0L : this.memberIdxToPos.sizeOf();
        return size += this.array == null ? 0L : (long)this.array.length;
    }

    public long sizeOf(int memberIdx) {
        if (this.memberIdxToPos == null) {
            return 0L;
        }
        ImmutableRoaringBitmap bitmap = this.getBitmap(memberIdx);
        return bitmap == null ? 0L : (long)bitmap.serializedSizeInBytes();
    }

    public void forEachExistingMemberIdx(IntPredicate action) {
        this.memberIdxToPos.forEachNotZeroValue(action);
    }

    private void build(Set<Integer> keySet, IntFunction<ImmutableRoaringBitmap> provider) {
        if (keySet.isEmpty()) {
            this.memberIdxToPos = CdCompressedIntIntMap.EMPTY;
            return;
        }
        int bufferSize = 0;
        int minMemberIdx = Integer.MAX_VALUE;
        int maxMemberIdx = Integer.MIN_VALUE;
        for (Integer memberIdx : keySet) {
            ImmutableRoaringBitmap roaringBitmap = provider.apply(memberIdx);
            bufferSize += roaringBitmap.serializedSizeInBytes();
            minMemberIdx = Math.min(minMemberIdx, memberIdx);
            maxMemberIdx = Math.max(maxMemberIdx, memberIdx);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize + 1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)44);
        int[] positions = new int[maxMemberIdx - minMemberIdx + 1];
        for (Integer memberIdx : keySet) {
            ImmutableRoaringBitmap roaringBitmap = provider.apply(memberIdx);
            positions[memberIdx.intValue() - minMemberIdx] = buffer.position();
            roaringBitmap.serialize(buffer);
        }
        this.array = buffer.array();
        this.memberIdxToPos = CdCompressedIntIntMap.build(-1, positions, minMemberIdx);
    }

    @Nullable
    public ImmutableRoaringBitmap getBitmap(int memberIdx) {
        if (this.memberIdxToPos == null) {
            throw new CdShouldNotBeHereProgrammingException("missing setup");
        }
        int pos = this.memberIdxToPos.getValue(memberIdx);
        if (pos == 0) {
            return null;
        }
        ByteBuffer bytes = ByteBuffer.wrap(this.array, pos, this.array.length - pos);
        return new ImmutableRoaringBitmap(bytes);
    }

    public boolean contains(int memberIdx) {
        return this.memberIdxToPos.getValue(memberIdx) != 0;
    }

    public void trimAndFreeze() {
    }

    public void trim() {
    }
}

