/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.common.collection.CdCollections;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapScalarEntityFactory;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapFactMemberPropertyColumnId;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapMemoryPropertiesColumn {
    private static long SHALLOW_SIZE_OF = -1L;
    private final IOlapFactListFactory listFactory;
    private final OlapLevel level;
    private ArrayList<OlapUserDefinedMemberProperty> properties;
    private IOlapFactColumn[] values;

    public OlapMemoryPropertiesColumn(IOlapFactListFactory listFactory, OlapLevel level) {
        this.listFactory = listFactory;
        this.level = level;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public List<OlapUserDefinedMemberProperty> getProperties() {
        return this.properties == null ? Collections.emptyList() : this.properties;
    }

    public long sizeOf() {
        long size;
        long l = size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        if (this.values != null) {
            for (IOlapFactColumn value : this.values) {
                size += value == null ? 0L : value.sizeOf();
            }
        }
        return size;
    }

    private void init(OlapMemberPropertiesValues propertyMap) {
        if (propertyMap.isEmpty()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (this.properties == null) {
            this.properties = propertyMap.getProperties().stream().filter(property -> !property.isAttribute()).collect(Collectors.toCollection(ArrayList::new));
            this.setupValuesColumns();
        } else {
            if (this.properties.size() != propertyMap.size()) {
                throw new CdShouldNotBeHereProgrammingException();
            }
            if (!CdCollections.intersect(this.properties, propertyMap.getProperties())) {
                throw new CdShouldNotBeHereProgrammingException();
            }
        }
    }

    private void setupValuesColumns() {
        this.values = new IOlapFactColumn[this.properties.size()];
        for (int i = 0; i < this.values.length; ++i) {
            OlapUserDefinedMemberProperty property = this.properties.get(i);
            if (property.isAttribute()) continue;
            this.values[i] = this.createColumn(this.listFactory, property.getName(), property.getInputType());
        }
    }

    public void add(OlapMemberPropertiesValues propertyMap) {
        if (propertyMap.isEmpty()) {
            List<OlapUserDefinedMemberProperty> levelProperties = this.level.getMemberProperties(null);
            for (OlapUserDefinedMemberProperty levelProperty : levelProperties) {
                if (levelProperty.isAttribute()) continue;
                propertyMap.put(levelProperty, null);
            }
            if (propertyMap.isEmpty()) {
                return;
            }
        }
        this.init(propertyMap);
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                OlapUserDefinedMemberProperty property = this.properties.get(i);
                if (property.isAttribute()) continue;
                Object value = propertyMap.get(property);
                this.values[i].addNewValue(value);
            }
        }
    }

    public boolean isSamePropertyValue(int dataHandlerIdx, OlapUserDefinedMemberProperty property, Object value) {
        if (dataHandlerIdx == -1 || this.properties == null) {
            return true;
        }
        int index = this.properties.indexOf(property);
        return this.values[index].compareToValueForCompare(value, dataHandlerIdx) == 0;
    }

    @Nullable
    public OlapScalarEntity getValue(int dataHandlerIdx, OlapUserDefinedMemberProperty property) {
        if (this.properties == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        int index = this.properties.indexOf(property);
        return this.getPropertyValue(dataHandlerIdx, index);
    }

    @Nullable
    public OlapScalarEntity getFallbackValue(int dataHandlerIdx, String propertyName) {
        int index = this.getPropertyIdx(propertyName);
        return this.getPropertyValue(dataHandlerIdx, index);
    }

    private OlapScalarEntity getPropertyValue(int dataHandlerIdx, int index) {
        if (dataHandlerIdx == -1 || this.properties == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (index < 0) {
            return OlapEmptyEntity.INSTANCE;
        }
        IOlapFactColumn valueColumn = this.values[index];
        if (valueColumn == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        return OlapScalarEntityFactory.create(valueColumn.getValueAsObject(dataHandlerIdx));
    }

    private IOlapFactColumn createColumn(IOlapFactListFactory listFactory, String property, OlapBuilderInputType type) {
        OlapFactMemberPropertyColumnId id = new OlapFactMemberPropertyColumnId(this.level, property);
        return type.createScalarEntityFactColumn(listFactory, id);
    }

    private int getPropertyIdx(String propertyName) {
        if (this.properties == null) {
            return -1;
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            OlapUserDefinedMemberProperty property = this.properties.get(i);
            if (!property.getName().equalsIgnoreCase(propertyName)) continue;
            return i;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.properties != null) {
            this.properties.trimToSize();
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                this.values[i].trimToSize();
            }
        }
    }
}

