/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.common.collection.CdArrays;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumn;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapFactMemberKeyColumnId;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapMemoryKeyColumn {
    private static long SHALLOW_SIZE_OF = -1L;
    private final IOlapFactListFactory listFactory;
    private final OlapLevel level;
    private OlapBuilderInputType[] types;
    private IOlapFactColumn[] keys;
    private IOlapFactColumn[] sortedKeys;
    private Integer[] sortedKeysOrder;

    public OlapMemoryKeyColumn(IOlapFactListFactory listFactory, OlapLevel level) {
        this.listFactory = listFactory;
        this.level = level;
    }

    public int size() {
        return this.keys == null ? 0 : this.keys[0].size();
    }

    public long sizeOf() {
        long size;
        long l = size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        if (this.keys != null) {
            for (IOlapFactColumn key : this.keys) {
                size += key.sizeOf();
            }
        }
        if (this.sortedKeys != null) {
            for (IOlapFactColumn sortedKey : this.sortedKeys) {
                size += sortedKey.sizeOf();
            }
        }
        return size;
    }

    public int getPartCount() {
        return this.types == null ? 0 : this.types.length;
    }

    @Nullable
    public OlapBuilderInputType[] getTypes() {
        return this.types;
    }

    public byte[] getUnderlyingHackValue(int dataHandlerIdx) {
        if (this.keys.length == 1) {
            return this.keys[0].getUnderlyingHackValue(dataHandlerIdx);
        }
        return null;
    }

    public OlapMemberKey getValue(int dataHandlerIdx) {
        if (this.types == null) {
            return OlapNoValueMemberKey.INSTANCE;
        }
        if (this.keys.length == 1) {
            Comparable value = this.keys[0].getValueAsObject(dataHandlerIdx);
            if (value == null) {
                return OlapNoValueMemberKey.INSTANCE;
            }
            return OlapMemberKey.create(this.types[0], value);
        }
        Comparable[] values = new Comparable[this.types.length];
        for (int i = 0; i < this.keys.length; ++i) {
            IOlapFactColumn column = this.keys[i];
            Comparable value = column.getValueAsObject(dataHandlerIdx);
            if (value == null) {
                return OlapNoValueMemberKey.INSTANCE;
            }
            values[i] = value;
        }
        return OlapMemberKey.create(this.types, values);
    }

    public Comparable[] getKeyValues(int dataHandlerIdx) {
        if (this.types == null || this.keys.length == 1) {
            throw new CdProgrammingException();
        }
        Comparable[] values = new Comparable[this.types.length];
        for (int i = 0; i < this.keys.length; ++i) {
            IOlapFactColumn column = this.keys[i];
            Comparable value = column.getValueAsObject(dataHandlerIdx);
            if (value == null) {
                throw new CdProgrammingException();
            }
            values[i] = value;
        }
        return values;
    }

    public OlapBuilderInputType getKeyType(int dataHandlerIdx) {
        if (this.types == null || this.keys.length != 1) {
            throw new CdProgrammingException();
        }
        Comparable value = this.keys[0].getValueAsObject(dataHandlerIdx);
        if (value == null) {
            throw new CdProgrammingException();
        }
        return this.types[0];
    }

    public Object getKeyValue(int dataHandlerIdx) {
        if (this.keys.length == 1) {
            return this.getKeySingleValue(dataHandlerIdx);
        }
        return this.getKeyValues(dataHandlerIdx);
    }

    public Comparable getKeySingleValue(int dataHandlerIdx) {
        if (this.types == null || this.keys.length != 1) {
            throw new CdProgrammingException();
        }
        Comparable value = this.keys[0].getValueAsObject(dataHandlerIdx);
        if (value == null) {
            return OlapNoValueMemberKey.INSTANCE;
        }
        return value;
    }

    public Comparable getComparableKey(int dataHandlerIdx) {
        if (this.types == null) {
            throw new CdProgrammingException();
        }
        if (this.types.length == 1) {
            return this.keys[0].getValueAsObject(dataHandlerIdx);
        }
        return new CdComparableArray(this.getKeyValues(dataHandlerIdx));
    }

    public void addValue(OlapMemberKey key) {
        if (this.keys == null) {
            this.init(key.getTypes());
        }
        if (this.types != null) {
            if (key == OlapNoValueMemberKey.INSTANCE) {
                for (int i = 0; i < this.keys.length; ++i) {
                    this.keys[i].addNewValue(null);
                }
            } else {
                Object keyValue = key.asJavaNativeValue();
                if (this.keys.length == 1) {
                    this.keys[0].addNewValue(keyValue);
                } else {
                    Object[] keyValues = (Object[])keyValue;
                    for (int i = 0; i < this.keys.length; ++i) {
                        IOlapFactColumn column = this.keys[i];
                        column.addNewValue(keyValues[i]);
                    }
                }
            }
        } else if (key == OlapNoValueMemberKey.INSTANCE) {
            boolean bl = false;
        }
    }

    public void init(@Nullable OlapBuilderInputType[] types) {
        this.types = types;
        if (types != null) {
            boolean swapped;
            this.setupKeyColumns();
            this.sortedKeys = (IOlapFactColumn[])this.keys.clone();
            this.sortedKeysOrder = new Integer[this.keys.length];
            for (int i = 0; i < this.sortedKeysOrder.length; ++i) {
                this.sortedKeysOrder[i] = i;
            }
            do {
                swapped = false;
                for (int i = 0; i < this.sortedKeys.length - 1; ++i) {
                    IOlapFactColumn sortedKey = this.sortedKeys[i];
                    IOlapFactColumn sortedKey2 = this.sortedKeys[i + 1];
                    if (sortedKey.getSortOrder() <= sortedKey2.getSortOrder()) continue;
                    CdArrays.swap((Object[])this.sortedKeys, (int)i, (int)(i + 1));
                    CdArrays.swap((Object[])this.sortedKeysOrder, (int)i, (int)(i + 1));
                    swapped = true;
                }
            } while (swapped);
        }
    }

    private void setupKeyColumns() {
        this.keys = new IOlapFactColumn[this.types.length];
        for (int ii = 0; ii < this.types.length; ++ii) {
            OlapBuilderInputType type = this.types[ii];
            this.keys[ii] = this.createColumn(this.listFactory, ii, type);
        }
    }

    public void trimToSize() {
        if (this.keys != null) {
            for (IOlapFactColumn column : this.keys) {
                column.trimToSize();
            }
        }
    }

    private IOlapFactColumn createColumn(IOlapFactListFactory listFactory, int keyN, OlapBuilderInputType type) {
        OlapFactMemberKeyColumnId id = new OlapFactMemberKeyColumnId(this.level, keyN);
        return type.createScalarEntityFactColumn(listFactory, id);
    }

    public int binarySearchByKeyValues(@Nullable IOlapEvaluationExceptionContext context, CdPaginatedIntList keySorted, Object keyValues) {
        try {
            if (this.keys.length == 1) {
                return this.doBinarySearchByKey(keySorted, (Comparable)keyValues);
            }
            return this.doBinarySearchByKeys(keySorted, (Comparable[])keyValues);
        }
        catch (ClassCastException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)"unexpected binary search by key error", (Throwable)ex);
            OlapNameContext nContext = context != null ? context.getNameContext() : OlapNameContext.DEFAULT_VALUES;
            Locale locale = context != null ? context.getLocale() : Locale.ENGLISH;
            String levelName = this.level.getUniqueName(nContext);
            String keyTypeInfo = OlapMemoryKeyColumn.getExpectedKeyTypeInfo(locale, this.types);
            String keyValueInfo = OlapMemoryKeyColumn.getLookupKeyValueInfo(keyValues);
            OlapInstrLocationRange errorLocation = context != null ? context.getErrorLocation() : null;
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.LEVEL_LOOKUP_BY_KEY_TYPE_MISMATCH, new Serializable[]{levelName, keyTypeInfo, keyValueInfo});
        }
    }

    private static String getLookupKeyValueInfo(Object keyValues) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(keyValues));
        return sb.toString();
    }

    private static String getExpectedKeyTypeInfo(Locale locale, OlapBuilderInputType[] types) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < types.length; ++ii) {
            OlapBuilderInputType type = types[ii];
            if (ii > 0) {
                sb.append(",");
            }
            String friendlyTypeName = new OlapBabylonService(locale).translateEnum(OlapBuilderInputType.class, type.name());
            sb.append(friendlyTypeName);
        }
        return sb.toString();
    }

    private int doBinarySearchByKey(CdPaginatedIntList keySorted, Comparable keyValue) {
        return this.keys[0].binarySearch(keySorted, keyValue, null);
    }

    private int doBinarySearchByKeys(CdPaginatedIntList keySorted, Comparable[] keyValues) {
        final Object[] extraKeyValues = new Object[keyValues.length];
        for (int ii = 1; ii < extraKeyValues.length; ++ii) {
            Comparable originalKeyValue = keyValues[this.sortedKeysOrder[ii]];
            extraKeyValues[ii] = this.sortedKeys[ii].transformValueForCompare(originalKeyValue);
        }
        return this.sortedKeys[0].binarySearch(keySorted, keyValues[this.sortedKeysOrder[0]], new IOlapFactExtraComparator(){
            final /* synthetic */ OlapMemoryKeyColumn this$0;
            {
                OlapMemoryKeyColumn olapMemoryKeyColumn = this$0;
                Objects.requireNonNull(olapMemoryKeyColumn);
                this.this$0 = olapMemoryKeyColumn;
            }

            @Override
            public int compareOtherColumns(int rowIdx) {
                for (int ii = 1; ii < extraKeyValues.length; ++ii) {
                    int comp;
                    IOlapFactColumn columnToCompare = this.this$0.sortedKeys[ii];
                    Object keyValue = extraKeyValues[ii];
                    int n = comp = keyValue == null ? 1 : columnToCompare.compareToValueForCompare(keyValue, rowIdx);
                    if (comp == 0) continue;
                    return comp;
                }
                return 0;
            }
        });
    }

    @Nullable
    public Object transformKeyValueForCompare(Object keyValue) {
        if (this.keys == null) {
            return null;
        }
        if (this.keys.length == 1) {
            return this.keys[0].transformValueForCompare((Comparable)keyValue);
        }
        Object[] values = new Object[this.keys.length];
        for (int i = 0; i < this.keys.length; ++i) {
            values[i] = this.keys[i].transformValueForCompare((Comparable)Array.get(keyValue, i));
        }
        return values;
    }

    int naturalCompareWithKeyForCompare(int dataHandlerIdx, Object keyForCompare) {
        if (this.types == null) {
            return 1;
        }
        if (this.keys.length == 1) {
            return this.keys[0].compareToValueForCompare(keyForCompare, dataHandlerIdx);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int comp = this.keys[i].compareToValueForCompare(Array.get(keyForCompare, i), dataHandlerIdx);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public int compareWithKeyForCompareInBinarySearch(int dataHandlerIdx, Object keyForCompare) {
        if (this.types == null) {
            return 1;
        }
        if (this.keys.length == 1) {
            return this.keys[0].compareToValueForCompare(keyForCompare, dataHandlerIdx);
        }
        for (int i = 0; i < this.sortedKeys.length; ++i) {
            int comp = this.sortedKeys[i].compareToValueForCompare(Array.get(keyForCompare, this.sortedKeysOrder[i]), dataHandlerIdx);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public boolean isType(Class<?> clazz) {
        if (this.types.length != 1) {
            return false;
        }
        return this.types[0].getJavaNativeValueType() == clazz;
    }

    public Comparator<Integer> sortKeyComparator() {
        return (row1, row2) -> {
            Object key1 = this.transformKeyValueForCompare(this.getKeyValue((int)row1));
            return this.compareWithKeyForCompareInBinarySearch((int)row2, key1 == OlapNoValueMemberKey.INSTANCE ? null : key1);
        };
    }

    public Integer[] sort(boolean parallel) {
        Integer[] positions = new Integer[this.size()];
        for (int pp = 0; pp < positions.length; ++pp) {
            positions[pp] = pp;
        }
        Comparator<Integer> keyComparator = this.sortKeyComparator();
        try {
            if (parallel) {
                Arrays.parallelSort(positions, keyComparator);
            } else {
                Arrays.sort(positions, keyComparator);
            }
        }
        catch (Exception ex) {
            try {
                int ii;
                String name = this.level != null ? this.level.getUniqueName(OlapNameContext.DEFAULT_VALUES) : "level";
                OlapLoggers.BUILDER.error((Object)("[key] unmountKeymap : " + name), (Throwable)ex);
                StringBuilder sb = new StringBuilder();
                for (ii = 0; ii < this.size(); ++ii) {
                    OlapMemberKey k = this.getValue(ii);
                    Object val = k.toTidyTableValue();
                    if (val == null) continue;
                    sb.append(val).append(",");
                }
                OlapLoggers.BUILDER.error((Object)("[key] unmountKeymap keys : " + String.valueOf(sb)));
                sb = new StringBuilder();
                for (ii = 0; ii < this.size(); ++ii) {
                    for (int jj = ii + 1; jj < this.size(); ++jj) {
                        boolean ok;
                        int c1 = keyComparator.compare(ii, jj);
                        int c2 = keyComparator.compare(jj, ii);
                        boolean bl = ok = Integer.signum(c1) == -Integer.signum(c2);
                        if (ok) continue;
                        Object k1 = this.getValue(ii).toTidyTableValue();
                        byte[] key1 = this.getUnderlyingHackValue(ii);
                        Object k2 = this.getValue(jj).toTidyTableValue();
                        byte[] key2 = this.getUnderlyingHackValue(jj);
                        sb.append("AS : c1/c2 (").append(c1).append("/").append(c2).append("), ");
                        sb.append("AS : k1 (").append(ii).append(") = [").append(k1).append("]").append("-[").append(Arrays.toString(key1)).append("], ");
                        sb.append("AS : k2 (").append(jj).append(") = [").append(k2).append("]").append("-[").append(Arrays.toString(key2)).append("], ");
                    }
                }
                OlapLoggers.BUILDER.error((Object)("[key] unmountKeymap keys " + String.valueOf(sb)));
            }
            catch (Exception ignored) {
                OlapLoggers.BUILDER.error((Object)"[key] unmountKeymap dump error ", (Throwable)ignored);
            }
            throw ex;
        }
        return positions;
    }
}

