/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.memory.NewOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.memory.NewOlapMemoryLevelMemberCaseInsensitive;
import crazydev.iccube.olap.entity.memory.OlapKeyOnlyMemoryLevelMember;
import java.util.List;

public abstract class OlapLevelMemoryFactory {
    static IOlapMemoryLevelMember createOlapMemoryLevelMember(OlapLevel level) {
        if (level.isNameColSameAsKeyCol() && level.isKeysUnique() && (!OlapLevelMemoryFactory.isFirstKeyTypeString(level) || level.isNamesUniqueFlag())) {
            return new OlapKeyOnlyMemoryLevelMember(level, OlapLevelMemoryFactory.firstKeyType(level));
        }
        MembersUpperLowerStrategyType caseStrategy = level.membersUpperLowerCaseStrategy();
        if (caseStrategy.ignoreCase() && level.getDefinedKeyTypes().stream().anyMatch(OlapBuilderInputType::isString)) {
            return new NewOlapMemoryLevelMemberCaseInsensitive(level);
        }
        return new NewOlapMemoryLevelMember(level);
    }

    private static boolean isFirstKeyTypeString(OlapLevel level) {
        List<OlapBuilderInputType> types = level.getDefinedKeyTypes();
        return !types.isEmpty() && types.getFirst().isString();
    }

    private static OlapBuilderInputType firstKeyType(OlapLevel level) {
        List<OlapBuilderInputType> types = level.getDefinedKeyTypes();
        if (types.isEmpty()) {
            throw new RuntimeException("internal error : unexpected empty key types for level " + level.getUniqueName(OlapDefaultNamesContext.DEFAULT_VALUES));
        }
        return types.getFirst();
    }
}

