/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.common.collection.CdObject2IntHollowMap;
import crazydev.common.collection.CdVisitor;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.memory.OlapBaseMemoryLevelMember;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapFactMemberKeyColumnId;
import crazydev.iccube.olap.schema.stats.OlapLevelStats;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapKeyOnlyMemoryLevelMember
extends OlapBaseMemoryLevelMember {
    private final OlapBuilderInputType keyType;
    private final MapForKey keyMap;
    private final IOlapFactColumn keyColumn;
    private ArrayList<Integer> noKeyIdx = new ArrayList();
    private ArrayList<String> noKeyNames = new ArrayList();

    public OlapKeyOnlyMemoryLevelMember(OlapLevel level, OlapBuilderInputType keyType) {
        super(level);
        this.keyType = keyType;
        this.keyMap = new MapForKey(this);
        this.keyColumn = keyType.createScalarEntityFactColumn(this.dimension.getListFactory(), new OlapFactMemberKeyColumnId(level, 0));
    }

    @Override
    public boolean isStringKeyUpperCase() {
        return this.keyMap.isStringType && this.level.membersUpperLowerCaseStrategy().ignoreCase();
    }

    private void addNoKeyMember(String name, int idx) {
        this.noKeyIdx.add(idx);
        this.noKeyNames.add(name);
    }

    @Nullable
    private String getNoKeyName(int dataHandlerIdx) {
        int idx = this.noKeyIdx.indexOf(dataHandlerIdx);
        if (idx == -1) {
            return null;
        }
        return this.noKeyNames.get(idx);
    }

    private int getNoKeyIdx(String name) {
        for (int i = 0; i < this.noKeyNames.size(); ++i) {
            String noKeyName = this.noKeyNames.get(i);
            if (!noKeyName.equalsIgnoreCase(name)) continue;
            return this.noKeyIdx.get(i);
        }
        return -1;
    }

    @Override
    protected boolean checkNameUnique(boolean nameUniqueInLevel) {
        return false;
    }

    @Nullable
    private Comparable transformKeyInString(String lookupChildName) {
        try {
            return this.keyType.getTypeConverter().toJavaNativeValue("Transformer", lookupChildName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    private String transformToString(int dataHandlerIdx) {
        Comparable value = this.keyColumn.getValueAsObject(dataHandlerIdx);
        return value == null ? null : value.toString();
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doTrim() {
        if (this.keyColumn != null) {
            this.keyColumn.trimToSize();
        }
        if (this.keyMap != null) {
            this.keyMap.trim();
        }
    }

    @Override
    public int addIndex(OlapMember member, String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues memberProperties, int uniqueHierarchyMemberIndex, @Nullable OlapMember parent) {
        int idx = super.addIndex(member, name, key, memberProperties, uniqueHierarchyMemberIndex, parent);
        if (key == OlapNoValueMemberKey.INSTANCE) {
            this.addNoKeyMember(name, idx);
            this.keyColumn.addNewValue(null);
        }
        if (key != null && key.isValueKey()) {
            Comparable value = key.getValue();
            this.keyColumn.addNewValue(value);
            this.keyMap.put(value, idx);
        }
        return idx;
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByKeyValue(Object memberKeyArray) {
        return this.keyMap.getMember(memberKeyArray);
    }

    @Override
    @Nullable
    OlapMember lookupMemberByKeyValue(Comparable memberKeyCdArray) {
        return this.keyMap.getMember(memberKeyCdArray);
    }

    @Override
    protected OlapMember lookupChildByNameIgnoreCase4Check(OlapMember parent, String lookupChildName) {
        OlapMember foundMember = this.keyMap.getMember(this.transformKeyInString(lookupChildName));
        return foundMember == null || !OlapMember.equal(foundMember.getParent(), parent) ? null : foundMember;
    }

    @Override
    protected OlapMember lookupMemberByKey4Check(@Nullable OlapMember parentMember, Comparable memberKeyCdArray, String hintMemberName) {
        return this.keyMap.getMember(memberKeyCdArray);
    }

    @Override
    public OlapMemberKey getKey(int dataHandlerIdx) {
        if (this.getNoKeyName(dataHandlerIdx) != null) {
            return OlapNoValueMemberKey.INSTANCE;
        }
        Comparable singleKeyValue = this.getSingleKeyValue(dataHandlerIdx);
        if (this.level.membersUpperLowerCaseStrategy().ignoreCase()) {
            singleKeyValue = (Comparable)this.keyMap.transformKey(singleKeyValue);
        }
        return OlapMemberKey.create(this.keyType, singleKeyValue);
    }

    @Override
    public Comparable getSingleKeyValue(int dataHandlerIdx) {
        return this.keyColumn.getValueAsObject(dataHandlerIdx);
    }

    @Override
    public String getName(int dataHandlerIdx) {
        String noKeyName = this.getNoKeyName(dataHandlerIdx);
        return noKeyName != null ? noKeyName : this.transformToString(dataHandlerIdx);
    }

    @Override
    public boolean nameEqualsIgnoreCase(int dataHandlerIdx, String name) {
        String noKeyName = this.getNoKeyName(dataHandlerIdx);
        if (noKeyName != null) {
            return noKeyName.equalsIgnoreCase(name);
        }
        return this.getName(dataHandlerIdx).equalsIgnoreCase(name);
    }

    @Override
    public Object getKeyValueForCompare(Object keyValue) {
        return keyValue;
    }

    @Override
    public int naturalCompareWithKeyForCompare(int dataHandlerIdx, Object keyForCompare) {
        Comparable key = this.getSingleKeyValue(dataHandlerIdx);
        return key == null ? -1 : -key.compareTo(keyForCompare);
    }

    @Override
    public OlapBuilderInputType[] getKeyType() {
        return new OlapBuilderInputType[]{this.keyType};
    }

    @Override
    public boolean isKeyType(Class<?> clazz) {
        return this.keyType.getJavaNativeValueType() == clazz;
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByNameIgnoreCase(String name) {
        int noKeyIdx = this.getNoKeyIdx(name);
        if (noKeyIdx != -1) {
            return this.getMember(noKeyIdx);
        }
        return this.keyMap == null ? null : this.keyMap.getMember(this.transformKeyInString(name));
    }

    @Override
    public void forEachMatchingKeyValue(@Nullable IOlapEvaluationExceptionContext context, Object memberKeyValue, CdVisitor<OlapMember> visitor) {
        this.keyMap.visit((Comparable)memberKeyValue, visitor);
    }

    @Override
    public void forEachMatchingNameIgnoreCase(String name, CdVisitor<OlapMember> visitor) {
        int noKeyIdx = this.getNoKeyIdx(name);
        if (noKeyIdx != -1) {
            visitor.visit((Object)this.getMember(noKeyIdx));
        } else if (this.keyMap != null) {
            this.keyMap.visit(this.transformKeyInString(name), visitor);
        }
    }

    @Override
    public OlapLevelStats createStats() {
        OlapLevelStats stats = super.createStats();
        long keyRamSize = this.keyColumn != null ? this.keyColumn.sizeOf() : 0L;
        long keySortedRamSize = this.keyMap != null ? this.keyMap.sizeOf() : 0L;
        stats = stats.setNameAnKeySize(0L, 0L, keyRamSize, keySortedRamSize);
        return stats;
    }

    @Override
    public OlapLevelStats createIncrLoadStats() {
        return new OlapLevelStats(this.level.getName(OlapNameContext.DEFAULT_VALUES), this.level.getMemberCount(), 0L, 0L, 0L, 0L, 0L, 0L, this.level.isHollow());
    }

    class MapForKey
    extends CdObject2IntHollowMap<Object> {
        final boolean isStringType;
        final /* synthetic */ OlapKeyOnlyMemoryLevelMember this$0;

        MapForKey(OlapKeyOnlyMemoryLevelMember this$0) {
            OlapKeyOnlyMemoryLevelMember olapKeyOnlyMemoryLevelMember = this$0;
            Objects.requireNonNull(olapKeyOnlyMemoryLevelMember);
            this.this$0 = olapKeyOnlyMemoryLevelMember;
            this.isStringType = this.this$0.keyType.isString();
        }

        public long sizeOf() {
            return super.sizeOf();
        }

        private Object transformKey(Object key) {
            key = this.isStringType ? ((String)key).toUpperCase() : key;
            return key;
        }

        public int put(Object key, int rowIdx) {
            key = this.transformKey(key);
            return super.put(key, rowIdx);
        }

        @Nullable
        public OlapMember getMember(Object key) {
            if (this.size == 0) {
                return null;
            }
            if (key == null) {
                return null;
            }
            int formerIdx = this.get(key = this.transformKey(key));
            if (formerIdx == -1) {
                return null;
            }
            return this.this$0.getMember(formerIdx);
        }

        protected int hashOnKey(int rowIdx) {
            Object key = this.this$0.keyColumn.getValueAsObject(rowIdx);
            key = this.transformKey(key);
            return this.hashOnKey(key);
        }

        protected int hashOnKey(Object key) {
            return this.secondHash(key.hashCode());
        }

        protected boolean equals(Object first, int secondIdx) {
            Object key = this.this$0.keyColumn.getValueAsObject(secondIdx);
            key = this.transformKey(key);
            return first.equals(key);
        }

        public void visit(Comparable key, CdVisitor<OlapMember> visitor) {
            OlapMember member = this.getMember(key);
            if (member != null) {
                visitor.visit((Object)member);
            }
        }
    }
}

