/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdActionEx;
import crazydev.common.collection.CdActionStoppable;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdIIntArrayList;
import crazydev.common.collection.CdIntArrayList;
import crazydev.common.collection.CdVisitor;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdResizablePackedBitList;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.node.facts.sparse.N_IntObjectHashMap;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierKeyPart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierMultiValueKeyPart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierSingleValueKeyPart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.memory.FactIndexingMembersHolder;
import crazydev.iccube.olap.entity.memory.IOlapAutoExistBitmapProvider;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.memory.OlapBaseLevelMemoryMembers;
import crazydev.iccube.olap.entity.memory.OlapMemoryPropertiesColumn;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.schema.stats.OlapLevelStats;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public abstract class OlapBaseMemoryLevelMember
implements IOlapMemoryLevelMember {
    private static final CdIntArrayList ATTRIBUTES_NOT_POSSIBLE_ON_LEVEL = new CdIntArrayList(0);
    protected final OlapDimension dimension;
    protected final OlapHierarchy hierarchy;
    protected final OlapLevel level;
    protected final ParentList parents;
    private final Map<String, BiFunction<OlapMember, OlapMemberFilter, OlapScalarEntity>> attributeFunctions = new HashMap<String, BiFunction<OlapMember, OlapMemberFilter, OlapScalarEntity>>();
    private final Map<String, Function<OlapMember, OlapScalarEntity>> propertyFunctions = new HashMap<String, Function<OlapMember, OlapScalarEntity>>();
    private final Map<OlapHierarchy, Boolean> hasOneRelationWithBase = new HashMap<OlapHierarchy, Boolean>();
    private final Map<String, OlapHierarchy> attributesByName = new HashMap<String, OlapHierarchy>();
    private final Map<OlapHierarchy, CdIIntArrayList> noBaseAttributes = new HashMap<OlapHierarchy, CdIIntArrayList>();
    private final Map<Integer, Int2IntOpenHashMap> hack = new ConcurrentHashMap<Integer, Int2IntOpenHashMap>();
    private final IOlapAutoExistBitmapProvider autoExist;
    protected OlapMemoryPropertiesColumn propertyColumn;
    private OlapBaseLevelMemoryMembers members;
    @Nullable
    private FactIndexingMembersHolder factIndexingMember;
    private int memberCount;
    private boolean functionsProcessed = false;
    private OlapBitmap mightNotBeHollow;
    private CdResizablePackedBitList uniqueHierarchyMemberIndexes;

    public OlapBaseMemoryLevelMember(OlapLevel level) {
        this.level = level;
        this.hierarchy = level.getHierarchy();
        this.autoExist = this.hierarchy.getSchema().getAutoExistContainer(this.hierarchy);
        this.members = this.useOnTheFly() ? null : new OlapBaseLevelMemoryMembers();
        this.uniqueHierarchyMemberIndexes = this.useOnTheFly() ? new CdResizablePackedBitList() : null;
        this.parents = ParentList.build(level);
        this.dimension = level.getDimension();
    }

    protected final void init() {
        if (this.propertyColumn == null) {
            IOlapFactListFactory listFactory = this.dimension.getListFactory();
            this.propertyColumn = new OlapMemoryPropertiesColumn(listFactory, this.level);
            this.doInit();
        }
    }

    protected abstract void doInit();

    @Override
    public OlapLevel getLevel() {
        return this.level;
    }

    @Override
    public void setupUniqueHierarchyMemberIndex(int dataHandlerIdx, int uniqueMemberIndex) {
        if (this.uniqueHierarchyMemberIndexes != null) {
            this.uniqueHierarchyMemberIndexes.set(dataHandlerIdx, uniqueMemberIndex);
        }
    }

    @Override
    public void removeFactIndexingMember(int dataHandlerIdx) {
        if (this.factIndexingMember != null) {
            this.factIndexingMember.removeFactIndexingMember(dataHandlerIdx);
        }
    }

    private boolean useOnTheFly() {
        return this.level.getHierarchy().isBase() && OlapMemberFactory.canBeOnTheFly(this.level);
    }

    public final int getUniqueHierarchyMemberIdx(int dataHandlerIdx) {
        if (this.members == null) {
            return this.uniqueHierarchyMemberIndexes.getInt(dataHandlerIdx);
        }
        return this.members.members.get(dataHandlerIdx).getUniqueHierarchyMemberIndex();
    }

    @Override
    public final OlapMember getMember(int dataHandlerIdx) {
        if (this.members == null) {
            int uniqueHierarchyMemberIndex = this.uniqueHierarchyMemberIndexes.getInt(dataHandlerIdx);
            OlapMember onTheFly = OlapMemberFactory.createOnTheFly(this.level, this, dataHandlerIdx, uniqueHierarchyMemberIndex);
            if (this.factIndexingMember != null) {
                OlapMember factMember = this.factIndexingMember.getFactMember(dataHandlerIdx);
                onTheFly.setDefinedIndexingMember(factMember);
            }
            return onTheFly;
        }
        OlapMember member = this.members.members.get(dataHandlerIdx);
        return member;
    }

    @Override
    public OlapMember refreshForOnTheFly(OlapMember potentialOnTheFlyMember) {
        if (potentialOnTheFlyMember.getLevel() != this.level) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (this.members == null && this.factIndexingMember != null) {
            int dataHandlerIdx = potentialOnTheFlyMember.getDataHandlerIdx();
            return this.getMember(dataHandlerIdx);
        }
        return potentialOnTheFlyMember;
    }

    @Override
    public OlapMember lookupMemberAndCheck(@Nullable OlapMember lookupParent, Comparable lookupCdKey, String lookupName, boolean keyUniqueInLevel, boolean nameUniqueInLevel, boolean nameUniqueInParent, boolean ignoreNameCollision) {
        OlapMember memberOnName;
        this.init();
        OlapMember memberWithSameKey = this.lookupMemberByKey4Check(lookupParent, lookupCdKey, lookupName);
        if (memberWithSameKey != null && OlapMember.equal(lookupParent, memberWithSameKey.getParent()) && (ignoreNameCollision || memberWithSameKey.getNameX().equalsIgnoreCase(lookupName))) {
            String memberWithSameKeyName = memberWithSameKey.getNameX();
            if (!(ignoreNameCollision || !nameUniqueInLevel || memberWithSameKeyName.equals(lookupName) || memberWithSameKey.getLevel().membersUpperLowerCaseStrategy().ignoreCase() && memberWithSameKeyName.equalsIgnoreCase(lookupName))) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_NAME_NOT_UNIQUE_IN_LEVEL, new Serializable[]{lookupName, lookupCdKey.toString(), this.level.getUniqueName(OlapNameContext.DEFAULT_VALUES), this.forErrorLog(memberWithSameKey, false)});
            }
            return memberWithSameKey;
        }
        if (keyUniqueInLevel && (memberWithSameKey != null || (memberWithSameKey = this.lookupMemberByKeyValue(lookupCdKey)) != null)) {
            if (this.level.isKeysUniqueFlag()) {
                OlapMember memberOnName2;
                if (!this.checkNameUnique(nameUniqueInLevel) && nameUniqueInLevel && (memberOnName2 = this.lookupMemberByNameIgnoreCase(lookupName)) != null) {
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_NAME_NOT_UNIQUE_IN_LEVEL, new Serializable[]{lookupName, lookupCdKey.toString(), this.level.getNameX(), this.forErrorLog(memberOnName2, false)});
                }
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_KEY_NOT_UNIQUE_IN_LEVEL, new Serializable[]{lookupCdKey.toString(), lookupName, this.level.getNameX(), this.forErrorLog(memberWithSameKey, false)});
            }
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_KEY_NOT_UNIQUE_IN_FACT_INDEXING_LEVEL, new Serializable[]{lookupCdKey.toString(), lookupName, this.level.getNameX(), this.forErrorLog(memberWithSameKey, false)});
        }
        if (this.checkNameUnique(nameUniqueInLevel) && (memberOnName = this.lookupMemberByNameIgnoreCase(lookupName)) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_NAME_NOT_UNIQUE_IN_LEVEL, new Serializable[]{lookupName, lookupCdKey.toString(), this.level.getNameX(), this.forErrorLog(memberOnName, false)});
        }
        if (memberWithSameKey != null && OlapMember.equal(memberWithSameKey.getParent(), lookupParent)) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_WITH_SAME_KEY_IN_PARENT, new Serializable[]{lookupCdKey.toString(), lookupName, lookupParent == null ? "NO PARENT" : lookupParent.getNameX(), this.forErrorLog(memberWithSameKey, true)});
        }
        if (lookupParent != null && nameUniqueInParent && !this.checkNameUnique(nameUniqueInLevel) && (memberOnName = this.lookupChildByNameIgnoreCase4Check(lookupParent, lookupName)) != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_WITH_SAME_NAME_IN_PARENT, new Serializable[]{lookupName, lookupCdKey.toString(), lookupParent.getNameX(), this.forErrorLog(memberWithSameKey, true)});
        }
        return null;
    }

    protected boolean checkNameUnique(boolean nameUniqueInLevel) {
        return nameUniqueInLevel;
    }

    private String forErrorLog(OlapMember member, boolean wParent) {
        if (member == null) {
            return "NULL";
        }
        OlapMemberKey key = member.getKey();
        return "('" + (key != null ? key.toString() : "<null>") + "', '" + member.getNameX() + "' )" + (String)(wParent && member.getParent() != null ? " parent :" + member.getParent().getNameX() : "");
    }

    @Nullable
    abstract OlapMember lookupMemberByKeyValue(Comparable var1);

    protected abstract OlapMember lookupChildByNameIgnoreCase4Check(OlapMember var1, String var2);

    @Override
    public void forEachMatchingKeyValue(OlapEntityIdentifierKeyPart key, CdVisitor<OlapMember> visitor) {
        OlapBuilderInputType[] types = this.getKeyType();
        if (types == null || types.length != key.getValueCount()) {
            return;
        }
        Object keyValue = this.asKeyValue(key, types);
        if (keyValue != null) {
            this.forEachMatchingKeyValue(null, keyValue, visitor);
        }
    }

    @Nullable
    protected Object asKeyValue(OlapEntityIdentifierKeyPart key, OlapBuilderInputType[] types) {
        Object keyValue;
        if (key instanceof OlapEntityIdentifierSingleValueKeyPart) {
            OlapEntityIdentifierSingleValueKeyPart singleKey = (OlapEntityIdentifierSingleValueKeyPart)key;
            keyValue = singleKey.getJavaNativeValue(types[0]);
        } else {
            OlapEntityIdentifierMultiValueKeyPart singleKey = (OlapEntityIdentifierMultiValueKeyPart)key;
            keyValue = singleKey.getJavaNativeValues(types);
        }
        return keyValue;
    }

    boolean sameKey(@Nullable OlapMember member, @Nullable Comparable memberKeyValue) {
        if (member == null || memberKeyValue == null) {
            return false;
        }
        Object keyForCompare = this.getKeyValueForCompare(memberKeyValue);
        return member.equalsWithKeyForCompare(keyForCompare);
    }

    protected abstract OlapMember lookupMemberByKey4Check(@Nullable OlapMember var1, Comparable var2, String var3);

    @Override
    public boolean isSamePropertyValue(int dataHandlerIdx, OlapUserDefinedMemberProperty property, Object value) {
        if (this.propertyColumn == null) {
            return true;
        }
        return this.propertyColumn.isSamePropertyValue(dataHandlerIdx, property, value);
    }

    @Override
    public final OlapDimension getDimension() {
        return this.dimension;
    }

    @Override
    public final int getMemberCount() {
        return this.memberCount;
    }

    @Override
    public void forEachMember(CdAction<OlapMember> action) {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            OlapMember member = this.getMember(i);
            action.apply((Object)member);
        }
    }

    @Override
    public boolean forEachMemberStoppable(CdActionStoppable<OlapMember> action) {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            OlapMember member = this.getMember(i);
            if (action.apply((Object)member)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final OlapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public OlapBitmap getAutoExist(OlapMember member) {
        return this.autoExist.getAutoExistBitmap(member);
    }

    @Override
    public void addAutoExistRelation(OlapMember member, OlapMember child) {
        this.autoExist.addAutoExistRelation(member, child);
    }

    @Override
    public boolean hasUserDefinedProperty(String propName) {
        String propertyName = propName.toUpperCase();
        return this.attributeFunctions.containsKey(propertyName) || this.propertyFunctions.containsKey(propertyName);
    }

    @Override
    @Nullable
    public OlapScalarEntity getPropertyValue(OlapMember member, int dataHandlerIdx, @Nullable OlapMemberFilter memberFilter, String propName) {
        if (dataHandlerIdx < 0) {
            return null;
        }
        String propertyName = propName.toUpperCase();
        BiFunction<OlapMember, OlapMemberFilter, OlapScalarEntity> attrFunction = this.attributeFunctions.get(propertyName);
        if (attrFunction != null) {
            return attrFunction.apply(member, memberFilter);
        }
        Function<OlapMember, OlapScalarEntity> propFunction = this.propertyFunctions.get(propertyName);
        if (propFunction != null) {
            return propFunction.apply(member);
        }
        if (!this.functionsProcessed && this.propertyColumn != null) {
            return this.propertyColumn.getFallbackValue(dataHandlerIdx, propertyName);
        }
        return null;
    }

    @Override
    public void forEachMemberEx(CdActionEx<OlapMember> action) {
        OlapMember member;
        for (int i = 0; i < this.getMemberCount() && action.apply(i, (Object)(member = this.getMember(i))); ++i) {
        }
    }

    @Override
    public OlapMember getParent(int dataHandlerIdx) {
        return this.parents.getParent(dataHandlerIdx);
    }

    @Override
    public int addIndex(OlapMember member, String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues memberProperties, int uniqueHierarchyMemberIndex, @Nullable OlapMember parent) {
        this.hack.clear();
        this.clearNoBaseMemberLinkRelations();
        this.init();
        if (this.members != null) {
            this.members.members.add(member);
        } else if (this.factIndexingMember != null) {
            this.factIndexingMember.addIncrementalLoadMember(member);
        }
        if (member.getDataHandlerIdx() != -1 && uniqueHierarchyMemberIndex >= 0 && this.dimension.getHierarchyCount() > 1 && !member.getLevel().isTerminal() && !member.isAllMember()) {
            if (member.getUniqueHierarchyMemberIndex() != uniqueHierarchyMemberIndex) {
                throw new RuntimeException();
            }
            this.autoExist.createBaseMemberBitmap(member);
        }
        if (memberProperties != null) {
            this.propertyColumn.add(memberProperties);
        }
        this.parents.addParent(parent, this.memberCount);
        return this.memberCount++;
    }

    @Override
    public abstract OlapLevelStats createIncrLoadStats();

    @Override
    public int getXmlaCardinality(@Nullable OlapMemberFilter tupleFilter) {
        int count = 0;
        if (tupleFilter == null || tupleFilter.isNotFiltering(this.level.getHierarchy())) {
            count = this.getMemberCount();
        } else if (tupleFilter.isAccepting(this.level)) {
            for (int i = 0; i < this.getMemberCount(); ++i) {
                OlapMember member = this.getMember(i);
                if (!tupleFilter.isAccepting(member)) continue;
                ++count;
            }
        }
        return count;
    }

    private void trimToSize(boolean incrLoad, boolean incrLoadActive) {
        this.noBaseAttributes.forEach((olapHierarchy, list) -> list.trimToSize());
        if (this.members != null) {
            this.members.members.trimToSize();
        }
        this.parents.trimToSize();
        if (this.mightNotBeHollow != null) {
            this.mightNotBeHollow = this.mightNotBeHollow.compact();
        }
        if (this.uniqueHierarchyMemberIndexes != null) {
            this.uniqueHierarchyMemberIndexes.trimToSize();
        }
        if (!incrLoad) {
            if (this.propertyColumn != null) {
                this.propertyColumn.trimToSize();
            }
            this.doTrim();
        }
    }

    protected abstract void doTrim();

    @Override
    public OlapLevelStats createStats() {
        long memberRamSize;
        long l = memberRamSize = this.members != null ? this.members.sizeOf() : 0L;
        if (this.uniqueHierarchyMemberIndexes != null) {
            memberRamSize += this.uniqueHierarchyMemberIndexes.sizeOf();
        }
        if (this.level.isAll()) {
            memberRamSize += this.getHierarchy().getAllMember().sizeOf();
        }
        if (this.factIndexingMember != null) {
            memberRamSize += this.factIndexingMember.sizeOf(false);
        }
        long parentRamSize = this.parents.sizeOf();
        long bitmapsRamSize = this.autoExist.getBitmapSize(this.level);
        long propertiesRamSize = this.propertyColumn != null ? this.propertyColumn.sizeOf() : 0L;
        long mightNotBeHollowRamSize = this.mightNotBeHollow != null ? this.mightNotBeHollow.sizeOf() : 0L;
        int memberCount = this.level.getMemberCount();
        String name = this.level.getName(OlapNameContext.DEFAULT_VALUES);
        MutableLong noBaseAttributesSize = new MutableLong(0L);
        this.noBaseAttributes.forEach((olapHierarchy, v) -> noBaseAttributesSize.add(v.sizeOf()));
        long noBaseRamSize = noBaseAttributesSize.longValue();
        return new OlapLevelStats(name, memberCount, memberRamSize, parentRamSize, bitmapsRamSize, propertiesRamSize, noBaseRamSize, mightNotBeHollowRamSize, this.level.isHollow());
    }

    @Override
    public void onFinishBuild(boolean incrLoad, boolean incrLoadActive) {
        this.onProcessFactIndexingMember();
        this.trimToSize(incrLoad, incrLoadActive);
    }

    @Override
    public void onProcessingDataCompleted(OlapBuilderContext context) {
        this.onProcessAttributes();
    }

    private void onProcessFactIndexingMember() {
        if (!this.level.getHierarchy().isBase() && OlapMemberFactory.canBeOnTheFly(this.level)) {
            if (this.members != null) {
                this.factIndexingMember = FactIndexingMembersHolder.build((CdAction<CdAction<OlapMember>>)((CdAction)this::forEachMember));
                this.uniqueHierarchyMemberIndexes = new CdResizablePackedBitList(this.members.members.size());
                for (int i = 0; i < this.members.members.size(); ++i) {
                    OlapMember m = this.members.members.get(i);
                    this.uniqueHierarchyMemberIndexes.set(m.getDataHandlerIdx(), m.getUniqueHierarchyMemberIndex());
                }
                this.uniqueHierarchyMemberIndexes.trimToSize();
                this.members = null;
            } else {
                this.factIndexingMember = this.factIndexingMember.onNewMembers();
            }
        }
    }

    @Override
    public void onProcessAttributes() {
        IOlapMemoryLevelMember dataHandler;
        this.clearNoBaseMemberLinkRelations();
        boolean lastLevel = this.getLevel().isLast();
        this.noBaseAttributes.entrySet().forEach(entry -> {
            OlapHierarchy noBaseHierarchy = (OlapHierarchy)entry.getKey();
            if (!noBaseHierarchy.isAttributeHierarchy() && !lastLevel) {
                entry.setValue(ATTRIBUTES_NOT_POSSIBLE_ON_LEVEL);
            }
            boolean hasNoBaserelation = this.hasAttributeRelation((CdIIntArrayList)entry.getValue());
            this.hasOneRelationWithBase.put(noBaseHierarchy, hasNoBaserelation);
        });
        this.attributeFunctions.clear();
        this.propertyFunctions.clear();
        this.attributesByName.clear();
        OlapLevel currentLevel = this.getLevel();
        OlapDimension dimension = currentLevel.getDimension();
        this.getLevel().forEachAttribute(attributeName -> {
            OlapHierarchy olapHierarchy = dimension.getHierarchyByName((String)attributeName);
            if (olapHierarchy != null) {
                this.attributesByName.put(olapHierarchy.getNameX().toUpperCase(), olapHierarchy);
            }
        });
        while ((dataHandler = currentLevel.getDataHandler()) instanceof OlapBaseMemoryLevelMember) {
            OlapBaseMemoryLevelMember currentMemoryLevel = (OlapBaseMemoryLevelMember)dataHandler;
            currentLevel.forEachProperty(propertyDef -> {
                String key = propertyDef.getName().toUpperCase();
                if (!this.propertyFunctions.containsKey(key)) {
                    this.propertyFunctions.put(key, member -> {
                        OlapMemoryPropertiesColumn currentPropertyColumn = currentMemoryLevel.propertyColumn;
                        if (currentPropertyColumn == null || !currentPropertyColumn.hasProperties()) {
                            return OlapEmptyEntity.INSTANCE;
                        }
                        OlapMember memberAtLevel = member.getAncestor(currentMemoryLevel.level);
                        if (memberAtLevel == null) {
                            return OlapEmptyEntity.INSTANCE;
                        }
                        int idx = memberAtLevel.getDataHandlerIdx();
                        return currentPropertyColumn.getValue(idx, (OlapUserDefinedMemberProperty)propertyDef);
                    });
                }
            });
            currentLevel.forEachAttribute(attributeName -> {
                String key = attributeName.toUpperCase();
                OlapHierarchy noBaseHier = currentMemoryLevel.attributesByName.get(key);
                if (noBaseHier != null && !this.attributeFunctions.containsKey(key)) {
                    this.attributeFunctions.put(key, (member, memberFilter) -> {
                        OlapMember memberAtLevel = member.getAncestor(currentMemoryLevel.level);
                        if (memberAtLevel == null) {
                            return OlapEmptyEntity.INSTANCE;
                        }
                        int idx = memberAtLevel.getDataHandlerIdx();
                        return currentMemoryLevel.getAttributeValue((OlapMemberFilter)memberFilter, idx, noBaseHier);
                    });
                }
            });
            if ((currentLevel = currentLevel.getPreviousLevel()) != null) continue;
        }
        this.functionsProcessed = true;
    }

    private boolean hasAttributeRelation(CdIIntArrayList list) {
        return list != null && list != ATTRIBUTES_NOT_POSSIBLE_ON_LEVEL;
    }

    @Override
    public int addAttributeMember(int dataHandlerIdx, OlapMember noBaseMember) {
        int existingDataHandlerIdx;
        if (dataHandlerIdx == -1) {
            return 0;
        }
        if (noBaseMember.getDimension() != this.getDimension()) {
            throw new CdShouldNotBeHereProgrammingException(noBaseMember.getDimension().getNameX() + ":" + this.getDimension().getNameX());
        }
        if (!noBaseMember.getLevel().isLast()) {
            throw new CdShouldNotBeHereProgrammingException(noBaseMember.getNameX());
        }
        this.clearNoBaseMemberLinkRelations();
        CdIIntArrayList list = this.noBaseAttributes.computeIfAbsent(noBaseMember.getHierarchy(), o -> new CdResizablePackedBitList());
        if (list == ATTRIBUTES_NOT_POSSIBLE_ON_LEVEL) {
            return 0;
        }
        int shiftedNoBaseHandlerIdx = noBaseMember.getDataHandlerIdx() + 1;
        int n = existingDataHandlerIdx = dataHandlerIdx >= list.size() ? 0 : list.getInt(dataHandlerIdx);
        if (existingDataHandlerIdx != 0 && existingDataHandlerIdx != shiftedNoBaseHandlerIdx) {
            this.noBaseAttributes.put(noBaseMember.getHierarchy(), (CdIIntArrayList)ATTRIBUTES_NOT_POSSIBLE_ON_LEVEL);
            return -existingDataHandlerIdx;
        }
        list.set(dataHandlerIdx, shiftedNoBaseHandlerIdx);
        return shiftedNoBaseHandlerIdx;
    }

    @Override
    public boolean definesAttributeOn(OlapLevel level) {
        OlapLevel prevLevel;
        if (!level.isLast()) {
            return false;
        }
        OlapHierarchy noBaseHierarchy = level.getHierarchy();
        OlapBaseMemoryLevelMember dataHandler = this;
        do {
            CdIIntArrayList list;
            if ((list = dataHandler.noBaseAttributes.get(noBaseHierarchy)) == ATTRIBUTES_NOT_POSSIBLE_ON_LEVEL) {
                return false;
            }
            if (list != null) {
                return true;
            }
            prevLevel = dataHandler.getLevel().getPreviousLevel();
            if (prevLevel != null && !prevLevel.isAll()) continue;
            return false;
        } while ((dataHandler = (OlapBaseMemoryLevelMember)prevLevel.getDataHandler()) != null);
        return false;
    }

    @Override
    @Nullable
    public OlapMember getAttributeMember(int dataHandlerIdx, OlapHierarchy noBaseHierarchy) {
        int shiftedNoBaseHandlerIdx;
        if (noBaseHierarchy.getDimension() != this.getDimension()) {
            throw new CdShouldNotBeHereProgrammingException(String.valueOf(noBaseHierarchy.getDimension()) + ":" + String.valueOf(this.getDimension()));
        }
        CdIIntArrayList list = this.noBaseAttributes.get(noBaseHierarchy);
        if (list == null) {
            return this.getParentAttributeMember(dataHandlerIdx, noBaseHierarchy);
        }
        if (list == ATTRIBUTES_NOT_POSSIBLE_ON_LEVEL) {
            return null;
        }
        int n = shiftedNoBaseHandlerIdx = dataHandlerIdx >= list.size() ? 0 : list.getInt(dataHandlerIdx);
        if (shiftedNoBaseHandlerIdx == 0) {
            return null;
        }
        return noBaseHierarchy.getLastLevel().getDataHandler().getMember(shiftedNoBaseHandlerIdx - 1);
    }

    @Override
    public OlapHierarchy getAttributeHierarchy(String propName) {
        String propertyName = propName.toUpperCase();
        return this.attributesByName.get(propertyName);
    }

    @Nullable
    private OlapMember getParentAttributeMember(int dataHandlerIdx, OlapHierarchy noBaseHierarchy) {
        OlapLevel previousLevel = this.getLevel().getPreviousLevel();
        if (previousLevel == null || previousLevel.isAll()) {
            return null;
        }
        OlapMember ancestor = this.getMember(dataHandlerIdx).getAncestor(previousLevel);
        if (ancestor == null) {
            return null;
        }
        return previousLevel.getDataHandler().getAttributeMember(ancestor.getDataHandlerIdx(), noBaseHierarchy);
    }

    @Nullable
    private OlapScalarEntity getAttributeValue(OlapMemberFilter memberFilter, int dataHandlerIdx, OlapHierarchy attributeHierarchy) {
        OlapMember noBaseMember = this.getAttributeMember(dataHandlerIdx, attributeHierarchy);
        if (noBaseMember == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        OlapMemberKey key = noBaseMember.getKey();
        if (key == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        if (memberFilter != null && !memberFilter.isAccepting(noBaseMember)) {
            return OlapEmptyEntity.INSTANCE;
        }
        return key.asScalarEntity();
    }

    @Override
    public boolean hasOneRelationWithBase(OlapHierarchy noBaseHierarchy) {
        return this.hasOneRelationWithBase.get(noBaseHierarchy) == Boolean.TRUE;
    }

    private void clearNoBaseMemberLinkRelations() {
        this.hasOneRelationWithBase.clear();
    }

    Object toObjectKey(Object memberKeyValue) {
        return memberKeyValue instanceof CdComparableArray ? ((CdComparableArray)memberKeyValue).getArray() : memberKeyValue;
    }

    @Override
    public boolean mightBeHollow(int dataHandlerIdx) {
        return this.mightNotBeHollow == null || !this.mightNotBeHollow.getBit(dataHandlerIdx);
    }

    @Override
    public void setCanNotBeHollow(int dataHandlerIdx) {
        if (this.mightNotBeHollow == null) {
            this.mightNotBeHollow = OlapBitmap.createBitmap();
        }
        this.mightNotBeHollow.setBit(dataHandlerIdx);
    }

    private static interface ParentList {
        public OlapMember getParent(int var1);

        public void addParent(@Nullable OlapMember var1, int var2);

        public static ParentList build(OlapLevel level) {
            if (level.getDepth() == 0) {
                return new FirstLevelParentList();
            }
            if (level.getDepth() == 1 && level.getHierarchy().getLevelAtDepth(0).isAll()) {
                return new PreviousIsAllParentList();
            }
            return new OtherParentList(level);
        }

        public void trimToSize();

        public long sizeOf();
    }

    private static class OtherParentList
    implements ParentList {
        private final OlapLevel level;
        private final N_IntObjectHashMap<OlapMember> ragged = new N_IntObjectHashMap();
        private CdIIntArrayList parentIdx = new CdIntArrayList();

        public OtherParentList(OlapLevel level) {
            this.level = level;
        }

        @Override
        public OlapMember getParent(int dataHandlerIdx) {
            int parentHandlerIdx = this.parentIdx.getInt(dataHandlerIdx);
            if (parentHandlerIdx < 0) {
                if (parentHandlerIdx == OtherParentListType.NULL_MEMBER.value) {
                    return null;
                }
                if (parentHandlerIdx == OtherParentListType.RAGGED_MEMBER.value) {
                    return (OlapMember)this.ragged.get(dataHandlerIdx);
                }
            }
            return this.level.getPreviousLevel().getDataHandler().getMember(parentHandlerIdx);
        }

        @Override
        public void addParent(@Nullable OlapMember parent, int dataHandlerIdx) {
            this.parentIdx = this.parentIdx.toMutable(() -> new CdIntArrayList(this.parentIdx.size()));
            if (parent == null) {
                this.parentIdx.add(OtherParentListType.NULL_MEMBER.value);
                return;
            }
            int parentDataHandlerIdx = parent.getDataHandlerIdx();
            if (parentDataHandlerIdx == -1 || parent.getLevel() != this.level.getPreviousLevel()) {
                this.ragged.put(this.parentIdx.size(), parent);
                this.parentIdx.add(OtherParentListType.RAGGED_MEMBER.value);
            } else {
                this.parentIdx.add(parentDataHandlerIdx);
            }
        }

        @Override
        public void trimToSize() {
            this.parentIdx = CdIIntArrayList.trimAndCompress((CdIIntArrayList)this.parentIdx);
            this.ragged.trim();
        }

        @Override
        public long sizeOf() {
            return CdRamUsageEstimator.shallowSizeOf((Object)this) + this.ragged.sizeOf(false) + this.parentIdx.sizeOf();
        }
    }

    private static class PreviousIsAllParentList
    implements ParentList {
        private OlapMember allMember;
        @Nullable
        private MutableRoaringBitmap nullMembers;

        @Override
        public OlapMember getParent(int dataHandlerIdx) {
            if (this.nullMembers != null && this.nullMembers.contains(dataHandlerIdx)) {
                return null;
            }
            return this.allMember;
        }

        @Override
        public void addParent(@Nullable OlapMember parent, int dataHandlerIdx) {
            if (parent == null) {
                if (this.nullMembers == null) {
                    this.nullMembers = new MutableRoaringBitmap();
                }
                this.nullMembers.add(dataHandlerIdx);
                return;
            }
            if (!parent.isAll()) {
                throw new CdShouldNotBeHereProgrammingException();
            }
            this.allMember = parent;
        }

        @Override
        public void trimToSize() {
            if (this.nullMembers != null) {
                this.nullMembers.trim();
            }
        }

        @Override
        public long sizeOf() {
            return CdRamUsageEstimator.shallowSizeOf((Object)this) + (this.nullMembers != null ? this.nullMembers.sizeOf() : 0L);
        }
    }

    private static class FirstLevelParentList
    implements ParentList {
        FirstLevelParentList() {
        }

        @Override
        public OlapMember getParent(int dataHandlerIdx) {
            return null;
        }

        @Override
        public void addParent(OlapMember parent, int dataHandlerIdx) {
            if (parent != null) {
                throw new CdShouldNotBeHereProgrammingException();
            }
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public long sizeOf() {
            return CdRamUsageEstimator.shallowSizeOf((Object)this);
        }
    }

    private static enum OtherParentListType {
        NULL_MEMBER(-2),
        RAGGED_MEMBER(-3);

        public final int value;

        private OtherParentListType(int value) {
            this.value = value;
        }
    }
}

