/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.memory;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdVisitor;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierKeyPart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.memory.NewOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewOlapMemoryLevelMemberCaseInsensitive
extends NewOlapMemoryLevelMember {
    protected NewOlapMemoryLevelMemberCaseInsensitive(OlapLevel level) {
        super(level);
    }

    @Override
    public int addIndex(OlapMember member, String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues memberProperties, int uniqueHierarchyMemberIndex, @Nullable OlapMember parent) {
        OlapMemberKey upperCaseKey = this.toUpperCase(key);
        return super.addIndex(member, name, upperCaseKey, memberProperties, uniqueHierarchyMemberIndex, parent);
    }

    @Override
    public boolean isStringKeyUpperCase() {
        return true;
    }

    @Override
    public OlapMemberKey getKey(int dataHandlerIdx) {
        return this.toUpperCase(super.getKey(dataHandlerIdx));
    }

    @Nullable
    private OlapMemberKey toUpperCase(@Nullable OlapMemberKey key) {
        if (key == null) {
            return null;
        }
        return key.toUpperCase();
    }

    @Override
    public void forEachMatchingKeyValue(@Nullable IOlapEvaluationExceptionContext context, Object memberKeyValue, CdVisitor<OlapMember> visitor) {
        Object key = this.convertKey(memberKeyValue);
        super.forEachMatchingKeyValue(context, key, visitor);
    }

    @Override
    public OlapMember lookupMemberByKeyValue(Object memberKeyArray) {
        Object key = this.convertKey(memberKeyArray);
        return super.lookupMemberByKeyValue(key);
    }

    @NotNull
    private Object convertKey(Object memberKeyArray) {
        return memberKeyArray.getClass().isArray() ? Arrays.stream((Comparable[])memberKeyArray).map(v -> v instanceof String ? v.toString().toUpperCase() : v).toArray(Comparable[]::new) : memberKeyArray.toString().toUpperCase();
    }

    @NotNull
    private Comparable convertKeyComparable(Comparable memberKeyArray) {
        String string;
        if (memberKeyArray instanceof CdComparableArray) {
            CdComparableArray comparableArray = (CdComparableArray)memberKeyArray;
            string = new CdComparableArray((Comparable[])comparableArray.stream().map(v -> v instanceof String ? v.toString().toUpperCase() : v).toArray(Comparable[]::new));
        } else {
            string = memberKeyArray.toString().toUpperCase();
        }
        return string;
    }

    @Override
    @Nullable
    protected Object asKeyValue(OlapEntityIdentifierKeyPart key, OlapBuilderInputType[] types) {
        Object keyValue = super.asKeyValue(key, types);
        return this.convertKey(keyValue);
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByKey4Check(OlapMember parentMember, Comparable memberKeyCdArray, String hintMemberName) {
        Comparable toUpper = this.convertKeyComparable(memberKeyCdArray);
        return super.lookupMemberByKey4Check(parentMember, toUpper, hintMemberName);
    }
}

