/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import org.jetbrains.annotations.Nullable;

public class OlapTupleCategoryMember
extends OlapAbstractCategoryMember {
    private static long SHALLOW_SIZE_OF = -1L;
    private final OlapTuple underlying;

    protected OlapTupleCategoryMember(@Nullable OlapEngineSessionContext session, @Nullable OlapEngineRequestContext request, OlapMember parent, OlapTuple underlying) {
        super(session, request, parent, OlapTupleCategoryMember.getNewName(underlying));
        this.underlying = underlying;
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    public OlapHierarchyScope getScope() {
        OlapAbstractCategoryMember parent = (OlapAbstractCategoryMember)this.getParent();
        return parent.getScope();
    }

    private static String getNewName(OlapTuple underlying) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < underlying.getMemberCount(); ++i) {
            OlapMember member = underlying.getMember(i);
            if (i != 0) {
                builder.append("-");
            }
            builder.append(member.getName(OlapNameContext.DEFAULT_VALUES));
        }
        return builder.toString();
    }

    @Override
    public OlapIterator<? extends OlapTuple> getTupleIterator() {
        return OlapIteratorFactory.singleton(this.underlying);
    }

    @Override
    @Nullable
    public OlapSubCubeEntity getSubCube() {
        return null;
    }

    @Override
    public void touch() {
        int memberCount = this.underlying.getMemberCount();
        for (int ii = 0; ii < memberCount; ++ii) {
            OlapMember member = this.underlying.getMember(ii);
            member.touch();
        }
    }
}

