/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.collection.CdActionEx;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMemberLogic;
import crazydev.iccube.olap.entity.member.OlapCategoryMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeOthersEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.Objects;

public class OlapSubCubeCategoryMemberLogic
extends OlapAbstractCategoryMemberLogic {
    private final OlapSubCubeEntity subCube;

    public OlapSubCubeCategoryMemberLogic(OlapCategoryMember categoryMember, OlapSubCubeEntity subCube) {
        super(categoryMember);
        this.subCube = subCube;
    }

    @Override
    public OlapSubCubeEntity getSubCube() {
        return this.subCube;
    }

    @Override
    protected boolean sameTupleSetDimensionality() {
        return false;
    }

    @Override
    protected void forEachTupleSet(final CdActionEx<OlapTuple> apply) {
        this.subCube.forEachSet(new CdActionEx<OlapTupleSet<?>>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean apply(int idx, OlapTupleSet<?> set) {
                OlapTuple item;
                OlapIterator iter = set.getIterator(false);
                iter.reset();
                while ((item = (OlapTuple)iter.next()) != null) {
                    if (apply.apply(idx, (Object)item)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public boolean isOther() {
        return this.subCube instanceof OlapSubCubeOthersEntity;
    }

    @Override
    protected void calculateDimensionality() {
        if (!this.isOther()) {
            super.calculateDimensionality();
        } else {
            for (OlapNonScalarEntity entity : this.subCube.getEntities(this.categoryMember)) {
                if (entity instanceof OlapTuple) {
                    OlapTuple olapTuple = (OlapTuple)entity;
                    this.categoryMember.setFactDimensionality(olapTuple);
                    continue;
                }
                if (entity instanceof OlapTupleSet) {
                    OlapTuple tuple;
                    OlapIterator iter = ((OlapTupleSet)entity).getIterator(false);
                    iter.reset();
                    while ((tuple = (OlapTuple)iter.next()) != null) {
                        this.categoryMember.setFactDimensionality(tuple);
                    }
                    continue;
                }
                if (entity == null) continue;
                throw new CdShouldNotBeHereProgrammingException(entity.getFriendlyTypeName());
            }
        }
    }
}

