/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseHierarchy;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapScalarEntityFactory;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoBaseRegularMember;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import org.jetbrains.annotations.Nullable;

public class OlapNoBaseRegularAllMember
extends OlapNoBaseRegularMember {
    private static long SHALLOW_SIZE_OF = -1L;
    private final String name;
    private final OlapMemberKey key;
    private final OlapMemberPropertiesValues propertiesValues;

    protected OlapNoBaseRegularAllMember(OlapBuilderContext context, OlapLevel level, @Nullable String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues propertiesValues) {
        super(context, level, null, null, null, null);
        this.name = name == null || name.isEmpty() ? OlapBuilderBaseHierarchy.DEFAULT_ALL_MEMBER_NAME : name;
        this.key = key == null ? OlapNoValueMemberKey.INSTANCE : key;
        this.propertiesValues = propertiesValues;
        if (this.key != OlapNoValueMemberKey.INSTANCE) {
            level.getDataHandler().addIndex(this, name, key, null, this.getUniqueHierarchyMemberIndex(), null);
        }
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected boolean mightBeHollow() {
        return false;
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return nameContext.getMemberName(this, this.name);
    }

    @Override
    protected boolean useDataHandler() {
        return false;
    }

    @Override
    @Nullable
    public OlapMember getParent() {
        return null;
    }

    @Override
    protected void setParent(OlapMember parent) {
        if (parent != null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    @Override
    public OlapMemberKey getKey() {
        return this.key;
    }

    @Override
    public Comparable getKeyValue() {
        return this.key != OlapNoValueMemberKey.INSTANCE ? super.getKeyValue() : this.key;
    }

    @Override
    @Nullable
    protected OlapScalarEntity doGetPropertyValue(@Nullable OlapMemberFilter memberFilter, @Nullable OlapUserDefinedMemberProperty property) {
        if (this.propertiesValues == null) {
            return null;
        }
        Object valueAsJavaObject = this.propertiesValues.get(property);
        return valueAsJavaObject == null ? null : OlapScalarEntityFactory.create(valueAsJavaObject);
    }

    @Override
    @Nullable
    protected OlapScalarEntity doGetPropertyValue(@Nullable OlapMemberFilter memberFilter, String propertyName) {
        if (this.propertiesValues == null) {
            return null;
        }
        OlapUserDefinedMemberProperty property = this.propertiesValues.getProperty(propertyName);
        return this.getPropertyValue(memberFilter, property);
    }

    @Override
    public boolean hasUserDefinedProperty(String propName) {
        if (this.propertiesValues == null) {
            return false;
        }
        return this.propertiesValues.getProperty(propName) != null;
    }

    @Override
    public boolean isAll() {
        return true;
    }

    @Override
    protected boolean needsBitmapAtOlapMemberLevel(OlapLevel level) {
        return false;
    }

    @Override
    @Nullable
    public OlapBitmap getBaseMemberBitmap() {
        return OlapBitmap.getOne();
    }

    @Override
    public OlapMember addBaseHierarchyChild(OlapBuilderContext context, OlapMember mainHierChild) {
        return mainHierChild;
    }
}

