/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMultiValueMemberKey;
import crazydev.iccube.olap.entity.scalar.OlapComparableVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import java.util.Arrays;

class OlapMultiValueRegularCaseInsensitiveMemberKey
extends OlapMultiValueMemberKey {
    private final OlapBuilderInputType[] types;
    private final Comparable[] values;

    OlapMultiValueRegularCaseInsensitiveMemberKey(OlapBuilderInputType[] types, Comparable[] values) {
        if (types.length <= 1) {
            throw new CdProgrammingException("Inconsistent multi-value key creation!");
        }
        if (types.length != values.length) {
            throw new CdProgrammingException("Inconsistent multi-value key creation!");
        }
        this.types = types;
        this.values = values;
    }

    @Override
    public boolean isEquals(String[] values) {
        if (this.getValues().length != values.length) {
            return false;
        }
        for (int idx = 0; idx < values.length; ++idx) {
            String thisValue;
            if (!(this.types[idx].isString() ? !this.values[idx].toString().equalsIgnoreCase(values[idx]) : !(thisValue = this.asScalarEntity(idx).asString()).equals(values[idx]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public OlapScalarEntity asScalarEntity() {
        return new OlapComparableVectorEntity(Arrays.asList(this.values), true);
    }

    @Override
    public OlapBuilderInputType[] getTypes() {
        return this.types;
    }

    @Override
    public Comparable[] getValues() {
        return this.values;
    }

    @Override
    public OlapMemberKey toUpperCase() {
        return this;
    }
}

