/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.IOlapEntityWithChildren;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.common.OlapMemberChildrenList;
import crazydev.iccube.olap.entity.hierarchy.OlapFlatHierarchy;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapHollowableMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberChildrenListFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapMemberWithChildren
extends OlapHollowableMember
implements IOlapEntityWithChildren {
    private static long SHALLOW_SIZE_OF = -1L;
    private OlapMemberChildren children;

    protected OlapMemberWithChildren(OlapBuilderContext context, OlapLevel level, @Nullable String name, @Nullable OlapMemberKey key) {
        this(context, level, null, name, key);
    }

    protected OlapMemberWithChildren(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key) {
        this(context, level, parent, name, key, null);
    }

    protected OlapMemberWithChildren(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues propertiesValues) {
        super(context, level, parent, name, key, propertiesValues);
        OlapHierarchy phierarchy;
        OlapHierarchy lhierarchy;
        this.setMemberChildren(this.createOnDemandChildren());
        if (this.isCalculated() && parent != null && (!(lhierarchy = level.getHierarchy()).equals(phierarchy = parent.getHierarchy()) || lhierarchy instanceof OlapFlatHierarchy)) {
            throw new CdProgrammingException("Unexpected calculated member '" + name + "' parent '" + String.valueOf(parent) + "' - level '" + String.valueOf(level) + "' - flat hierarchy '" + String.valueOf(lhierarchy) + "'");
        }
    }

    protected OlapMemberChildren createOnDemandChildren() {
        return this.createEmptyChildren();
    }

    protected OlapMemberChildren createEmptyChildren() {
        return OlapMemberChildrenList.emptyList();
    }

    @Override
    public void onFinishLoad() {
        super.onFinishLoad();
        if (this.children != null) {
            this.children.trimToSize();
        }
    }

    @Override
    public long sizeOf() {
        long size = super.sizeOf();
        if (this.children != null) {
            size += this.children.shallowSizeOf();
        }
        return size;
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    public boolean isAll() {
        return false;
    }

    @Override
    public IOlapEntityWithChildren getEntityWithChildrenParent() {
        OlapMember parent = this.getParent();
        return parent == null ? this.getHierarchy() : (IOlapEntityWithChildren)((Object)parent);
    }

    @Override
    public int getChildrenCount() {
        return this.getMemberChildren().size();
    }

    @Override
    public int getChildrenCount(@Nullable OlapMemberFilter filter) {
        if (filter == null) {
            return this.getChildrenCount();
        }
        OlapIterator<OlapMember> filteredChildren = this.getChildren(filter);
        return filteredChildren._sizeSlow();
    }

    @Override
    public int getChildrenCountForDrilldown(OlapCalculatedMemberManager calcMemberManager, @Nullable OlapMemberFilter filter) {
        return this.getChildrenCount(filter);
    }

    @Override
    @Nullable
    public OlapMember getFirstChild(@Nullable OlapMemberFilter tupleFilter) {
        if (tupleFilter == null) {
            return this.getMemberChildren().isEmpty() ? null : this.getMemberChildren().get(0);
        }
        return this.doGetFirstChild(tupleFilter);
    }

    @Nullable
    private OlapMember doGetFirstChild(OlapMemberFilter tupleFilter) {
        int len = this.getMemberChildren().size();
        for (int idx = 0; idx < len; ++idx) {
            OlapMember child = this.getMemberChildren().get(idx);
            if (!tupleFilter.isAccepting(child)) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember getLastChild(@Nullable OlapMemberFilter tupleFilter) {
        if (tupleFilter == null) {
            return this.getMemberChildren().isEmpty() ? null : this.getMemberChildren().get(this.getMemberChildren().size() - 1);
        }
        return this.doGetLastChild(tupleFilter);
    }

    @Nullable
    private OlapMember doGetLastChild(OlapMemberFilter tupleFilter) {
        int len = this.getMemberChildren().size();
        for (int idx = len - 1; idx >= 0; --idx) {
            OlapMember child = this.getMemberChildren().get(idx);
            if (!tupleFilter.isAccepting(child)) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember getLastChildR(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember last;
        for (last = this.getLastChild(tupleFilter); last != null && last.getLastChild(tupleFilter) != null; last = last.getLastChild(tupleFilter)) {
        }
        return last;
    }

    @Override
    public OlapMember getChild(int pos) {
        return this.getMemberChildren().get(pos);
    }

    @Override
    public int getChildPosition(@Nullable OlapMemberFilter tupleFilter, OlapMember child) {
        if (!OlapMember.equal(child.getParent(), this)) {
            throw new CdProgrammingException("Missing child '" + String.valueOf(child) + "' in '" + String.valueOf(this) + "'");
        }
        if (tupleFilter == null) {
            if (this.getMemberChildren().size() < 32) {
                for (int i = 0; i < this.getMemberChildren().size(); ++i) {
                    if (!OlapMember.equal(child, this.getMemberChildren().get(i))) continue;
                    return i;
                }
            } else {
                int pos = this.getMemberChildren().indexOf(child);
                if (pos >= 0) {
                    return pos;
                }
            }
            child.getParent();
            throw new CdProgrammingException("Missing child '" + String.valueOf(child) + "' in '" + String.valueOf(this) + "'");
        }
        return this.getSlowChildPosition(tupleFilter, child);
    }

    private int getSlowChildPosition(OlapMemberFilter tupleFilter, OlapMember child) {
        int position = 0;
        int childrenSize = this.getMemberChildren().size();
        for (int idx = 0; idx < childrenSize; ++idx) {
            OlapMember xchild = this.getMemberChildren().get(idx);
            if (!tupleFilter.isAccepting(xchild)) continue;
            if (OlapMember.equal(xchild, child)) {
                return position;
            }
            ++position;
        }
        throw new CdProgrammingException("Missing child '" + String.valueOf(child) + "' in '" + String.valueOf(this) + "'");
    }

    @Override
    @Nullable
    public OlapMember getChildAtPosition(@Nullable OlapMemberFilter tupleFilter, int pos) {
        int len = this.getMemberChildren().size();
        if (pos < 0 || pos >= len) {
            return null;
        }
        if (tupleFilter == null) {
            return this.getMemberChildren().get(pos);
        }
        int position = 0;
        for (int idx = 0; idx < len; ++idx) {
            OlapMember child = this.getMemberChildren().get(idx);
            if (!tupleFilter.isAccepting(child)) continue;
            if (position == pos) {
                return child;
            }
            ++position;
        }
        return null;
    }

    @Override
    public OlapIterator<OlapMember> getChildren(@Nullable OlapMemberFilter tupleFilter) {
        if (this.getMemberChildren().isEmpty()) {
            return OlapIteratorFactory.empty();
        }
        int len = this.getMemberChildren().size();
        if (len == 1) {
            OlapMember child = this.getMemberChildren().get(0);
            if (tupleFilter == null || tupleFilter.isAccepting(child)) {
                return OlapIteratorFactory.singleton(child);
            }
            return OlapIteratorFactory.empty();
        }
        OlapIterator<OlapMember> subset = this.getMemberChildren().asIterator();
        if (tupleFilter == null) {
            return subset;
        }
        return OlapIteratorFactory.filter(subset, tupleFilter.asOlapMemberIteratorFilter());
    }

    @Override
    public OlapIterator<OlapMember> getChildrenForMdxFunction(OlapCalculatedMemberManager calcMemberManager, @Nullable OlapMemberFilter tupleFilter) {
        return this.getChildren(tupleFilter);
    }

    @Override
    public OlapIterator<OlapMember> getChildrenR(@Nullable OlapMemberFilter tupleFilter, @Nullable OlapLevel maxLevel, boolean withThis) {
        if (this.getMemberChildren().isEmpty()) {
            return withThis ? OlapIteratorFactory.singleton(this) : OlapIteratorFactory.empty();
        }
        OlapIterator<OlapMember> childrenR = OlapIteratorFactory.childrenR(this, maxLevel, withThis);
        if (tupleFilter == null) {
            return childrenR;
        }
        return OlapIteratorFactory.filter(childrenR, tupleFilter.asOlapMemberIteratorFilter());
    }

    @Override
    public OlapMember addChild(OlapBuilderContext context, OlapMember child) {
        if (!OlapMember.equal(child.getParent(), this)) {
            child.getParent();
            throw new CdProgrammingException("MDX addChild inconsistency.");
        }
        if (this.getMemberChildren().isEmpty()) {
            this.setMemberChildren(OlapMemberChildrenListFactory.buildEmptyChildrenList(this.getLevel().getNextLevel()));
        }
        this.handleFactHollowOnAddChild(context, child);
        this.getMemberChildren().add(child);
        this.addChildBitMap(child);
        return child;
    }

    @Override
    public OlapMember addBaseHierarchyChild(OlapBuilderContext context, OlapMember mainHierChild) {
        throw new CdDoNotCallMeProgrammingException();
    }

    protected void addChildBitMap(OlapMember child) {
        this.setBaseMemberBitmap(child);
    }

    @Override
    @Nullable
    public OlapMember unfilteredLookupMemberByName(OlapNameContext nameContext, String name) {
        OlapMember child;
        OlapIterator<OlapMember> children = this.getChildren(null);
        while ((child = children.next()) != null) {
            if (!OlapCaseInsensitiveName.equals(child.getName(nameContext), name)) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember lookupMemberByRange(Object keyForCompare, OlapLevel level) {
        if (this.getMemberChildren().isEmpty()) {
            return this;
        }
        OlapLevel childrenLevel = this.getChildrenLevel();
        boolean isAsc = childrenLevel == null || childrenLevel.getOrderKind().isAsc();
        boolean hasUnknown = this.isAll() && this.getHierarchy().hasCreatedUnknown();
        OlapMember lookupMember = this.getMemberChildren().binaryRangeLookupFromKey4Comp(keyForCompare, isAsc, hasUnknown);
        if (lookupMember == null) {
            return null;
        }
        if (lookupMember.getLevel() == level) {
            return lookupMember;
        }
        return lookupMember.lookupMemberByRange(keyForCompare, level);
    }

    protected Iterable<OlapMember> getChildren() {
        return this.getMemberChildren().iterable();
    }

    @Nullable
    private OlapLevel getChildrenLevel() {
        return this.getLevel().getNextLevel();
    }

    @Override
    public int validateIndexingByRange(OlapBuilderErrorManager errorManager, int errorsToStop, OlapMemberKey beginInterval, OlapMemberKey endInterval) {
        OlapLevel childrenLevel = this.getChildrenLevel();
        return OlapHierarchy.validateIndexingByRange(errorManager, errorsToStop, this.getMemberChildren(), childrenLevel, beginInterval, endInterval);
    }

    @Override
    public boolean isMdxGeneration(@Nullable OlapMemberFilter tupleFilter, int generation) {
        if (this.isMdxLeaf(tupleFilter)) {
            return generation == 0;
        }
        int len = this.getMemberChildren().size();
        for (int idx = 0; idx < len; ++idx) {
            OlapMember child = this.getMemberChildren().get(idx);
            if (!child.isMdxGeneration(tupleFilter, generation - 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeChildren() {
        this.setMemberChildren(OlapMemberChildrenList.emptyList());
    }

    @Override
    @Nullable
    public OlapMember lookupChildByNameIgnoreCase(String childName) {
        return this.getMemberChildren().lookupChildByNameIgnoreCase(childName);
    }

    @Override
    @Nullable
    public OlapMember lookupChildByKeyValue(OlapLevel keyLevel, Object keyValue) {
        OlapMember member = this.getLevel().getNextLevel() == keyLevel && keyLevel.getOrderBy() == OlapMemberOrderByType.BY_KEY ? this.getMemberChildren().binaryLookupFromKey4Comp(keyLevel, keyValue) : this.getMemberChildren().lookupFromKeyForComp(keyLevel, keyValue);
        return member;
    }

    void handleFactHollowOnAddChild(OlapBuilderContext context, OlapMember child) {
        if (this.isAll()) {
            return;
        }
        if (this.getMemberChildren().isEmpty()) {
            this.setFactIndexingMember(context, child);
        } else if (this.getMemberChildren().size() == 1) {
            this.removeFactHollow(context);
        }
    }

    @Override
    public long getDescendantsCount() {
        int count = 1;
        for (int i = 0; i < this.getMemberChildren().size(); ++i) {
            OlapMember child = this.getMemberChildren().get(i);
            count = (int)((long)count + child.getDescendantsCount());
        }
        return count;
    }

    @Override
    @Nullable
    public OlapMember lookupChildByMdxIdentifier(OlapNameContext nameContext, OlapMemberFilter permissions, Predicate<OlapMember> matcher) {
        int childrenCount = this.getChildrenCount();
        for (int i = 0; i < childrenCount; ++i) {
            OlapMember child = this.getChild(i);
            if (permissions != null && !permissions.isAccepting(child) || !matcher.test(child)) continue;
            return child;
        }
        return null;
    }

    protected OlapMemberChildren getMemberChildren() {
        return this.children;
    }

    protected void setMemberChildren(OlapMemberChildren children) {
        this.children = children;
    }
}

