/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.shared.schema.S_MeasureIndex;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapAllMember;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapFilteredOutMember;
import crazydev.iccube.olap.entity.member.OlapHollowRegularMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMemberWithChildren;
import crazydev.iccube.olap.entity.member.OlapNoBaseHollowTerminalMember;
import crazydev.iccube.olap.entity.member.OlapNoBaseRegularAllMember;
import crazydev.iccube.olap.entity.member.OlapNoBaseRegularMember;
import crazydev.iccube.olap.entity.member.OlapNoBaseTerminalMember;
import crazydev.iccube.olap.entity.member.OlapSchemaCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapSelectCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapTerminalMember;
import crazydev.iccube.olap.entity.memory.OlapBaseMemoryLevelMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberEvaluationContext;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import java.io.Serializable;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OlapMemberFactory {
    public static OlapMember createMember(OlapBuilderContext context, boolean isBase, @Nullable OlapLevel level, OlapMember memberParent, String memberName, OlapMemberKey key, OlapMemberPropertiesValues propertiesValues) {
        if (isBase && level != null && level.isLast() && !level.getHierarchy().isParentChild()) {
            return OlapMemberFactory.createOlapTerminalMember(context, level, memberParent, memberName, key, propertiesValues);
        }
        return OlapMemberFactory.createRegularMember(context, level, memberParent, memberName, key, propertiesValues);
    }

    public static boolean canBeOnTheFly(OlapLevel level) {
        return level.getIsStructuralLastLevel() && !level.getHierarchy().isParentChild();
    }

    public static OlapMember createOnTheFly(OlapLevel level, OlapBaseMemoryLevelMember dataHandler, int dataHandlerIdx, int uniqueHierarchyMemberIndex) {
        if (OlapMemberFactory.canBeOnTheFly(level)) {
            if (level.getHierarchy().isBase()) {
                return new OlapTerminalMember(dataHandler, dataHandlerIdx, uniqueHierarchyMemberIndex);
            }
            if (level.isHollow()) {
                return new OlapNoBaseHollowTerminalMember(dataHandler, dataHandlerIdx, uniqueHierarchyMemberIndex);
            }
            return new OlapNoBaseTerminalMember(dataHandler, dataHandlerIdx, uniqueHierarchyMemberIndex);
        }
        throw new CdShouldNotBeHereProgrammingException(level.getNameX());
    }

    public static OlapMember createRegularMember(OlapBuilderContext context, OlapLevel level, OlapMember memberParent, String memberName, OlapMemberKey key, OlapMemberPropertiesValues propertiesValues) {
        if (level == null || level.getHierarchy().isBase()) {
            return new OlapMemberWithChildren(context, level, memberParent, memberName, key, propertiesValues);
        }
        if (level.isLast() && !level.getHierarchy().isParentChild()) {
            if (level.isHollow()) {
                return new OlapNoBaseHollowTerminalMember(context, level, memberParent, memberName, key, propertiesValues);
            }
            return new OlapNoBaseTerminalMember(context, level, memberParent, memberName, key, propertiesValues);
        }
        if (level.isHollow()) {
            return new OlapHollowRegularMember(context, level, memberParent, memberName, key, propertiesValues);
        }
        return new OlapNoBaseRegularMember(context, level, memberParent, memberName, key, propertiesValues);
    }

    public static OlapMember createOlapAllMember(OlapBuilderContext context, OlapLevel level, String name) {
        return OlapMemberFactory.createOlapAllMember(context, level, name, null);
    }

    public static OlapMember createOlapAllMember(OlapBuilderContext context, OlapLevel level, String name, @Nullable OlapMemberKey key) {
        return OlapMemberFactory.createOlapAllMember(context, level, name, key, null);
    }

    public static OlapMember createOlapAllMember(OlapBuilderContext context, OlapLevel level, String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues propertiesValues) {
        if (level == null || level.getHierarchy().isBase()) {
            return new OlapAllMember(context, level, name, key, propertiesValues);
        }
        return new OlapNoBaseRegularAllMember(context, level, name, key, propertiesValues);
    }

    public static OlapCalculatedMember createOlapCalculatedMember(OlapCreateCalcMemberEvaluationContext context, boolean definedAtSelectStatementLevel, long declarationOrder, String name, OlapLevel anchor, OlapInstrLocationRange idRange, OlapInstr formula, OlapCellProperties cellProperties, @Nullable String definedUniqueName) {
        OlapMemberFactory.validateCellProperties(context, idRange, name, OlapMemberFactory.isMeasures(anchor), cellProperties);
        if (definedAtSelectStatementLevel) {
            return new OlapSelectCalculatedMember(declarationOrder, name, anchor, idRange, formula, cellProperties, definedUniqueName);
        }
        return new OlapSchemaCalculatedMember(name, anchor, idRange, formula, cellProperties, definedUniqueName);
    }

    public static OlapCalculatedMember createOlapCalculatedMember(OlapCreateCalcMemberEvaluationContext context, boolean definedAtSelectStatementLevel, long declarationOrder, String name, OlapMember anchor, OlapInstrLocationRange idRange, OlapInstr formula, OlapCellProperties cellProperties, @Nullable String definedUniqueName) {
        OlapMemberFactory.validateCellProperties(context, idRange, name, OlapMemberFactory.isMeasures(anchor), cellProperties);
        if (definedAtSelectStatementLevel) {
            return new OlapSelectCalculatedMember(declarationOrder, name, anchor, idRange, formula, cellProperties, definedUniqueName);
        }
        return new OlapSchemaCalculatedMember(name, anchor, idRange, formula, cellProperties, definedUniqueName);
    }

    public static OlapMeasureMember createOlapMeasureMember(OlapLevel level, S_MeasureIndex index, String name, IOlapBuilderBaseFactsDef measureGroup, OlapBuilderInputType cubeDataType, OlapAggregationType hierarchyAggregationType, boolean emptyIsZero) {
        return new OlapMeasureMember(level, index, name, measureGroup, cubeDataType, hierarchyAggregationType, emptyIsZero, null);
    }

    public static OlapFilteredOutMember createOlapFilteredOutMember(OlapMember underlying) {
        return new OlapFilteredOutMember(underlying);
    }

    public static OlapTerminalMember createOlapTerminalMember(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, String name, OlapMemberKey key, OlapMemberPropertiesValues propertiesValues) {
        return new OlapTerminalMember(context, level, parent, name, key, propertiesValues);
    }

    private static void validateCellProperties(OlapCreateCalcMemberEvaluationContext context, OlapInstrLocationRange idRange, String name, OlapDimension dimension, OlapCellProperties cellProperties) {
        if (context == null) {
            return;
        }
        OlapCube measuresCube = null;
        if (dimension.isMeasures()) {
            measuresCube = dimension.getCube();
        }
        if (measuresCube != null) {
            IOlapSchemaPermission schemaPermissions = context.getSchemaPermissions();
            IOlapCubePermission permissions = schemaPermissions.getCubePermissions(measuresCube);
            Set<String> measureGroups = measuresCube.getMeasureGroupNames(permissions);
            OlapMemberFactory.validateCalcMeasureCellProperties(idRange, name, cellProperties, measureGroups);
        } else {
            OlapMemberFactory.validateCalcMemberCellProperties(idRange, name, cellProperties);
        }
    }

    private static void validateCalcMeasureCellProperties(OlapInstrLocationRange idRange, String name, OlapCellProperties cellProperties, Set<String> measureGroups) {
        OlapCaseInsensitiveNames names;
        if (cellProperties == null) {
            return;
        }
        String amg = cellProperties.getAssociatedMeasureGroup();
        if (amg != null && !(names = new OlapCaseInsensitiveNames(measureGroups)).contains(amg)) {
            throw new OlapEvaluationException(idRange, OlapErrorCode.CALC_MEASURE_UNKNOWN_ASSOCIATED_MEASURE_GROUP, new Serializable[]{name, amg});
        }
    }

    private static void validateCalcMemberCellProperties(OlapInstrLocationRange idRange, String name, OlapCellProperties cellProperties) {
        if (cellProperties == null) {
            return;
        }
        String amg = cellProperties.getAssociatedMeasureGroup();
        if (CdStringUtils.isNotNullAndNotBlank((String)amg)) {
            throw new OlapEvaluationException(idRange, OlapErrorCode.CALC_MEMBER_ASSOCIATED_MEASURE_GROUP, new Serializable[]{name});
        }
        String df = cellProperties.getDisplayFolder();
        if (CdStringUtils.isNotNullAndNotBlank((String)df)) {
            throw new OlapEvaluationException(idRange, OlapErrorCode.CALC_MEMBER_DISPLAY_FOLDER, new Serializable[]{name});
        }
    }

    private static OlapDimension isMeasures(OlapLevel anchor) {
        return anchor.getDimension();
    }

    private static OlapDimension isMeasures(OlapMember anchor) {
        return anchor.getDimension();
    }
}

