/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import com.google.common.collect.Lists;
import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdArrays;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.olap.OlapEntityType;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.cluster.shared.schema.S_FactMemberDefIndices;
import crazydev.iccube.cluster.shared.schema.S_FactMemberInfo;
import crazydev.iccube.cluster.shared.schema.S_MemberDefType;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.OlapKeyIdentifiable;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.IOlapMember;
import crazydev.iccube.olap.entity.member.OlapLevelBackwardNavigator;
import crazydev.iccube.olap.entity.member.OlapLevelBaseNavigator;
import crazydev.iccube.olap.entity.member.OlapLevelForwardNavigator;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMemberRank;
import crazydev.iccube.olap.entity.member.OlapMemberUniqueNameType;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.model.IResMember;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public abstract class OlapMember
extends OlapTuple
implements IOlapMember,
IResMember,
OlapNameIdentifiableEntity,
OlapKeyIdentifiable,
Comparable<OlapMemberKey> {
    public static final String FRIENDLY_NAME = "member";
    public static final Comparator<OlapMember> RANK_COMPARATOR = Comparator.comparing(OlapMember::getRank);
    public static final Comparator<OlapMember> INDEX_COMPARATOR = Comparator.comparingInt(o -> o.uniqueHierarchyMemberIndex);
    protected static final int NO_INDEX = -1;
    protected final IOlapMemoryLevelMember dataHandler;
    protected final int dataHandlerIdx;
    protected int uniqueHierarchyMemberIndex;

    protected OlapMember(IOlapMemoryLevelMember dataHandler, int dataHandlerIdx, int uniqueHierarchyMemberIndex) {
        this.dataHandler = dataHandler;
        this.dataHandlerIdx = dataHandlerIdx;
        this.uniqueHierarchyMemberIndex = uniqueHierarchyMemberIndex;
    }

    protected OlapMember(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key) {
        this(context, level, parent, name, key, null);
    }

    protected OlapMember(OlapBuilderContext context, OlapLevel level, @Nullable OlapMember parent, @Nullable String name, @Nullable OlapMemberKey key, @Nullable OlapMemberPropertiesValues memberProperties) {
        this.dataHandler = level.getDataHandler();
        this.uniqueHierarchyMemberIndex = this.getNextHierarchyMemberIndex();
        if (this.useDataHandler()) {
            int localIndex = this.needsBitmapAtOlapMemberLevel(level) ? this.uniqueHierarchyMemberIndex : -1;
            this.dataHandlerIdx = this.dataHandler.addIndex(this, name, key, memberProperties, localIndex, parent);
            this.dataHandler.setupUniqueHierarchyMemberIndex(this.dataHandlerIdx, this.uniqueHierarchyMemberIndex);
        } else {
            this.dataHandlerIdx = -1;
            this.setParent(parent);
            if (memberProperties != null && !memberProperties.isEmpty()) {
                throw new CdShouldNotBeHereProgrammingException();
            }
        }
        if (parent != null && this.wantsAddToParent() && parent.getHierarchy() == this.getHierarchy()) {
            parent.addChild(context, this);
        }
    }

    protected void setUniqueHierarchyIndex(int index) {
        this.uniqueHierarchyMemberIndex = index;
    }

    public static boolean equal(@Nullable OlapMember m1, @Nullable OlapMember m2) {
        return m1 == m2 || m1 != null && m2 != null && m1.dataHandlerIdx == m2.dataHandlerIdx && m1.dataHandler == m2.dataHandler && OlapMemberFactory.canBeOnTheFly(m1.getLevel());
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.MEMBER;
    }

    @Nullable
    public S_NonEmptyBehavior getDefinedNonEmptyBehavior() {
        return null;
    }

    @Override
    public OlapTuple[] unroll(GFContext context) {
        OlapTuple[] unrolled = new OlapTuple[]{this};
        return unrolled;
    }

    private static boolean isDescendant(OlapMember ancestor, OlapMember descendant) {
        do {
            if (!OlapMember.equal(descendant = descendant.getParent(), ancestor)) continue;
            return true;
        } while (descendant != null);
        return false;
    }

    @Nullable
    private static OlapMember applyRelativePositions(@Nullable OlapMemberFilter tupleFilter, OlapMember ancestor, int[] childPositions) {
        int pos;
        OlapMember cousin = ancestor;
        while ((pos = cousin.getLevel().getDepth()) < childPositions.length) {
            int levelDelta = childPositions[pos];
            if ((cousin = cousin.getChildAtPosition(tupleFilter, levelDelta)) != null) continue;
            return null;
        }
        return cousin;
    }

    @Nullable
    public static OlapMember getCommonRoot(List<OlapMember> others) {
        if (others.isEmpty()) {
            return null;
        }
        if (others.size() == 1) {
            return others.get(0);
        }
        List roots = others.stream().map(OlapMember::getAncestors).collect(Collectors.toList());
        int levelIdx = 0;
        OlapMember commonRoot = null;
        OlapMember current;
        while ((current = (OlapMember)CdArrays.getNullable((Object[])((OlapMember[])roots.get(0)), (int)levelIdx)) != null) {
            for (int i = 1; i < roots.size(); ++i) {
                if (OlapMember.equal(current, (OlapMember)CdArrays.getNullable((Object[])((OlapMember[])roots.get(i)), (int)levelIdx))) continue;
                return commonRoot;
            }
            commonRoot = current;
            ++levelIdx;
        }
        return commonRoot;
    }

    @NotNull
    public OlapMember[] getAncestors() {
        int memberLevel = this.getLevel().getDepth();
        OlapMember[] ancestors = new OlapMember[memberLevel + 1];
        OlapMember parent = this;
        do {
            ancestors[parent.getLevel().getDepth()] = parent;
        } while ((parent = parent.getParent()) != null);
        return ancestors;
    }

    public static OlapMember[] getBranch(OlapMember node, OlapMember descendant) {
        if (!node.isAncestor(descendant)) {
            return new OlapMember[0];
        }
        int numBranchMembers = descendant.getLevel().getDepth() - node.getLevel().getDepth();
        OlapMember[] branch = new OlapMember[numBranchMembers];
        OlapMember descendantParent = descendant;
        do {
            branch[--numBranchMembers] = descendantParent;
        } while ((descendantParent = descendantParent.getParent()) != null && !OlapMember.equal(descendantParent, node));
        return branch;
    }

    public long sizeOf() {
        return this.shallowSizeOf();
    }

    protected abstract long shallowSizeOf();

    protected boolean needsBitmapAtOlapMemberLevel(OlapLevel level) {
        OlapHierarchy olapHierarchy = level.getHierarchy();
        return olapHierarchy.isBase();
    }

    protected boolean useDataHandler() {
        return true;
    }

    protected int getNextHierarchyMemberIndex() {
        return this.getHierarchy().getNextUniqueMemberIndex();
    }

    @Override
    public OlapMemberKey getKey() {
        return this.dataHandler.getKey(this.dataHandlerIdx);
    }

    @Override
    public Comparable getKeyValue() {
        return this.dataHandler.getSingleKeyValue(this.dataHandlerIdx);
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        String name = this.dataHandler.getName(this.dataHandlerIdx);
        return nameContext.getMemberName(this, name);
    }

    @Override
    public String getNameX() {
        return this.getName(OlapNameContext.DEFAULT_VALUES);
    }

    @Override
    public String getUniqueNameX() {
        return this.getUniqueName(OlapNameContext.DEFAULT_VALUES);
    }

    @Override
    public String getLevelNameX() {
        return this.getLevel().getNameX();
    }

    @Override
    public String getHierarchyNameX() {
        return this.getHierarchy().getNameX();
    }

    @Override
    public String getDimensionNameX() {
        return this.getDimension().getNameX();
    }

    @Override
    public OlapLevel getLevel() {
        return this.dataHandler.getLevel();
    }

    public int getLevelDepth() {
        return this.getLevel().getDepth();
    }

    @Nullable(value="if the dimension has only one hierarchy (not for terminal members)")
    public @Nullable(value="if the dimension has only one hierarchy (not for terminal members)") OlapBitmap getBaseMemberBitmap() {
        OlapLevel level = this.getLevel();
        if (level.isTerminal()) {
            return MutableRoaringBitmap.bitmapOfOne(this.getUniqueHierarchyMemberIndex());
        }
        return this.dataHandler.getAutoExist(this);
    }

    protected void setBaseMemberBitmap(OlapMember child) {
        if (!this.getHierarchy().isBase()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (this.getDimension().getHierarchyCount() == 1) {
            return;
        }
        this.dataHandler.addAutoExistRelation(this, child);
        OlapMember parent = this.getParent();
        if (parent != null) {
            parent.setBaseMemberBitmap(child);
        }
    }

    @Nullable
    public OlapBitmap getFullMemberBitmap() {
        if (this.getHierarchy().isBase() && this.getParent() != null && !this.getParent().isAll()) {
            MutableRoaringBitmap bitmap = OlapBitmap.createBitmap();
            OlapMember member = this;
            do {
                bitmap.setBit(member.uniqueHierarchyMemberIndex);
            } while ((member = member.getParent()) != null && !member.isAll());
            return bitmap;
        }
        return this.getBaseMemberBitmap();
    }

    @Override
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.getHierarchy().getTupleDimensionality();
    }

    public final int getUniqueHierarchyMemberIndex() {
        return this.uniqueHierarchyMemberIndex;
    }

    public void setLocalUniqueHierarchyMemberIndex(int localUniqueHierarchyMemberIndex) {
        throw new RuntimeException("internal error: inconsistent usage of setLocalUniqueHierarchyMemberIndex");
    }

    public final int getDataHandlerIdx() {
        return this.dataHandlerIdx;
    }

    protected boolean wantsAddToParent() {
        return true;
    }

    public boolean isDefinedAtSelectStatementLevel() {
        return false;
    }

    @Override
    public boolean isMdxNull() {
        return false;
    }

    @Override
    protected OlapTupleSet<OlapMember> toSet_(IOlapPrepareContext context) {
        return OlapSetFactory.singleton(this);
    }

    @Override
    public boolean isToSetApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public OlapTuple toTuple(IOlapPrepareContext context) {
        return this;
    }

    @Override
    public boolean isToTupleApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member")
    public @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member") OlapMember toNullableMember(IOlapPrepareContext context) {
        return this;
    }

    @Override
    public boolean isToMemberApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public OlapScalarEntity toValue(GFContext context, GFTupleEvaluator evaluator) {
        if (context.isConstrained()) {
            return (OlapScalarEntity)context.onConstrainedViolation();
        }
        if (this.isKO()) {
            return OlapEmptyEntity.INSTANCE;
        }
        return evaluator.getValue(context, this, false);
    }

    @Override
    public boolean isToValueApplicable(GFContext context, GFTupleEvaluator evaluator) {
        return true;
    }

    @Override
    public boolean isScoping(OlapMember member) {
        return member.equals(this);
    }

    @Override
    public boolean isScoping(OlapHierarchy hierarchy) {
        return hierarchy.equals(this.getHierarchy());
    }

    @Override
    public OlapEntityType getEntityType() {
        return OlapEntityType.MEMBER;
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        StringBuilder builder = new StringBuilder();
        OlapMemberUniqueNameType uniqueNameType = this.getUniqueNameType();
        this.appendUniqueName(builder, nameContext, uniqueNameType);
        return builder.toString();
    }

    public OlapMemberUniqueNameType getUniqueNameType() {
        if (this.isAll()) {
            return OlapMemberUniqueNameType.X_ALL;
        }
        if (this.getKey() == OlapNoValueMemberKey.INSTANCE) {
            if (this.getParent() != null) {
                return OlapMemberUniqueNameType.PARENT_NAME;
            }
            return OlapMemberUniqueNameType.LEVEL_NAME;
        }
        if (this.getLevel().isKeysUniqueFlag()) {
            return OlapMemberUniqueNameType.LEVEL_KEY;
        }
        if (this.getParent() != null) {
            return OlapMemberUniqueNameType.PARENT_KEY;
        }
        return OlapMemberUniqueNameType.X_OTHER;
    }

    protected void appendUniqueName(StringBuilder builder, OlapNameContext nameContext, OlapMemberUniqueNameType uniqueNameType) {
        switch (uniqueNameType) {
            case LEVEL_KEY: {
                OlapLevel level = this.getLevel();
                level.appendUniqueNameForMember(builder, nameContext);
                this.getKey().appendUniqueName(builder);
                break;
            }
            case LEVEL_NAME: {
                OlapLevel level = this.getLevel();
                level.appendUniqueNameForMember(builder, nameContext);
                this.doAppendMemberName(nameContext, builder);
                break;
            }
            case PARENT_KEY: {
                OlapMember parent = this.getParent();
                OlapMemberUniqueNameType parentUniqueNameType = parent.getUniqueNameType();
                parent.appendUniqueName(builder, nameContext, parentUniqueNameType);
                this.getKey().appendUniqueName(builder);
                break;
            }
            case PARENT_NAME: {
                OlapMember parent = this.getParent();
                OlapMemberUniqueNameType parentUniqueNameType = parent.getUniqueNameType();
                parent.appendUniqueName(builder, nameContext, parentUniqueNameType);
                this.doAppendMemberName(nameContext, builder);
                break;
            }
            case X_ALL: {
                this.doAppendUniqueNameWithoutKeys(builder, nameContext);
                break;
            }
            case X_OTHER: {
                this.appendUniqueNameSpecial(builder, nameContext, this.getLevel());
                break;
            }
            default: {
                throw new RuntimeException("internal error : unexpected member unique name type [" + String.valueOf((Object)uniqueNameType) + "]");
            }
        }
    }

    public String getUniqueNameWithoutKeys(OlapNameContext nameContext) {
        StringBuilder builder = new StringBuilder();
        this.doAppendUniqueNameWithoutKeys(builder, nameContext);
        return builder.toString();
    }

    private void appendUniqueNameSpecial(StringBuilder builder, OlapNameContext nameContext, OlapLevel olapLevel) {
        if (olapLevel.isNamesUniqueFlag()) {
            olapLevel.appendUniqueNameForMember(builder, nameContext);
            this.doAppendMemberName(nameContext, builder);
        } else {
            olapLevel.appendUniqueNameForMember(builder, nameContext);
            this.getKey().appendUniqueName(builder);
        }
    }

    private void doAppendUniqueNameWithoutKeys(StringBuilder builder, OlapNameContext nameContext) {
        OlapLevel level = this.getLevel();
        OlapMember parent = this.getParent();
        if (level.isAll()) {
            boolean collision = false;
            for (OlapLevel olapLevel : this.getHierarchy().getLevels()) {
                if (!OlapCaseInsensitiveName.equals(olapLevel.getName(nameContext), this.getName(nameContext))) continue;
                collision = true;
                break;
            }
            if (!collision) {
                this.getHierarchy().doAppendUniqueNameForMember(builder, nameContext);
                this.doAppendMemberName(nameContext, builder);
            } else {
                level.appendUniqueNameForMember(builder, nameContext);
                this.doAppendMemberName(nameContext, builder);
            }
        } else if (level.isNamesUniqueFlag()) {
            level.appendUniqueNameForMember(builder, nameContext);
            this.doAppendMemberName(nameContext, builder);
        } else if (level.isNameUniqueInParent() && parent != null) {
            parent.doAppendUniqueNameWithoutKeys(builder, nameContext);
            this.doAppendMemberName(nameContext, builder);
        } else {
            this.appendUniqueName(builder, nameContext, this.getUniqueNameType());
        }
    }

    private void doAppendMemberName(OlapNameContext nameContext, StringBuilder builder) {
        builder.append(".[").append(CdMdxUtils.escape((String)this.getName(nameContext))).append("]");
    }

    @Override
    public boolean isAllMember() {
        return this.isAll();
    }

    @Override
    public abstract boolean isAll();

    public OlapMemberRank getRank() {
        IntArrayList positions = new IntArrayList(this.getLevel().getDepth() + 1);
        OlapMember member = this;
        while (true) {
            OlapMember memberParent;
            if ((memberParent = member.getParent()) == null) break;
            positions.add(0, memberParent.getChildPosition(null, member));
            member = memberParent;
        }
        positions.add(0, member.isAll() ? 0 : member.getLevel().getMemberPosition(null, member));
        return new OlapMemberRank(positions);
    }

    public final OlapCube getCube() {
        OlapCube cube = this.getDimension().getCube();
        if (cube == null) {
            throw new RuntimeException("internal error: missing cube for measure [" + this.getNameX() + "]");
        }
        return cube;
    }

    public final OlapDimension getDimension() {
        return this.dataHandler.getDimension();
    }

    @Override
    public boolean isMember() {
        return true;
    }

    @Override
    public final OlapHierarchy getHierarchy() {
        return this.dataHandler.getHierarchy();
    }

    public int getTupleDimensionalityIndex() {
        return this.getHierarchy().getTupleDimensionalityIndex();
    }

    public boolean aggrFactsOnAncestors() {
        return this.getHierarchy().aggrFactsOnAncestors();
    }

    public OlapScalarEntity getValue(OlapNameContext nameContext) {
        OlapMemberKey key = this.getKey();
        if (key.isSingleValue()) {
            Comparable value = key.getValue();
            if (value instanceof LocalDate) {
                LocalDate date = (LocalDate)value;
                return new OlapDateEntity(date);
            }
            if (value instanceof LocalDateTime) {
                LocalDateTime date = (LocalDateTime)value;
                return new OlapDateTimeEntity(date);
            }
            if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                return new OlapNumericEntity((Long)value);
            }
            if (value instanceof Double || value instanceof Float) {
                return new OlapNumericEntity((Double)value);
            }
        }
        return new OlapStringEntity(this.getName(nameContext));
    }

    @Override
    public String getCaption(Locale locale, OlapNameContext nameContext) {
        String caption = this.doGetCaption(locale);
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            caption = this.getName(nameContext);
        }
        return caption;
    }

    @Nullable
    public String getCaptionEx(Locale locale, OlapNameContext nameContext) {
        String caption = this.doGetCaption(locale);
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            return null;
        }
        return caption;
    }

    @Nullable
    protected String doGetCaption(Locale locale) {
        OlapLevel level = this.dataHandler.getLevel();
        OlapSchema schema = level.getDimension().getSchema();
        if (this.isAll()) {
            OlapSchemaLocalization localization = schema.getLocalization();
            return localization.getAllMemberCaption(locale, this);
        }
        OlapMemberPropertyManager memberPropertyManager = schema.getMemberPropertyManager();
        List<OlapUserDefinedMemberProperty> properties = memberPropertyManager.getMemberCaptionProperty(level, locale);
        if (properties == null || properties.isEmpty()) {
            OlapSchemaLocalization localization = schema.getLocalization();
            return localization.getMemberCaption(locale, this);
        }
        String caption = null;
        for (int ii = 0; ii < properties.size(); ++ii) {
            String valueAsString;
            OlapUserDefinedMemberProperty property = properties.get(ii);
            OlapScalarEntity value = this.getPropertyValue(null, property);
            if (value == null || CdStringUtils.isNullOrBlank((String)(valueAsString = value.asString()))) continue;
            caption = valueAsString;
            break;
        }
        return caption;
    }

    @Override
    @Nullable
    public String getDescription(Locale locale) {
        OlapLevel level = this.dataHandler.getLevel();
        OlapSchema schema = level.getDimension().getSchema();
        if (this.isAll()) {
            OlapSchemaLocalization localization = schema.getLocalization();
            return localization.getAllMemberDescription(locale, this);
        }
        OlapSchemaLocalization localization = schema.getLocalization();
        return localization.getMemberDescription(locale, this);
    }

    @Nullable
    public OlapScalarEntity getUnaryOperator() {
        OlapLevel level = this.dataHandler.getLevel();
        OlapSchema schema = level.getDimension().getSchema();
        OlapMemberPropertyManager memberPropertyManager = schema.getMemberPropertyManager();
        OlapUserDefinedMemberProperty property = memberPropertyManager.getUnaryOperatorProperty(level);
        if (property == null) {
            return null;
        }
        return this.getPropertyValue(null, property);
    }

    @Nullable
    public boolean isSamePropertyValue(OlapUserDefinedMemberProperty property, Object value) {
        return this.dataHandler.isSamePropertyValue(this.dataHandlerIdx, property, value);
    }

    public OlapScalarEntity getPropertyValue(@Nullable OlapMemberFilter memberFilter, OlapUserDefinedMemberProperty property) {
        if (memberFilter != null && !memberFilter.isAccepting(property, this.getLevel())) {
            return OlapEmptyEntity.INSTANCE;
        }
        return this.doGetPropertyValue(memberFilter, property);
    }

    @Override
    public final OlapScalarEntity getPropertyValue(String name) {
        return this.getPropertyValue(null, name);
    }

    @Override
    @Nullable
    public final OlapScalarEntity getPropertyValue(@Nullable OlapMemberFilter memberFilter, String propertyName) {
        if (memberFilter != null && !memberFilter.isAccepting(propertyName, this.getLevel())) {
            return OlapEmptyEntity.INSTANCE;
        }
        return this.doGetPropertyValue(memberFilter, propertyName);
    }

    protected OlapScalarEntity doGetPropertyValue(@Nullable OlapMemberFilter memberFilter, OlapUserDefinedMemberProperty property) {
        return this.getPropertyValue(memberFilter, property.getName());
    }

    protected OlapScalarEntity doGetPropertyValue(@Nullable OlapMemberFilter memberFilter, String propertyName) {
        return this.dataHandler.getPropertyValue(this, this.dataHandlerIdx, memberFilter, propertyName);
    }

    @Nullable
    public OlapCellProperties getCellProperties() {
        return null;
    }

    @Override
    @Nullable
    public OlapCellPropertyValue getCellPropertyValue(OlapCellProperty property) {
        return null;
    }

    public OlapTuple asTuple() {
        return this;
    }

    @Override
    @Nullable
    public OlapMember getParent() {
        return this.dataHandler.getParent(this.dataHandlerIdx);
    }

    protected void setParent(OlapMember parent) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public OlapMember getRoot() {
        OlapMember parent = this.getParent();
        return parent == null ? this : parent.getRoot();
    }

    @Override
    public boolean isCalculated() {
        return false;
    }

    @Override
    public boolean isMeasureVector() {
        return false;
    }

    @Override
    public int getMeasureVectorSize() {
        return -1;
    }

    @Override
    public boolean isMeasure() {
        return false;
    }

    public int getXmlaChildrenCardinality(OlapMemberFilter tupleFilter) {
        try {
            return this.getXmlaChildrenCardinalityUnsafe(tupleFilter);
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[xmla] could not retrieve children", (Throwable)ex);
            return 0;
        }
    }

    private int getXmlaChildrenCardinalityUnsafe(OlapMemberFilter tupleFilter) {
        int count = 0;
        OlapIterator<OlapMember> children = this.getChildren(tupleFilter);
        children.reset();
        while (children.next() != null) {
            ++count;
        }
        return count;
    }

    public int getXmlaDescendantsCardinality(OlapMemberFilter tupleFilter) {
        try {
            return this.getXmlaDescendantsCardinalityUnsafe(tupleFilter);
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[xmla] could not retrieve descendants", (Throwable)ex);
            return 0;
        }
    }

    private int getXmlaDescendantsCardinalityUnsafe(OlapMemberFilter tupleFilter) {
        OlapMember member;
        int count = 0;
        OlapIterator<OlapMember> children = this.getChildren(tupleFilter);
        children.reset();
        while ((member = children.next()) != null) {
            count += 1 + member.getXmlaDescendantsCardinality(tupleFilter);
        }
        return count;
    }

    public boolean isLeaf() {
        return this.getChildrenCount() == 0;
    }

    public boolean isMdxLeaf(@Nullable OlapMemberFilter tupleFilter) {
        if (tupleFilter == null) {
            return this.isLeaf();
        }
        OlapIterator<OlapMember> myChildren = this.getChildren(tupleFilter);
        myChildren.reset();
        return myChildren.next() == null;
    }

    public abstract int getChildrenCount();

    public abstract int getChildrenCount(@Nullable OlapMemberFilter var1);

    @Override
    public abstract int getChildrenCountForDrilldown(OlapCalculatedMemberManager var1, @Nullable OlapMemberFilter var2);

    @Nullable
    public abstract OlapMember getFirstChild(@Nullable OlapMemberFilter var1);

    @Nullable
    public abstract OlapMember getLastChild(@Nullable OlapMemberFilter var1);

    @Nullable
    public abstract OlapMember getLastChildR(@Nullable OlapMemberFilter var1);

    public abstract OlapMember getChild(int var1);

    public abstract int getChildPosition(@Nullable OlapMemberFilter var1, OlapMember var2);

    @Nullable
    public abstract OlapMember getChildAtPosition(@Nullable OlapMemberFilter var1, int var2);

    public abstract OlapIterator<OlapMember> getChildren(@Nullable OlapMemberFilter var1);

    public abstract OlapIterator<OlapMember> getChildrenForMdxFunction(OlapCalculatedMemberManager var1, @Nullable OlapMemberFilter var2);

    public abstract OlapIterator<OlapMember> getChildrenR(@Nullable OlapMemberFilter var1, @Nullable OlapLevel var2, boolean var3);

    public abstract OlapMember addChild(OlapBuilderContext var1, OlapMember var2);

    public abstract OlapMember addBaseHierarchyChild(OlapBuilderContext var1, OlapMember var2);

    public void addLinkToMainMember(OlapMember mainHierChild) {
    }

    public OlapTupleSet<OlapMember> navigateMembers(@Nullable OlapMemberFilter tupleFilter, Predicate<OlapMember> accepting, boolean direction) {
        ArrayList<OlapMember> memberList = new ArrayList<OlapMember>();
        OlapLevelBaseNavigator navigator = direction ? new OlapLevelForwardNavigator(tupleFilter, this) : new OlapLevelBackwardNavigator(tupleFilter, this);
        OlapMember nextMember = this;
        while (nextMember != null && accepting.test(nextMember)) {
            memberList.add(nextMember);
            nextMember = navigator.next();
        }
        return OlapSetFactory.instance(direction ? memberList : Lists.reverse(memberList));
    }

    @Nullable
    public OlapMember getPrevMember(@Nullable OlapMemberFilter tupleFilter) {
        OlapLevelBackwardNavigator backNavigator = new OlapLevelBackwardNavigator(tupleFilter, this);
        return backNavigator.next();
    }

    @Nullable
    public OlapMember getNextMember(@Nullable OlapMemberFilter tupleFilter) {
        OlapLevelForwardNavigator forwardNavigator = new OlapLevelForwardNavigator(tupleFilter, this);
        return forwardNavigator.next();
    }

    @Nullable
    public OlapMember lag(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index < 0) {
            return this.lead(tupleFilter, -index);
        }
        OlapLevelBackwardNavigator backwardNavigator = new OlapLevelBackwardNavigator(tupleFilter, this);
        OlapMember previousMember = this;
        for (int i = 0; i < index; ++i) {
            previousMember = backwardNavigator.next();
            if (previousMember != null) continue;
            return null;
        }
        return previousMember;
    }

    @Nullable
    public OlapMember lead(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index < 0) {
            return this.lag(tupleFilter, -index);
        }
        OlapLevelForwardNavigator forwardNavigator = new OlapLevelForwardNavigator(tupleFilter, this);
        OlapMember nextMember = this;
        for (int i = 0; i < index; ++i) {
            nextMember = forwardNavigator.next();
            if (nextMember != null) continue;
            return null;
        }
        return nextMember;
    }

    public OlapTupleSet<OlapMember> lastPeriods(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index == 0) {
            return OlapSetFactory.empty();
        }
        if (index < 0) {
            ArrayList<OlapMember> memberList = new ArrayList<OlapMember>();
            OlapLevelForwardNavigator forwardNavigator = new OlapLevelForwardNavigator(tupleFilter, this);
            OlapMember nextMember = this;
            for (int i = 0; i < -index && nextMember != null; ++i) {
                memberList.add(nextMember);
                nextMember = forwardNavigator.next();
            }
            return OlapSetFactory.instance(memberList);
        }
        LinkedList<OlapMember> memberList = new LinkedList<OlapMember>();
        OlapLevelBackwardNavigator backwardNavigator = new OlapLevelBackwardNavigator(tupleFilter, this);
        OlapMember nextMember = this;
        for (int i = 0; i < index && nextMember != null; ++i) {
            memberList.addFirst(nextMember);
            nextMember = backwardNavigator.next();
        }
        return OlapSetFactory.instance(memberList);
    }

    public OlapTupleSet<OlapMember> periodsToDate(@Nullable OlapMemberFilter tupleFilter, OlapLevel level) {
        OlapMember begin;
        OlapMember ancestor = this.getAncestor(level);
        OlapMember olapMember = begin = ancestor == null ? null : ancestor.getFirstDescendant(tupleFilter, this.getLevel());
        if (begin == null) {
            return OlapSetFactory.empty();
        }
        ArrayList<OlapMember> memberList = new ArrayList<OlapMember>();
        OlapLevelForwardNavigator forwardNavigator = new OlapLevelForwardNavigator(tupleFilter, begin);
        OlapMember nextMember = begin;
        while (nextMember != null && !OlapMember.equal(nextMember, this)) {
            memberList.add(nextMember);
            nextMember = forwardNavigator.next();
        }
        memberList.add(this);
        return OlapSetFactory.instance(memberList);
    }

    public boolean isSibling(OlapMember member) {
        OlapMember parent = this.getParent();
        return this.getLevel().equals(member.getLevel()) && (parent == null || parent.equals(member.getParent()));
    }

    public OlapMember getFirstSibling(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember parent = this.getParent();
        OlapMember firstSibling = parent != null ? parent.getFirstChild(tupleFilter) : this.getHierarchy().getFirstRootMember(tupleFilter);
        if (firstSibling == null) {
            throw new CdProgrammingException("Inconsistent getFirstSibling usage!");
        }
        return firstSibling;
    }

    public OlapMember getLastSibling(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember parent = this.getParent();
        OlapMember lastSibling = parent != null ? parent.getLastChild(tupleFilter) : this.getHierarchy().getLastRootMember(tupleFilter);
        if (lastSibling == null) {
            throw new CdProgrammingException("Inconsistent getLastSibling usage!");
        }
        return lastSibling;
    }

    public OlapTupleSet<OlapMember> getSiblings(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember parent = this.getParent();
        if (parent != null) {
            return OlapSetFactory.instance(parent.getChildren(tupleFilter));
        }
        return this.getLevel().getMembers(tupleFilter);
    }

    @Nullable
    public OlapMember getBranchingMember(OlapMember member) {
        OlapMember thatAtLevel;
        OlapLevel olapLevel;
        OlapMember thisAtLevel;
        OlapMember lastMatchingMember = null;
        Iterator<OlapLevel> iterator = this.getHierarchy().getLevels().iterator();
        while (iterator.hasNext() && OlapMember.equal(thisAtLevel = this.getAncestor(olapLevel = iterator.next()), thatAtLevel = member.getAncestor(olapLevel)) && thisAtLevel != null) {
            lastMatchingMember = thisAtLevel;
        }
        return lastMatchingMember;
    }

    public boolean isSameBranch(OlapMember member) {
        if (!this.getHierarchy().equals(member.getHierarchy())) {
            return false;
        }
        if (OlapMember.equal(this, member)) {
            return true;
        }
        int comp = Integer.compare(this.getLevel().getDepth(), member.getLevel().getDepth());
        if (comp == 0) {
            return false;
        }
        if (comp > 0) {
            return OlapMember.isDescendant(member, this);
        }
        return OlapMember.isDescendant(this, member);
    }

    public boolean isDescendant(OlapMember ancestor) {
        if (!this.getHierarchy().equals(ancestor.getHierarchy())) {
            return false;
        }
        return !OlapMember.equal(this, ancestor) && OlapMember.isDescendant(ancestor, this);
    }

    @Override
    public boolean isAncestor(IResMember descendant) {
        return this.isAncestor((OlapMember)descendant);
    }

    public boolean isAncestor(OlapMember descendant) {
        if (!this.getHierarchy().equals(descendant.getHierarchy())) {
            return false;
        }
        return OlapMember.isDescendant(this, descendant);
    }

    public boolean isAncestorOrSame(OlapMember descendant) {
        if (OlapMember.equal(this, descendant)) {
            return true;
        }
        return this.isAncestor(descendant);
    }

    @Nullable
    public OlapMember getAncestor(OlapLevel level) {
        if (this.getLevel() == level) {
            return this;
        }
        if (!level.getHierarchy().equals(this.getHierarchy())) {
            throw new CdProgrammingException("Unexpected ancestor level '" + String.valueOf(level) + "' for member '" + String.valueOf(this) + "' of hierarchy '" + String.valueOf(this.getHierarchy()) + "'");
        }
        OlapMember parent = this;
        do {
            if (!parent.getLevel().equals(level)) continue;
            return parent;
        } while (parent.getLevel().getDepth() >= level.getDepth() && (parent = parent.getParent()) != null);
        return null;
    }

    @Nullable
    public OlapMember getAncestor(int distance) {
        OlapMember ancestor;
        if (distance < 0) {
            throw new CdProgrammingException("Unexpected ancestor distance '" + distance + "' for member '" + String.valueOf(this) + "' of hierarchy '" + String.valueOf(this.getHierarchy()) + "'");
        }
        for (ancestor = this; ancestor != null && distance > 0; ancestor = ancestor.getParent(), --distance) {
        }
        return ancestor;
    }

    public OlapTupleSet<OlapMember> getAscendants() {
        ArrayList<OlapMember> ascendants = new ArrayList<OlapMember>();
        for (OlapMember parent = this; parent != null; parent = parent.getParent()) {
            ascendants.add(parent);
        }
        return OlapSetFactory.instance(ascendants);
    }

    public OlapTupleSet<OlapMember> getDescendants(@Nullable OlapMemberFilter tupleFilter, @Nullable OlapLevel level, OlapOption descFlag) {
        if (level == null && descFlag == OlapOption.LEAVES) {
            return this.getDescendants(tupleFilter, Integer.MAX_VALUE, descFlag);
        }
        if (level == null) {
            level = this.getLevel();
        }
        if (level.getDepth() < this.getLevel().getDepth()) {
            return OlapSetFactory.empty();
        }
        if (!level.getHierarchy().equals(this.getHierarchy())) {
            throw new CdProgrammingException("Unexpected descendants level '" + String.valueOf(level) + "' for member '" + String.valueOf(this) + "' of hierarchy '" + String.valueOf(this.getHierarchy()) + "'");
        }
        int distance = level.getDepth() - this.getLevel().getDepth();
        return this.getDescendants(tupleFilter, distance, descFlag);
    }

    public OlapTupleSet<OlapMember> getDescendants(@Nullable OlapMemberFilter tupleFilter, int reqDistance, OlapOption descFlag) {
        if (reqDistance < 0) {
            return OlapSetFactory.empty();
        }
        OlapLevel lookupLevel = this.getLevel();
        int levelDepth = lookupLevel.getDepth();
        int distance = Math.min(reqDistance, this.getHierarchy().getLastLevel().getDepth() - lookupLevel.getDepth());
        OlapLevel maxLevel = this.getHierarchy().getLevelForDistance(levelDepth + distance);
        if (OlapOption.SELF == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, maxLevel, true);
            DistanceEqualIteratorFilter descendantFilter = new DistanceEqualIteratorFilter(levelDepth, distance);
            OlapIterator<OlapMember> xchildren = OlapIteratorFactory.filter(children, descendantFilter);
            return OlapSetFactory.instance(xchildren);
        }
        if (OlapOption.AFTER == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, null, true);
            DistanceGreaterIteratorFilter descendantFilter = new DistanceGreaterIteratorFilter(levelDepth, distance);
            OlapIterator<OlapMember> xchildren = OlapIteratorFactory.filter(children, descendantFilter);
            return OlapSetFactory.instance(xchildren);
        }
        if (OlapOption.BEFORE == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, maxLevel == null ? null : maxLevel.getPreviousLevel(), true);
            DistanceSmallerIteratorFilter descendantFilter = new DistanceSmallerIteratorFilter(levelDepth, distance);
            OlapIterator<OlapMember> xchildren = OlapIteratorFactory.filter(children, descendantFilter);
            return OlapSetFactory.instance(xchildren);
        }
        if (OlapOption.BEFORE_AND_AFTER == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, null, true);
            DistanceNotEqualIteratorFilter descendantFilter = new DistanceNotEqualIteratorFilter(levelDepth, distance);
            OlapIterator<OlapMember> xchildren = OlapIteratorFactory.filter(children, descendantFilter);
            return OlapSetFactory.instance(xchildren);
        }
        if (OlapOption.SELF_AND_AFTER == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, null, true);
            DistanceGreaterEqualIteratorFilter descendantFilter = new DistanceGreaterEqualIteratorFilter(levelDepth, distance);
            OlapIterator<OlapMember> xchildren = OlapIteratorFactory.filter(children, descendantFilter);
            return OlapSetFactory.instance(xchildren);
        }
        if (OlapOption.SELF_AND_BEFORE == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, maxLevel, true);
            DistanceSmallerEqualIteratorFilter descendantFilter = new DistanceSmallerEqualIteratorFilter(levelDepth, distance);
            OlapIterator<OlapMember> xchildren = OlapIteratorFactory.filter(children, descendantFilter);
            return OlapSetFactory.instance(xchildren);
        }
        if (OlapOption.SELF_BEFORE_AFTER == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, null, true);
            return OlapSetFactory.instance(children);
        }
        if (OlapOption.LEAVES == descFlag) {
            OlapIterator<OlapMember> children = this.getChildrenR(tupleFilter, null, true);
            OlapMemberOlapAbstractIteratorFilter descendantFilter = new OlapMemberOlapAbstractIteratorFilter(levelDepth, distance, tupleFilter);
            OlapIterator<OlapMember> xchildren = OlapIteratorFactory.filter(children, descendantFilter);
            return OlapSetFactory.instance(xchildren);
        }
        throw new CdProgrammingException("Inconsistent code!");
    }

    @Nullable
    public OlapMember cousin(@Nullable OlapMemberFilter tupleFilter, OlapMember ancestor) {
        int memberDepth = this.getLevel().getDepth();
        int ancestorDepth = ancestor.getLevel().getDepth();
        if (ancestorDepth == memberDepth) {
            return ancestor;
        }
        if (ancestorDepth > memberDepth) {
            return null;
        }
        int[] memberLevels = this.getRelativeChildPositions(tupleFilter);
        OlapMember cousin = OlapMember.applyRelativePositions(tupleFilter, ancestor, memberLevels);
        return cousin;
    }

    private int[] getRelativeChildPositions(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember memberParent;
        OlapMember parent = this.getParent();
        if (parent == null) {
            return new int[0];
        }
        int[] levels = new int[parent.getLevel().getDepth() + 1];
        OlapMember member = this;
        while ((memberParent = member.getParent()) != null) {
            int posInLevel;
            levels[memberParent.getLevel().getDepth()] = posInLevel = memberParent.getChildPosition(tupleFilter, member);
            member = memberParent;
        }
        return levels;
    }

    public abstract boolean isMdxGeneration(@Nullable OlapMemberFilter var1, int var2);

    @Override
    @Nullable
    public OlapTuple extract(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache, @Nullable OlapTupleFilter tupleFilter, Collection<OlapHierarchy> hierarchies) {
        if (hierarchies.isEmpty()) {
            return this;
        }
        if (hierarchies.contains(this.getHierarchy())) {
            return this;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapTuple extractOthers(IOlapEvaluationExceptionContext errContext, OlapTupleDimensionalityCache cache, OlapTupleFilter tupleFilter, Set<OlapHierarchy> hierarchies) {
        if (!hierarchies.contains(this.getHierarchy())) {
            return this;
        }
        return null;
    }

    @Nullable
    public OlapMember openingPeriod(@Nullable OlapMemberFilter tupleFilter, OlapLevel level) {
        return this.openingClosingPeriod(tupleFilter, level, true);
    }

    @Nullable
    public OlapMember closingPeriod(@Nullable OlapMemberFilter tupleFilter, OlapLevel level) {
        return this.openingClosingPeriod(tupleFilter, level, false);
    }

    @Nullable
    private OlapMember openingClosingPeriod(@Nullable OlapMemberFilter tupleFilter, OlapLevel level, boolean isOpening) {
        if (level.getDepth() < this.getLevel().getDepth()) {
            return null;
        }
        OlapMember ancestor = this.getAncestor(level);
        OlapMember period = ancestor == null ? (isOpening ? this.getFirstDescendant(tupleFilter, level) : this.getLastDescendant(tupleFilter, level)) : (isOpening ? ancestor.getFirstDescendant(tupleFilter, this.getLevel()) : ancestor.getLastDescendant(tupleFilter, this.getLevel()));
        return period;
    }

    @Nullable
    public OlapMember getFirstDescendant(@Nullable OlapMemberFilter tupleFilter, @Nullable OlapLevel level) {
        if (level == this.getLevel()) {
            return this;
        }
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            if (level == null) {
                return this;
            }
            if (level.getDepth() < this.getLevel().getDepth()) {
                return null;
            }
        }
        for (int idx = 0; idx < childrenCount; ++idx) {
            OlapMember firstDescendant;
            OlapMember child = this.getChild(idx);
            if (tupleFilter != null && !tupleFilter.isAccepting(child) || (firstDescendant = child.getFirstDescendant(tupleFilter, level)) == null) continue;
            return firstDescendant;
        }
        return null;
    }

    @Nullable
    public OlapMember getLastDescendant(@Nullable OlapMemberFilter tupleFilter, @Nullable OlapLevel level) {
        if (level == this.getLevel()) {
            return this;
        }
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            if (level == null) {
                return this;
            }
            if (level.getDepth() < this.getLevel().getDepth()) {
                return null;
            }
        }
        for (int idx = childrenCount - 1; idx >= 0; --idx) {
            OlapMember lastDescendant;
            OlapMember child = this.getChild(idx);
            if (tupleFilter != null && !tupleFilter.isAccepting(child) || (lastDescendant = child.getLastDescendant(tupleFilter, level)) == null) continue;
            return lastDescendant;
        }
        return null;
    }

    public OlapNonScalarEntity linkMember(OlapNameContext nameContext, IOlapDimensionsPermission permissions, OlapHierarchy hierarchy) {
        if (this.getHierarchy().equals(hierarchy)) {
            return this;
        }
        OlapMemberKey key = this.getKey();
        if (key == OlapNoValueMemberKey.INSTANCE) {
            return OlapNullEntity.INSTANCE;
        }
        OlapEntityIdentifier memberKeyIdentifier = key.asIdentifier();
        OlapNonScalarEntity link = hierarchy.lookupEntityByMdxIdentifier(nameContext, permissions, memberKeyIdentifier);
        return link;
    }

    public OlapAggregationType getHierarchyAggregationType() {
        throw new CdProgrammingException("Inconsistent getHierarchyAggregationType usage.");
    }

    @Override
    public int getMemberCount() {
        return 1;
    }

    @Override
    public OlapMember getMember(int idx) {
        if (idx != 0) {
            throw new CdProgrammingException("Inconsistent getMember(" + idx + ") usage '" + String.valueOf(this) + "'");
        }
        return this;
    }

    @Override
    @Nullable
    public OlapMember getTuple(OlapEvaluationContext context, OlapDimension dimension) {
        return this.getDimension().equals(dimension) ? this : null;
    }

    @Override
    public boolean hasMember(OlapDimension dimension) {
        return this.getDimension().equals(dimension);
    }

    @Override
    public boolean hasMember(OlapHierarchy hierarchy) {
        return this.getHierarchy().equals(hierarchy);
    }

    @Override
    public boolean hasMember(OlapMember member) {
        return OlapMember.equal(this, member);
    }

    @Override
    @Nullable
    public OlapMember getMember(OlapHierarchy hierarchy) {
        return this.getHierarchy().equals(hierarchy) ? this : null;
    }

    @Override
    @Nullable
    public OlapMember getMember(OlapHierarchy hierarchy, int idx) {
        return idx == 0 ? this.getMember(hierarchy) : null;
    }

    @Override
    public int getMemberPos(OlapHierarchy hierarchy) {
        return this.getHierarchy().equals(hierarchy) ? 0 : -1;
    }

    @Override
    @Nullable
    public OlapMember getMeasureMember() {
        return null;
    }

    @Override
    public OlapTuple replace(int pos, OlapMember member) {
        if (pos != 0) {
            throw new RuntimeException("internal error: inconsistent member pos [" + pos + "]!");
        }
        if (!this.getHierarchy().equals(member.getHierarchy())) {
            throw new RuntimeException("internal error: inconsistent member hierarchy [" + ONames.uname4Log(member.getHierarchy()) + "]!");
        }
        return member;
    }

    public final OlapTupleSet<? extends OlapMember> drilldown(@Nullable OlapMemberFilter memberFilter, @Nullable OlapTupleFilter tupleFilter, int pos) {
        if (pos != 0) {
            throw new CdProgrammingException("Inconsistent member pos [" + pos + "]!");
        }
        OlapIterator<OlapMember> children = this.getChildren(memberFilter);
        return OlapSetFactory.instance(children);
    }

    @Override
    public boolean exists(@Nullable OlapTupleFilter filter) {
        if (filter != null) {
            return filter.isAccepting(this);
        }
        return true;
    }

    @Override
    public List<OlapDimension> getDimensions() {
        ArrayList<OlapDimension> dimensions = new ArrayList<OlapDimension>(1);
        dimensions.add(this.getDimension());
        return dimensions;
    }

    @Override
    public List<OlapHierarchy> getTupleHierarchies() {
        ArrayList<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>(1);
        hierarchies.add(this.getHierarchy());
        return hierarchies;
    }

    @Override
    public boolean hasCalcMember() {
        return this.isCalculated();
    }

    @Override
    public OlapTuple removeCalcMembers(IOlapEvaluationExceptionContext context, OlapTupleDimensionalityCache cache) {
        if (this.isCalculated()) {
            return null;
        }
        return this;
    }

    @Override
    public boolean contains(OlapTuple tuple) {
        return tuple instanceof OlapMember && (OlapMember.equal(this, (OlapMember)tuple) || this.isAncestor((OlapMember)tuple));
    }

    @Nullable
    public abstract OlapMember unfilteredLookupMemberByName(OlapNameContext var1, String var2);

    @Override
    public boolean inSubTuple(OlapTuple lookup, OlapBitSet bitSet) {
        return lookup.getMemberCount() == 1 && OlapMember.equal(this, lookup.getMember(0));
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public boolean isDefault(@Nullable OlapMemberFilter tupleFilter) {
        return this.getHierarchy().isDefaultMember(tupleFilter, this);
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof OlapMember && OlapMember.equal(this, (OlapMember)obj);
    }

    @Override
    public int hashCode() {
        return 31 * this.getLevel().hashCode() + Integer.hashCode(this.uniqueHierarchyMemberIndex);
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) {
        return ONames.uname4Log(this);
    }

    @Override
    public int compareTo(OlapMemberKey keyValue) {
        return this.getKey().compareTo(keyValue);
    }

    @Override
    public String toString() {
        return this.getNameX() + " [H:" + this.getTupleDimensionalityIndex() + "]";
    }

    @Override
    public void setDimensionBitSet(OlapBitSet tupleDim) {
        tupleDim.set(this.getDimension().getDimensionalityIndex());
    }

    @Override
    @Nullable
    public OlapMember getMemberByDimensionality(int tupleDimensionality) {
        if (this.getHierarchy().getTupleDimensionalityIndex() == tupleDimensionality) {
            return this;
        }
        return null;
    }

    @Override
    public OlapDimensionality createDimensionality() {
        OlapDimensionality dimensionality = new OlapDimensionality();
        dimensionality.add(this.getDimension());
        return dimensionality;
    }

    @Override
    public void addMembersInArray(OlapMember[] array, int position) {
        array[position] = this;
    }

    @Nullable
    public abstract OlapMember lookupMemberByRange(Object var1, @Nullable OlapLevel var2);

    public abstract int validateIndexingByRange(OlapBuilderErrorManager var1, int var2, OlapMemberKey var3, OlapMemberKey var4);

    public void onFinishLoad() {
    }

    public String getMeasureGroupName() {
        return "";
    }

    public String getMeasureGroupNameForPermissions() {
        return "";
    }

    public boolean forEachNoBaseTerminalMember(OlapMember baseMember, CdAction<OlapMember> action) {
        return false;
    }

    public boolean isCategoryMember() {
        return false;
    }

    public boolean isIn4Facts(OlapDimensionality dimensionality) {
        return dimensionality.isIn(this.getDimension());
    }

    public boolean canNotBeCompacted() {
        return false;
    }

    public abstract void removeChildren();

    @Nullable
    public abstract OlapMember lookupChildByNameIgnoreCase(String var1);

    @Nullable
    public abstract OlapMember lookupChildByKeyValue(OlapLevel var1, Object var2);

    public boolean equalsWithKeyForCompare(Object keyForCompare) {
        if (this.isCreatedUnknownMember() || !this.useDataHandler()) {
            return false;
        }
        return this.compareWithKeyForCompare(keyForCompare) == 0;
    }

    public int compareWithKeyForCompare(Object keyForCompare) {
        try {
            return this.dataHandler.naturalCompareWithKeyForCompare(this.dataHandlerIdx, keyForCompare);
        }
        catch (RuntimeException npe) {
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  D: " + this.getDimension().getNameX())));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  H: " + this.getHierarchy().getNameX())));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  L: " + this.getLevel().getNameX())));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  N: " + this.getName(OlapNameContext.DEFAULT_VALUES))));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  C: " + this.getClass().getSimpleName())));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  I: " + this.dataHandlerIdx)));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  T: " + Arrays.toString((Object[])this.dataHandler.getKeyType()))));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare  K: " + String.valueOf(this.getKey()))));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare PC: " + String.valueOf(keyForCompare != null ? keyForCompare.getClass() : ""))));
            OlapMember.safeLog(() -> OlapLoggers.BUILDER.error((Object)("internal error: compareWithKeyForCompare PV: " + String.valueOf(keyForCompare))));
            throw npe;
        }
    }

    private static void safeLog(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean nameEqualsIgnoreCase(String name) {
        return this.dataHandler.nameEqualsIgnoreCase(this.dataHandlerIdx, name);
    }

    public OlapBitmap getBaseMemberBitmap4Exist() {
        return this.getBaseMemberBitmap();
    }

    public boolean isCreatedUnknownMember() {
        return OlapMember.equal(this.getLevel().getCreatedUnkownMember(), this);
    }

    public boolean isVisible() {
        return true;
    }

    public boolean hasPositionInAnchor() {
        throw new RuntimeException("internal error: inconsistent usage of hasPositionInAnchor");
    }

    public void setPositionInAnchor(int position) {
        throw new RuntimeException("internal error: inconsistent usage of setPositionInAnchor");
    }

    @Nullable
    public String getAssociatedMeasureGroup() {
        return null;
    }

    @Nullable
    public String getDisplayFolder(Locale locale, OlapNameContext context) {
        return null;
    }

    @Nullable
    protected String getDisplayFolder(Locale locale, OlapNameContext context, @Nullable String displayFolder) {
        if (CdStringUtils.isNullOrBlank((String)displayFolder)) {
            return null;
        }
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String df = localization.getMeasureDisplayFolder(locale, this);
        if (CdStringUtils.isNullOrBlank((String)df)) {
            return displayFolder;
        }
        return df;
    }

    public boolean isOtherCategory() {
        return false;
    }

    public void resetCategory() {
    }

    @Override
    public boolean isInTupleDim(OlapTuple tuple) {
        return this.getTupleDimensionality().intersects(tuple.getTupleDimensionality());
    }

    @Override
    public void forEach(Consumer<OlapMember> consumer, Predicate<OlapMember> filter) {
        if (filter.test(this)) {
            consumer.accept(this);
        }
    }

    @Override
    public S_TupleDimensionality getClusterTupleDimensionality() {
        OlapTupleDimensionality dimensionality = this.getTupleDimensionality();
        return dimensionality;
    }

    @Override
    public void forEach(S_FactMemberDefIndices indices) {
        OlapMember fMember = this.getFactIndexingMember();
        S_MemberDefType fMemberType = S_MemberDefType.memberType(fMember);
        int iHierarchyIndex = this.getHierarchy().getTupleDimensionalityIndex();
        int hierarchyIndex = fMember.getHierarchy().getTupleDimensionalityIndex();
        int memberIndex = fMember.getUniqueHierarchyMemberIndex();
        S_FactMemberInfo info = S_FactMemberInfo.setup(fMemberType, fMember);
        try {
            indices.apply(fMemberType, iHierarchyIndex, hierarchyIndex, memberIndex, info);
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)("[mdx] unexpected member.forEach() error [" + this.getDimensionNameX() + "][" + this.getHierarchyNameX() + "][" + this.getNameX() + "]"), (Throwable)ex);
            throw ex;
        }
    }

    public void touch() {
    }

    @Override
    public boolean existAllways() {
        OlapBitmap bitmap4Exist = this.getBaseMemberBitmap4Exist();
        return bitmap4Exist == null || bitmap4Exist.isOne();
    }

    @Nullable
    public OlapMember getDefinedFactIndexingMember() {
        return this;
    }

    @NotNull
    public OlapMember getFactIndexingMember() {
        return this;
    }

    public boolean isFactHollow() {
        return false;
    }

    public boolean isStructuralFactHollow() {
        return false;
    }

    public abstract long getDescendantsCount();

    public OlapMember getMemberForSecurity() {
        return this;
    }

    @Nullable
    public abstract OlapMember lookupChildByMdxIdentifier(OlapNameContext var1, OlapMemberFilter var2, Predicate<OlapMember> var3);

    public final int addAttributeMember(OlapMember noBaseMember) {
        if (!this.getHierarchy().isBase()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        return this.dataHandler.addAttributeMember(this.dataHandlerIdx, noBaseMember);
    }

    @Nullable
    public final OlapMember getAttributeMember(OlapHierarchy hierarchy) {
        return this.dataHandler.getAttributeMember(this.dataHandlerIdx, hierarchy);
    }

    public boolean hasUserDefinedProperty(String propName) {
        return this.dataHandler.hasUserDefinedProperty(propName);
    }

    public void forEachFamilyMember(CdAction<OlapMember> action) {
        for (OlapMember p = this; p != null; p = p.getParent()) {
            action.apply((Object)p);
        }
        int count = this.getChildrenCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).forEachAndDescendants(action);
        }
    }

    public void forEachAndDescendants(CdAction<OlapMember> action) {
        action.apply((Object)this);
        int count = this.getChildrenCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).forEachFamilyMember(action);
        }
    }

    public void forEachAndAncestor(CdAction<OlapMember> action) {
        for (OlapMember member = this; member != null; member = member.getParent()) {
            action.apply((Object)member);
        }
    }

    public void setDefinedIndexingMember(@Nullable OlapMember factMember) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public static boolean equals(List<OlapMember> members, List<OlapMember> other) {
        if (members.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < members.size(); ++i) {
            OlapMember elotro;
            OlapMember este = members.get(i);
            if (OlapMember.equal(este, elotro = other.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLastLevel() {
        return this.getLevel().isLast();
    }

    private static class DistanceEqualIteratorFilter
    extends LevelDepthIteratorFilter {
        public DistanceEqualIteratorFilter(int levelDepth, int distance) {
            super(levelDepth, distance);
        }

        @Override
        public boolean accept(OlapMember olapMember) {
            int childDistance = olapMember.getLevel().getDepth() - this.levelDepth;
            return childDistance == this.distance;
        }
    }

    private static class DistanceGreaterIteratorFilter
    extends LevelDepthIteratorFilter {
        public DistanceGreaterIteratorFilter(int levelDepth, int distance) {
            super(levelDepth, distance);
        }

        @Override
        public boolean accept(OlapMember olapMember) {
            int childDistance = olapMember.getLevel().getDepth() - this.levelDepth;
            return childDistance > this.distance;
        }
    }

    private static class DistanceSmallerIteratorFilter
    extends LevelDepthIteratorFilter {
        public DistanceSmallerIteratorFilter(int levelDepth, int distance) {
            super(levelDepth, distance);
        }

        @Override
        public boolean accept(OlapMember olapMember) {
            int childDistance = olapMember.getLevel().getDepth() - this.levelDepth;
            return childDistance < this.distance;
        }
    }

    private static class DistanceNotEqualIteratorFilter
    extends LevelDepthIteratorFilter {
        public DistanceNotEqualIteratorFilter(int levelDepth, int distance) {
            super(levelDepth, distance);
        }

        @Override
        public boolean accept(OlapMember olapMember) {
            int childDistance = olapMember.getLevel().getDepth() - this.levelDepth;
            return childDistance != this.distance;
        }
    }

    private static class DistanceGreaterEqualIteratorFilter
    extends LevelDepthIteratorFilter {
        public DistanceGreaterEqualIteratorFilter(int levelDepth, int distance) {
            super(levelDepth, distance);
        }

        @Override
        public boolean accept(OlapMember olapMember) {
            int childDistance = olapMember.getLevel().getDepth() - this.levelDepth;
            return childDistance >= this.distance;
        }
    }

    private static class DistanceSmallerEqualIteratorFilter
    extends LevelDepthIteratorFilter {
        public DistanceSmallerEqualIteratorFilter(int levelDepth, int distance) {
            super(levelDepth, distance);
        }

        @Override
        public boolean accept(OlapMember olapMember) {
            int childDistance = olapMember.getLevel().getDepth() - this.levelDepth;
            return childDistance <= this.distance;
        }
    }

    private static class OlapMemberOlapAbstractIteratorFilter
    implements OlapAbstractIteratorFilter<OlapMember> {
        private final int levelDepth;
        private final int distance;
        private final OlapMemberFilter tupleFilter;

        public OlapMemberOlapAbstractIteratorFilter(int levelDepth, int distance, OlapMemberFilter tupleFilter) {
            this.levelDepth = levelDepth;
            this.distance = distance;
            this.tupleFilter = tupleFilter;
        }

        @Override
        public boolean accept(OlapMember olapMember) {
            int childDistance = olapMember.getLevel().getDepth() - this.levelDepth;
            return childDistance == this.distance || childDistance < this.distance && olapMember.isMdxLeaf(this.tupleFilter);
        }

        @Override
        public IOlapIteratorFilter<OlapMember> newInstance() {
            return this;
        }
    }

    private static abstract class LevelDepthIteratorFilter
    implements OlapAbstractIteratorFilter<OlapMember> {
        protected final int levelDepth;
        protected final int distance;

        public LevelDepthIteratorFilter(int levelDepth, int distance) {
            this.levelDepth = levelDepth;
            this.distance = distance;
        }

        @Override
        public IOlapIteratorFilter<OlapMember> newInstance() {
            return this;
        }
    }
}

