/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapIteratorHelper;
import crazydev.iccube.collection.olapiterator.OlapChildrenRIterator;
import crazydev.iccube.olap.entity.IOlapEntityWithChildren;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.request.request.IcCubeRequest;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class OlapLevelBaseNavigator
implements OlapIterator<OlapMember> {
    @Nullable
    protected final OlapMemberFilter tupleFilter;
    protected final OlapLevel lookupLevel;
    protected final OlapMember lookupMember;
    protected final boolean includeFirst;
    private final OlapTupleDimensionality tupleDimensionality;
    private final int direction;
    private boolean algo0Active;
    private boolean algo1Active;
    private int algo1Position;
    private IOlapEntityWithChildren algo1Parent;
    private Algo2Iterator algo2Iterator;

    public OlapLevelBaseNavigator(@Nullable OlapMemberFilter tupleFilter, OlapMember member, boolean includeFirst, int direction) {
        this.tupleFilter = tupleFilter;
        this.lookupMember = member;
        this.direction = direction;
        this.lookupLevel = member.getLevel();
        this.includeFirst = includeFirst;
        this.tupleDimensionality = this.lookupLevel.getHierarchy().getTupleDimensionality();
        this.reset();
    }

    @Override
    public boolean isCrossjoin() {
        return false;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        return this._sizeSlow();
    }

    @Override
    public boolean mightHaveCalcMember() {
        return false;
    }

    @Override
    @Nullable
    public List<OlapMember> tryExtractMeasures(OlapHierarchy measureHierarchy) {
        if (this.lookupLevel.getHierarchy().isMeasures()) {
            List<OlapMember> measures = OlapIteratorHelper.extractTuplesForMeasures(this);
            return measures;
        }
        return Collections.emptyList();
    }

    @Override
    public void reset() {
        this.algo0Active = this.includeFirst;
        this.algo1Active = true;
        this.algo1Position = -1;
        this.algo1Parent = null;
        this.algo2Iterator = null;
    }

    @Override
    @Nullable
    public OlapMember next() {
        IcCubeRequest.assertNotCancelled("set-iteration");
        if (this.algo0Active) {
            this.algo0Active = false;
            return this.lookupMember;
        }
        if (this.algo1Active) {
            if (this.algo1Parent == null) {
                this.initAlgo1();
            }
            while (this.algo1Position >= 0 && this.algo1Position < this.algo1Parent.getChildrenCount()) {
                OlapMember potentialMember = this.algo1Parent.getChild(this.algo1Position);
                this.algo1Position += this.direction;
                if (!this.isAccepting(potentialMember)) continue;
                return potentialMember;
            }
            this.algo1Active = false;
        }
        if (this.algo2Iterator == null) {
            this.algo2Iterator = new Algo2Iterator(this, this.getParentEntityWithChildren(this.lookupMember));
        }
        return this.algo2Iterator.next();
    }

    private void initAlgo1() {
        IOlapEntityWithChildren parent = this.getParentEntityWithChildren(this.lookupMember);
        if (parent != null) {
            this.algo1Parent = parent;
            this.algo1Position = this.algo1Parent.getChildPosition(null, this.lookupMember);
            this.algo1Position += this.direction;
        }
    }

    private IOlapEntityWithChildren getParentEntityWithChildren(OlapMember member) {
        OlapMember parent = member.getParent();
        return parent == null ? member.getHierarchy() : (IOlapEntityWithChildren)((Object)parent);
    }

    private boolean isAccepting(OlapMember member) {
        return member.getLevel() == this.lookupLevel && this.isSubSelecting(member);
    }

    private boolean isSubSelecting(OlapMember member) {
        return this.tupleFilter == null || this.tupleFilter.isAccepting(member);
    }

    @Override
    public boolean _isEmpty() {
        throw new CdProgrammingException("");
    }

    @Override
    public int _sizeSlow() {
        OlapIterator iter = this.newInstance();
        int count = 0;
        while (iter.next() != null) {
            ++count;
        }
        return count;
    }

    @Override
    public OlapMember _getSlow(int index) {
        OlapMember lmember;
        OlapIterator iter = this.newInstance();
        int count = 0;
        while ((lmember = (OlapMember)iter.next()) != null) {
            if (count++ != index) continue;
            return lmember;
        }
        return null;
    }

    @Override
    public boolean isMemberIterator() {
        return true;
    }

    @Override
    public boolean isMembersCrossjoin() {
        return true;
    }

    @Override
    public boolean isCacheUseless() {
        return false;
    }

    protected abstract OlapChildrenRIterator newChildrenRIterator(OlapMember var1, OlapLevel var2);

    @Override
    public List<List<OlapMember>> asCrossjoinMaterializedTuples() {
        return OlapIterator.asCrossjoinMaterializedTuples(this);
    }

    private class Algo2Iterator {
        private OlapChildrenRIterator childrenIterator;
        private IOlapEntityWithChildren brotherParent;
        private IOlapEntityWithChildren brother;
        private int nextBrotherPosition;
        final /* synthetic */ OlapLevelBaseNavigator this$0;

        public Algo2Iterator(OlapLevelBaseNavigator olapLevelBaseNavigator, IOlapEntityWithChildren parentMember) {
            OlapLevelBaseNavigator olapLevelBaseNavigator2 = olapLevelBaseNavigator;
            Objects.requireNonNull(olapLevelBaseNavigator2);
            this.this$0 = olapLevelBaseNavigator2;
            this.brother = parentMember;
            this.moveToBrotherParent();
        }

        @Nullable
        public OlapMember next() {
            while (this.childrenIterator != null) {
                OlapMember member;
                while ((member = (OlapMember)this.childrenIterator.next()) != null && !this.this$0.isAccepting(member)) {
                }
                if (member == null) {
                    this.buildNextRIterator();
                    continue;
                }
                return member;
            }
            return null;
        }

        private void buildNextRIterator() {
            if (this.brotherParent != null) {
                while (this.nextBrotherPosition >= 0 && this.nextBrotherPosition < this.brotherParent.getChildrenCount()) {
                    OlapMember rootForRIterator = this.brotherParent.getChild(this.nextBrotherPosition);
                    this.nextBrotherPosition += this.this$0.direction;
                    if (!this.this$0.isSubSelecting(rootForRIterator)) continue;
                    this.childrenIterator = this.this$0.newChildrenRIterator(rootForRIterator, this.this$0.lookupLevel);
                    return;
                }
                this.brother = this.brotherParent;
                this.moveToBrotherParent();
            } else {
                this.childrenIterator = null;
            }
        }

        private void moveToBrotherParent() {
            this.brotherParent = this.brother == null ? null : this.brother.getEntityWithChildrenParent();
            this.nextBrotherPosition = this.brotherParent == null ? -1 : this.brotherParent.getChildPosition(null, (OlapMember)((Object)this.brother)) + this.this$0.direction;
            this.buildNextRIterator();
        }
    }
}

