/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMemberLogic;
import crazydev.iccube.olap.entity.member.OlapCategoryMember;
import crazydev.iccube.olap.entity.member.OlapSubCubeCategoryMemberLogic;
import crazydev.iccube.olap.entity.member.OlapTupleSetCategoryMemberLogic;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryMemberStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class OlapCategoryMemberLogicFactory {
    private final OlapCategoryMember category;
    private final OlapEngineRequestContext c_context;
    private final OlapProperties c_requestProperties;
    @Nullable
    private final OlapInstrExecListener c_instrExecListener;
    private final OlapSchema c_schema;
    private final OlapInstr instr;
    private final OlapHierarchyScope scope;
    private final OlapEntityIdentifier id;
    private final boolean dynamicEvaluation;
    private final OlapInstr formula;
    private final OlapCategoryMemberProperties properties;
    private final Object logicLOCK = new Object();
    @Nullable
    private OlapAbstractCategoryMemberLogic logic;

    OlapCategoryMemberLogicFactory(OlapCategoryMember category, OlapMdxStatementExecutionContext context, OlapInstr instr, OlapHierarchyScope scope, OlapEntityIdentifier id, boolean dynamicEvaluation, OlapInstr formula, OlapCategoryMemberProperties properties) {
        this.instr = instr;
        this.scope = scope;
        this.id = id;
        this.dynamicEvaluation = dynamicEvaluation;
        this.c_context = context.getRequestContext();
        this.c_requestProperties = context.getRequestProperties();
        this.c_instrExecListener = context.getInstrExecListener();
        this.c_schema = context.getSchema();
        this.category = category;
        this.formula = formula;
        this.properties = properties;
    }

    boolean isDynamic() {
        return this.dynamicEvaluation;
    }

    boolean isOtherCategory() {
        OlapAbstractCategoryMemberLogic logic = this.setupForOnDemandStaticEvaluation();
        return logic.isOther();
    }

    @Nullable
    OlapIterator<? extends OlapTuple> getTupleIterator() {
        OlapAbstractCategoryMemberLogic logic = this.setupForOnDemandStaticEvaluation();
        return logic.getTupleIterator();
    }

    @Nullable
    OlapSubCubeEntity getSubCube() {
        OlapAbstractCategoryMemberLogic logic = this.setupForOnDemandStaticEvaluation();
        return logic.getSubCube();
    }

    void touch() {
        this.setupForOnDemandStaticEvaluation();
    }

    OlapCategoryMemberProperties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasLogic() {
        Object object = this.logicLOCK;
        synchronized (object) {
            return this.logic != null;
        }
    }

    OlapAbstractCategoryMemberLogic getLogic() {
        OlapAbstractCategoryMemberLogic logic = this.setupForOnDemandStaticEvaluation();
        return logic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupForRequestStaticEvaluation(OlapMdxStatementExecutionContext context) {
        Object object = this.logicLOCK;
        synchronized (object) {
            if (OlapHierarchyScope.REQUEST == this.scope && !this.dynamicEvaluation) {
                if (this.logic != null) {
                    throw new RuntimeException("internal error: unexpected logic for (static) category [" + ONames.uname4Log(this.category) + "]");
                }
                Object entity = this.instr.evaluateCategoryMemberFormula(context, this.scope, this.id, false, this.formula);
                this.logic = this.createLogic(entity);
                this.logic.init(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupForRequestDynamicEvaluation(OlapMdxStatementExecutionContext context) {
        Object object = this.logicLOCK;
        synchronized (object) {
            if (OlapHierarchyScope.REQUEST == this.scope && this.dynamicEvaluation) {
                if (this.logic != null) {
                    throw new RuntimeException("internal error: unexpected logic for (dynamic) category [" + ONames.uname4Log(this.category) + "]");
                }
                if (!context.hasEvaluatedSlicerAndSubSelect()) {
                    throw new OlapEvaluationException(context, OlapErrorCode.CAT_EVAL_ERROR, new Serializable[]{"the DYNAMIC REQUEST category [" + this.category.getNameX() + "] cannot be evaluated in that context [no slicer/no-sub-select] [" + context.getClass().getName() + "]"});
                }
                Object entity = this.instr.evaluateCategoryMemberFormula(context, this.scope, this.id, true, this.formula);
                this.logic = this.createLogic(entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initForRequestDynamicEvaluation(OlapMdxStatementExecutionContext context) {
        Object object = this.logicLOCK;
        synchronized (object) {
            if (OlapHierarchyScope.REQUEST == this.scope && this.dynamicEvaluation) {
                if (this.logic == null) {
                    throw new RuntimeException("internal error: missing logic for (dynamic) category [" + ONames.uname4Log(this.category) + "]");
                }
                this.logic.init(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OlapAbstractCategoryMemberLogic setupForOnDemandStaticEvaluation() {
        Object object = this.logicLOCK;
        synchronized (object) {
            if (this.logic != null) {
                return this.logic;
            }
            if (this.scope == OlapHierarchyScope.REQUEST || this.dynamicEvaluation) {
                throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"The category member '" + ONames.uname4Log(this.category) + "' cannot be used in that context [scope:" + String.valueOf((Object)this.scope) + "][dynamic:" + this.dynamicEvaluation + "]"});
            }
            OlapCreateCategoryMemberStatementExecutionContext sContext = new OlapCreateCategoryMemberStatementExecutionContext(this.c_context, this.c_requestProperties, this.c_instrExecListener, this.c_schema);
            Object entity = this.instr.evaluateCategoryMemberFormula(sContext, this.scope, this.id, false, this.formula);
            this.logic = this.createLogic(entity);
            this.logic.init(sContext);
            return this.logic;
        }
    }

    private OlapAbstractCategoryMemberLogic createLogic(Object entity) {
        OlapAbstractCategoryMemberLogic logic;
        if (entity instanceof OlapIterator) {
            logic = new OlapTupleSetCategoryMemberLogic(this.category, (OlapIterator)entity);
        } else if (entity instanceof OlapSubCubeEntity) {
            logic = new OlapSubCubeCategoryMemberLogic(this.category, (OlapSubCubeEntity)entity);
        } else {
            OlapLoggers.MDX_EVALUATION.error((Object)("internal error : unexpected category member '" + ONames.uname4Log(this.category) + "' expression type : " + entity.getClass().getName()));
            throw new RuntimeException("internal error : unexpected category member '" + ONames.uname4Log(this.category) + "' expression type");
        }
        return logic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.scope == OlapHierarchyScope.REQUEST) {
            return;
        }
        Object object = this.logicLOCK;
        synchronized (object) {
            this.logic = null;
            this.category.resetFactDimensionality();
            this.category.createOnDemandChildren();
        }
    }
}

