/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.master.schema.M_SchemaSubCubeFactory;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.cluster.shared.schema.S_CategoryDef;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMemberLogic;
import crazydev.iccube.olap.entity.member.OlapCategoryMemberLogicFactory;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.jetbrains.annotations.Nullable;

public abstract class OlapCategoryMember
extends OlapAbstractCategoryMember {
    private static long SHALLOW_SIZE_OF = -1L;
    private final OlapHierarchyScope scope;
    private final OlapCategoryMemberLogicFactory logicFactory;
    private LazyInitializer<Object> onDemandInitializer;

    protected OlapCategoryMember(OlapMdxStatementExecutionContext context, OlapInstr instr, OlapHierarchyScope scope, OlapEntityIdentifier id, boolean dynamicEvaluation, OlapInstr formula, OlapCategoryMemberProperties properties, OlapMember parent, String name) {
        super(OlapCategoryMember.extractSession(context, scope), OlapCategoryMember.extractRequest(context, scope), parent, name);
        OlapCategoryMember p;
        this.scope = scope;
        this.logicFactory = new OlapCategoryMemberLogicFactory(this, context, instr, scope, id, dynamicEvaluation, formula, properties);
        this.logicFactory.setupForRequestStaticEvaluation(context);
        if (parent instanceof OlapCategoryMember && (p = (OlapCategoryMember)parent).hasOnDemandChildren()) {
            throw new OlapEvaluationException(context, OlapErrorCode.CAT_CREATE_CHILD_IN_ADD_CHILDREN, new Serializable[]{name, parent.getNameX()});
        }
        if (this.hasOnDemandChildren()) {
            this.createOnDemandInitiliazer();
        }
    }

    protected OlapCategoryMember(OlapMdxStatementExecutionContext context, OlapInstr instr, OlapHierarchyScope scope, OlapEntityIdentifier id, boolean dynamicEvaluation, OlapInstr formula, OlapCategoryMemberProperties properties, OlapMember parent, OlapLevel level) {
        super(OlapCategoryMember.extractSession(context, scope), OlapCategoryMember.extractRequest(context, scope), parent, level);
        this.scope = scope;
        this.logicFactory = new OlapCategoryMemberLogicFactory(this, context, instr, scope, id, dynamicEvaluation, formula, properties);
        this.logicFactory.setupForRequestStaticEvaluation(context);
        if (this.hasOnDemandChildren()) {
            this.createOnDemandInitiliazer();
        }
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    private void createOnDemandInitiliazer() {
        this.onDemandInitializer = new LazyInitializer<Object>(this){
            final /* synthetic */ OlapCategoryMember this$0;
            {
                OlapCategoryMember olapCategoryMember = this$0;
                Objects.requireNonNull(olapCategoryMember);
                this.this$0 = olapCategoryMember;
            }

            protected OlapMemberChildren initialize() {
                this.this$0.setupChildrenForOnDemandStaticEvaluation();
                return null;
            }
        };
    }

    private boolean hasOnDemandChildren() {
        return this.scope != OlapHierarchyScope.REQUEST && this.logicFactory.getProperties().addChildren();
    }

    @Override
    protected OlapMemberChildren getMemberChildren() {
        if (this.onDemandInitializer != null) {
            try {
                this.onDemandInitializer.get();
            }
            catch (ConcurrentException e) {
                throw new CdRuntimeException((Throwable)e, "Creating Category children");
            }
        }
        return super.getMemberChildren();
    }

    @Nullable
    private static OlapEngineSessionContext extractSession(OlapMdxStatementExecutionContext context, OlapHierarchyScope scope) {
        return scope == OlapHierarchyScope.SESSION ? context.getSessionContext() : null;
    }

    @Nullable
    private static OlapEngineRequestContext extractRequest(OlapMdxStatementExecutionContext context, OlapHierarchyScope scope) {
        return scope == OlapHierarchyScope.REQUEST ? context.getRequestContext() : null;
    }

    void setupChildrenForOnDemandStaticEvaluation() {
        this.logicFactory.setupForOnDemandStaticEvaluation();
    }

    OlapMemberChildren resetOnDemandChildren() {
        OlapMemberChildren emptyChildren = this.createEmptyChildren();
        this.setMemberChildren(emptyChildren);
        return emptyChildren;
    }

    public OlapCategoryMemberProperties getProperties() {
        return this.logicFactory.getProperties();
    }

    @Override
    public OlapHierarchyScope getScope() {
        return this.scope;
    }

    @Override
    public boolean isDynamicCategory() {
        return this.logicFactory.isDynamic();
    }

    @Override
    public boolean isOtherCategory() {
        return this.logicFactory.isOtherCategory();
    }

    @Override
    @Nullable
    public OlapIterator<? extends OlapTuple> getTupleIterator() {
        return this.logicFactory.getTupleIterator();
    }

    @Override
    @Nullable
    public OlapSubCubeEntity getSubCube() {
        return this.logicFactory.getSubCube();
    }

    @Override
    public void touch() {
        this.logicFactory.touch();
    }

    @Override
    public OlapMember addChild(OlapBuilderContext context, OlapMember child) {
        return super.addChild(context, child);
    }

    @Override
    public boolean isIn4Facts(OlapDimensionality dimensionality) {
        this.logicFactory.setupForOnDemandStaticEvaluation();
        return super.isIn4Facts(dimensionality);
    }

    OlapAbstractCategoryMemberLogic getLogic() {
        return this.logicFactory.getLogic();
    }

    public boolean hasLogic() {
        return this.logicFactory.hasLogic();
    }

    public void createRequestDynamicLogic(OlapMdxStatementExecutionContext context) {
        this.logicFactory.setupForRequestDynamicEvaluation(context);
    }

    public void initRequestDynamicLogic(OlapMdxStatementExecutionContext context) {
        this.logicFactory.initForRequestDynamicEvaluation(context);
    }

    @Override
    public void resetCategory() {
        this.logicFactory.reset();
    }

    public void registerToCluster(OlapMdxStatementExecutionContext context) {
        OlapMdxStatementExecutionContext sContext = context;
        S_CategoryDef categoryDef = this.createCategoryDef();
        List<S_CategoryDef> childrenCategoryDef = this.createChildrenCategoryDef();
        OlapEngineApplicationContext applicationContext = sContext.getApplicationContext();
        M_LocalCluster cluster = applicationContext.getCluster();
        switch (this.scope) {
            case SCHEMA: {
                S_SchemaRef schemaRef = sContext.getSchema().getClusterRef();
                cluster.createSchemaCategory(schemaRef, categoryDef, childrenCategoryDef);
                break;
            }
            case SESSION: {
                S_SchemaRef schemaRef = sContext.getSchema().getClusterRef();
                S_MdxSessionContextRef sessionContextRef = sContext.getSessionContext().getClusterContextRef();
                cluster.createSessionCategory(schemaRef, sessionContextRef, categoryDef, childrenCategoryDef);
                break;
            }
            case REQUEST: {
                S_SchemaRef schemaRef = sContext.getSchema().getClusterRef();
                S_MdxSessionContextRef sessionContextRef = sContext.getSessionContext().getClusterContextRef();
                S_MdxStatementRequestContextRef mdxStatementContextRef = sContext.getClusterContextRef();
                cluster.createRequestCategory(schemaRef, sessionContextRef, mdxStatementContextRef, categoryDef, childrenCategoryDef);
                break;
            }
            default: {
                throw new RuntimeException("internal error: unexpected category scope [" + String.valueOf((Object)this.scope) + "]");
            }
        }
    }

    private S_CategoryDef createCategoryDef() {
        S_FactSubCube subCube = M_SchemaSubCubeFactory.createForCategory(this);
        return new S_CategoryDef(this, subCube);
    }

    private List<S_CategoryDef> createChildrenCategoryDef() {
        ArrayList<S_CategoryDef> categories = new ArrayList<S_CategoryDef>();
        for (OlapMember child : this.getMemberChildren().iterable()) {
            if (!(child instanceof OlapAbstractCategoryMember)) continue;
            OlapAbstractCategoryMember category = (OlapAbstractCategoryMember)child;
            S_FactSubCube subCube = M_SchemaSubCubeFactory.createForCategory(category);
            categories.add(new S_CategoryDef(category, subCube));
        }
        return categories;
    }
}

