/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.olap.OlapEntityType;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapScopeIsolation;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapCalculatedMemberDeclarationOrder;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMemberRank;
import crazydev.iccube.olap.entity.member.OlapMemberUniqueNameType;
import crazydev.iccube.olap.entity.member.OlapMemberWithChildren;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperties;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class OlapCalculatedMember
extends OlapMemberWithChildren {
    public static final String FRIENDLY_NAME = "calculated member";
    private static long SHALLOW_SIZE_OF = -1L;
    private final String name;
    private final OlapInstrLocationRange idRange;
    private final OlapInstr formula;
    private final OlapCellProperties cellProperties;
    @Nullable
    private final String definedUniqueName;
    private int positionInAnchor = -1;
    @Nullable
    private S_NonEmptyBehavior nonEmptyBehavior;
    private OlapMember parent;

    protected OlapCalculatedMember(String name, OlapLevel anchor, OlapInstrLocationRange idRange, OlapInstr formula, OlapCellProperties cellProperties, @Nullable String definedUniqueName) {
        super(null, anchor, null, null);
        this.name = name;
        this.idRange = idRange;
        this.formula = formula;
        this.cellProperties = cellProperties;
        this.definedUniqueName = definedUniqueName;
    }

    protected OlapCalculatedMember(String name, OlapMember anchor, OlapInstrLocationRange idRange, OlapInstr formula, OlapCellProperties cellProperties, @Nullable String definedUniqueName) {
        super(null, anchor.getLevel().getNextLevel(), anchor, null, null);
        this.name = name;
        this.idRange = idRange;
        this.formula = formula;
        this.cellProperties = cellProperties;
        this.definedUniqueName = definedUniqueName;
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected OlapMemberChildren createOnDemandChildren() {
        return super.createOnDemandChildren();
    }

    public static OlapCalculatedMember highestPriorityMember(@Nullable OlapEvaluationContext context, OlapCalculatedMember left, OlapCalculatedMember right) {
        OlapScopeIsolation lScope = left.getScopeIsolation();
        OlapScopeIsolation rScope = right.getScopeIsolation();
        if (lScope == OlapScopeIsolation.CUBE && rScope == null) {
            return left;
        }
        if (rScope == OlapScopeIsolation.CUBE && lScope == null) {
            return right;
        }
        if (left.getSolveOrder() == right.getSolveOrder()) {
            OlapProperties properties;
            if (context != null && (properties = context.getRequestProperties()).isDuplicatedSolveOrderError()) {
                throw new OlapEvaluationException(context, OlapErrorCode.DUPLICATED_SOLVE_ORDER, new Serializable[]{ONames.name4Log(left), Integer.valueOf(left.getSolveOrder()), ONames.name4Log(right), Integer.valueOf(right.getSolveOrder())});
            }
            if (left.isMeasure()) {
                if (right.isMeasure()) {
                    if (left.getDeclarationOrder().evaluateBefore(right.getDeclarationOrder())) {
                        return left;
                    }
                    return right;
                }
                return left;
            }
            if (right.isMeasure()) {
                return right;
            }
            if (left.getDeclarationOrder().evaluateBefore(right.getDeclarationOrder())) {
                return left;
            }
            return right;
        }
        if (left.getSolveOrder() > right.getSolveOrder()) {
            return left;
        }
        return right;
    }

    @Override
    protected boolean wantsAddToParent() {
        return false;
    }

    @Override
    public abstract boolean isDefinedAtSelectStatementLevel();

    @Override
    protected boolean useDataHandler() {
        return false;
    }

    @Override
    protected void setParent(OlapMember parent) {
        this.parent = parent;
    }

    @Override
    @Nullable
    public OlapMember getParent() {
        return this.parent;
    }

    @Override
    public boolean canNotBeCompacted() {
        return true;
    }

    @Override
    @Nullable
    public OlapBitmap getBaseMemberBitmap4Exist() {
        if (this.parent != null) {
            return this.parent.getBaseMemberBitmap();
        }
        return OlapBitmap.getOne();
    }

    @Override
    public boolean existAllways() {
        return this.parent == null || this.parent.existAllways();
    }

    @Override
    protected int getNextHierarchyMemberIndex() {
        if (!this.isDefinedAtSelectStatementLevel()) {
            return super.getNextHierarchyMemberIndex();
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void setLocalUniqueHierarchyMemberIndex(int localUniqueHierarchyMemberIndex) {
        throw new RuntimeException("internal error: inconsistent usage of setLocalUniqueHierarchyMemberIndex");
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return this.name;
    }

    @Override
    public OlapMemberKey getKey() {
        return OlapNoValueMemberKey.INSTANCE;
    }

    @Override
    public Comparable getKeyValue() {
        return OlapNoValueMemberKey.INSTANCE;
    }

    @Override
    public boolean hasPositionInAnchor() {
        return this.positionInAnchor != -1;
    }

    @Override
    public void setPositionInAnchor(int position) {
        if (this.hasPositionInAnchor()) {
            throw new CdProgrammingException("Duplicated rank setup for calc. member : " + ONames.uname4Log(this));
        }
        this.positionInAnchor = position;
    }

    @Override
    public OlapMemberRank getRank() {
        if (this.positionInAnchor == -1) {
            throw new RuntimeException("internal error: missing rank for calc. member : " + ONames.uname4Log(this));
        }
        OlapMember myParent = this.getParent();
        if (myParent == null) {
            if (this.getLevel().getDepth() != 0) {
                throw new RuntimeException("internal error: inconsistent level for calc. member : " + ONames.uname4Log(this));
            }
            return new OlapMemberRank(this.positionInAnchor);
        }
        OlapMemberRank parentRank = myParent.getRank();
        return new OlapMemberRank(parentRank, this.positionInAnchor);
    }

    @Override
    protected boolean needsBitmapAtOlapMemberLevel(OlapLevel level) {
        return false;
    }

    @Override
    public OlapBitmap getBaseMemberBitmap() {
        return OlapBitmap.getOne();
    }

    public abstract OlapCalculatedMemberDeclarationOrder getDeclarationOrder();

    @Override
    @Nullable
    public String getDisplayFolder(Locale locale, OlapNameContext context) {
        return this.getDisplayFolder(locale, context, this.cellProperties.getDisplayFolder());
    }

    @Override
    @Nullable
    public String getAssociatedMeasureGroup() {
        return this.cellProperties.getAssociatedMeasureGroup();
    }

    @Override
    public boolean isVisible() {
        return this.cellProperties.getVisible() != 0;
    }

    @Nullable
    public Boolean isCached() {
        return this.cellProperties.isCached();
    }

    @Override
    @Nullable
    protected String doGetCaption(Locale locale) {
        String myCaption = this.cellProperties.getCaption(locale);
        if (CdStringUtils.isNotNullAndNotBlank((String)myCaption)) {
            return myCaption;
        }
        return super.doGetCaption(locale);
    }

    @Override
    @Nullable
    public String getDescription(Locale locale) {
        String caption;
        String string = caption = this.cellProperties != null ? this.cellProperties.getDescription(locale) : null;
        if (CdStringUtils.isNotNullAndNotBlank((String)caption)) {
            return caption;
        }
        return super.getDescription(locale);
    }

    @Override
    public OlapMember getMeasureMember() {
        if (this.isMeasure()) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isCalculated() {
        return true;
    }

    @Override
    public boolean isMeasureVector() {
        return false;
    }

    @Override
    public int getMeasureVectorSize() {
        return -1;
    }

    @Override
    public boolean isMeasure() {
        return this.getDimension().isMeasures();
    }

    public OlapInstrLocationRange getIdRange() {
        return this.idRange;
    }

    public OlapInstr getFormula() {
        return this.formula;
    }

    public int getSolveOrder() {
        return this.cellProperties.getSolveOrder();
    }

    @Nullable
    public OlapScopeIsolation getScopeIsolation() {
        return this.cellProperties.getScopeIsolation();
    }

    public int getVisible() {
        return this.cellProperties.getVisible();
    }

    @Override
    public OlapAggregationType getHierarchyAggregationType() {
        return OlapAggregationType.SUM;
    }

    public void setDefinedNonEmptyBehavior(S_NonEmptyBehavior nonEmptyBehavior) {
        this.nonEmptyBehavior = nonEmptyBehavior;
    }

    @Override
    @Nullable
    public S_NonEmptyBehavior getDefinedNonEmptyBehavior() {
        return this.nonEmptyBehavior;
    }

    @Override
    public OlapCellProperties getCellProperties() {
        return this.cellProperties;
    }

    @Override
    @Nullable
    public OlapCellPropertyValue getCellPropertyValue(OlapCellProperty property) {
        return this.cellProperties.getCellPropertyValue(property);
    }

    @Override
    public OlapMember addChild(OlapBuilderContext context, OlapMember child) {
        throw new CdDoNotCallMeProgrammingException();
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        OlapMemberUniqueNameType uniqueNameType = this.getUniqueNameType();
        return this.getUniqueName(nameContext, uniqueNameType);
    }

    @Override
    public OlapMemberUniqueNameType getUniqueNameType() {
        if (this.definedUniqueName != null) {
            return OlapMemberUniqueNameType.X_CALC_DEFINED;
        }
        if (this.isMeasure()) {
            return OlapMemberUniqueNameType.X_CALC_MEASURE;
        }
        return super.getUniqueNameType();
    }

    private String getUniqueName(OlapNameContext nameContext, OlapMemberUniqueNameType uniqueNameType) {
        switch (uniqueNameType) {
            case X_CALC_DEFINED: {
                return this.definedUniqueName;
            }
            case X_CALC_MEASURE: {
                return this.getDimension().getUniqueName(nameContext) + ".[" + CdMdxUtils.escape((String)this.getName(nameContext)) + "]";
            }
        }
        return super.getUniqueName(nameContext);
    }

    @Override
    public String getUniqueNameWithoutKeys(OlapNameContext nameContext) {
        if (this.definedUniqueName != null) {
            return this.definedUniqueName;
        }
        if (this.isMeasure()) {
            return this.getDimension().getUniqueName(nameContext) + ".[" + CdMdxUtils.escape((String)this.getName(nameContext)) + "]";
        }
        return super.getUniqueNameWithoutKeys(nameContext);
    }

    @Override
    public OlapEntityType getEntityType() {
        return this.isMeasure() ? OlapEntityType.MEASURE : super.getEntityType();
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    @Override
    public String getMeasureGroupName() {
        if (this.isMeasure()) {
            return "Calculated Measure";
        }
        return super.getMeasureGroupName();
    }

    @Override
    public String getMeasureGroupNameForPermissions() {
        if (this.isMeasure()) {
            String measureGroupName = this.getAssociatedMeasureGroup();
            return measureGroupName;
        }
        return super.getMeasureGroupName();
    }

    @Override
    @Nullable
    public OlapMember getPrevMember(@Nullable OlapMemberFilter tupleFilter) {
        return null;
    }

    @Override
    @Nullable
    public OlapMember getNextMember(@Nullable OlapMemberFilter tupleFilter) {
        return null;
    }

    @Override
    @Nullable
    public OlapMember lag(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index == 0) {
            return this;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember lead(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index == 0) {
            return this;
        }
        return null;
    }

    @Override
    public OlapTupleSet<OlapMember> lastPeriods(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index == 0) {
            return OlapSetFactory.empty();
        }
        if (index == 1 || index == -1) {
            ArrayList<OlapCalculatedMember> periods = new ArrayList<OlapCalculatedMember>();
            periods.add(this);
            return OlapSetFactory.instance(periods);
        }
        return OlapSetFactory.empty();
    }

    @Override
    public OlapTupleSet<OlapMember> periodsToDate(@Nullable OlapMemberFilter tupleFilter, OlapLevel level) {
        return OlapSetFactory.empty();
    }

    @Override
    public OlapIterator<OlapMember> getChildrenForMdxFunction(OlapCalculatedMemberManager calcMemberManager, @Nullable OlapMemberFilter tupleFilter) {
        List<OlapMember> children = this.getChildrenForMdxFunctionEx(calcMemberManager, tupleFilter);
        if (children.isEmpty()) {
            return OlapIteratorFactory.empty();
        }
        if (children.size() == 1) {
            OlapMember child = children.get(0);
            return OlapIteratorFactory.singleton(child);
        }
        children.sort(OlapMember.RANK_COMPARATOR);
        return OlapIteratorFactory.instance(children);
    }

    private List<OlapMember> getChildrenForMdxFunctionEx(OlapCalculatedMemberManager calcMemberManager, @Nullable OlapMemberFilter tupleFilter) {
        ArrayList<OlapMember> children = null;
        List<OlapMember> members = calcMemberManager.getAllCalculatedMembers(tupleFilter);
        for (OlapMember member : members) {
            OlapMember memberParent = member.getParent();
            if (memberParent == null || !memberParent.equals(this)) continue;
            if (children == null) {
                children = new ArrayList<OlapMember>();
            }
            children.add(member);
        }
        if (children == null) {
            return Collections.emptyList();
        }
        return children;
    }

    @Override
    public int getChildrenCountForDrilldown(OlapCalculatedMemberManager calcMemberManager, @Nullable OlapMemberFilter filter) {
        List<OlapMember> children = this.getChildrenForMdxFunctionEx(calcMemberManager, filter);
        return children.size();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected void setFactIndexingMember(OlapBuilderContext context, OlapMember member) {
    }
}

