/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.member;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.catmember.OlapCategoryMemberProperties;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapMemberRank;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class OlapCalcCategoryMember
extends OlapCategoryMember {
    private static long SHALLOW_SIZE_OF = -1L;
    private final String name;
    private int positionInAnchor = -1;
    private OlapMember parent;

    public OlapCalcCategoryMember(OlapMdxStatementExecutionContext context, OlapInstr instr, OlapHierarchyScope scope, OlapEntityIdentifier id, boolean dynamicEvaluation, OlapInstr formula, OlapCategoryMemberProperties properties, OlapMember parent, String name) {
        super(context, instr, scope, id, dynamicEvaluation, formula, properties, parent, parent.getLevel().getNextLevel());
        this.name = name;
    }

    @Override
    protected long shallowSizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    protected boolean wantsAddToParent() {
        return false;
    }

    @Override
    public boolean isDefinedAtSelectStatementLevel() {
        return true;
    }

    @Override
    protected boolean useDataHandler() {
        return false;
    }

    @Override
    protected void setParent(OlapMember parent) {
        this.parent = parent;
    }

    @Override
    @Nullable
    public OlapMember getParent() {
        return this.parent;
    }

    @Override
    public boolean canNotBeCompacted() {
        return super.canNotBeCompacted();
    }

    @Override
    @Nullable
    public OlapBitmap getBaseMemberBitmap4Exist() {
        return super.getBaseMemberBitmap4Exist();
    }

    @Override
    protected int getNextHierarchyMemberIndex() {
        return -1;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void setLocalUniqueHierarchyMemberIndex(int localUniqueHierarchyMemberIndex) {
        if (-1 != this.uniqueHierarchyMemberIndex) {
            throw new RuntimeException("internal error: calc. category member : duplicated unique hierarchy index!");
        }
        this.setUniqueHierarchyIndex(localUniqueHierarchyMemberIndex);
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return this.name;
    }

    @Override
    public OlapMemberKey getKey() {
        return OlapNoValueMemberKey.INSTANCE;
    }

    @Override
    public Comparable getKeyValue() {
        return OlapNoValueMemberKey.INSTANCE;
    }

    @Override
    public boolean hasPositionInAnchor() {
        return this.positionInAnchor != -1;
    }

    @Override
    public void setPositionInAnchor(int position) {
        if (this.hasPositionInAnchor()) {
            throw new CdProgrammingException("Duplicated rank setup for calc. category member : " + ONames.uname4Log(this));
        }
        this.positionInAnchor = position;
    }

    @Override
    public OlapMemberRank getRank() {
        if (this.positionInAnchor == -1) {
            throw new RuntimeException("internal error: missing rank for calc. category member : " + ONames.uname4Log(this));
        }
        OlapMember myParent = this.getParent();
        if (myParent == null) {
            if (this.getLevel().getDepth() != 0) {
                throw new RuntimeException("internal error: inconsistent level for calc. category member : " + ONames.uname4Log(this));
            }
            return new OlapMemberRank(this.positionInAnchor);
        }
        OlapMemberRank parentRank = myParent.getRank();
        return new OlapMemberRank(parentRank, this.positionInAnchor);
    }

    @Override
    @Nullable
    public OlapMember getPrevMember(@Nullable OlapMemberFilter tupleFilter) {
        return null;
    }

    @Override
    @Nullable
    public OlapMember getNextMember(@Nullable OlapMemberFilter tupleFilter) {
        return null;
    }

    @Override
    @Nullable
    public OlapMember lag(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index == 0) {
            return this;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember lead(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index == 0) {
            return this;
        }
        return null;
    }

    @Override
    public OlapTupleSet<OlapMember> lastPeriods(@Nullable OlapMemberFilter tupleFilter, int index) {
        if (index == 0) {
            return OlapSetFactory.empty();
        }
        if (index == 1 || index == -1) {
            ArrayList<OlapCalcCategoryMember> periods = new ArrayList<OlapCalcCategoryMember>();
            periods.add(this);
            return OlapSetFactory.instance(periods);
        }
        return OlapSetFactory.empty();
    }

    @Override
    public String toString() {
        return super.toString() + " [calc-category]";
    }
}

