/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.level;

import crazydev.common.collection.CdPair;
import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.enums.OlapLevelType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public abstract class OlapLevelTypeHelper {
    public static List<CdPair<String, LocalDateTime>> getDates(OlapLevelType level, String levelNameFormat, Locale levelNameLocale, LocalDateTime dimStartTime, LocalDateTime dimEndTime, @Nullable OlapLevelType parentLevel, @Nullable LocalDateTime parentLevelStartDate) {
        LocalDateTime currentBucketEnd;
        if (parentLevel != null && !level.getNextDate(dimStartTime).isBefore((ReadablePartial)parentLevel.getNextDate(dimStartTime))) {
            throw new CdRuntimeException("Level should be properly ordered: this:[" + String.valueOf((Object)level) + "] / parent:[" + String.valueOf((Object)parentLevel) + "]");
        }
        LocalDateTime currentBucketStart = parentLevelStartDate == null ? dimStartTime : parentLevelStartDate;
        currentBucketStart = level.transformToValidDate(currentBucketStart, null);
        LocalDateTime bucketEndDate = parentLevel == null ? dimEndTime : parentLevel.getNextDate(currentBucketStart);
        ArrayList<CdPair<String, LocalDateTime>> children = new ArrayList<CdPair<String, LocalDateTime>>();
        do {
            if (!CdJodaTimeUtil.isInBound((LocalDateTime)dimStartTime, (LocalDateTime)dimEndTime, (LocalDateTime)currentBucketStart, (LocalDateTime)(currentBucketEnd = level.getNextDate(currentBucketStart)))) continue;
            String name = level.getMemberNameFor(levelNameFormat, levelNameLocale, currentBucketStart);
            children.add((CdPair<String, LocalDateTime>)new CdPair((Object)name, (Object)currentBucketStart));
        } while ((currentBucketStart = currentBucketEnd).isBefore((ReadablePartial)bucketEndDate));
        return children;
    }
}

