/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.level;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdActionStoppable;
import crazydev.common.collection.CdVisitor;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.olap.OlapEntityType;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderAttributeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapAbstractIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapFirstNotAllMembersIterator;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.enums.OlapMemberNotKeyOrder;
import crazydev.iccube.enums.OlapMemberOrderByType;
import crazydev.iccube.enums.OlapMemberOrderKind;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierKeyPart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierNamePart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.member.OlapLevelForwardNavigator;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.properties.member.OlapMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.model.IResLevel;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.schema.stats.OlapLevelStats;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapIdentifiable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapLevel
extends OlapNonScalarAbstractEntity
implements IResLevel,
OlapNameIdentifiableEntity {
    public static final String FRIENDLY_NAME = "level";
    private static final Set<String> IC3_GEO_PROPERTY_NAMES_LC = new HashSet<String>(Arrays.asList("@Ic3Lat".toLowerCase(), "@Ic3Long".toLowerCase(), "@Ic3iso2".toLowerCase()));
    private final OlapHierarchy hierarchy;
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final OlapLevelType type;
    private final int depth;
    private final boolean isAll;
    private final OlapMemberOrderByType orderBy;
    private final OlapMemberOrderKind orderKind;
    private final boolean namesUnique;
    private final boolean checkNamesUnique;
    private final boolean keysUnique;
    private final boolean nameUniqueInParent;
    private final boolean checkNameUniqueInParent;
    private final boolean factIndexing;
    private final List<OlapUserDefinedMemberProperty> memberProperties = new ArrayList<OlapUserDefinedMemberProperty>();
    private final IOlapMemoryLevelMember dataHandler;
    private final boolean isLastLevel;
    private final List<OlapBuilderInputType> definedKeyTypes;
    @Nullable
    private final OlapMemberNotKeyOrder orderNoKey;
    private final boolean isNameColSameAsKeyCol;
    private final boolean doNotValidateEmptyLevel;
    private final String missingAttributeMemberName;
    private final HashSet<String> attributeHierarchies;
    @Nullable
    private OlapLevel previous;
    @Nullable
    private OlapLevel next;
    private int memberCount;
    @Nullable
    private OlapLevel hollowLevel;
    private OlapMember unknownMember;
    private int uniqueIndex = -1;

    public OlapLevel(OlapHierarchy hierarchy, int depth, IOlapBuilderHierarchyLevelDef levelDef, boolean isLastLevel) {
        this(null, hierarchy, levelDef.getName(), levelDef.getDescription(), depth, levelDef.getLevelType(), false, levelDef.getOrderMembersByType(), levelDef.getOrderKind(), levelDef.getOrderNoKey(), levelDef.isKeyUniqueInLevel(), levelDef.isNameUniqueInLevel(), levelDef.isNameUniqueInParent(), levelDef.isNameUniqueInLevel(), levelDef.isNameUniqueInParent(), levelDef.isFactIndexing(), levelDef.isDoNotValidateEmptyLevel(), levelDef.isNameSameAsKey(), levelDef.getKeyTypes(), isLastLevel, levelDef.getAttributes(), levelDef.getMissingAttributeMemberName());
    }

    public OlapLevel(OlapHierarchy hierarchy, String name, @Nullable String description, int depth, OlapMemberOrderByType orderBy, @Nullable OlapMemberOrderKind orderKind, boolean keysUnique, boolean namesUnique, boolean nameUniqueInParent) {
        this(null, hierarchy, name, description, depth, orderBy, orderKind, keysUnique, namesUnique, nameUniqueInParent);
    }

    public OlapLevel(@Nullable OlapBuilderContextMode buildingMode, OlapHierarchy hierarchy, String name, @Nullable String description, int depth, OlapMemberOrderByType orderBy, @Nullable OlapMemberOrderKind orderKind, boolean keysUnique, boolean namesUnique, boolean nameUniqueInParent) {
        this(buildingMode, hierarchy, name, description, depth, null, false, orderBy, orderKind, null, keysUnique, namesUnique, nameUniqueInParent, false, false, false, false, false, null, false, null, null);
    }

    public OlapLevel(OlapHierarchy hierarchy, String name, @Nullable String description, int depth, OlapLevelType type, boolean isAll, boolean keysUnique, boolean namesUnique, boolean nameUniqueInParent) {
        this(null, hierarchy, name, description, depth, type, isAll, OlapMemberOrderByType.NONE, null, null, keysUnique, namesUnique, nameUniqueInParent, false, false, false, false, false, null, false, null, null);
    }

    public OlapLevel(@Nullable OlapBuilderContextMode buildingMode, OlapHierarchy hierarchy, String name, @Nullable String description, int depth, @Nullable OlapLevelType type, boolean isAll, OlapMemberOrderByType orderBy, @Nullable OlapMemberOrderKind orderKind, @Nullable OlapMemberNotKeyOrder orderNoKey, boolean keysUnique, boolean namesUnique, boolean nameUniqueInParent, boolean checkNamesUnique, boolean checkNameUniqueInParent, boolean isFactIndexing, boolean doNotValidateEmptyLevel, boolean nameSameAsKey, @Nullable List<OlapBuilderInputType> keyTypes, boolean isLastLevel, @Nullable List<IOlapBuilderAttributeDef> attributeDefs, @Nullable String missingAttributeMemberName) {
        int index;
        OlapLevel parentLevel;
        this.isNameColSameAsKeyCol = nameSameAsKey;
        this.definedKeyTypes = keyTypes == null ? Collections.emptyList() : keyTypes;
        this.isLastLevel = isLastLevel;
        this.hierarchy = hierarchy;
        this.depth = depth;
        this.isAll = isAll;
        this.name = name;
        this.description = description;
        this.type = type;
        this.factIndexing = isFactIndexing;
        this.orderBy = orderBy == null ? OlapMemberOrderByType.NONE : orderBy;
        this.orderKind = orderKind == null ? OlapLevel.getDefaultOrderKind() : orderKind;
        this.orderNoKey = orderNoKey;
        this.keysUnique = keysUnique;
        this.namesUnique = namesUnique;
        this.nameUniqueInParent = nameUniqueInParent;
        this.dataHandler = hierarchy.getOrCreateDataHandler(this);
        this.checkNamesUnique = checkNamesUnique;
        this.checkNameUniqueInParent = checkNameUniqueInParent;
        this.doNotValidateEmptyLevel = doNotValidateEmptyLevel;
        this.missingAttributeMemberName = missingAttributeMemberName;
        this.attributeHierarchies = new HashSet();
        if (attributeDefs != null) {
            attributeDefs.forEach(a -> this.attributeHierarchies.add(a.getName()));
        }
        if (OlapBuilderContextMode.INCR_LOAD == buildingMode && this.depth > 1 && (parentLevel = hierarchy.getLevelAtDepth(depth - 1)) != null && (index = parentLevel.getUniqueIndex()) != -1) {
            OlapSchema schema = hierarchy.getSchema();
            this.uniqueIndex = schema.getNextLevelIndexAndIncrement();
        }
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.LEVEL;
    }

    public int getUniqueIndex() {
        return this.uniqueIndex;
    }

    public void setUniqueIndex(int uniqueIndex) {
        this.uniqueIndex = uniqueIndex;
    }

    public static OlapMemberOrderKind getDefaultOrderKind() {
        return OlapMemberOrderKind.ASC;
    }

    public static OlapLevel createAllLevel(OlapHierarchy hierarchy, String allLevelName) {
        return new OlapLevel(hierarchy, allLevelName, null, 0, null, true, true, true, true);
    }

    public static OlapEntity range(@Nullable OlapMemberFilter tupleFilter, @Nullable OlapMember from, @Nullable OlapMember to) {
        if (from == null && to == null) {
            return OlapNullEntity.INSTANCE;
        }
        if (from == null) {
            OlapLevel level = to.getLevel();
            return level.createMemberRange(tupleFilter, from, to);
        }
        OlapLevel level = from.getLevel();
        return level.createMemberRange(tupleFilter, from, to);
    }

    @Nullable
    public OlapLevelType getLevelType() {
        return this.type;
    }

    public OlapMemberOrderByType getOrderBy() {
        return this.orderBy;
    }

    public void addMemberProperty(OlapNameContext nameContext, OlapUserDefinedMemberProperty property) {
        OlapMemberPropertyManager propertyManager = this.getDimension().getSchema().getMemberPropertyManager();
        propertyManager.registerUserDefinedProperty(nameContext, property);
        if (!this.memberProperties.contains(property)) {
            this.memberProperties.add(property);
        }
    }

    public List<OlapUserDefinedMemberProperty> getMemberProperties(@Nullable OlapMemberFilter memberFilter) {
        return memberFilter == null ? this.memberProperties : this.memberProperties.stream().filter(p -> memberFilter.isAccepting((OlapUserDefinedMemberProperty)p, this)).collect(Collectors.toList());
    }

    public boolean isNamesUniqueFlag() {
        return this.namesUnique;
    }

    public boolean isKeysUniqueFlag() {
        return this.keysUnique;
    }

    public boolean isNameUniqueInParent() {
        return this.nameUniqueInParent;
    }

    public void validateConsistency(OlapBuilderErrorManager errorManager) {
        this.validateEmptyLevel(errorManager);
    }

    private void validateEmptyLevel(OlapBuilderErrorManager errorManager) {
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return nameContext.getLevelName(this, this.name);
    }

    public String getNameX() {
        return this.getName(OlapNameContext.DEFAULT_VALUES);
    }

    public String getUniqueNameX() {
        return this.getUniqueName(OlapNameContext.DEFAULT_VALUES);
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        if (nameContext.hasNewUniqueName(this)) {
            return this.createUniqueName(nameContext);
        }
        return this.createUniqueName(nameContext);
    }

    public void appendUniqueNameForMember(StringBuilder builder, OlapNameContext nameContext) {
        builder.append(this.getUniqueName(nameContext));
    }

    private String createUniqueName(OlapNameContext nameContext) {
        if (this.hierarchy.isMeasures()) {
            return this.hierarchy.getUniqueName(nameContext);
        }
        return this.getHierarchy().getUniqueName(nameContext) + ".[" + CdMdxUtils.escape((String)this.getName(nameContext)) + "]";
    }

    @Override
    public String getCaption(Locale locale, OlapNameContext nameContext) {
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String caption = this.isAll() ? localization.getAllLevelCaption(locale, this) : localization.getLevelCaption(locale, this);
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            caption = this.getName(nameContext);
        }
        return caption;
    }

    @Override
    @Nullable
    public String getDescription(Locale locale) {
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String descriptionL = this.isAll() ? localization.getAllLevelDescription(locale, this) : localization.getLevelDescription(locale, this);
        if (CdStringUtils.isNotNullAndNotBlank((String)descriptionL)) {
            return descriptionL;
        }
        return this.description;
    }

    @Override
    public boolean isAllMember() {
        return false;
    }

    public boolean isAll() {
        return this.isAll;
    }

    public OlapDimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    public OlapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public OlapTupleSet<OlapMember> getMembers(@Nullable OlapMemberFilter tupleFilter) {
        OlapIterator<OlapMember> forwardNavigator = this.getLevelMemberIterator(tupleFilter);
        if (forwardNavigator == null) {
            return OlapSetFactory.empty();
        }
        return OlapSetFactory.instance(forwardNavigator);
    }

    public int getMemberPosition(@Nullable OlapMemberFilter tupleFilter, OlapMember member) {
        int position = 0;
        OlapIterator<OlapMember> members = this.getLevelMemberIterator(tupleFilter);
        if (members != null) {
            OlapMember nextMember;
            members.reset();
            while ((nextMember = members.next()) != null) {
                if (tupleFilter != null && !tupleFilter.isAccepting(nextMember)) continue;
                if (OlapMember.equal(nextMember, member)) {
                    return position;
                }
                ++position;
            }
        }
        throw new CdProgrammingException("Missing member '" + ONames.uname4Log(member) + "' in '" + String.valueOf(this) + "'");
    }

    private OlapIterator<OlapMember> getLevelMemberIterator(@Nullable OlapMemberFilter tupleFilter) {
        OlapLevel previousLevel = this.getPreviousLevel();
        OlapMember allMember = this.getHierarchy().getAllMember();
        if (allMember != null && previousLevel == allMember.getLevel()) {
            return new OlapFirstNotAllMembersIterator(allMember, this, tupleFilter);
        }
        OlapMember first = this.getHierarchy().getFirstMemberForLevel(tupleFilter, this);
        if (first == null) {
            return null;
        }
        return new OlapLevelForwardNavigator(tupleFilter, first, true);
    }

    public OlapMember addMember(OlapMember member, boolean isUnknown) {
        if (member.getHierarchy() != this.getHierarchy()) {
            throw new CdProgrammingException("Member inconsistency (1).");
        }
        if (member.getLevel() != this) {
            throw new CdProgrammingException("Member inconsistency (2).");
        }
        if (this.isAll() ^ member.isAll()) {
            throw new CdProgrammingException("Member inconsistency (3).");
        }
        if (!member.isAll() && member.getParent() == null && this.depth != 0 && !this.isAll()) {
            throw new CdProgrammingException("Member inconsistency. [" + String.valueOf(member) + "]");
        }
        if (member.getParent() == null) {
            member.getHierarchy().addRootMember(member);
        }
        if (isUnknown) {
            this.setUnknownMember(member);
        }
        ++this.memberCount;
        return member;
    }

    public void setUnknownMember(OlapMember member) {
        this.unknownMember = member;
    }

    public boolean isEmpty() {
        return this.memberCount == 0;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public int getMemberCount(@Nullable OlapMemberFilter filter) {
        if (this.isAll) {
            OlapMember all = this.getHierarchy().getAllMember();
            if (all != null && (filter == null || filter.isAccepting(all))) {
                return 1;
            }
            return 0;
        }
        return this.getXmlaCardinality(filter);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int getLevelNumber() {
        return this.depth;
    }

    @Nullable
    public OlapLevel getPreviousLevel() {
        return this.previous;
    }

    public OlapLevel setPreviousLevel(OlapLevel level) {
        if (this.depth != level.depth + 1) {
            throw new CdProgrammingException("Level [" + this.depth + "/" + level.depth + "] inconsistency.");
        }
        this.previous = level;
        return this.previous;
    }

    @Nullable
    public OlapLevel getNextLevel() {
        return this.next;
    }

    public OlapLevel setNextLevel(OlapLevel level) {
        if (this.depth != level.depth - 1) {
            throw new CdProgrammingException("Level [" + this.depth + "/" + level.depth + "] inconsistency.");
        }
        this.next = level;
        return this.next;
    }

    public boolean isLast() {
        return this.next == null;
    }

    public void clearNextLevel() {
        this.next = null;
    }

    @Override
    protected OlapTupleSet<?> toSet_(IOlapPrepareContext context) {
        if (context.isConstrained()) {
            return (OlapTupleSet)context.onConstrainedViolation();
        }
        return this.getMembers(context.getMemberFilter());
    }

    @Override
    public boolean isToSetApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public boolean isScoping(OlapMember member) {
        return member.getLevel().equals(this);
    }

    @Override
    public boolean isScoping(OlapHierarchy hierarchy) {
        return hierarchy.equals(this.getHierarchy());
    }

    public OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, OlapEntityIdentifier id) {
        OlapNonScalarEntity firstMember = this.lookupFirstMember(nameContext, permissions, id);
        if (firstMember.isMdxNull()) {
            return firstMember;
        }
        OlapMember member = (OlapMember)firstMember;
        if (id.getPartCount() == 1) {
            return member;
        }
        OlapMemberFilter permissionsFilter = permissions.getMemberFilter();
        boolean ok = true;
        for (int idx = 1; idx < id.getPartCount(); ++idx) {
            OlapEntityIdentifierPart nextPart = id.getPart(idx);
            OlapMember child = member.lookupChildByMdxIdentifier(nameContext, permissionsFilter, m -> nextPart.isIdentifying(nameContext, (OlapIdentifiable)m));
            if (child == null) {
                ok = false;
                break;
            }
            member = child;
        }
        if (ok) {
            return member;
        }
        return OlapNullEntity.INSTANCE;
    }

    private OlapNonScalarEntity lookupFirstMember(OlapNameContext nameContext, IOlapDimensionsPermission permissions, OlapEntityIdentifier id) {
        if (id.getPartCount() == 0) {
            throw new CdProgrammingException("MDX entity lookup inconsistency.");
        }
        OlapEntityIdentifierPart id0 = id.getFirstPart();
        if (id0.isAll()) {
            OlapHierarchy hierarchy = this.getHierarchy();
            OlapMember allMember = hierarchy.getAllMember();
            if (allMember == null) {
                return OlapNullEntity.INSTANCE;
            }
            return this.isAll ? allMember : OlapNullEntity.INSTANCE;
        }
        if (this.isAll()) {
            OlapHierarchy hierarchy = this.getHierarchy();
            OlapMember allMember = hierarchy.getAllMember();
            if (allMember == null) {
                return OlapNullEntity.INSTANCE;
            }
            return id0.isIdentifying(nameContext, allMember) ? allMember : OlapNullEntity.INSTANCE;
        }
        if (this.hierarchy.isMeasures()) {
            return this.lookupFirstMemberWithIteration(nameContext, permissions, id0);
        }
        return id0.isKey() ? this.lookupFirstMemberByKey(permissions, id0) : this.lookupFirstMemberByName(permissions, id0);
    }

    private OlapNonScalarEntity lookupFirstMemberWithIteration(OlapNameContext nameContext, IOlapDimensionsPermission permissions, OlapEntityIdentifierPart id) {
        OlapMember member;
        OlapIterator iterator = this.getMembers(permissions.getMemberFilter()).getIterator(false);
        if (iterator == null) {
            return OlapNullEntity.INSTANCE;
        }
        iterator.reset();
        while ((member = (OlapMember)iterator.next()) != null) {
            if (!id.isIdentifying(nameContext, member)) continue;
            return member;
        }
        return OlapNullEntity.INSTANCE;
    }

    private OlapNonScalarEntity lookupFirstMemberByKey(IOlapDimensionsPermission permissions, OlapEntityIdentifierPart id) {
        OlapEntityIdentifierKeyPart key = (OlapEntityIdentifierKeyPart)id;
        OlapMemberFilter permissionsFilter = permissions.getMemberFilter();
        OlapMember[] member = new OlapMember[1];
        this.dataHandler.forEachMatchingKeyValue(key, (CdVisitor<OlapMember>)((CdVisitor)olapMember -> {
            if (permissionsFilter == null || permissionsFilter.isAccepting((OlapMember)olapMember)) {
                member[0] = olapMember;
                return false;
            }
            return true;
        }));
        if (member[0] == null) {
            return OlapNullEntity.INSTANCE;
        }
        return member[0];
    }

    private OlapNonScalarEntity lookupFirstMemberByName(IOlapDimensionsPermission permissions, OlapEntityIdentifierPart id) {
        OlapEntityIdentifierNamePart name = (OlapEntityIdentifierNamePart)id;
        OlapMemberFilter permissionsFilter = permissions.getMemberFilter();
        OlapMember[] member = new OlapMember[1];
        this.dataHandler.forEachMatchingNameIgnoreCase(name.getName(), (CdVisitor<OlapMember>)((CdVisitor)olapMember -> {
            if (permissionsFilter == null || permissionsFilter.isAccepting((OlapMember)olapMember)) {
                member[0] = olapMember;
                return false;
            }
            return true;
        }));
        if (member[0] == null) {
            return OlapNullEntity.INSTANCE;
        }
        return member[0];
    }

    public OlapTupleSet createMemberRange(@Nullable OlapMemberFilter tupleFilter, @Nullable OlapMember from, @Nullable OlapMember to) {
        if (from == null && to == null) {
            throw new CdProgrammingException("Range [NULL:NULL] error : from/to level/hierarchy '" + String.valueOf(this) + "'.");
        }
        if (from != null && !this.equals(from.getLevel())) {
            throw new CdProgrammingException("Range '" + String.valueOf(from) + "' : '" + String.valueOf(to == null ? "NULL" : to) + "' error : from/to level/hierarchy '" + String.valueOf(this) + "' mismatch.");
        }
        if (to != null && !this.equals(to.getLevel())) {
            throw new CdProgrammingException("Range '" + String.valueOf(from == null ? "[NULL]" : from) + "' : '" + String.valueOf(to) + "' error : from/to level/hierarchy '" + String.valueOf(this) + "' mismatch.");
        }
        if (from != null && to != null && !from.getLevel().equals(to.getLevel())) {
            throw new CdProgrammingException("Range '" + String.valueOf(from) + "' : '" + String.valueOf(to) + "' error : from/to level/hierarchy '" + String.valueOf(from.getLevel()) + "' : '" + String.valueOf(to.getLevel()) + "' mismatch.");
        }
        OlapTupleSet<OlapMember> xmembers = this.getMembers(tupleFilter);
        return xmembers.range(from, to);
    }

    @Nullable
    public OlapMember unfilteredLookupMemberByName(OlapNameContext nameContext, String name) {
        OlapMember member;
        OlapIterator<OlapMember> iterator = this.getLevelMemberIterator(null);
        if (iterator == null) {
            return null;
        }
        iterator.reset();
        while ((member = iterator.next()) != null) {
            if (!OlapCaseInsensitiveName.equals(member.getName(nameContext), name)) continue;
            return member;
        }
        return null;
    }

    @Nullable
    public OlapUserDefinedMemberProperty lookupPropertyByName(String name) {
        for (OlapUserDefinedMemberProperty memberProperty : this.memberProperties) {
            if (!memberProperty.getName().equals(name)) continue;
            return memberProperty;
        }
        return null;
    }

    public boolean checkNamesUniqueInLevel() {
        return this.checkNamesUnique;
    }

    public boolean checkNameUniqueInParent() {
        return this.checkNameUniqueInParent;
    }

    public IOlapMemoryLevelMember getDataHandler() {
        return this.dataHandler;
    }

    public boolean isTerminal() {
        return this.next == null;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) {
        String str = this.getHierarchy().toMdxString(nameContext, truncate, maxSize);
        return str + ".[" + CdMdxUtils.escape((String)this.name) + "]";
    }

    @Override
    public OlapEntityType getEntityType() {
        return OlapEntityType.LEVEL;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public String toString() {
        return ONames.uname4Log(this) + (this.isAll ? "(all)" : "");
    }

    public OlapMemberOrderKind getOrderKind() {
        return this.orderKind;
    }

    @Nullable
    public OlapMemberNotKeyOrder getOrderNoKey() {
        return this.orderNoKey;
    }

    public boolean isOrderKeyAndDecOrder() {
        return this.orderKind.isDec() && this.orderBy == OlapMemberOrderByType.BY_KEY;
    }

    @Nullable
    public OlapMember lookupMemberByKeyValue(Object memberKeyValue) {
        return this.dataHandler.lookupMemberByKeyValue(memberKeyValue);
    }

    public void forEachMatchingKeyValue(@Nullable IOlapEvaluationExceptionContext context, Object memberKeyValue, CdVisitor<OlapMember> visitor) {
        this.dataHandler.forEachMatchingKeyValue(context, memberKeyValue, visitor);
    }

    @Nullable
    public OlapMember lookupMemberByName(String memberName) {
        return this.dataHandler.lookupMemberByNameIgnoreCase(memberName);
    }

    public final OlapMember getMemberAtDataIdx(int dataIdx) {
        return this.dataHandler.getMember(dataIdx);
    }

    @Nullable
    public OlapBuilderInputType[] getMemberKeyType() {
        return this.dataHandler.getKeyType();
    }

    public boolean isFactIndexing() {
        return this.factIndexing;
    }

    public String getCreationName() {
        return this.name;
    }

    @Nullable
    public Object getKeyForCompare(Object keyValue) {
        return this.dataHandler.getKeyValueForCompare(keyValue);
    }

    public OlapLevelStats createStats() {
        return this.dataHandler.createStats();
    }

    public OlapLevelStats createIncrLoadStats() {
        return this.dataHandler.createIncrLoadStats();
    }

    public int getXmlaCardinality(@Nullable OlapMemberFilter tupleFilter) {
        return this.dataHandler.getXmlaCardinality(tupleFilter);
    }

    @Nullable
    public OlapLevel getHollowLevel() {
        return this.hollowLevel;
    }

    public void setHollowLevel(OlapLevel hollowLevel) {
        this.hollowLevel = hollowLevel;
    }

    public boolean isHollow() {
        return this.hollowLevel != null;
    }

    public void forEachMember(CdAction<OlapMember> action) {
        if (this.isAll) {
            OlapMember allMember = this.getHierarchy().getAllMember();
            action.apply((Object)allMember);
        }
        this.dataHandler.forEachMember(action);
    }

    public void forEachMemberWithoutAll(CdAction<OlapMember> action) {
        this.dataHandler.forEachMember(action);
    }

    public boolean forEachMemberWithoutAllStoppable(CdActionStoppable<OlapMember> action) {
        return this.dataHandler.forEachMemberStoppable(action);
    }

    @Nullable
    public OlapMember getCreatedUnkownMember() {
        return this.unknownMember;
    }

    @Override
    public String toStringForDebugger() {
        return this.getUniqueName(OlapNameContext.DEFAULT_VALUES);
    }

    public boolean isKeyType(Class<?> localDateClass) {
        return this.dataHandler.isKeyType(localDateClass);
    }

    public boolean isNameColSameAsKeyCol() {
        return this.isNameColSameAsKeyCol;
    }

    public List<OlapBuilderInputType> getDefinedKeyTypes() {
        return this.definedKeyTypes;
    }

    public boolean isKeysUnique() {
        return this.keysUnique || this.isLastLevel && this.getHierarchy().isBase() && this.getDimension().isFactIndexing();
    }

    public boolean isMembersAllMembers() {
        return this.hierarchy.isMembersAllMembers();
    }

    public List<String> getKeyForReportingMetaInfo() {
        return this.definedKeyTypes.stream().map(Enum::name).toList();
    }

    public List<String> getMemberPropertiesForReportingMetaInfo() {
        return this.memberProperties.stream().map(OlapMemberProperty::getName).toList();
    }

    @Nullable
    public OlapLevel getMatchingAttributeLevel(OlapHierarchy hierarchy) {
        String hierarchyName = hierarchy.getNameX();
        OlapLevel current = this;
        do {
            if (!current.attributeHierarchies.contains(hierarchyName)) continue;
            return current;
        } while ((current = current.previous) != null);
        return null;
    }

    public boolean hasOneRelationWithBase(OlapHierarchy noBaseHierarchy) {
        return this.getDataHandler().hasOneRelationWithBase(noBaseHierarchy);
    }

    public void forEachAttribute(Consumer<? super String> action) {
        this.attributeHierarchies.forEach(action);
    }

    public void forEachProperty(Consumer<? super OlapUserDefinedMemberProperty> action) {
        this.memberProperties.forEach(action);
    }

    public String getMissingAttributeMemberName() {
        return this.missingAttributeMemberName;
    }

    @Nullable
    public OlapHierarchy getAttributeHierarchy(String propertyName) {
        return this.getDataHandler().getAttributeHierarchy(propertyName);
    }

    public MembersUpperLowerStrategyType membersUpperLowerCaseStrategy() {
        return this.getDimension().membersUpperLowerCaseStrategy();
    }

    public boolean isStringKeyUpperCase() {
        return this.dataHandler.isStringKeyUpperCase();
    }

    public boolean getIsStructuralLastLevel() {
        return this.isLastLevel;
    }

    public boolean isAttributeLevelOf(@Nullable OlapLevel baseLevel) {
        if (baseLevel == null || this.getDimension() != baseLevel.getDimension() || !baseLevel.getHierarchy().isBase() || this.getHierarchy().isBase()) {
            return false;
        }
        return baseLevel.dataHandler.definesAttributeOn(this);
    }

    public static class OlapMatchLevelFilter
    implements OlapAbstractIteratorFilter<OlapMember> {
        private final OlapLevel level;

        public OlapMatchLevelFilter(OlapLevel level) {
            this.level = level;
        }

        @Override
        public boolean accept(OlapMember o) {
            return o.getLevel() == this.level;
        }

        @Override
        public IOlapIteratorFilter<OlapMember> newInstance() {
            return this;
        }
    }
}

