/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.id;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapIdentifiable;
import crazydev.iccube.olap.util.OlapNameIdentifiable;
import org.jetbrains.annotations.Nullable;

public class OlapEntityIdentifierNamePart
extends OlapEntityIdentifierPart {
    private final boolean delimited;
    private final String name;

    public OlapEntityIdentifierNamePart(boolean delimited, String name) {
        this.delimited = delimited;
        this.name = name;
    }

    @Override
    public boolean isDelimited() {
        return this.delimited;
    }

    @Override
    public boolean isKey() {
        return false;
    }

    @Override
    public boolean isAll() {
        return OlapCaseInsensitiveName.equals("all", this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isIdentifying(OlapNameContext nameContext, OlapIdentifiable entity) {
        if (this.isAll()) {
            if (entity instanceof OlapNameIdentifiableEntity) {
                OlapNameIdentifiableEntity nameIdentifiable = (OlapNameIdentifiableEntity)entity;
                return nameIdentifiable.isAllMember();
            }
            return false;
        }
        if (entity instanceof OlapNameIdentifiable) {
            OlapNameIdentifiable nameIdentifiable = (OlapNameIdentifiable)entity;
            return OlapCaseInsensitiveName.equals(this.name, nameIdentifiable.getName(nameContext));
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapEntityIdentifierNamePart that = (OlapEntityIdentifierNamePart)o;
        return OlapCaseInsensitiveName.equals(this.name, that.name);
    }

    @Override
    @Nullable
    public String asName() {
        return this.name;
    }

    public String toString() {
        return this.name + (this.isAll() ? "(all)" : "");
    }
}

