/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.hierarchy;

import crazydev.common.collection.CdAction;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.olap.OlapEntityType;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyAllPermissions;
import crazydev.iccube.authorizationx.permissions.hierarchy.OlapRoleHierarchyPermissions;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.builders.dimension.OlapBuilderDimensionBuilder;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderExcelTimeLineSupport;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.IOlapEntityWithChildren;
import crazydev.iccube.olap.entity.OlapEntityVarType;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.common.OlapMemberChildrenList;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierMultiValueKeyPart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierSingleValueKeyPart;
import crazydev.iccube.olap.entity.level.IOlapLevelNameFactory;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapAll4FactMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberChildrenListFactory;
import crazydev.iccube.olap.entity.member.OlapMemberFactory;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.member.OlapNoValueMemberKey;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.memory.OlapMemoryHierarchyLevelMembers;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.properties.OlapMemberPropertiesValues;
import crazydev.iccube.olap.entity.result.model.IResHierarchy;
import crazydev.iccube.olap.entity.result.model.IResMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarAbstractEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapFilteredOutTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.schema.OlapDynamicSchemaHierarchyIndex;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaHierarchyIndex;
import crazydev.iccube.olap.schema.OlapStaticSchemaHierarchyIndex;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.schema.stats.OlapHierarchyStats;
import crazydev.iccube.olap.schema.stats.OlapLevelStats;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public abstract class OlapHierarchy
extends OlapNonScalarAbstractEntity
implements IResHierarchy,
OlapNameIdentifiableEntity,
IOlapEntityWithChildren {
    public static final int DYNAMIC_TUPLE_DIMENSIONALITY_INDEX_NOT_SET = -2;
    public static final String FRIENDLY_NAME = "hierarchy";
    protected final List<OlapLevel> levels = new ArrayList<OlapLevel>();
    private final OlapRoleHierarchyAllPermissions allPermissions;
    private final OlapDimension dimension;
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String folderName;
    private final boolean isBase;
    private final boolean isCategory;
    private final AtomicInteger currentMemberIndex = new AtomicInteger(-1);
    private final OlapMemoryHierarchyLevelMembers dataHandler;
    private final boolean aggrFactOnAncestor;
    private final OlapHierarchyScope scope;
    private final OlapSchemaHierarchyIndex tupleDimensionalityIndex;
    private final OlapBuilderExcelTimeLineSupport excelTimeLineSupport;
    @Nullable
    private final Locale locale;
    private String caption;
    @Nullable
    private OlapMember definedDefaultMember;
    private OlapMemberChildren rootMembers = OlapMemberChildrenList.emptyList();
    private volatile boolean factsOnlyInLeafs = true;
    private boolean acceptCategoryMembers = false;
    @Nullable
    private IOlapLevelNameFactory levelNameFactory = null;
    private OlapMember all4facts;
    private boolean isAttributeHierarchy = false;
    @Nullable
    private OlapHierarchy attributeOfHierarchy;

    protected OlapHierarchy(OlapDimension dimension, OlapHierarchyScope scope, int tupleDimensionalityIndex, String name, @Nullable String description, boolean isBase, boolean isCategory, boolean aggrFactOnAncestor, @Nullable OlapBuilderExcelTimeLineSupport excelTimeLineSupport, @Nullable Locale locale, @Nullable String folderName) {
        this.aggrFactOnAncestor = aggrFactOnAncestor;
        this.allPermissions = new OlapRoleHierarchyAllPermissions(this);
        this.dimension = dimension;
        this.isBase = isBase;
        this.isCategory = isCategory;
        this.folderName = folderName;
        this.name = name;
        this.caption = name;
        this.description = description;
        this.dataHandler = new OlapMemoryHierarchyLevelMembers();
        this.scope = scope;
        OlapSchema schema = dimension.getSchema();
        if (tupleDimensionalityIndex == -1) {
            throw new RuntimeException("internal error: inconsistent index [" + tupleDimensionalityIndex + "] for hierarchy [" + name + "]");
        }
        this.tupleDimensionalityIndex = this.scope == OlapHierarchyScope.SCHEMA ? new OlapStaticSchemaHierarchyIndex(this, tupleDimensionalityIndex) : new OlapDynamicSchemaHierarchyIndex(schema, this, tupleDimensionalityIndex);
        this.excelTimeLineSupport = excelTimeLineSupport != null ? excelTimeLineSupport : OlapBuilderExcelTimeLineSupport.NONE;
        this.locale = locale;
    }

    @Override
    public OlapEntityVarType getVarType() {
        return OlapEntityVarType.HIERARCHY;
    }

    public static int validateIndexingByRange(OlapBuilderErrorManager errorManager, int errorsToStop, OlapMemberChildren children, @Nullable OlapLevel childrenLevel, @Nullable OlapMemberKey beginInterval, @Nullable OlapMemberKey endInterval) {
        if (errorsToStop <= 0 || children.isEmpty()) {
            return errorsToStop;
        }
        double checkMult = OlapHierarchy.getOrderMultiplier(childrenLevel);
        OlapMember formerMember = null;
        for (OlapMember child : children.iterable()) {
            if (formerMember != null && (double)formerMember.compareTo(child.getKey()) * checkMult >= 0.0) {
                OlapNameContext nameContext = errorManager.getNameContext();
                errorManager.addError(OlapBuilderErrorCode.RANGED_HIERARCHY_MEMBERS_WRONG_ORDER, new Serializable[]{formerMember.getUniqueName(nameContext), formerMember.getKey().toString(), child.getUniqueName(nameContext), child.getKey().toString()});
                if (--errorsToStop < 0) {
                    return 0;
                }
            }
            formerMember = child;
        }
        if (checkMult > 0.0) {
            for (i = 1; i < children.size(); ++i) {
                begin = children.get(i - 1);
                if ((errorsToStop = OlapHierarchy.validateIndexingByRangeMember(errorManager, errorsToStop, beginInterval, endInterval, begin, end = children.get(i))) > 0) continue;
                return 0;
            }
        } else {
            for (i = children.size() - 1; i > 0; --i) {
                begin = children.get(i);
                if ((errorsToStop = OlapHierarchy.validateIndexingByRangeMember(errorManager, errorsToStop, beginInterval, endInterval, begin, end = children.get(i - 1))) > 0) continue;
                return 0;
            }
        }
        OlapMember begin = children.get(children.size() - 1);
        errorsToStop = OlapHierarchy.validateIndexingByRangeMember(errorManager, errorsToStop, beginInterval, endInterval, begin, null);
        return errorsToStop;
    }

    private static double getOrderMultiplier(OlapLevel childrenLevel) {
        boolean isInverseOrder = childrenLevel != null && childrenLevel.isOrderKeyAndDecOrder();
        double checkMult = isInverseOrder ? -1.0 : 1.0;
        return checkMult;
    }

    private static int validateIndexingByRangeMember(OlapBuilderErrorManager errorManager, int errorsToStop, @Nullable OlapMemberKey beginInterval, @Nullable OlapMemberKey endInterval, @Nullable OlapMember begin, @Nullable OlapMember end) {
        if (errorsToStop <= 0) {
            return errorsToStop;
        }
        if (end != null && beginInterval != null && end.compareTo(beginInterval) <= 0 || begin != null && endInterval != null && begin.compareTo(endInterval) >= 0) {
            OlapNameContext nameContext = errorManager.getNameContext();
            String beginMember = begin == null ? "-" : begin.getUniqueName(nameContext);
            String beginMemberKey = begin == null ? "-" : begin.getKey().toString();
            String endMemberKey = end == null ? "-" : end.getKey().toString();
            String beginIntervalMess = beginInterval == null ? "-" : beginInterval.toString();
            String endIntervalMess = endInterval == null ? "-" : endInterval.toString();
            errorManager.addError(OlapBuilderErrorCode.RANGED_HIERARCHY_INVALID_INTERVAL, new Serializable[]{beginMember, beginMemberKey, endMemberKey, beginIntervalMess, endIntervalMess});
            if (--errorsToStop <= 0) {
                return 0;
            }
        }
        begin.validateIndexingByRange(errorManager, errorsToStop, begin.getKey(), end == null ? null : end.getKey());
        return errorsToStop;
    }

    public boolean removeCategory() {
        return this.isCategory && this.dimension.removeCategoryHierarchy(this);
    }

    public void resetForSchema(OlapSchema otherSchema, int nextHierarchyIndexOffset) {
        this.tupleDimensionalityIndex.resetForSchema(otherSchema, nextHierarchyIndexOffset);
    }

    public void resetTupleDimensionalityIndexForDynamicHierarchy(int index) {
        this.tupleDimensionalityIndex.resetForDynamicHierarchy(index);
    }

    public abstract boolean isParentChild();

    public boolean isMeasures() {
        return this.dimension.isMeasures();
    }

    public String getNameX() {
        return this.getName(OlapNameContext.DEFAULT_VALUES);
    }

    public String getUniqueNameX() {
        return this.getUniqueName(OlapNameContext.DEFAULT_VALUES);
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return nameContext.getHierarchyName(this, this.name);
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        if (nameContext.hasNewUniqueName(this)) {
            return this.createUniqueName(nameContext);
        }
        return this.createUniqueName(nameContext);
    }

    public void doAppendUniqueNameForMember(StringBuilder builder, OlapNameContext nameContext) {
        builder.append(this.getUniqueName(nameContext));
    }

    private String createUniqueName(OlapNameContext nameContext) {
        if (this.isMeasures()) {
            return this.dimension.getUniqueName(nameContext);
        }
        StringBuilder builder = new StringBuilder();
        if (!this.dimension.excludeDimensionName()) {
            builder.append(this.dimension.getUniqueName(nameContext)).append(".");
        }
        builder.append("[").append(CdMdxUtils.escape((String)this.getName(nameContext))).append("]");
        return builder.toString();
    }

    @Override
    public String getCaption(Locale locale, OlapNameContext nameContext) {
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String caption = localization.getHierarchyCaption(locale, this);
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            caption = this.getInternalCaption(nameContext);
        }
        return caption;
    }

    @Override
    @Nullable
    public String getDescription(Locale locale) {
        OlapSchema schema = this.getDimension().getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String descriptionL = localization.getHierarchyDescription(locale, this);
        if (CdStringUtils.isNotNullAndNotBlank((String)descriptionL)) {
            return descriptionL;
        }
        return this.description;
    }

    protected String getInternalCaption(OlapNameContext nameContext) {
        return nameContext.getHierarchyName(this, this.caption);
    }

    public OlapRoleHierarchyPermissions getAllPermissions() {
        return this.allPermissions;
    }

    public boolean isExcelTimeLine() {
        return this.excelTimeLineSupport == OlapBuilderExcelTimeLineSupport.VISIBLE;
    }

    public boolean isExcelTimeLineVisible() {
        return true;
    }

    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isAllMember() {
        return false;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public OlapSchema getSchema() {
        return this.dimension.getSchema();
    }

    public OlapDimension getDimension() {
        return this.dimension;
    }

    public boolean isDefaultMember(@Nullable OlapMemberFilter tupleFilter, OlapMember member) {
        return OlapMember.equal(member, this.getNullableDefaultMember(tupleFilter));
    }

    @Override
    @Nullable
    public IResMember getDefaultMember(@Nullable OlapMemberFilter filter) {
        return this.getNullableDefaultMember(filter);
    }

    public final OlapMember getNonNullDefaultMember(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember defaultMember = this.getNullableDefaultMember(tupleFilter);
        if (defaultMember != null) {
            return defaultMember;
        }
        throw new CdProgrammingException("Missing default-member for hierarchy '" + String.valueOf(this) + "'");
    }

    @Nullable
    public final OlapMember getNullableDefaultMember(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember localDefinedDefaultMember = this.getDefinedDefaultMember(tupleFilter);
        if (localDefinedDefaultMember == null) {
            OlapMember allMember = this.getAllMember();
            if (allMember != null) {
                return allMember;
            }
            OlapMember firstRoot = this.getFirstRootMember(tupleFilter);
            return firstRoot;
        }
        return localDefinedDefaultMember;
    }

    @Nullable
    private OlapMember getDefinedDefaultMember(@Nullable OlapMemberFilter tupleFilter) {
        OlapMember redefinedDefaultMember;
        OlapMember olapMember = redefinedDefaultMember = tupleFilter == null ? null : tupleFilter.getRedefinedDefaultMember(this);
        if (redefinedDefaultMember != null) {
            if (tupleFilter.isAccepting(redefinedDefaultMember)) {
                return redefinedDefaultMember;
            }
            return null;
        }
        if (this.definedDefaultMember != null && tupleFilter != null && !tupleFilter.isAccepting(this.definedDefaultMember)) {
            return null;
        }
        return this.definedDefaultMember;
    }

    public void setInitialDefaultMember() {
        if (this.definedDefaultMember == null) {
            return;
        }
        this.definedDefaultMember = this.getNullableDefaultMember(null);
    }

    public void setDefaultMember(OlapMember defaultMember) {
        if (defaultMember.getHierarchy() != this) {
            throw new CdProgrammingException("Inconsistent default member hierarchy '" + String.valueOf(defaultMember) + "'");
        }
        this.definedDefaultMember = defaultMember;
    }

    @Nullable
    public OlapMember getDefinedDefaultMember() {
        return this.definedDefaultMember;
    }

    @Nullable
    public OlapMember getAllMember() {
        OlapLevel allLevel = this.getAllLevel();
        if (allLevel != null) {
            if (this.rootMembers.size() != 1) {
                throw new CdProgrammingException("Inconsistent HAS-ALL hierarchy (missing all-level)!");
            }
            return this.rootMembers.get(0);
        }
        return null;
    }

    public OlapTupleSet<OlapMember> getMembers() {
        return this.getMembers(null);
    }

    public OlapTupleSet<OlapMember> getMembers(@Nullable OlapMemberFilter tupleFilter) {
        return this.getMembersX(tupleFilter != null ? tupleFilter.asOlapMemberIteratorFilter() : null);
    }

    public OlapTupleSet<OlapMember> getMembersX(@Nullable IOlapIteratorFilter<OlapMember> memberFilter) {
        OlapIterator<OlapMember> members = OlapIteratorFactory.multiChildrenR(this.getRootMembers());
        if (memberFilter != null) {
            members = OlapIteratorFactory.filter(members, memberFilter);
        }
        return OlapSetFactory.instance(members);
    }

    public abstract OlapLevel addLevel(OlapLevel var1);

    public abstract List<OlapLevel> getLevels();

    public List<OlapLevel> getLevels(IOlapHierarchyPermission permissions) {
        ArrayList<OlapLevel> authorized = new ArrayList<OlapLevel>();
        List<OlapLevel> levels = this.getLevels();
        int size = levels.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapLevel level = levels.get(ii);
            if (!permissions.isLevelAuthorized(level)) continue;
            authorized.add(level);
        }
        return authorized;
    }

    @Nullable
    public abstract OlapLevel getAllLevel();

    public void validateConsistency(OlapBuilderErrorManager errorManager) {
        List<OlapLevel> levels = this.getLevels();
        if (levels == null || levels.isEmpty()) {
            errorManager.addError(OlapBuilderErrorCode.HIERARCHY_NO_LEVEL, new Serializable[]{this.getUniqueName(errorManager.getNameContext())});
        } else {
            for (OlapLevel level : levels) {
                level.validateConsistency(errorManager);
            }
            this.assertLevelChainConsistency(errorManager);
        }
        if (this.isBase && this.getDimension().isIndexingByRange()) {
            this.validateIndexingByRange(errorManager);
        }
        if (this.getNullableDefaultMember(null) == null) {
            errorManager.addError(OlapBuilderErrorCode.HIERARCHY_NO_DEFAULT_MEMBER, new Serializable[]{this.getUniqueName(errorManager.getNameContext())});
        }
    }

    private void validateIndexingByRange(OlapBuilderErrorManager errorManager) {
        int errorsToStop = 10;
        OlapMember allmember = this.getAllMember();
        if (allmember != null) {
            allmember.validateIndexingByRange(errorManager, errorsToStop, null, null);
        } else {
            OlapHierarchy.validateIndexingByRange(errorManager, errorsToStop, this.getRootMembers(), null, null, null);
        }
    }

    protected void assertLevelChainConsistency(OlapBuilderErrorManager errorManager) {
        OlapNameContext nameContext = errorManager.getNameContext();
        List<OlapLevel> levels = this.getLevels();
        for (int idx = 0; idx < levels.size(); ++idx) {
            OlapLevel level = levels.get(idx);
            OlapLevel prev = level.getPreviousLevel();
            OlapLevel next = level.getNextLevel();
            if (idx == 0) {
                if (prev == null) continue;
                throw new CdProgrammingException("hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency [missing previous level:" + level.getName(nameContext) + ".");
            }
            if (idx == levels.size() - 1) {
                if (next == null) continue;
                throw new CdProgrammingException("hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency [missing next level:" + level.getName(nameContext) + ".");
            }
            if (prev != null && next != null) continue;
            throw new CdProgrammingException("hierarchy '" + this.getUniqueName(nameContext) + "' inconsistency [missing previous/next level:" + level.getName(nameContext) + ".");
        }
        int xpos = 0;
        OlapLevel xlevel = levels.get(xpos);
        while ((xlevel = xlevel.getNextLevel()) != null) {
            if (xlevel == levels.get(++xpos)) continue;
            throw new CdProgrammingException("hierarchy '" + this.getUniqueName(nameContext) + "' inconsistent next level chain.");
        }
        xpos = levels.size() - 1;
        xlevel = levels.get(xpos);
        while ((xlevel = xlevel.getPreviousLevel()) != null) {
            if (xlevel == levels.get(--xpos)) continue;
            throw new CdProgrammingException("hierarchy '" + this.getUniqueName(nameContext) + "' inconsistent previous level chain.");
        }
    }

    @Override
    protected OlapTupleSet<?> toSet_(IOlapPrepareContext context) {
        return this.toTuple(context).toSet(context);
    }

    @Override
    public boolean isToSetApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public OlapTuple toTuple(IOlapPrepareContext context) {
        OlapMember member = this.toNullableMember(context);
        if (member == null) {
            return OlapFilteredOutTuple.INSTANCE;
        }
        return member.toTuple(context);
    }

    @Override
    public boolean isToTupleApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member")
    public @Nullable(value="possibly null when delegating the call to the (possibly empty 'coz of filtering) hierarchy default member") OlapMember toNullableMember(IOlapPrepareContext context) {
        if (context.isConstrained()) {
            return (OlapMember)context.onConstrainedViolation();
        }
        return context.getNullableCurrentMember(this);
    }

    @Override
    public boolean isToMemberApplicable(IOlapPrepareContext context) {
        return true;
    }

    @Override
    public OlapScalarEntity toValue(GFContext context, GFTupleEvaluator evaluator) {
        return this.toTuple(context.getPrepareContext()).toValue(context, evaluator);
    }

    @Override
    public boolean isToValueApplicable(GFContext context, GFTupleEvaluator evaluator) {
        return true;
    }

    @Override
    public boolean isScoping(OlapMember member) {
        return member.getHierarchy().equals(this);
    }

    @Override
    public boolean isScoping(OlapHierarchy hierarchy) {
        return hierarchy.equals(this);
    }

    @Override
    public OlapEntityType getEntityType() {
        return OlapEntityType.HIERARCHY;
    }

    public boolean canIndexByRange() {
        return this.getDimension().isIndexingByRange();
    }

    public OlapMember[] lookupMemberByRange(@Nullable OlapLevel level, Object keyValue) {
        OlapMember[] olapMemberArray;
        OlapBuilderInputType[] levelKeyTypes;
        if (keyValue.getClass().isArray() && Array.getLength(keyValue) == 2 && (levelKeyTypes = this.getLastLevel().getMemberKeyType()) != null && levelKeyTypes.length == 1) {
            return this.doMultipleLookupByRange(level, keyValue);
        }
        OlapMember olapMember = this.doSingleLookupByRange(keyValue, level);
        if (olapMember == null) {
            olapMemberArray = new OlapMember[]{};
        } else {
            OlapMember[] olapMemberArray2 = new OlapMember[1];
            olapMemberArray = olapMemberArray2;
            olapMemberArray2[0] = olapMember;
        }
        return olapMemberArray;
    }

    private OlapMember[] doMultipleLookupByRange(OlapLevel level, Object keyArrayValue) {
        Object start = Array.get(keyArrayValue, 1);
        Object end = Array.get(keyArrayValue, 0);
        OlapMember from = start == null ? null : this.doSingleLookupByRange(start, level);
        OlapMember to = end == null ? null : this.doSingleLookupByRange(end, level);
        return this.doMultipleLookupByRangeEx(level, from, to);
    }

    public OlapMember[] doMultipleLookupByRangeEx(OlapLevel level, @Nullable OlapMember from, @Nullable OlapMember to) {
        ArrayList<OlapMember> returnMembers;
        block7: {
            if (from == null && to == null) {
                throw new CdRuntimeException("Both members are null");
            }
            if (OlapMember.equal(from, to)) {
                return new OlapMember[]{from};
            }
            returnMembers = new ArrayList<OlapMember>();
            do {
                if (OlapMember.equal(from, to)) {
                    returnMembers.add(from);
                } else {
                    OlapMember member;
                    if (from != null && to != null && from.getLevel() != to.getLevel()) {
                        throw new CdRuntimeException("Pyramidal hierarchies are not supported, both levels should be equal [" + from.getLevel().getName(OlapNameContext.DEFAULT_VALUES) + "] - [" + to.getLevel().getName(OlapNameContext.DEFAULT_VALUES) + "]");
                    }
                    OlapTupleSet set = (OlapTupleSet)OlapLevel.range(null, from, to);
                    OlapIterator iter = set.getIterator(false);
                    iter.reset();
                    while ((member = (OlapMember)iter.next()) != null) {
                        returnMembers.add(member);
                    }
                }
                if (!this.aggrFactOnAncestor) break block7;
                from = from == null ? null : from.getParent();
                OlapMember olapMember = to = to == null ? null : to.getParent();
                if (from == null && to == null) break block7;
                if (from == null || !from.isAll()) continue;
                returnMembers.add(from);
                break block7;
            } while (to == null || !to.isAll());
            returnMembers.add(to);
        }
        return returnMembers.toArray(new OlapMember[returnMembers.size()]);
    }

    @Nullable
    private OlapMember doSingleLookupByRange(Object keyValue, @Nullable OlapLevel level) {
        Object valueForCompare = this.getLastLevel().getDataHandler().getKeyValueForCompare(keyValue);
        OlapMember allMember = this.getAllMember();
        if (allMember != null) {
            return allMember.lookupMemberByRange(valueForCompare, level);
        }
        boolean isAsc = this.getFirstLevel().getOrderKind().isAsc();
        OlapMember lookupMember = this.rootMembers.binaryRangeLookupFromKey4Comp(valueForCompare, isAsc, this.hasCreatedUnknown());
        return lookupMember == null ? null : lookupMember.lookupMemberByRange(valueForCompare, level);
    }

    public boolean hasCreatedUnknown() {
        return this.getLastLevel().getCreatedUnkownMember() != null;
    }

    public OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, OlapEntityIdentifier id) {
        OlapLevel level;
        int idx;
        IOlapDimensionPermission dimPermissions = permissions.getDimensionPermissions(this.getDimension());
        IOlapHierarchyPermission hierarchyPermissions = dimPermissions.getHierarchyPermission(this);
        List<OlapLevel> levels = this.getLevels(hierarchyPermissions);
        int levelsSize = levels.size();
        OlapEntityIdentifierPart levelId = id.getPart(0);
        for (idx = 0; idx < levelsSize; ++idx) {
            level = levels.get(idx);
            if (!levelId.isIdentifying(nameContext, level)) continue;
            if (id.getPartCount() == 1) {
                return level;
            }
            OlapEntityIdentifier next = id.subIdentifier(1);
            OlapNonScalarEntity member = level.lookupEntityByMdxIdentifier(nameContext, permissions, next);
            if (member.isMdxNull()) break;
            return member;
        }
        for (idx = 0; idx < levelsSize; ++idx) {
            level = levels.get(idx);
            OlapNonScalarEntity member = level.lookupEntityByMdxIdentifier(nameContext, permissions, id);
            if (member.isMdxNull()) continue;
            return member;
        }
        return OlapNullEntity.INSTANCE;
    }

    @Nullable
    public OlapLevel lookupLevel(OlapNameContext nameContext, IOlapHierarchyPermission permissions, OlapEntityIdentifier id) {
        if (id.getPartCount() != 1) {
            return null;
        }
        OlapEntityIdentifierPart levelId = id.getPart(0);
        for (OlapLevel level : this.getLevels(permissions)) {
            if (!levelId.isIdentifying(nameContext, level)) continue;
            return level;
        }
        return null;
    }

    @Nullable
    public OlapLevel lookupLevel(IOlapHierarchyPermission permissions, int index) {
        for (OlapLevel level : this.getLevels(permissions)) {
            if (level.getDepth() != index) continue;
            return level;
        }
        return null;
    }

    @Nullable
    public OlapLevel getLevelAtDepth(int depth) {
        if (depth >= 0 && depth < this.levels.size()) {
            return this.levels.get(depth);
        }
        return null;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toMdxString(OlapNameContext nameContext, boolean truncate, int maxSize) {
        String str = this.dimension.toMdxString(nameContext, truncate, maxSize);
        return str + ".[" + CdMdxUtils.escape((String)this.name) + "]";
    }

    public String toString() {
        return this.name + "(" + this.getTupleDimensionalityIndex() + ")";
    }

    @Nullable
    public OlapLevel getLevel(IOlapHierarchyPermission permissions, OlapLevelType levelType) {
        for (OlapLevel level : this.getLevels(permissions)) {
            if (level.getLevelType() != levelType) continue;
            return level;
        }
        return null;
    }

    @Nullable
    public OlapLevel getLevelForDistance(int lookupDepth) {
        List<OlapLevel> levels = this.getLevels();
        int size = levels.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapLevel level = levels.get(ii);
            if (level.getDepth() != lookupDepth) continue;
            return level;
        }
        return null;
    }

    @Nullable
    public OlapLevel lookupLevelByName(OlapNameContext nameContext, IOlapHierarchyPermission permissions, String name) {
        List<OlapLevel> levels = this.getLevels(permissions);
        int size = levels.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapLevel level = levels.get(ii);
            if (!OlapCaseInsensitiveName.equals(level.getName(nameContext), name)) continue;
            return level;
        }
        return null;
    }

    @Nullable
    public OlapLevel unfilteredLookupLevelByName(OlapNameContext nameContext, String name) {
        for (OlapLevel level : this.getLevels()) {
            if (!OlapCaseInsensitiveName.equals(level.getName(nameContext), name)) continue;
            return level;
        }
        return null;
    }

    @Override
    public String getFriendlyTypeName() {
        return FRIENDLY_NAME;
    }

    public OlapLevel getFirstLevel() {
        return this.getLevels().get(0);
    }

    public OlapLevel getLastLevel() {
        List<OlapLevel> levelList = this.getLevels();
        return levelList.get(levelList.size() - 1);
    }

    public abstract OlapLevel getFactIndexingLevel();

    public OlapMemberChildren getRootMembers() {
        return this.rootMembers;
    }

    @Override
    public IOlapEntityWithChildren getEntityWithChildrenParent() {
        return null;
    }

    @Override
    public int getChildrenCount() {
        return this.rootMembers.size();
    }

    @Override
    public OlapMember getChild(int position) {
        return this.rootMembers.get(position);
    }

    @Override
    public int getChildPosition(@Nullable OlapMemberFilter tupleFilter, OlapMember lookupMember) {
        int index = this.rootMembers.indexOf(lookupMember);
        if (index < 0 || tupleFilter != null && !tupleFilter.isAccepting(lookupMember)) {
            throw new CdProgrammingException("Missing child '" + String.valueOf(lookupMember) + "' in '" + String.valueOf(this) + "'");
        }
        return index;
    }

    public void addRootMember(OlapMember member) {
        if (this.rootMembers.isEmpty()) {
            this.rootMembers = OlapMemberChildrenListFactory.buildEmptyChildrenList(this.getFirstLevel());
        }
        this.rootMembers.add(member);
    }

    @Nullable
    public OlapMember getFirstRootMember(@Nullable OlapMemberFilter tupleFilter) {
        for (int i = 0; i < this.rootMembers.size(); ++i) {
            OlapMember rootMember = this.rootMembers.get(i);
            if (tupleFilter != null && !tupleFilter.isAccepting(rootMember)) continue;
            return rootMember;
        }
        return null;
    }

    @Nullable
    public OlapMember getLastRootMember(@Nullable OlapMemberFilter tupleFilter) {
        for (int i = this.rootMembers.size() - 1; i >= 0; --i) {
            OlapMember rootMember = this.rootMembers.get(i);
            if (tupleFilter != null && !tupleFilter.isAccepting(rootMember)) continue;
            return rootMember;
        }
        return null;
    }

    @Nullable
    public OlapMember getFirstMemberForLevel(@Nullable OlapMemberFilter tupleFilter, OlapLevel level) {
        for (int idx = 0; idx < this.rootMembers.size(); ++idx) {
            OlapMember first;
            OlapMember member = this.rootMembers.get(idx);
            if (tupleFilter != null && !tupleFilter.isAccepting(member) || (first = member.getFirstDescendant(tupleFilter, level)) == null) continue;
            return first;
        }
        return null;
    }

    public int getNextUniqueMemberIndex() {
        return this.currentMemberIndex.incrementAndGet();
    }

    public int getMaxUniqueMemberIndex() {
        return this.currentMemberIndex.get();
    }

    public int getCurrentMemberIndex() {
        return this.currentMemberIndex.get();
    }

    public int getTupleDimensionalityIndex() {
        return this.tupleDimensionalityIndex.getValue();
    }

    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionalityIndex.getDimensionality();
    }

    public IOlapMemoryLevelMember getOrCreateDataHandler(OlapLevel level) {
        return this.dataHandler.getOrCreateDataHandler(level);
    }

    @Nullable
    public OlapMember addUnknownMember(OlapBuilderContext context, @Nullable OlapMember baseMember, String unknownMemberName) {
        OlapMember unknownMember;
        Optional<OlapLevel> options = this.getLevels().stream().filter(l -> !l.isAll() && CdStringUtils.isNotNullAndNotBlank((String)l.getMissingAttributeMemberName())).reduce((level, level2) -> level2);
        if (options.isPresent() && (unknownMember = options.get().lookupMemberByName(unknownMemberName)) != null) {
            unknownMember.forEachAndAncestor((CdAction<OlapMember>)((CdAction)member -> {
                if (!member.isAllMember()) {
                    member.getLevel().setUnknownMember((OlapMember)member);
                    context.addNoBaseBaseLink((OlapMember)member, baseMember);
                }
            }));
            return unknownMember;
        }
        OlapMember parentMember = this.getAllMember();
        for (OlapLevel level3 : this.getLevels()) {
            if (level3.isAll()) continue;
            OlapMemberPropertiesValues properties = level3.getMemberProperties(null).isEmpty() ? null : new OlapMemberPropertiesValues();
            OlapMember unknownMember2 = OlapMemberFactory.createMember(context, this.isBase, level3, parentMember, unknownMemberName, OlapNoValueMemberKey.INSTANCE, properties);
            level3.addMember(unknownMember2, true);
            parentMember = unknownMember2;
            if (baseMember == null) continue;
            if (level3.isLast()) {
                unknownMember2.addBaseHierarchyChild(context, baseMember);
                context.addNoBaseBaseLink(unknownMember2, baseMember);
            }
            OlapBuilderDimensionBuilder.addAttributeMember(baseMember, unknownMember2);
        }
        return parentMember;
    }

    public static OlapMember getAttributeMember(OlapMember baseMember, OlapMember member) {
        OlapLevel baseLevel = baseMember.getLevel().getMatchingAttributeLevel(member.getHierarchy());
        if (baseLevel == null) {
            return null;
        }
        return baseMember.getAncestor(baseLevel);
    }

    public void onFinishBuild(boolean incrLoad, boolean incrLoadActive) {
        this.dataHandler.onFinishBuild(incrLoad, incrLoadActive);
        CdAction action = OlapMember::onFinishLoad;
        List<OlapLevel> levels = this.getLevels();
        for (OlapLevel level : levels) {
            level.forEachMember((CdAction<OlapMember>)action);
        }
    }

    public boolean aggrFactsOnAncestors() {
        return this.aggrFactOnAncestor;
    }

    public boolean isStandardRollup() {
        return this.aggrFactOnAncestor && this.factsOnlyInLeafs;
    }

    public void setNotStandardRollupBroken() {
        this.factsOnlyInLeafs = false;
    }

    public void forEachNoBaseTerminalMember(OlapMember baseMember, CdAction<OlapMember> action) {
        if (!this.isBase) {
            for (OlapMember rootMember : this.rootMembers.iterable()) {
                rootMember.forEachNoBaseTerminalMember(baseMember, action);
            }
        }
    }

    public int getMemberCount() {
        int count = 0;
        List<OlapLevel> levels = this.getLevels();
        int size = levels.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapLevel level = levels.get(ii);
            count += level.getMemberCount();
        }
        return count;
    }

    public void setAcceptsCategoryMembers() {
        this.acceptCategoryMembers = true;
    }

    public boolean acceptCategoryMembers() {
        return this.acceptCategoryMembers;
    }

    public boolean isCategory() {
        return this.isCategory;
    }

    @Nullable
    public IOlapLevelNameFactory getLevelNameFactory() {
        return this.levelNameFactory;
    }

    public void setLevelNameFactory(@Nullable IOlapLevelNameFactory levelNameFactory) {
        this.levelNameFactory = levelNameFactory;
    }

    public OlapHierarchyScope getScope() {
        return this.scope;
    }

    public boolean isSchemaBased() {
        return this.scope == OlapHierarchyScope.SCHEMA;
    }

    public boolean isSessionBased() {
        return this.scope == OlapHierarchyScope.SESSION;
    }

    public boolean isRequestBased() {
        return this.scope == OlapHierarchyScope.REQUEST;
    }

    public void deleteCategoryMember(OlapAbstractCategoryMember member) {
        throw new RuntimeException("internal error : DROP CATEGORY MEMBER is not supported yet");
    }

    public boolean deleteAllCategoryMembers() {
        if (!this.acceptCategoryMembers()) {
            throw new RuntimeException("internal error : deleteAllCategoryMembers() not supported for hierarchy [" + ONames.name4Log(this) + "]");
        }
        OlapLevel firstLevel = this.levels.get(0);
        if (firstLevel.getMemberCount() != 1 || this.rootMembers.size() != 1) {
            throw new RuntimeException("internal error : first level with more than one member");
        }
        if (this.levels.size() <= 1) {
            return false;
        }
        this.levels.clear();
        this.levels.add(firstLevel);
        firstLevel.clearNextLevel();
        this.dataHandler.removeAllExcept(firstLevel);
        OlapMember firstMember = this.rootMembers.get(0);
        firstMember.removeChildren();
        OlapSchema schema = this.dimension.getSchema();
        schema.deleteCategoryHierarchyBitmaps(this);
        return true;
    }

    public OlapHierarchyStats createStats() {
        ArrayList<OlapLevelStats> hierarchyStats = new ArrayList<OlapLevelStats>();
        for (OlapLevel level : this.levels) {
            hierarchyStats.add(level.createStats());
        }
        long autoExistSize = this.getSchema().getAutoExistContainer().sizeOf(this.levels.getFirst().getHierarchy());
        return new OlapHierarchyStats(this.name, this.getTupleDimensionalityIndex(), this.isBase, this.isHollow(), hierarchyStats, autoExistSize);
    }

    public OlapHierarchyStats createIncrLoadStats() {
        ArrayList<OlapLevelStats> hierarchyStats = new ArrayList<OlapLevelStats>();
        for (OlapLevel level : this.levels) {
            hierarchyStats.add(level.createIncrLoadStats());
        }
        long autoExistSize = this.getSchema().getAutoExistContainer().sizeOf(this.levels.getFirst().getHierarchy());
        return new OlapHierarchyStats(this.name, this.getTupleDimensionalityIndex(), this.isBase, this.isHollow(), hierarchyStats, autoExistSize);
    }

    public boolean isHollow() {
        return false;
    }

    public OlapMember getAllMember4Facts() {
        if (this.all4facts == null) {
            this.buildAllMember4Facts();
        }
        return this.all4facts;
    }

    private void buildAllMember4Facts() {
        OlapMember member = this.getAllMember();
        this.all4facts = member != null ? member : new OlapAll4FactMember(this);
    }

    public void forEachMember(CdAction<OlapMember> action) {
        for (int i = 0; i < this.levels.size(); ++i) {
            this.levels.get(i).forEachMemberWithoutAll(action);
        }
    }

    public void resetCategoryMembers() {
        if (!this.acceptCategoryMembers()) {
            return;
        }
        this.getLevels().forEach(level -> level.forEachMemberWithoutAll((CdAction<OlapMember>)((CdAction)OlapMember::resetCategory)));
    }

    @Override
    public String toStringForDebugger() {
        return this.getUniqueName(OlapNameContext.DEFAULT_VALUES);
    }

    @Nullable
    public OlapMember lookupMemberForDataSourceQuery(OlapNameContext nameContext, IOlapDimensionsPermission permissions, OlapScalarEntity entity) {
        OlapNonScalarEntity member;
        if (entity instanceof OlapStringEntity) {
            String name = entity.asString();
            OlapEntityIdentifier nameID = new OlapEntityIdentifier(name);
            member = this.lookupEntityByMdxIdentifier(nameContext, permissions, nameID);
            if (member instanceof OlapMember) {
                return (OlapMember)member;
            }
        }
        String key = entity.asString();
        OlapEntityIdentifier keyID = new OlapEntityIdentifier(new OlapEntityIdentifierSingleValueKeyPart(key));
        member = this.lookupEntityByMdxIdentifier(nameContext, permissions, keyID);
        if (member instanceof OlapMember) {
            return (OlapMember)member;
        }
        return null;
    }

    @Nullable
    public OlapMember lookupMemberForDataSourceQuery(OlapNameContext nameContext, IOlapDimensionsPermission permissions, List<OlapScalarEntity> entities) {
        if (entities.size() == 1) {
            OlapMember member = this.lookupMemberForDataSourceQuery(nameContext, permissions, entities.get(0));
            return member;
        }
        String[] keys = new String[entities.size()];
        for (int ii = 0; ii < entities.size(); ++ii) {
            String key;
            OlapScalarEntity entity = entities.get(ii);
            keys[ii] = key = entity.asString();
        }
        OlapEntityIdentifier keyID = new OlapEntityIdentifier(new OlapEntityIdentifierMultiValueKeyPart(keys));
        OlapNonScalarEntity member = this.lookupEntityByMdxIdentifier(nameContext, permissions, keyID);
        if (member instanceof OlapMember) {
            return (OlapMember)member;
        }
        return null;
    }

    public boolean mightBeFactHollow() {
        return this.dimension.canDoHollow() && this.aggrFactsOnAncestors();
    }

    @Nullable
    public String getFolderName() {
        return this.folderName;
    }

    @Nullable
    public Comparator<String> getLocalizedStringComparator() {
        return this.getSchema().getLocalizedStringComparator();
    }

    public boolean isMembersAllMembers() {
        return this.dimension.isMembersAllMembers();
    }

    public boolean hasOneRelationWithBase(OlapHierarchy noBaseHierarchy) {
        if (!this.isBase() || this.getDimension() != noBaseHierarchy.getDimension()) {
            return false;
        }
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).getDataHandler().hasOneRelationWithBase(noBaseHierarchy)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeHierarchy() {
        return this.isAttributeHierarchy;
    }

    @Nullable
    public OlapHierarchy getAttributeOfHierarchy() {
        return this.attributeOfHierarchy;
    }

    public void setIsAttributeHierarchy(boolean isAttributeHierarchy, @Nullable OlapHierarchy hierarchy) {
        this.isAttributeHierarchy = isAttributeHierarchy;
        this.attributeOfHierarchy = hierarchy;
    }

    public void setCaption(String caption) {
        this.caption = CdStringUtils.isNotNullAndNotBlank((String)caption) ? caption : this.name;
    }
}

