/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.dimension;

import crazydev.iccube.olap.entity.IOlapDimensionality;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.List;

public class OlapDimensionality
implements IOlapDimensionality {
    private final OlapBitSet dimensions = new OlapBitSet();

    public static OlapDimensionality intersect(OlapDimensionality dim1, OlapDimensionality dim2) {
        OlapDimensionality dim = new OlapDimensionality();
        dim.add(dim1);
        dim.add(dim2);
        return dim;
    }

    public void clear() {
        this.dimensions.clear();
    }

    public void resetForSchema(OlapSchema schema, List<OlapDimension> indexingDimensions) {
        this.dimensions.clear();
        for (OlapDimension indexingDimension : indexingDimensions) {
            this.add(indexingDimension);
        }
    }

    public void add(OlapDimensionality dimensionality) {
        this.dimensions.or(dimensionality.dimensions);
    }

    public final void add(OlapDimension dimension) {
        this.dimensions.set(dimension.getDimensionalityIndex());
    }

    public final void add(OlapMember[] members) {
        for (OlapMember member : members) {
            this.add(member.getDimension());
        }
    }

    public final boolean intersects(OlapDimensionality other) {
        return this.dimensions.intersects(other.dimensions);
    }

    public boolean isIn(OlapMember member) {
        return this.isIn(member.getDimension());
    }

    public final boolean isIn(OlapDimension dimension) {
        return this.dimensions.get(dimension.getDimensionalityIndex());
    }

    public boolean isIn(OlapTuple tuple) {
        for (int i = 0; i < tuple.getMemberCount(); ++i) {
            OlapMember olapMember = tuple.getMember(i);
            if (!this.isIn(olapMember)) continue;
            return true;
        }
        return false;
    }

    public boolean isEquals(OlapDimensionality other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.dimensions.equals(other.dimensions);
    }

    public int cardinality() {
        return this.dimensions.cardinality();
    }
}

