/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.common;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.system.CdVirtualMachine;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class OlapNewChildren
implements OlapMemberChildren {
    protected OlapLevel expectedLevel;
    @Nullable
    protected ArrayList<OlapMember> ragged;

    public OlapNewChildren(OlapLevel expectedLevel) {
        this.expectedLevel = expectedLevel;
    }

    protected OlapMember getFromRagged(int fakeDataHandlerIdx) {
        return this.ragged.get(-fakeDataHandlerIdx - 1);
    }

    protected abstract int getDataHandlerIdx(int var1);

    @Override
    public OlapMember get(int index) {
        int idx = this.getDataHandlerIdx(index);
        return this.getMemberFromLevelIdx(idx);
    }

    @Override
    public boolean add(OlapMember member) {
        int handlerIdx = member.getDataHandlerIdx();
        if (member.getLevel() == this.expectedLevel && handlerIdx >= 0) {
            this.addToMemberList(handlerIdx);
        } else {
            if (this.ragged == null) {
                this.ragged = new ArrayList();
            }
            this.ragged.add(member);
            this.addToMemberList(-this.ragged.size());
        }
        return true;
    }

    protected abstract void addToMemberList(int var1);

    @Override
    public int indexOf(OlapMember member) {
        int dataHandlerIdx;
        if (member.getLevel() == this.expectedLevel) {
            dataHandlerIdx = member.getDataHandlerIdx();
        } else {
            if (this.ragged == null) {
                return -1;
            }
            int raggedIdx = this.ragged.indexOf(member);
            if (raggedIdx < 0) {
                return -1;
            }
            dataHandlerIdx = -raggedIdx - 1;
        }
        return this.getMembersDataHandlerIdx(dataHandlerIdx);
    }

    protected abstract int getMembersDataHandlerIdx(int var1);

    protected OlapMember getMemberFromLevelIdx(int dataHandlerIdx) {
        if (dataHandlerIdx >= 0) {
            return this.expectedLevel.getDataHandler().getMember(dataHandlerIdx);
        }
        return this.getFromRagged(dataHandlerIdx);
    }

    protected int createdUnknownDataHandlerIdx() {
        OlapMember createdUnknownMember = this.expectedLevel.getCreatedUnkownMember();
        return createdUnknownMember == null || createdUnknownMember.getDataHandlerIdx() < 0 ? Integer.MAX_VALUE : createdUnknownMember.getDataHandlerIdx();
    }

    @Override
    @Nullable
    public OlapMember lookupFromKeyForComp(OlapLevel keyLevel, Object keyValue) {
        Object keyForCompare = keyLevel.getKeyForCompare(keyValue);
        int createdUnknownMemberIdx = this.createdUnknownDataHandlerIdx();
        IOlapMemoryLevelMember dataHandler = this.expectedLevel.getDataHandler();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int dataHandlerIdx = this.getDataHandlerIdx(i);
            if (dataHandlerIdx < 0 || dataHandlerIdx == createdUnknownMemberIdx || dataHandler.naturalCompareWithKeyForCompare(dataHandlerIdx, keyForCompare) != 0) continue;
            return this.getMemberFromLevelIdx(dataHandlerIdx);
        }
        return null;
    }

    @Override
    public Iterable<OlapMember> iterable() {
        final int size = this.size();
        return () -> new Iterator<OlapMember>(this){
            int i;
            final /* synthetic */ OlapNewChildren this$0;
            {
                OlapNewChildren olapNewChildren = this$0;
                Objects.requireNonNull(olapNewChildren);
                this.this$0 = olapNewChildren;
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                return ++this.i < size;
            }

            @Override
            public OlapMember next() {
                return this.this$0.get(this.i);
            }
        };
    }

    @Override
    @Nullable
    public OlapMember lookupChildByNameIgnoreCase(String lookupName) {
        int size = this.size();
        IOlapMemoryLevelMember dataHandler = this.expectedLevel.getDataHandler();
        for (int i = 0; i < size; ++i) {
            int dataHandlerIdx = this.getDataHandlerIdx(i);
            if (dataHandlerIdx >= 0) {
                if (!dataHandler.nameEqualsIgnoreCase(dataHandlerIdx, lookupName)) continue;
                return this.getMemberFromLevelIdx(dataHandlerIdx);
            }
            OlapMember ragged = this.getFromRagged(dataHandlerIdx);
            if (!ragged.nameEqualsIgnoreCase(lookupName)) continue;
            return ragged;
        }
        return null;
    }

    @Override
    public void trimToSize() {
        if (this.ragged != null) {
            this.ragged.trimToSize();
        }
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        if (!this.isEmpty()) {
            return this.expectedLevel.getHierarchy().getTupleDimensionality();
        }
        return null;
    }

    @Override
    public OlapIterator<OlapMember> asIterator() {
        return OlapIteratorFactory.instance(this);
    }

    @Override
    public long shallowSizeOf() {
        long size = 0L;
        if (this.ragged != null) {
            size += CdRamUsageEstimator.shallowSizeOf(this.ragged);
            size += CdRamUsageEstimator.alignObjectSize((long)((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + (long)CdVirtualMachine.NUM_BYTES_OBJECT_REF * (long)this.ragged.size()));
        }
        return size;
    }
}

