/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.common;

import crazydev.common.collection.CdPaginatedSortedList;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.Comparator;
import java.util.Iterator;
import java.util.RandomAccess;
import org.jetbrains.annotations.Nullable;

public final class OlapMemberSortedChildrenList
extends CdPaginatedSortedList<OlapMember>
implements OlapMemberChildren,
RandomAccess {
    private static final Comparator<Object> KEY_COMPARATOR_ASC = (o1, o2) -> -((OlapMember)o1).compareWithKeyForCompare(o2);
    private static final Comparator<Object> KEY_COMPARATOR_DESC = (o1, o2) -> ((OlapMember)o1).compareWithKeyForCompare(o2);
    private static long SHALLOW_SIZE_OF = -1L;

    public OlapMemberSortedChildrenList(Comparator<OlapMember> comparator) {
        super(comparator);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        if (!this.isEmpty()) {
            OlapMember first = this.get(0);
            return first.getTupleDimensionality();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public Iterable<OlapMember> iterable() {
        return this;
    }

    @Override
    public long shallowSizeOf() {
        long size;
        long l = size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        if (this._data != null) {
            size += CdRamUsageEstimator.shallowSizeOf((Object[])this._data);
            for (Object[] child : this._data) {
                if (child == null) continue;
                size += CdRamUsageEstimator.shallowSizeOf((Object[])child);
            }
        }
        if (this._startPos != null) {
            size += CdRamUsageEstimator.sizeOf((int[])this._startPos);
        }
        if (this._pos != null) {
            size += CdRamUsageEstimator.sizeOf((int[])this._pos);
        }
        return size;
    }

    @Override
    public OlapMember get(int offset) {
        return (OlapMember)super.get(offset);
    }

    @Override
    public int indexOf(OlapMember child) {
        return super.indexOf((Object)child);
    }

    @Override
    public boolean add(OlapMember item) {
        return super.add((Object)item);
    }

    @Override
    @Nullable
    public OlapMember binaryLookupFromKey4Comp(OlapLevel keyLevel, Object keyValue) {
        Object keyForCompare = keyLevel.getKeyForCompare(keyValue);
        int pos = this.binarySearch(keyForCompare, keyLevel.getOrderKind().isAsc() ? KEY_COMPARATOR_ASC : KEY_COMPARATOR_DESC);
        if (pos >= 0) {
            OlapMember member = this.get(pos);
            return member;
        }
        return null;
    }

    @Override
    public OlapMember binaryRangeLookupFromKey4Comp(Object keyForCompare, boolean isAsc, boolean hasUnknown) {
        if (hasUnknown) {
            return this.searchRangeLookupFRomKey4Comp(keyForCompare, isAsc);
        }
        if (isAsc) {
            int pos = super.binarySearch(keyForCompare, KEY_COMPARATOR_ASC);
            int memberPos = pos >= 0 ? pos : Math.min(this.size() - 1, Math.max(0, -2 - pos));
            return this.get(memberPos);
        }
        int pos = super.binarySearch(keyForCompare, KEY_COMPARATOR_DESC);
        int memberPos = pos >= 0 ? pos : Math.min(this.size() - 1, Math.max(0, -1 - pos));
        return this.get(memberPos);
    }

    @Nullable
    private OlapMember searchRangeLookupFRomKey4Comp(Object keyForCompare, boolean isAsc) {
        int size = this.size();
        OlapMember member = null;
        OlapMember prevMember = null;
        for (int i = 0; i < size; ++i) {
            OlapMember tmember = this.get(i);
            if (tmember.isCreatedUnknownMember()) continue;
            int res = (isAsc ? KEY_COMPARATOR_ASC : KEY_COMPARATOR_DESC).compare(member = tmember, keyForCompare);
            if (res == 0) {
                return member;
            }
            if (res > 0) {
                return prevMember == null || !isAsc ? member : prevMember;
            }
            prevMember = member;
        }
        return member;
    }

    @Override
    @Nullable
    public OlapMember lookupFromKeyForComp(OlapLevel keyLevel, Object keyValue) {
        Object keyForCompare = keyLevel.getKeyForCompare(keyValue);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            OlapMember child = this.get(i);
            if (child.getLevel() != keyLevel || !child.equalsWithKeyForCompare(keyForCompare)) continue;
            return child;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapMember lookupChildByNameIgnoreCase(String lookupName) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            OlapMember child = (OlapMember)iterator.next();
            if (!child.nameEqualsIgnoreCase(lookupName)) continue;
            return child;
        }
        return null;
    }

    @Override
    public OlapIterator<OlapMember> asIterator() {
        return OlapIteratorFactory.instance(this);
    }
}

