/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.cmember;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class OlapSessionCalculatedMemberManager
extends OlapCalculatedMemberManager {
    private final String schemaName;
    private final Map<String, OlapCubeCalculatedMemberManager> calcMemberManagers = new ConcurrentHashMap<String, OlapCubeCalculatedMemberManager>();

    public OlapSessionCalculatedMemberManager(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    protected boolean isSelectScope() {
        return false;
    }

    public void addSessionCalcMemberIfNotContained(OlapInstrLocationRange errorLocation, OlapNameContext nameContext, OlapMember calcMember) {
        if (!calcMember.isMeasure()) {
            this.doAddIfNotContained(errorLocation, nameContext, calcMember);
        } else {
            OlapCube cube = calcMember.getCube();
            String cubeName = cube.getNameX();
            OlapCubeCalculatedMemberManager manager = this.calcMemberManagers.computeIfAbsent(cubeName, k -> new OlapCubeCalculatedMemberManager((String)k, new OlapSchemaCalculatedMemberManager()));
            manager.doAddIfNotContained(errorLocation, nameContext, calcMember);
        }
    }

    public void dropSessionCalcMember(OlapNameContext nameContext, OlapEntityIdentifier id, @Nullable OlapCube cube) {
        if (cube == null) {
            this.doDelete(this.lookupCalculatedMember(nameContext, id));
        } else {
            OlapCubeCalculatedMemberManager manager = this.calcMemberManagers.get(cube.getNameX());
            if (manager != null) {
                manager.doDelete(manager.lookupCalculatedMember(nameContext, id));
            }
        }
    }

    public List<OlapUserMeasureMember> getUserMeasures(String cubeName, @Nullable OlapMemberFilter tupleFilter) {
        OlapCubeCalculatedMemberManager manager = this.calcMemberManagers.get(cubeName);
        if (manager != null) {
            return manager.getUserMeasures(tupleFilter);
        }
        return Collections.emptyList();
    }

    public List<OlapMember> getVisibleCalculatedMembers(String cubeName, @Nullable OlapMemberFilter tupleFilter) {
        OlapCubeCalculatedMemberManager manager = this.calcMemberManagers.get(cubeName);
        if (manager != null) {
            return manager.getVisibleCalculatedMembers(tupleFilter);
        }
        return Collections.emptyList();
    }

    public List<OlapMember> getInvisibleCalculatedMembers(String cubeName, @Nullable OlapMemberFilter tupleFilter) {
        OlapCubeCalculatedMemberManager manager = this.calcMemberManagers.get(cubeName);
        if (manager != null) {
            return manager.getInvisibleCalculatedMembers(tupleFilter);
        }
        return Collections.emptyList();
    }

    @Nullable
    public OlapMember lookupCalculatedMember(String cubeName, OlapNameContext nameContext, OlapEntityIdentifier id) {
        OlapCubeCalculatedMemberManager manager = this.calcMemberManagers.get(cubeName);
        if (manager != null) {
            return manager.lookupCalculatedMember(nameContext, id);
        }
        return null;
    }
}

