/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.entity.cmember;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCubeCalculatedMemberManager
extends OlapCalculatedMemberManager {
    private final String cubeName;
    private final OlapSchemaCalculatedMemberManager schemaCalcMemberManager;

    public OlapCubeCalculatedMemberManager(String cubeName, OlapSchemaCalculatedMemberManager schemaCalculatedMemberManager) {
        this.cubeName = cubeName;
        this.schemaCalcMemberManager = schemaCalculatedMemberManager;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    protected boolean contains(OlapNameContext nameContext, OlapMember member) {
        return super.contains(nameContext, member) || this.schemaCalcMemberManager.contains(nameContext, member);
    }

    public OlapMember addIfNotContained(@Nullable OlapErrorLocation errorLocation, IOlapCubePermission cubePermissions, OlapNameContext nameContext, OlapMember member) {
        if (!member.isMeasure()) {
            throw new CdProgrammingException("internal error: not a calculated *measure*");
        }
        if (cubePermissions.isReadOnly()) {
            String cube = cubePermissions.getCube().getName(OlapNameContext.DEFAULT_VALUES);
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.CUBE_READ_ONLY, new Serializable[]{cube});
        }
        return this.doAddIfNotContained(errorLocation, nameContext, member);
    }

    public void addUserMeasureIfNotContained(@Nullable OlapErrorLocation errorLocation, IOlapCubePermission cubePermissions, OlapNameContext nameContext, OlapUserMeasureMember measure) {
        if (cubePermissions.isReadOnly()) {
            String cube = cubePermissions.getCube().getName(OlapNameContext.DEFAULT_VALUES);
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.CUBE_READ_ONLY, new Serializable[]{cube});
        }
        this.doAddUserMeasureIfNotContained(errorLocation, nameContext, measure);
    }

    public void deleteAll(@Nullable OlapErrorLocation errorLocation, IOlapCubePermission cubePermissions) {
        this.doDeleteAll(o -> !cubePermissions.isReadOnly());
    }

    public void delete(@Nullable OlapErrorLocation errorLocation, IOlapCubePermission cubePermissions, @Nullable OlapMember member) {
        if (member != null && !member.isMeasure()) {
            throw new CdProgrammingException("internal error: not a calculated *measure*");
        }
        if (cubePermissions.isReadOnly()) {
            String cube = cubePermissions.getCube().getName(OlapNameContext.DEFAULT_VALUES);
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.CUBE_READ_ONLY, new Serializable[]{cube});
        }
        if (member == null) {
            return;
        }
        this.doDelete(member);
    }

    public void deleteAllUserMeasures(@Nullable OlapErrorLocation errorLocation, IOlapCubePermission cubePermissions) {
        this.doDeleteAllUserMeasures(o -> !cubePermissions.isReadOnly());
    }

    public void deleteUserMeasure(@Nullable OlapErrorLocation errorLocation, IOlapCubePermission cubePermissions, @Nullable OlapUserMeasureMember member) {
        if (cubePermissions.isReadOnly()) {
            String cube = cubePermissions.getCube().getName(OlapNameContext.DEFAULT_VALUES);
            throw new OlapEvaluationException(errorLocation, OlapErrorCode.CUBE_READ_ONLY, new Serializable[]{cube});
        }
        if (member == null) {
            return;
        }
        this.doDeleteUserMeasure(member);
    }

    @Override
    @Nullable
    public OlapMember lookupCalculatedMember(OlapNameContext nameContext, OlapEntityIdentifier id) {
        OlapMember member = this.schemaCalcMemberManager.lookupCalculatedMember(nameContext, id);
        if (member != null) {
            return member;
        }
        return super.lookupCalculatedMember(nameContext, id);
    }

    @Override
    public List<OlapMember> getAllCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        List<OlapMember> calcMembers = this.schemaCalcMemberManager.getAllCalculatedMembers(tupleFilter);
        calcMembers.addAll(super.getAllCalculatedMembers(tupleFilter));
        return calcMembers;
    }

    @Override
    public List<OlapUserMeasureMember> getUserMeasures(@Nullable OlapMemberFilter memberFilter) {
        List<OlapUserMeasureMember> measures = this.schemaCalcMemberManager.getUserMeasures(memberFilter);
        measures.addAll(super.getUserMeasures(memberFilter));
        return measures;
    }

    @Override
    public List<OlapMember> getVisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        List<OlapMember> calcMembers = this.schemaCalcMemberManager.getVisibleCalculatedMembers(tupleFilter);
        calcMembers.addAll(super.getVisibleCalculatedMembers(tupleFilter));
        return calcMembers;
    }

    @Override
    public List<OlapMember> getInvisibleCalculatedMembers(@Nullable OlapMemberFilter tupleFilter) {
        List<OlapMember> calcMembers = this.schemaCalcMemberManager.getInvisibleCalculatedMembers(tupleFilter);
        calcMembers.addAll(super.getInvisibleCalculatedMembers(tupleFilter));
        return calcMembers;
    }

    @Override
    protected void setupOtherLastPositions(OlapCalculatedMemberManager other) {
        super.setupOtherLastPositions(other);
        this.schemaCalcMemberManager.setupOtherLastPositions(other);
    }

    @Override
    protected boolean isSelectScope() {
        return false;
    }
}

