/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.cube;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapPerspectiveCube
extends OlapCube {
    private final OlapRegularCube regularCube;
    @NotNull
    private final OlapPerspective perspective;

    public OlapPerspectiveCube(@NotNull OlapPerspective perspective, OlapRegularCube cube) {
        super(cube.getSchemaReference(), perspective.getName(), OlapPerspectiveCube.getDescription(cube));
        this.perspective = perspective;
        this.regularCube = cube;
        this.addDimension(cube.getMeasuresDimension());
    }

    @Override
    public boolean isPerspective() {
        return true;
    }

    private static String getDescription(OlapCube cube) {
        String description = cube.getDescription();
        return "Perspective" + (String)(CdStringUtils.isNullOrBlank((String)description) ? "" : " : " + description);
    }

    @Override
    public boolean isFactless() {
        return this.regularCube.isFactless();
    }

    @Override
    public List<IOlapBuilderBaseFactsDef> getCubeFacts() {
        return this.regularCube.getCubeFacts();
    }

    @Override
    public OlapCube getUnderlying() {
        return this;
    }

    @Override
    public OlapRegularCube getRegularCube() {
        return this.regularCube;
    }

    @Override
    public OlapRegularCube getNonEmptyCube() {
        return this.regularCube.getNonEmptyCube();
    }

    @Override
    @Nullable
    public OlapSubSelectTupleFilter getSubSelectTupleFilter() {
        return this.regularCube.getSubSelectTupleFilter();
    }

    @Override
    public OlapCubeCalculatedMemberManager getCalcMemberManager() {
        return this.regularCube.getCalcMemberManager();
    }

    @Override
    public List<OlapMember> getCalcMembers() {
        return this.regularCube.getCalcMembers();
    }

    @Override
    public OlapFactMeasureGroupBaseManager getFactManager(String measureGroupName) {
        return this.regularCube.getFactManager(measureGroupName);
    }

    @Override
    public OlapFactCubeManager getCubeFactManager() {
        return this.regularCube.getCubeFactManager();
    }

    @Override
    public OlapFactCubeManager getNullableCubeFactManager() {
        return this.regularCube.getCubeFactManager();
    }

    @Override
    @NotNull
    public OlapPerspective getPerspective() {
        return this.perspective;
    }

    @Override
    public Date getLastDataUpdatedTime() {
        return this.regularCube.getLastDataUpdatedTime();
    }

    @Override
    public OlapCube getClusterCube() {
        return this.regularCube.getClusterCube();
    }
}

