/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.cube;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubeFullControlPermissions;
import crazydev.iccube.authorizationx.permissions.cube.OlapRoleCubePermissions;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionMeta;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaReference;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.olap.util.OlapNameIdentifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OlapCube
implements OlapNameIdentifiable {
    private final OlapSchemaReference schemaReference;
    private final String name;
    @Nullable
    private final String description;
    private final OlapRoleCubeFullControlPermissions fullControlPermissions;
    private List<OlapDimension> dimensions = new ArrayList<OlapDimension>();
    private OlapMeasuresDimension measuresDimension;

    protected OlapCube(OlapSchema schema, String name, @Nullable String description) {
        this(new OlapSchemaReference(schema), name, description);
    }

    protected OlapCube(OlapSchemaReference schemaReference, String name, @Nullable String description) {
        this.schemaReference = schemaReference;
        this.name = name;
        this.description = description;
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new CdRuntimeException("Missing cube name!");
        }
        this.fullControlPermissions = new OlapRoleCubeFullControlPermissions(this);
        OlapSchema schema = schemaReference.getSchema();
        for (OlapDimension dimension : schema.getDimensions()) {
            this.addDimension(dimension);
        }
    }

    public boolean isPerspective() {
        return false;
    }

    public static OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, @Nullable List<OlapHierarchy> requestHierarchies, @Nullable List<OlapHierarchy> sessionHierarchies, List<OlapDimension> myDimensions, List<OlapDimension> allDimensions, OlapEntityIdentifier id) {
        OlapNonScalarEntity entity = null;
        if (requestHierarchies != null && !requestHierarchies.isEmpty()) {
            entity = OlapCube.doLookupEntityByMdxIdentifier(nameContext, permissions, requestHierarchies, myDimensions, allDimensions, id);
        }
        if (entity == null && sessionHierarchies != null && !sessionHierarchies.isEmpty()) {
            entity = OlapCube.doLookupEntityByMdxIdentifier(nameContext, permissions, sessionHierarchies, myDimensions, allDimensions, id);
        }
        if (entity == null) {
            entity = OlapCube.doLookupEntityByMdxIdentifier(nameContext, permissions, null, myDimensions, allDimensions, id);
        }
        return entity != null ? entity : OlapNullEntity.INSTANCE;
    }

    @Nullable
    private static OlapNonScalarEntity doLookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, @Nullable List<OlapHierarchy> extraHierarchies, List<OlapDimension> myDimensions, List<OlapDimension> allDimensions, OlapEntityIdentifier id) {
        OlapNonScalarEntity entity;
        OlapDimension dimension;
        int idx;
        OlapEntityIdentifierPart dimensionId = id.getPart(0);
        int dimensionsSize = allDimensions.size();
        for (idx = 0; idx < dimensionsSize; ++idx) {
            dimension = allDimensions.get(idx);
            if (!dimensionId.isIdentifying(nameContext, dimension)) continue;
            if (id.getPartCount() == 1) {
                return dimension;
            }
            OlapEntityIdentifier next = id.subIdentifier(1);
            return dimension.lookupEntityByMdxIdentifier(nameContext, permissions, extraHierarchies, next);
        }
        for (idx = 0; idx < dimensionsSize; ++idx) {
            dimension = allDimensions.get(idx);
            if (!myDimensions.contains(dimension) || (entity = dimension.lookupEntityByMdxIdentifier(nameContext, permissions, extraHierarchies, id)).isMdxNull()) continue;
            return entity;
        }
        for (idx = 0; idx < dimensionsSize; ++idx) {
            dimension = allDimensions.get(idx);
            if (myDimensions.contains(dimension) || (entity = dimension.lookupEntityByMdxIdentifier(nameContext, permissions, extraHierarchies, id)).isMdxNull()) continue;
            return entity;
        }
        return null;
    }

    public void resetForSchema(OlapSchema schema, int nextDimensionIndexOffset, int nextHierarchyIndexOffset, int nextPartitionIndexOffset) {
        this.schemaReference.resetForSchema(schema);
        if (this.measuresDimension == null) {
            throw new RuntimeException("internal error: missing [Measures] dimension");
        }
        this.measuresDimension.resetForSchema(schema, nextDimensionIndexOffset, nextHierarchyIndexOffset);
    }

    public String getSchemaName() {
        return this.getSchema().getName();
    }

    public OlapSchema getSchema() {
        return this.schemaReference.getSchema();
    }

    public OlapSchemaReference getSchemaReference() {
        return this.schemaReference;
    }

    public OlapRoleCubePermissions getFullControlPermissions() {
        return this.fullControlPermissions;
    }

    public abstract boolean isFactless();

    public abstract List<IOlapBuilderBaseFactsDef> getCubeFacts();

    public boolean isOwnDimension(OlapDimension dimension) {
        OlapFactCubeManager fm = this.getNullableCubeFactManager();
        if (fm == null) {
            return this.dimensions.contains(dimension);
        }
        return fm.containsDimension(dimension);
    }

    public boolean isOwnDimension(OlapDimension dimension, String measureGroupName) {
        OlapFactCubeManager fm = this.getNullableCubeFactManager();
        if (fm == null) {
            return false;
        }
        return fm.containsDimension(dimension, measureGroupName);
    }

    protected void addDimension(OlapDimension dimension) {
        this.dimensions.add(dimension);
        if (dimension instanceof OlapMeasuresDimension) {
            this.measuresDimension = (OlapMeasuresDimension)dimension;
        }
    }

    @Override
    public String getName(OlapNameContext nameContext) {
        return this.name;
    }

    public String getNameX() {
        return this.getName(OlapNameContext.DEFAULT_VALUES);
    }

    @Override
    public String getUniqueName(OlapNameContext nameContext) {
        return "[" + CdMdxUtils.escape((String)this.getName(nameContext)) + "]";
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public String getCaption(Locale locale, OlapNameContext nameContext) {
        OlapSchema schema = this.schemaReference.getSchema();
        OlapSchemaLocalization localization = schema.getLocalization();
        String caption = localization.getCubeCaption(locale, this);
        if (CdStringUtils.isNullOrBlank((String)caption)) {
            caption = this.getName(nameContext);
        }
        return caption;
    }

    public abstract OlapCube getUnderlying();

    public abstract OlapRegularCube getRegularCube();

    public abstract OlapRegularCube getNonEmptyCube();

    @Nullable
    public abstract OlapSubSelectTupleFilter getSubSelectTupleFilter();

    public abstract OlapCubeCalculatedMemberManager getCalcMemberManager();

    public abstract List<OlapMember> getCalcMembers();

    public List<OlapDimension> getDimensions() {
        return this.dimensions;
    }

    public List<OlapDimension> getDimensions(IOlapDimensionsPermission permissions) {
        ArrayList<OlapDimension> authorized = new ArrayList<OlapDimension>();
        for (OlapDimension dimension : this.getDimensions()) {
            if (!dimension.isMeasures() && !permissions.isDimensionAuthorized(dimension)) continue;
            authorized.add(dimension);
        }
        return authorized;
    }

    public List<OlapDimension> getOwnDimensions(IOlapDimensionsPermission permissions) {
        List<OlapDimension> dimensions = this.getOwnDimensionsWithoutMeasures(permissions);
        dimensions.add(this.measuresDimension);
        return dimensions;
    }

    public List<OlapDimension> getOwnDimensionsWithoutMeasures(IOlapDimensionsPermission permissions, String measureGroupName) {
        ArrayList<OlapDimension> authorized = new ArrayList<OlapDimension>();
        for (OlapDimension dimension : this.getDimensions()) {
            if (dimension.isMeasures() || !permissions.isDimensionAuthorized(dimension) || dimension.isFactIndexing() && !dimension.isAlwaysVisibleReporting() && !this.isOwnDimension(dimension, measureGroupName)) continue;
            authorized.add(dimension);
        }
        return authorized;
    }

    public List<OlapDimensionMeta> getDimensionsMeta(Locale locale, IOlapCubePermission cPerms, IOlapDimensionsPermission dPerms) {
        ArrayList<OlapDimensionMeta> meta = new ArrayList<OlapDimensionMeta>();
        for (OlapDimension dimension : this.getDimensions()) {
            if (dimension.isMeasures() || !dPerms.isDimensionAuthorized(dimension)) continue;
            List<String> measureGroupNames = this.getDimensionMeasureGroupNames(cPerms, dimension);
            List<String> measureGroupCaptions = this.getDimensionMeasureGroupCaptions(locale, cPerms, dimension);
            meta.add(new OlapDimensionMeta(dimension, measureGroupNames, measureGroupCaptions));
        }
        return meta;
    }

    private List<String> getDimensionMeasureGroupNames(IOlapCubePermission cPerms, OlapDimension dimension) {
        OlapFactCubeManager fm = this.getNullableCubeFactManager();
        if (fm != null) {
            List<String> measureGroups = fm.getMeasureGroupNames(cPerms, dimension);
            return measureGroups;
        }
        return Collections.emptyList();
    }

    private List<String> getDimensionMeasureGroupCaptions(Locale locale, IOlapCubePermission cPerms, OlapDimension dimension) {
        OlapFactCubeManager fm = this.getNullableCubeFactManager();
        if (fm != null) {
            List<String> measureGroups = fm.getMeasureGroupCaptions(locale, cPerms, dimension);
            return measureGroups;
        }
        return Collections.emptyList();
    }

    public List<OlapDimension> getOwnDimensionsWithoutMeasures(IOlapDimensionsPermission permissions) {
        ArrayList<OlapDimension> authorized = new ArrayList<OlapDimension>();
        for (OlapDimension dimension : this.getDimensions()) {
            if (dimension.isMeasures() || !permissions.isDimensionAuthorized(dimension) || dimension.isFactIndexing() && !dimension.isAlwaysVisibleReporting() && !this.isOwnDimension(dimension)) continue;
            authorized.add(dimension);
        }
        return authorized;
    }

    @Nullable
    public OlapHierarchy getDefaultTimeHierarchy(IOlapDimensionsPermission permissions) {
        List<OlapDimension> allDimensions = this.getDimensions(permissions);
        for (OlapDimension dimension : allDimensions) {
            if (!dimension.isDefaultTimeDimension()) continue;
            return dimension.getDefaultTimeHierarchy(permissions);
        }
        return null;
    }

    public OlapMeasuresDimension getMeasuresDimension() {
        if (this.measuresDimension == null) {
            throw new CdProgrammingException("Dimension [Measures] not found in cube [" + ONames.name4Log(this) + "]");
        }
        return this.measuresDimension;
    }

    public int getHierarchyCount(IOlapDimensionsPermission permissions) {
        int count = 0;
        List<OlapDimension> allDimensions = this.getDimensions(permissions);
        for (int idx = 0; idx < allDimensions.size(); ++idx) {
            OlapDimension dimension = allDimensions.get(idx);
            count += dimension.getHierarchyCount(permissions);
        }
        return count;
    }

    public int getDimensionOrdinal(OlapDimension dimension) {
        List<OlapDimension> allDimensions = this.getDimensions();
        for (int idx = 0; idx < allDimensions.size(); ++idx) {
            if (allDimensions.get(idx) != dimension) continue;
            return idx;
        }
        throw new CdProgrammingException("Dimension [" + String.valueOf(dimension) + "] no found in cube [" + ONames.name4Log(this) + "]");
    }

    public abstract OlapFactMeasureGroupBaseManager getFactManager(String var1);

    public abstract OlapFactCubeManager getCubeFactManager();

    @Nullable
    public abstract OlapFactCubeManager getNullableCubeFactManager();

    public OlapNonScalarEntity lookupEntityByMdxIdentifier(OlapNameContext nameContext, IOlapDimensionsPermission permissions, @Nullable List<OlapHierarchy> requestHierarchies, @Nullable List<OlapHierarchy> sessionHierarchies, OlapEntityIdentifier id) {
        if (id.getPartCount() == 0) {
            return OlapNullEntity.INSTANCE;
        }
        List<OlapDimension> myDimensions = this.getOwnDimensions(permissions);
        List<OlapDimension> allDimensions = this.getDimensions(permissions);
        return OlapCube.lookupEntityByMdxIdentifier(nameContext, permissions, requestHierarchies, sessionHierarchies, myDimensions, allDimensions, id);
    }

    public boolean isDimensionOrHierarchyPrefix(IOlapDimensionsPermission permissions, OlapNameContext nameContext, OlapEntityIdentifier id) {
        OlapDimension dimension;
        int idx;
        if (id.getPartCount() == 0) {
            return false;
        }
        OlapEntityIdentifierPart firstPart = id.getPart(0);
        List<OlapDimension> dimensions = this.getDimensions(permissions);
        int dimensionsSize = dimensions.size();
        for (idx = 0; idx < dimensionsSize; ++idx) {
            dimension = dimensions.get(idx);
            if (!firstPart.isIdentifying(nameContext, dimension)) continue;
            return true;
        }
        for (idx = 0; idx < dimensionsSize; ++idx) {
            dimension = dimensions.get(idx);
            List<OlapHierarchy> allHierarchies = dimension.getHierarchies(permissions);
            for (OlapHierarchy hierarchy : allHierarchies) {
                if (!firstPart.isIdentifying(nameContext, hierarchy)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public OlapMeasureMember lookupMeasureByName(OlapNameContext nameContext, String name) {
        return this.getMeasuresDimension().unfilteredLookupMeasureByName(nameContext, name);
    }

    @Nullable
    public OlapDimension lookupDimensionByName(OlapNameContext nameContext, String name) {
        List<OlapDimension> allDimensions = this.getDimensions();
        for (int idx = 0; idx < allDimensions.size(); ++idx) {
            OlapDimension dimension = allDimensions.get(idx);
            if (!OlapCaseInsensitiveName.equals(dimension.getName(nameContext), name)) continue;
            return dimension;
        }
        return null;
    }

    public OlapNonScalarEntity lookupHierarchyByPosition(IOlapDimensionsPermission permissions, int position) {
        int pos = 1;
        List<OlapDimension> allDimensions = this.getDimensions(permissions);
        for (int idx = 0; idx < allDimensions.size(); ++idx) {
            OlapDimension dimension = allDimensions.get(idx);
            if (position == 0) {
                if (!dimension.isMeasures()) continue;
                return dimension.getMeasureHierarchy();
            }
            if (dimension.isMeasures()) continue;
            List<OlapHierarchy> allHierarchies = dimension.getHierarchies(permissions);
            for (OlapHierarchy hierarchy : allHierarchies) {
                if (pos == position) {
                    return hierarchy;
                }
                ++pos;
            }
        }
        return OlapNullEntity.INSTANCE;
    }

    @Nullable
    public OlapHierarchy lookupHierarchyByTupleDimensionalityIndex(IOlapDimensionsPermission permissions, int index) {
        for (OlapDimension dimension : this.getDimensions()) {
            if (!permissions.isDimensionAuthorized(dimension)) continue;
            IOlapDimensionPermission dimensionPermissions = permissions.getDimensionPermissions(dimension);
            for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                if (!dimensionPermissions.isHierarchyAuthorized(hierarchy) || hierarchy.getTupleDimensionalityIndex() != index) continue;
                return hierarchy;
            }
        }
        return null;
    }

    public List<OlapMeasureMember> getMeasuresMembers(IOlapSchemaPermission permissions, String measureGroupName) {
        IOlapCubePermission cubePermissions = permissions.getCubePermissions(this);
        if (!cubePermissions.isMeasureGroupAuthorized(measureGroupName)) {
            return Collections.emptyList();
        }
        ArrayList<OlapMeasureMember> measures = new ArrayList<OlapMeasureMember>();
        IOlapDimensionsPermission dimPermissions = permissions.getDimensionsPermissions(this);
        List<OlapMeasureMember> authorizedMeasures = this.getMeasuresDimension().getMeasureMembers(dimPermissions.getMemberFilter());
        for (OlapMeasureMember authorizedMeasure : authorizedMeasures) {
            if (!OlapCaseInsensitiveName.equals(measureGroupName, authorizedMeasure.getMeasureGroupName())) continue;
            measures.add(authorizedMeasure);
        }
        return measures;
    }

    public List<OlapMeasureMember> getMeasuresMembers(String measureGroupName) {
        ArrayList<OlapMeasureMember> measures = new ArrayList<OlapMeasureMember>();
        for (OlapMeasureMember measure : this.getMeasuresDimension().getMeasureMembers(null)) {
            if (!OlapCaseInsensitiveName.equals(measureGroupName, measure.getMeasureGroupName())) continue;
            measures.add(measure);
        }
        return measures;
    }

    public Set<String> getMeasureGroupNames(@Nullable IOlapCubePermission perms) {
        HashSet<String> measureGroupNames = new HashSet<String>();
        List<OlapMeasureMember> measures = this.getMeasuresDimension().getMeasureMembers(null);
        for (OlapMeasureMember measure : measures) {
            String group = measure.getMeasureGroupName();
            if (perms != null && !perms.isMeasureGroupAuthorized(group)) continue;
            measureGroupNames.add(measure.getMeasureGroupName());
        }
        return measureGroupNames;
    }

    public List<OlapDimension> getIndexingDimensions() {
        OlapCube underlying = this.getUnderlying();
        if (underlying.isFactless()) {
            List<OlapDimension> dimensions = this.getSchema().getDimensions();
            return dimensions;
        }
        OlapFactCubeManager factManager = this.getCubeFactManager();
        return factManager.getIndexingDimensions();
    }

    @Nullable
    public Collection<OlapDimension> getIndexingDimensions(String measureName) {
        OlapFactCubeManager factManager = this.getCubeFactManager();
        return factManager.getIndexingDimensions(measureName);
    }

    public String toString() {
        return ONames.name4Log(this);
    }

    @Nullable
    public OlapPerspective getPerspective() {
        return null;
    }

    public Date getLastDataUpdatedTime() {
        return new Date();
    }

    public boolean hasPerspective() {
        OlapSchema schema = this.schemaReference.getSchema();
        return schema.getDefaultPerspective() != null || this.getPerspective() != null;
    }

    public OlapCube getClusterCube() {
        OlapCube cube = this.getUnderlying();
        if (cube == this) {
            return cube;
        }
        return cube.getClusterCube();
    }

    public List<OlapUserMeasureMember> getUserMeasures(@Nullable OlapMemberFilter filter) {
        OlapCubeCalculatedMemberManager manager = this.getCalcMemberManager();
        return manager.lookupUserMeasures(filter);
    }
}

