/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.schemas;

import crazydev.common.collection.CdTruncatedList;
import crazydev.common.exception.CdError;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.type.SchemaGarbageCollectorType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.common.OlapListenerList;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaDataUpdatedListener;
import crazydev.iccube.olap.component.schemas.IOlapEngineSchemaLifeCycleListener;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingLock;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapCubeInfo;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDataUpdate;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.OlapSchemaInformationEx;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStatsStatus;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Strings;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapEngineSchemaManager {
    private static final AtomicLong uuid = new AtomicLong(0L);
    @Nullable
    private final OlapTenant tenant;
    private final String tenantInfo;
    private final OlapFileCleaner cleaner;
    private final Map<String, OlapSchema> schemas = new HashMap<String, OlapSchema>();
    private final Map<String, OlapSchemaLoadingLock> loadingSchemas = new HashMap<String, OlapSchemaLoadingLock>();
    private final OlapListenerList listenerList = new OlapListenerList();
    private final OlapListenerList listenerListDataUpdated = new OlapListenerList();

    public OlapEngineSchemaManager(@Nullable OlapTenant tenant, @Nullable OlapListenerList listeners, OlapFileCleaner cleaner) {
        this.tenant = tenant;
        this.tenantInfo = OlapTenant.info(tenant);
        this.listenerList.initFrom(listeners);
        this.cleaner = cleaner;
    }

    public void addSchemaLifeCycleListener(IOlapEngineSchemaLifeCycleListener listener) {
        this.listenerList.add(IOlapEngineSchemaLifeCycleListener.class, listener);
    }

    public void removeSchemaLifeCycleListener(IOlapEngineSchemaLifeCycleListener listener) {
        this.listenerList.remove(IOlapEngineSchemaLifeCycleListener.class, listener);
    }

    public void addSchemaDataUpdatedListener(IOlapEngineSchemaDataUpdatedListener listener) {
        this.listenerListDataUpdated.add(IOlapEngineSchemaDataUpdatedListener.class, listener);
    }

    public void removeSchemaDataUpdatedListener(IOlapEngineSchemaDataUpdatedListener listener) {
        this.listenerListDataUpdated.remove(IOlapEngineSchemaDataUpdatedListener.class, listener);
    }

    public long getUuid() {
        return uuid.get();
    }

    private void onChanged() {
        uuid.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSchemaInformationEx> listSchemaEx() {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            ArrayList<OlapSchemaInformationEx> infos = new ArrayList<OlapSchemaInformationEx>();
            for (OlapSchema olapSchema : this.schemas.values()) {
                infos.add(new OlapSchemaInformationEx(OlapSchemaInformationEx.Status.LOADED, olapSchema.getInformation()));
            }
            for (OlapSchemaLoadingLock olapSchemaLoadingLock : this.loadingSchemas.values()) {
                infos.add(new OlapSchemaInformationEx(OlapSchemaInformationEx.Status.LOADING, olapSchemaLoadingLock.getSchemaInformation()));
            }
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSchemaInformationEx> listSchema(@Nullable String filter) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            ArrayList<OlapSchemaInformationEx> infos = new ArrayList<OlapSchemaInformationEx>();
            for (OlapSchema schema : this.schemas.values()) {
                if (filter != null && !CdStringUtils.isNullOrBlank((String)filter) && !Strings.CI.contains((CharSequence)schema.getName(), (CharSequence)filter)) continue;
                infos.add(new OlapSchemaInformationEx(OlapSchemaInformationEx.Status.LOADED, schema.getInformation()));
            }
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSchemaLoaded(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            return this.schemas.get(schemaName) != null;
        }
    }

    public boolean isSchemaLoaded(File factory) {
        OlapSchemaInformation info = this.getLoadedSchemaInformation(factory);
        return info != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaStats getLoadedSchemaStatistics(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema schema = this.schemas.get(schemaName);
            return schema == null ? null : schema.getStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoadedSchemaCount() {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            return this.schemas.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLoadedSchemaMemory() {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            double ram = 0.0;
            for (OlapSchema schema : this.schemas.values()) {
                OlapSchemaStats stats = schema.getStats();
                if (stats == null || stats.getStatus() == OlapSchemaStatsStatus.NOT_AVAILABLE) continue;
                ram += (double)stats.getTotalRamSize();
            }
            return ram;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSchemaInformation> getAllLoadedSchemaInformation(@Nullable String filter) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            ArrayList<OlapSchemaInformation> infos = new ArrayList<OlapSchemaInformation>();
            for (OlapSchema schema : this.schemas.values()) {
                if (filter != null && !CdStringUtils.isNullOrBlank((String)filter) && !Strings.CI.contains((CharSequence)schema.getName(), (CharSequence)filter)) continue;
                infos.add(schema.getInformation());
            }
            return infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSchemaInformation> getAllLoadingSchemaInformation(boolean ignoredRestoring) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            ArrayList<OlapSchemaInformation> infos = new ArrayList<OlapSchemaInformation>();
            for (OlapSchemaLoadingLock schema : this.loadingSchemas.values()) {
                OlapSchemaInformation schemaInformation = schema.getSchemaInformation();
                if (ignoredRestoring && schemaInformation.getRestoredBackupTimestamp() != null) continue;
                infos.add(schema.getSchemaInformation());
            }
            return infos;
        }
    }

    @Nullable
    public String getLoadedSchemaName(File schemaFactoryFile) {
        OlapSchemaInformation info = this.getLoadedSchemaInformation(schemaFactoryFile);
        return info == null ? null : info.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IOlapBuilderSchemaDefFactory getLoadedSchemaFactory(String schema) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema loadedSchema = this.schemas.get(schema);
            return loadedSchema != null ? loadedSchema.getDefinitionFactory() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaInformation getLoadingSchemaInformation(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchemaLoadingLock loadingSchema = this.loadingSchemas.get(schemaName);
            if (loadingSchema != null) {
                return loadingSchema.getSchemaInformation();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaInformation getLoadedSchemaInformation(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema loadedSchema = this.schemas.get(schemaName);
            if (loadedSchema != null) {
                return loadedSchema.getInformation();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaInformation getLoadedSchemaInformation(File schemaFactoryFile) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            for (OlapSchema schema : this.schemas.values()) {
                File xmlFile = schema.getDefinitionFactory().getXmlFile();
                if (!schemaFactoryFile.equals(xmlFile)) continue;
                return schema.getInformation();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaInformation getLoadingSchemaInformation(File schemaFactoryFile) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            for (OlapSchemaLoadingLock schema : this.loadingSchemas.values()) {
                OlapSchemaInformation schemaInfo = schema.getSchemaInformation();
                if (!schemaInfo.getFactoryFile().equals(schemaFactoryFile)) continue;
                return schemaInfo;
            }
            return null;
        }
    }

    public OlapSchemaInformationForTests getLoadingSchemaInformationForTests(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema schema = this.schemas.get(schemaName);
            if (schema != null) {
                return schema.getInformationForPerformanceTests();
            }
            throw new RuntimeException("missing schema: " + schemaName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<? extends CdError>> getLoadedSchemaPermsErrors(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            for (OlapSchema schema : this.schemas.values()) {
                if (!schema.getName().equals(schemaName)) continue;
                return schema.getPermsErrors();
            }
            return Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getOfflineSnapshot(File schemaFactoryFile) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            for (OlapSchema olapSchema : this.schemas.values()) {
                if (!schemaFactoryFile.equals(olapSchema.getDefinitionFactory().getXmlFile())) continue;
                return olapSchema.getOfflineSnapshot();
            }
            for (OlapSchemaLoadingLock olapSchemaLoadingLock : this.loadingSchemas.values()) {
                OlapSchemaInformation schemaInformation = olapSchemaLoadingLock.getSchemaInformation();
                if (!schemaFactoryFile.equals(schemaInformation.getFactoryFile())) continue;
                return schemaInformation.getOfflineSnapshot();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSchemaLoading(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            return schemaName != null && this.loadingSchemas.containsKey(schemaName);
        }
    }

    public boolean isSchemaLoading(File factory) {
        OlapSchemaInformation info = this.getLoadingSchemaInformation(factory);
        return info != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getSchemaLoadRequestUuid(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            if (schemaName == null) {
                return null;
            }
            OlapSchemaLoadingLock info = this.loadingSchemas.get(schemaName);
            if (info != null) {
                return info.getSchemaInformation().getRequestUuid();
            }
            OlapSchema loadedSchema = this.schemas.get(schemaName);
            if (loadedSchema != null) {
                return loadedSchema.getInformation().getRequestUuid();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getSchemaLoadingRequestUuid(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            if (schemaName == null) {
                return null;
            }
            OlapSchemaLoadingLock info = this.loadingSchemas.get(schemaName);
            if (info != null) {
                return info.getSchemaInformation().getRequestUuid();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSchemaLoadingLock onSchemaLoadingStarted(OlapEngineRequestContext requestContext, OlapSchemaInformation schemaInformation) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            if (this.loadingSchemas.containsKey(schemaInformation.getName())) {
                return new OlapSchemaLoadingLock(schemaInformation, -1);
            }
            requestContext.setLoadingSchemaInformation(schemaInformation);
            OlapSchemaLoadingLock lock = new OlapSchemaLoadingLock(schemaInformation, 0);
            this.loadingSchemas.put(schemaInformation.getName(), lock);
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSchemaLoadingDone(OlapEngineRequestContext requestContext, OlapSchemaLoadingLock lock) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            String schema = lock.getSchemaInformation().getName();
            OlapSchemaLoadingLock acquiredLock = this.loadingSchemas.get(schema);
            if (acquiredLock == lock) {
                Logger logger;
                OlapSchemaInformation loadedSchemaInformation;
                this.loadingSchemas.remove(schema);
                OlapSchemaInformation info = acquiredLock.getSchemaInformation();
                info.onSchemaLoaded();
                OlapSchema loadedSchema = this.schemas.get(schema);
                if (loadedSchema != null && (loadedSchemaInformation = loadedSchema.getInformation()) != info) {
                    loadedSchemaInformation.onSchemaLoaded(info);
                }
                if ((logger = requestContext.getLoggers().schema()).isInfoEnabled()) {
                    String timing = CdTimeUtils.format((Date)info.getRefreshTimeStart(), (Date)info.getRefreshTimeEnd());
                    logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + info.getName() + "] loaded in [" + timing + "]"));
                    OlapLoggers.CHECKPOINTS.info((Object)"[ic3] schema loaded [%s] in [%s] [tenant:%s]".formatted(info.getName(), timing, this.tenantInfo));
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSchemaStartedPhaseI(OlapEngineRequestContext requestContext, OlapSchema schema, String command) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            this.fireSchemaStartedPhaseI(requestContext, schema, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSchemaStartedPhaseII(OlapEngineRequestContext requestContext, OlapSchema schema, String command) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            this.fireSchemaStartedPhaseII(requestContext, schema, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchema(OlapEngineRequestContext requestContext, OlapSchema schema) {
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, schema.getName());
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger;
            String schemaName = schema.getName();
            OlapSchema prev = this.schemas.put(schemaName, schema);
            if (prev != null) {
                this.fireSchemaUnloaded(requestContext, prev);
            }
            if ((logger = requestContext.getLoggers().schema()).isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] successfully added" + (prev == null ? "" : " (replaced)") + "."));
            }
            this.fireSchemaLoaded(requestContext, schema);
            this.onChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrLoadSchema(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, schema.getName());
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] successfully incr. loaded"));
            }
            this.fireSchemaIncrLoaded(requestContext, schema, incrLoadInfo);
        }
        this.fireSchemaDataUpdated(schema.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrLoadSchemaOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, schema.getName());
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] incr. loaded on-error"));
            }
            this.fireSchemaIncrLoadedOnError(requestContext, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSchemaOnError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] loaded on-error"));
            }
            this.fireSchemaLoadedOnError(requestContext, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSchemaOnErrorCleanup(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] loaded on-error cleanup"));
            }
            this.fireSchemaLoadedOnErrorCleanup(requestContext, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSchemaDone(OlapEngineRequestContext requestContext, OlapSchema schema) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] loaded done"));
            }
            this.fireSchemaLoadedDone(requestContext, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scriptStatementApplied(OlapEngineRequestContext requestContext, OlapSchema schema, OlapScriptInformation information) {
        if (requestContext.isScriptStatementAppliedDeactivated()) {
            return;
        }
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, schema.getName());
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] script applied"));
            }
            this.fireSchemaScriptStatementApplied(requestContext, schema, information);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadSchema(OlapEngineRequestContext requestContext, String name) {
        boolean status;
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, name);
        SchemaGarbageCollectorType callGC = SchemaGarbageCollectorType.NONE;
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema schema;
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " unloading schema [" + name + "]"));
            }
            if ((schema = this.schemas.remove(name)) != null) {
                callGC = schema.getCallGC();
                this.fireSchemaUnloaded(requestContext, schema);
                this.onChanged();
            }
            status = schema != null;
        }
        if (status && callGC == SchemaGarbageCollectorType.ACTIVE) {
            long ms = 1000L;
            CdSystemUtils.callGC((long)1000L);
            M_LocalCluster cluster = requestContext.getCluster();
            N_OlapEngine engine = cluster.getEngine();
            engine.callGC(1000L);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadPartitions(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, schema.getName());
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] successfully unloaded partitions"));
            }
            this.fireSchemaPartitionsUnloaded(requestContext, schema, unloadPartitionsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPartitions(OlapEngineRequestContext requestContext, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, schema.getName());
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] successfully (re)loaded partitions"));
            }
            this.fireSchemaPartitionsLoaded(requestContext, schema, loadPartitionsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPartitionsError(OlapEngineRequestContext requestContext, OlapSchema schema) {
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.WRITE, schema.getName());
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            Logger logger = requestContext.getLoggers().schema();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[schema]" + this.tenantInfo + " schema [" + schema.getName() + "] (re)load partitions error"));
            }
            this.fireSchemaPartitionsLoadError(requestContext, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpSchemaIndex(OlapEngineRequestContext requestContext, String name) throws IOException {
        OlapSchema schema;
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.READ, name);
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(name);
        }
        if (schema != null) {
            return schema.dumpFactsIndex(requestContext);
        }
        throw new IOException("Missing schema : " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaStats refreshSchemaStatistics(OlapEngineRequestContext requestContext, String name) {
        OlapSchema schema;
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.READ, name);
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(name);
        }
        if (schema != null) {
            return schema.refreshStats(requestContext.getRequestStatusManager());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSchemaPartitionInformation> listSchemaPartitions(OlapEngineRequestContext requestContext, String schemaName) {
        OlapSchema schema;
        requestContext.assertSchemaAccessLock(IcCubeSchemaAccessLockMode.READ, schemaName);
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaName);
        }
        if (schema != null) {
            return schema.listPartitions();
        }
        return new ArrayList<OlapSchemaPartitionInformation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaDataUpdate getSchemaNullableLastDataUpdate(OlapEngineRequestContext requestContext, String schemaName) {
        OlapSchema schema;
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaName);
        }
        if (schema != null) {
            OlapRoleApplicationPermissions applicationPermissions = requestContext.getApplicationPermissions();
            IOlapSchemasPermission permissions = requestContext.getSchemasPermissions();
            if (permissions.isSchemaAuthorized(applicationPermissions, schema)) {
                Date schemaLastRefreshTimestamp = schema.getNullableLastRefreshTime();
                Date schemaLastDataUpdateTimestamp = schema.getNullableLastDataUpdatedTime();
                if (schemaLastRefreshTimestamp != null && schemaLastDataUpdateTimestamp != null) {
                    String schemaLastRefreshTime_ISO_8601 = CdTimeUtils.formatServerTimeForJavascript((Date)schemaLastRefreshTimestamp);
                    String schemaLastDataUpdateTime_ISO_8601 = CdTimeUtils.formatServerTimeForJavascript((Date)schemaLastDataUpdateTimestamp);
                    return new OlapSchemaDataUpdate(schemaLastRefreshTimestamp, schemaLastRefreshTime_ISO_8601, schemaLastDataUpdateTimestamp, schemaLastDataUpdateTime_ISO_8601);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSchemaLastDataUpdatedTime(OlapEngineRequestContext requestContext, String schemaName) {
        OlapSchema schema;
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            schema = this.schemas.get(schemaName);
        }
        if (schema != null) {
            OlapRoleApplicationPermissions applicationPermissions = requestContext.getApplicationPermissions();
            IOlapSchemasPermission permissions = requestContext.getSchemasPermissions();
            if (permissions.isSchemaAuthorized(applicationPermissions, schema)) {
                long timestamp = schema.getLastDataUpdatedTimeX();
                return timestamp;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSchema> getAllAuthorizedSchemas(OlapEngineRequestContext requestContext, IcCubeSchemaAccessLockMode mode) {
        requestContext.assertAllSchemaAccessLock(mode);
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapRoleApplicationPermissions applicationPermissions = requestContext.getApplicationPermissions();
            IOlapSchemasPermission permissions = requestContext.getSchemasPermissions();
            return this.getAllSchemas(applicationPermissions, permissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchema getAuthorizedSchema(OlapEngineRequestContext requestContext, @Nullable IOlapSchemasPermission permissions, IcCubeSchemaAccessLockMode mode, String name) {
        if (name == null) {
            return null;
        }
        requestContext.assertSchemaAccessLock(mode, name);
        if ("ic3_Fake_Schema".equals(name)) {
            OlapEngineApplicationContext applicationContext = requestContext.getApplicationContext();
            OlapSchema schema = applicationContext.getSchemaForMdxWithNoSchema();
            return schema;
        }
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapRoleApplicationPermissions applicationPermissions = requestContext.getApplicationPermissions();
            IOlapSchemasPermission schemasPermissions = permissions == null ? requestContext.getSchemasPermissions() : permissions;
            List<OlapSchema> allSchemas = this.getAllSchemas(applicationPermissions, schemasPermissions);
            for (int ii = 0; ii < allSchemas.size(); ++ii) {
                OlapSchema schema = allSchemas.get(ii);
                if (!schema.getName().equals(name)) continue;
                return schema;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OlapSchema> getAllSchemas(OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            ArrayList<OlapSchema> authorizedSchemas = new ArrayList<OlapSchema>();
            for (OlapSchema schema : this.schemas.values()) {
                if (permissions != null && !permissions.isSchemaAuthorized(applicationPermissions, schema)) continue;
                authorizedSchemas.add(schema);
            }
            return authorizedSchemas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CdTruncatedList<OlapSchema> getAllSchemas(OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, int limit, @Nullable String query) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            CdTruncatedList authorizedSchemas = new CdTruncatedList();
            int truncatedCount = 0;
            for (OlapSchema schema : this.schemas.values()) {
                String filter;
                if (permissions != null && !permissions.isSchemaAuthorized(applicationPermissions, schema)) continue;
                String schemaName = schema.getName().toLowerCase();
                String string = filter = query != null ? query.trim().toLowerCase() : null;
                if (filter != null && !filter.isEmpty() && !schemaName.contains(filter)) continue;
                if (authorizedSchemas.size() >= limit) {
                    ++truncatedCount;
                    continue;
                }
                authorizedSchemas.add((Object)schema);
            }
            if (truncatedCount > 0) {
                authorizedSchemas.setMoreSuggestions(true);
                authorizedSchemas.setNumMoreSuggestions(truncatedCount);
            }
            return authorizedSchemas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaFunctionRepositorySnapshot getAuthorizedSchemaFunctionRepositorySnapshot(OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema schema = this.schemas.get(schemaName);
            if (schema != null && permissions.isSchemaAuthorized(applicationPermissions, schema)) {
                return schema.getFunctionRepositorySnapshot();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File getDefinitionFromBackup(String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema schema = this.schemas.get(schemaName);
            if (schema != null && schema.getBackupDir() != null) {
                IOlapBuilderSchemaDefFactory factory = schema.getDefinitionFactory();
                File file = factory.getXmlFile();
                return file;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAuthorizedSchema(OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema schema = this.schemas.get(schemaName);
            return schema != null && permissions.isSchemaAuthorized(applicationPermissions, schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAuthorizedSchemaWithIncrementalActive(OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            OlapSchema schema = this.schemas.get(schemaName);
            return schema != null && permissions.isSchemaAuthorized(applicationPermissions, schema) && schema.isIncrLoadActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllAuthorizedSchemaNames(OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            ArrayList<String> authorizedSchemaNames = new ArrayList<String>();
            for (OlapSchema schema : this.getAllSchemas(applicationPermissions, permissions)) {
                authorizedSchemaNames.add(schema.getName());
            }
            return authorizedSchemaNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdTruncatedList<String> getAllAuthorizedSchemaNames(OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, int limit, @Nullable String query) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            CdTruncatedList authorizedSchemaNames = new CdTruncatedList();
            CdTruncatedList<OlapSchema> allSchemas = this.getAllSchemas(applicationPermissions, permissions, limit, query);
            for (OlapSchema schema : allSchemas) {
                authorizedSchemaNames.add((Object)schema.getName());
            }
            authorizedSchemaNames.setMoreSuggestions(allSchemas.isMoreSuggestions());
            authorizedSchemaNames.setNumMoreSuggestions(allSchemas.getNumMoreSuggestions());
            return authorizedSchemaNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSchemaInfo getAuthorizedSchemaInfo(OlapEngineRequestContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions, String schemaName) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            for (OlapSchema schema : this.getAllSchemas(applicationPermissions, permissions)) {
                if (!schema.getName().equalsIgnoreCase(schemaName)) continue;
                IOlapSchemaPermission schemaPermissions = permissions.getSchemaPermissions(context, schema, true);
                if (schemaPermissions.isError()) break;
                ArrayList<OlapCubeInfo> cubes = new ArrayList<OlapCubeInfo>();
                for (OlapCube cube : schema.getCubes(schemaPermissions)) {
                    cubes.add(new OlapCubeInfo(cube.getNameX(), cube.getNameX()));
                }
                return new OlapSchemaInfo(schemaName, cubes);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSchemaInfo> getAuthorizedSchemaInfos(Locale locale, OlapNameContext nameContext, OlapEngineRequestContext context, OlapRoleApplicationPermissions applicationPermissions, IOlapSchemasPermission permissions) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            ArrayList<OlapSchemaInfo> schemas = new ArrayList<OlapSchemaInfo>();
            for (OlapSchema schema : this.getAllSchemas(applicationPermissions, permissions)) {
                IOlapSchemaPermission schemaPermissions = permissions.getSchemaPermissions(context, schema, true);
                if (schemaPermissions.isError()) continue;
                ArrayList<OlapCubeInfo> cubes = new ArrayList<OlapCubeInfo>();
                for (OlapCube cube : schema.getCubes(schemaPermissions)) {
                    cubes.add(new OlapCubeInfo(cube.getCaption(locale, nameContext), cube.getName(nameContext)));
                }
                schemas.add(new OlapSchemaInfo(schema.getName(), cubes));
            }
            return schemas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeToRealTime() {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            for (OlapSchema schema : this.schemas.values()) {
                schema.upgradeToRealTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemasPermissionsDeleted(List<IOlapSchemasPermission> schemasPermissions) {
        Map<String, OlapSchema> map = this.schemas;
        synchronized (map) {
            for (OlapSchema schema : this.schemas.values()) {
                schema.removePermissions(schemasPermissions);
            }
        }
    }

    private void fireSchemaStartedPhaseI(OlapEngineRequestContext context, OlapSchema schema, String command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaStartedPhaseI(context, schema, command);
        }
    }

    private void fireSchemaStartedPhaseII(OlapEngineRequestContext context, OlapSchema schema, String command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaStartedPhaseII(context, schema, command);
        }
    }

    private void fireSchemaLoaded(OlapEngineRequestContext context, OlapSchema schema) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaLoaded(context, schema);
        }
        this.fireSchemaDataUpdated(schema.getName());
    }

    private void fireSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaIncrLoaded(context, schema, incrLoadInfo);
        }
        this.fireSchemaDataUpdated(schema.getName());
    }

    private void fireSchemaIncrLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaIncrLoadedOnError(context, schema);
        }
    }

    private void fireSchemaLoadedOnError(OlapEngineRequestContext context, OlapSchema schema) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaLoadedOnError(context, schema);
        }
    }

    private void fireSchemaLoadedOnErrorCleanup(OlapEngineRequestContext context, OlapSchema schema) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaLoadedOnErrorCleanup(context, schema);
        }
    }

    private void fireSchemaLoadedDone(OlapEngineRequestContext context, OlapSchema schema) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaLoadedDone(context, schema);
        }
    }

    private void fireSchemaScriptStatementApplied(OlapEngineRequestContext context, OlapSchema schema, OlapScriptInformation information) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaScriptStatementApplied(context, schema, information);
        }
    }

    private void fireSchemaUnloaded(OlapEngineRequestContext context, OlapSchema schema) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaUnloaded(context, schema);
        }
    }

    private void fireSchemaPartitionsUnloaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaPartitionsUnloaded(context, schema, unloadPartitionsInfo);
        }
        this.fireSchemaDataUpdated(schema.getName());
    }

    private void fireSchemaPartitionsLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaPartitionsLoaded(context, schema, loadPartitionsInfo);
        }
        this.fireSchemaDataUpdated(schema.getName());
    }

    private void fireSchemaPartitionsLoadError(OlapEngineRequestContext context, OlapSchema schema) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaLifeCycleListener.class) continue;
            ((IOlapEngineSchemaLifeCycleListener)listeners[ii + 1]).onSchemaPartitionsLoadError(context, schema);
        }
    }

    private void fireSchemaDataUpdated(String schema) {
        Object[] listeners = this.listenerListDataUpdated.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IOlapEngineSchemaDataUpdatedListener.class) continue;
            ((IOlapEngineSchemaDataUpdatedListener)listeners[ii + 1]).onSchemaDataUpdated(schema);
        }
    }
}

