/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.plugins;

import crazydev.common.exception.CdError;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginContainer;
import crazydev.iccube.olap.component.plugins.OlapEnginePluginInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapEngineAllPluginsInfo {
    private final File pluginsDirectory;
    private final List<File> allPluginLocations = new ArrayList<File>();
    private final Map<String, File> allPluginContainers = new HashMap<String, File>();
    private final List<OlapEnginePluginInfo> allPlugins = new ArrayList<OlapEnginePluginInfo>();
    private final List<File> allPluginDependencies = new ArrayList<File>();
    private final Map<File, List<CdError>> allErrors = new HashMap<File, List<CdError>>();
    private String serverRequestUuid;

    public OlapEngineAllPluginsInfo(File pluginsDirectory) {
        this.pluginsDirectory = pluginsDirectory;
    }

    public void clear(String uuid) {
        this.allPluginLocations.clear();
        this.allPluginContainers.clear();
        this.allPlugins.clear();
        this.allPluginDependencies.clear();
        this.allErrors.clear();
        this.serverRequestUuid = uuid;
    }

    public File getPluginsDirectory() {
        return this.pluginsDirectory;
    }

    public String getServerRequestUuid() {
        return this.serverRequestUuid;
    }

    public void addAllPluginsLocations(List<File> pluginLocations) {
        this.allPluginLocations.addAll(pluginLocations);
    }

    public void allPluginContainer(String name, File pluginLocation, OlapConfPluginContainer pluginContainer) {
        this.allPluginContainers.put(name, pluginLocation);
    }

    public void addPluginDependency(File pluginLocation) {
        this.allPluginDependencies.add(pluginLocation);
    }

    public void addPluginLocationErrors(File pluginLocation, List<? extends CdError> errors) {
        List<CdError> pluginErrors = this.allErrors.get(pluginLocation);
        if (pluginErrors == null) {
            pluginErrors = new ArrayList<CdError>();
            this.allErrors.put(pluginLocation, pluginErrors);
        }
        pluginErrors.addAll(errors);
    }

    public void addPlugin(OlapEnginePluginInfo plugin) {
        this.allPlugins.add(plugin);
    }

    public List<OlapEnginePluginInfo> getAllPlugins() {
        return this.allPlugins;
    }

    public List<File> getAllPluginLocations() {
        return this.allPluginLocations;
    }

    @Nullable
    public String getPluginName(File location) {
        for (Map.Entry<String, File> entry : this.allPluginContainers.entrySet()) {
            if (!entry.getValue().equals(location)) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<CdError> getErrors(File location) {
        List<CdError> errors = this.allErrors.get(location);
        return errors != null ? errors : Collections.emptyList();
    }

    public boolean hasErrors(File location) {
        List<CdError> errors = this.getErrors(location);
        return errors != null && !errors.isEmpty();
    }

    @Nullable
    public OlapEnginePluginInfo lookupPlugin(String pluginName) {
        for (OlapEnginePluginInfo plugin : this.allPlugins) {
            if (!plugin.getName().equals(pluginName)) continue;
            return plugin;
        }
        return null;
    }
}

