/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.context;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.xml.CdXmlParametersUtils;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.directories.OlapEngineDirectoriesResolved;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.pub.context.IOlapEngineApplicationContext;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.runtime.OlapRuntime;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OlapRuntimeContext {
    private final IOlapEngineApplicationContext appContext;
    private final OlapDirectoriesResolved directories;
    private final OlapFileSystem rootFileSystem;

    private OlapRuntimeContext(IOlapEngineApplicationContext appContext, OlapRuntime runtime, @Nullable File fileSystemRoot, OlapDirectories directories, @Nullable OlapTenant tenant) {
        this.appContext = appContext;
        OlapDirectoriesResolved rootDirectories = OlapDirectoriesResolved.create(directories);
        if (tenant != null) {
            try {
                this.directories = rootDirectories.create(tenant);
            }
            catch (OlapDirectoriesResolvedNotSuperAdminException ex) {
                throw new RuntimeException("internal error: inconsistent directories setup", ex);
            }
        } else {
            this.directories = rootDirectories;
        }
        this.rootFileSystem = OlapFileSystem.createDataFileSystem(runtime, fileSystemRoot, this.directories);
    }

    private OlapRuntimeContext(OlapFileSystem rootFileSystem) {
        this.appContext = null;
        this.directories = null;
        this.rootFileSystem = rootFileSystem;
    }

    public IOlapEngineApplicationContext getAppContext() {
        return this.appContext;
    }

    @Nullable
    public OlapTenant getTenant() {
        return this.directories != null ? this.directories.getTenant() : null;
    }

    public static OlapRuntimeContext create__(OlapFileSystem rootFileSystem) {
        return new OlapRuntimeContext(rootFileSystem);
    }

    public static OlapRuntimeContext create__(OlapRuntime runtime, @Nullable File fileSystemRoot, OlapDirectories directories) {
        return new OlapRuntimeContext(null, runtime, fileSystemRoot, directories, null);
    }

    public static OlapRuntimeContext create(OlapEngineApplicationContext context) {
        OlapRuntime runtime = context.getRuntime();
        File fileSystemRoot = context.getFileSystemRoot();
        OlapDirectories directories = context.getDirectories();
        return new OlapRuntimeContext(context, runtime, fileSystemRoot, directories, null);
    }

    public static OlapRuntimeContext create(OlapEngineApplicationContext context, OlapTenant tenant) {
        OlapRuntime runtime = context.getRuntime();
        File fileSystemRoot = context.getFileSystemRoot();
        OlapDirectories directories = context.getDirectories();
        return new OlapRuntimeContext(context, runtime, fileSystemRoot, directories, tenant);
    }

    public static OlapRuntimeContext create(OlapEngineSessionContext context) {
        OlapEngineApplicationContext appContext = context.getApplicationContext();
        OlapRuntime runtime = appContext.getRuntime();
        File fileSystemRoot = appContext.getFileSystemRoot();
        OlapDirectories directories = appContext.getDirectories();
        OlapTenant tenant = context.getUserTenant();
        return new OlapRuntimeContext(context.getApplicationContext(), runtime, fileSystemRoot, directories, tenant);
    }

    public static OlapRuntimeContext create(OlapEngineRequestContext context) {
        OlapEngineApplicationContext appContext = context.getApplicationContext();
        if (appContext == null) {
            return OlapRuntimeContext.create__(null);
        }
        OlapRuntime runtime = appContext.getRuntime();
        File fileSystemRoot = appContext.getFileSystemRoot();
        OlapDirectories directories = appContext.getDirectories();
        OlapTenant tenant = context.getUserTenant();
        return new OlapRuntimeContext(context.getApplicationContext(), runtime, fileSystemRoot, directories, tenant);
    }

    public CdVFileSystem getVfs() {
        return this.directories.getVfs();
    }

    public OlapEngineDirectoriesResolved getEngineDirectoriesResolved() {
        return this.directories.asEngineDirectories();
    }

    public OlapDirectoriesResolved getDirectoriesResolved() {
        return this.directories;
    }

    public OlapFileSystem getRootFileSystem() {
        return this.rootFileSystem;
    }

    @Nullable
    public String getUserDefinedProperty(String key) {
        if (this.appContext != null) {
            return this.appContext.getUserDefinedProperty(key);
        }
        return null;
    }

    public File getUserDefinedFile(String userDefinedFileName) {
        File trusted;
        if (CdXmlParametersUtils.startWithParam((String)userDefinedFileName)) {
            String path = CdXmlParametersUtils.replace((String)userDefinedFileName);
            trusted = new File(path);
        } else {
            OlapFileSystem fs = this.getRootFileSystem();
            trusted = fs.create(userDefinedFileName).__getUnderlying();
        }
        return trusted;
    }
}

