/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.context;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextRef;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalConfiguration;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfile;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.component.context.OlapDefaultLoggers;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSessionCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSessionCalculatedMembers;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.catmember.OlapSessionCategoryMemberManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutors;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsManager;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapTransactionStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluation;
import crazydev.iccube.olap.eval.set.OlapSessionSetManager;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.authorization.OlapMaxUserExceededException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
public class OlapEngineSessionContext {
    private final OlapEngineApplicationContext applicationContext;
    private final S_MdxSessionContextRef clusterContextRef;
    private final boolean sessionLess;
    private final String sessionId;
    private final OlapPrincipal user;
    private final IOlapContextLoggers loggers;
    private final OlapMdxExecutors mdxExecutors;
    private final Map<String, SessionSets> allSets = new ConcurrentHashMap<String, SessionSets>();
    private final OlapSessionCategoryMemberManager categoryMemberManager;
    private final Map<String, OlapSessionCalculatedMemberManager> calcMemberManagers = new ConcurrentHashMap<String, OlapSessionCalculatedMemberManager>();

    public OlapEngineSessionContext(OlapEngineApplicationContext applicationContext, boolean sessionLess, String sessionId, OlapPrincipal user, @Nullable IOlapContextLoggers contextLoggers) {
        this.applicationContext = applicationContext;
        this.sessionLess = sessionLess;
        this.sessionId = sessionId;
        this.user = user;
        IOlapContextLoggers iOlapContextLoggers = this.loggers = contextLoggers == null ? OlapDefaultLoggers.INSTANCE : contextLoggers;
        if (applicationContext != null) {
            OlapEngineMdxEvalConfiguration evalConfiguration = applicationContext.getMdxEvalConfiguration();
            OlapMdxExecutorsManager mdxExecutorsManager = applicationContext.getMdxExecutorsManager();
            OlapEngineMdxEvalProfile profile = evalConfiguration.getProfile(user);
            this.mdxExecutors = new OlapMdxExecutors(mdxExecutorsManager, profile);
        } else {
            this.mdxExecutors = null;
        }
        this.categoryMemberManager = new OlapSessionCategoryMemberManager(this);
        this.clusterContextRef = new S_MdxSessionContextRef(this);
        if (applicationContext != null) {
            M_LocalCluster cluster = applicationContext.getCluster();
            cluster.createMdxSessionContext(this.clusterContextRef.createObjectInitData());
        }
    }

    public OlapEngineSessionContext(OlapEngineApplicationContext applicationContext, boolean sessionLess, String sessionId, OlapPrincipal user) {
        this(applicationContext, sessionLess, sessionId, user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionDestroyed() {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            this.allSets.clear();
        }
        this.calcMemberManagers.clear();
        this.categoryMemberManager.onSessionDestroyed();
        if (this.applicationContext != null) {
            M_LocalCluster cluster = this.applicationContext.getCluster();
            cluster.deleteMdxSessionContext(this.clusterContextRef);
        }
    }

    public boolean isSessionLess() {
        return this.sessionLess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaLoadedOnError(OlapSchema schema) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            this.allSets.remove(schema.getName());
        }
        this.categoryMemberManager.onSchemaLoadedOnError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaPartitionsUnloaded(OlapSchema schema, OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                sets.staticSetManager.onSchemaPartitionsUnloaded(unloadPartitionsInfo);
            }
        }
        this.categoryMemberManager.onSchemaPartitionsUnloaded(schema, unloadPartitionsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaPartitionsLoaded(OlapSchema schema, OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                sets.staticSetManager.onSchemaPartitionsLoaded(loadPartitionsInfo);
            }
        }
        this.categoryMemberManager.onSchemaPartitionsLoaded(schema, loadPartitionsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaPartitionsLoadError(OlapSchema schema) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                sets.staticSetManager.onSchemaPartitionsLoadError();
            }
        }
        this.categoryMemberManager.onSchemaPartitionsLoadError(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchema schema, OlapSchemaIncrLoadInfo incrLoadInfo) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                sets.staticSetManager.onSchemaIncrLoaded(context, incrLoadInfo);
            }
        }
        this.categoryMemberManager.onSchemaIncrLoaded(schema, incrLoadInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaIncrLoadedOnError(OlapSchema schema) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                sets.staticSetManager.onSchemaIncrLoadedOnError();
            }
        }
        this.categoryMemberManager.onSchemaIncrLoadedOnError(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaUnloaded(OlapSchema schema) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            this.allSets.remove(schema.getName());
        }
        this.categoryMemberManager.onSchemaUnloaded(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScriptStatementApplied(OlapSchema schema, OlapScriptInformation information) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                sets.staticSetManager.onScriptStatementApplied(information);
            }
        }
        this.categoryMemberManager.onScriptStatementApplied(schema, information);
    }

    public void onSecurityAllPermissionsRemoved(OlapSchema schema) {
        SessionSets sets = this.allSets.get(schema.getName());
        if (sets != null) {
            sets.staticSetManager.onSecurityAllPermissionsRemoved();
        }
        this.categoryMemberManager.onSecurityPermissionsRemoved(schema);
    }

    public void onSecurityPermissionsSwitched(OlapEngineRequestContext context, OlapSchema schema, @Nullable IOlapSchemaPermission permissions) {
        SessionSets sets = this.allSets.get(schema.getName());
        if (sets != null) {
            sets.staticSetManager.onSecurityPermissionsSwitched(context, permissions);
        }
        this.categoryMemberManager.onSecurityPermissionsSwitched(schema, permissions);
    }

    public String __debug() {
        return this.sessionId;
    }

    public OlapPrincipal getUser() {
        return this.user;
    }

    public String getUserName() {
        return this.user.getName();
    }

    public String getUserRoleName() {
        return this.user.getRoleName();
    }

    @Nullable
    public OlapTenant getUserTenant() {
        return this.user.getTenant();
    }

    public void resetUserTenant(@Nullable OlapTenant tenant) {
        this.user.resetTenant(tenant);
    }

    public Locale getUserLocale() {
        Locale userLocale = this.user.getLocale();
        if (userLocale != null) {
            return userLocale;
        }
        OlapEngineApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext == null) {
            return Locale.getDefault();
        }
        OlapEngineComponent engine = applicationContext.getOlapEngineComponent();
        if (engine == null) {
            return Locale.getDefault();
        }
        return engine.getLocale();
    }

    public boolean isForMdxCacheRebuild() {
        return false;
    }

    public OlapEngineApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Nullable
    public IOlapBigBrotherMgr getBigBrotherMgr() {
        return this.applicationContext.getBigBrotherMgr();
    }

    public OlapSessionCategoryMemberManager getSessionCategoryMemberManager() {
        return this.categoryMemberManager;
    }

    public M_BackupManager getOrCreateBackupManager(OlapRuntimeContext runtimeContext) {
        return this.applicationContext.getOrCreateBackupManager(runtimeContext);
    }

    public OlapCacheManager getCacheManager() {
        return this.applicationContext.getCacheManager();
    }

    public OlapFileCleaner getFileCleaner() {
        return this.applicationContext.getFileCleaner();
    }

    public OlapProperties getOlapEngineProperties() {
        return this.applicationContext.getOlapEngineComponent().getProperties();
    }

    public OlapMdxExecutors getMdxExecutors() {
        return this.mdxExecutors;
    }

    public OlapRolePermissions getUserPermissions(OlapRequestId requestId) {
        if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
            OlapLoggers.AUTHORIZATION.debug((Object)("[auth] user [user:" + this.user.getName() + "] [role:" + this.user.getRoleName() + "] [session:" + this.sessionId + "]"));
        }
        try {
            IOlapPermissionsService roleService = this.applicationContext.getAuthorizationService();
            OlapRolePermissions permissions = roleService.authorizeUser(requestId, this.user);
            return permissions;
        }
        catch (OlapMissingRoleException ex) {
            throw new OlapRoleAuthorizationRuntimeException("user/role [" + this.user.getName() + "/" + this.user.getRoleName() + "] is not authorized (missing role)");
        }
        catch (OlapMaxUserExceededException ex) {
            throw new OlapRoleAuthorizationRuntimeException("user/role [" + this.user.getName() + "/" + this.user.getRoleName() + "] is not authorized (user count)");
        }
    }

    public IcCubeRequestStatusManager getRequestStatusManager() {
        return this.applicationContext.getRequestStatusManager();
    }

    public int getIncrLoadCountPerDayLimit() {
        return this.applicationContext.getIncrLoadCountPerDayLimit();
    }

    public boolean isCommunity() {
        return this.applicationContext.isCommunity();
    }

    public boolean isMissing() {
        return this.applicationContext.isMissing();
    }

    public boolean isBackupLicensed() {
        return this.applicationContext.isBackupLicensed();
    }

    public boolean isOfflineCubeLicensed() {
        return this.applicationContext.isOfflineCubeLicensed();
    }

    public boolean isAccessRightsLicensed() {
        return this.applicationContext.isAccessRightsLicensed();
    }

    public boolean isGviLicensed() {
        return this.applicationContext.isGviLicenced();
    }

    public boolean isMmapFactsLicensed() {
        return this.applicationContext.isMmapFactsLicenced();
    }

    public boolean isRealTimeLicensed() {
        return this.applicationContext.isRealTimeLicensed();
    }

    public boolean isIncrLoadLicensed() {
        return this.applicationContext.isIncrLoadLicensed();
    }

    public boolean isSchedulerLicensed() {
        return this.applicationContext.isSchedulerLicensed();
    }

    public boolean isManagementApiLicensed() {
        return this.applicationContext.isManagementApiLicensed();
    }

    public boolean isReportServerLicensed() {
        return this.applicationContext.isReportServerLicensed();
    }

    public boolean isPrintServerLicensed() {
        return this.applicationContext.isPrintServerLicensed();
    }

    public boolean isMultithreadedMdxQueryLicensed() {
        return this.applicationContext.isMultithreadedMdxQueryLicensed();
    }

    public boolean isAsyncLoadReadLicensed() {
        return this.applicationContext.isAsyncLoadReadLicensed();
    }

    public boolean isAsyncLoadProcLicensed() {
        return this.applicationContext.isAsyncLoadProcLicensed();
    }

    public boolean isTablePartitioningLicensed() {
        return this.applicationContext.isTablePartitioningLicensed();
    }

    public boolean isFactsPartitioningLicensed() {
        return this.applicationContext.isFactsPartitioningLicensed();
    }

    public boolean isAllDataSourcesLicensed() {
        return this.applicationContext.isAllDataSourcesLicensed();
    }

    public boolean isPerspectivesLicensed() {
        return this.applicationContext.isPerspectivesLicensed();
    }

    @Nullable
    public String getPoweredBy() {
        return this.applicationContext.getPoweredBy();
    }

    public boolean isMethodsModuleAuthorized(String moduleName) {
        return this.applicationContext.isMethodsModuleAuthorized(moduleName);
    }

    public IOlapContextLoggers getLoggers() {
        return this.loggers;
    }

    public S_MdxSessionContextRef getClusterContextRef() {
        return this.clusterContextRef;
    }

    public void begin() {
    }

    public void rollback() {
    }

    public void commit(OlapTransactionStatementExecutionContext context) {
    }

    public IOlapCalculatedMembers getCalcMemberManagerForLookup(OlapSchema schema, @Nullable OlapCalculatedMemberManager calcMemberManager) {
        OlapSessionCalculatedMemberManager manager = this.calcMemberManagers.get(schema.getName());
        if (manager == null) {
            return calcMemberManager;
        }
        return new OlapSessionCalculatedMembers(manager, calcMemberManager);
    }

    public void addCalcMemberIfNotContained(OlapInstrLocationRange errorLocation, OlapNameContext nameContext, OlapSchema schema, OlapMember calcMember) {
        OlapSessionCalculatedMemberManager manager = this.calcMemberManagers.computeIfAbsent(schema.getName(), OlapSessionCalculatedMemberManager::new);
        manager.addSessionCalcMemberIfNotContained(errorLocation, nameContext, calcMember);
    }

    public void removeCalcMember(OlapNameContext nameContext, OlapEntityIdentifier id, OlapSchema schema, @Nullable OlapCube cube) {
        OlapSessionCalculatedMemberManager manager = this.calcMemberManagers.get(schema.getName());
        if (manager != null) {
            manager.dropSessionCalcMember(nameContext, id, cube);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSessionSet(OlapSchema schema) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            return sets != null && !sets.setDeclarations.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OlapSetDeclaration> getSetDeclarations(OlapSchema schema) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            ArrayList<OlapSetDeclaration> declarations = new ArrayList<OlapSetDeclaration>();
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                for (OlapSetDeclaration declaration : sets.setDeclarations.values()) {
                    declarations.add(new OlapSetDeclaration(declaration.isForSelect(), declaration.getCubeName(), declaration.getSetName(), declaration.isSessionScoped(), declaration.isDynamicEvaluation(), declaration.getMdx(), declaration.getFormula(), declaration.getDisplayFolder(), declaration.getDescription()));
                }
            }
            return declarations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSetDeclaration(OlapSchema schema, String name) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                return sets.setDeclarations.containsKey(name);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapSetDeclaration lookupSetDeclaration(OlapSchema schema, String name) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                return sets.setDeclarations.get(name);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetDeclarationIfNotContained(OlapInstrLocationRange definitionRange, OlapSchema schema, @Nullable String cube, String name, boolean sessionScoped, boolean dynamicEvaluation, String mdx, OlapInstr formula, @Nullable String displayFolder, @Nullable String description) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            if (this.containsSetDeclaration(schema, name)) {
                throw new OlapEvaluationException(definitionRange, OlapErrorCode.DUPLICATED_NAMED_SET, new Serializable[]{name});
            }
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets == null) {
                sets = new SessionSets(schema);
                this.allSets.put(schema.getName(), sets);
            }
            sets.setDeclarations.put(name, new OlapSetDeclaration(false, cube, name, sessionScoped, dynamicEvaluation, mdx, formula, displayFolder, description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSetDeclarations(OlapSchema schema, List<String> names) {
        Map<String, SessionSets> map = this.allSets;
        synchronized (map) {
            SessionSets sets = this.allSets.get(schema.getName());
            if (sets != null) {
                for (String name : names) {
                    OlapSetDeclaration declaration = sets.setDeclarations.remove(name);
                    if (declaration == null) continue;
                    sets.staticSetManager.removeSetDeclaration(declaration);
                }
            }
        }
    }

    @Nullable
    public OlapSetEvaluation getEvaluatedStaticSetDeclaration(OlapEvaluationContext eContext, OlapSetDeclaration setDeclaration) {
        OlapSchema schema = eContext.getSchema();
        SessionSets sets = this.allSets.get(schema.getName());
        if (sets == null) {
            throw new OlapEvaluationException(eContext, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"missing schema [" + String.valueOf(schema) + "] SESSION set [" + setDeclaration.getQualifiedSetName() + "]"});
        }
        return sets.staticSetManager.getEvaluatedStaticSetDeclaration(eContext, setDeclaration);
    }

    public OlapSetEvaluation evaluateStaticSetDeclaration(OlapEvaluationContext eContext, OlapSetDeclaration setDeclaration) {
        OlapSchema schema = eContext.getSchema();
        SessionSets sets = this.allSets.get(schema.getName());
        if (sets == null) {
            throw new OlapEvaluationException(eContext, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"missing schema [" + String.valueOf(schema) + "] SESSION set [" + setDeclaration.getQualifiedSetName() + "]"});
        }
        return sets.staticSetManager.evaluateStaticSetDeclaration(eContext, setDeclaration);
    }

    static class SessionSets {
        final OlapSchema schema;
        final Map<String, OlapSetDeclaration> setDeclarations = new CdCaseInsensitiveHashMap();
        final OlapSessionSetManager staticSetManager;

        SessionSets(OlapSchema schema) {
            this.schema = schema;
            this.staticSetManager = new OlapSessionSetManager(schema);
        }
    }
}

