/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.context;

import crazydev.common.collection.CdCollections;
import crazydev.common.tests.CdTestUtils;
import crazydev.common.utils.CdLocaleUtils;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderLoadMeasureGroupContext;
import crazydev.iccube.builder.OlapBuilderLoadPartitionsContext;
import crazydev.iccube.builder.OlapBuilderUnloadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.executor.pool.OlapBuilderTableExecutorPool;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTaskExecutor;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskExecutor;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.shared.context.S_MdxSessionContextRef;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.common.IOlapContext;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.OlapEngineResultSerializationConfiguration;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCurrent;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfo;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfos;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.catmember.OlapRequestCategoryMemberManager;
import crazydev.iccube.olap.eval.catmember.OlapSessionCategoryMemberManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutors;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFStaticTupleEvaluator;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.select.context.OlapCubeExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapFlatAuthorizationExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapPerspectiveExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSchemaExpressionEvaluationContext;
import crazydev.iccube.olap.executor.IOlapExecutor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDataUpdate;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeActiveRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLock;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapEngineRequestContext
implements IOlapContext {
    private final OlapEngineSessionContext sessionContext;
    private final OlapRequestNamesContext namingService;
    private final OlapRequestId requestId;
    private final Locale locale;
    private final CdXmlaCaller caller;
    private final OlapRolePermissions permissions;
    private final OlapRequestCategoryMemberManager categoryMemberManager;
    private final AtomicReference<IcCubeSchemaAccessLock> schemaAccessLock = new AtomicReference();
    private final AtomicBoolean doNotUseResultCache;
    private final Map<String, IOlapBuilderSchemaDefFactory> schemaFactoryForLoad = new HashMap<String, IOlapBuilderSchemaDefFactory>();
    private final Object rebuildMdxResultCacheInfosLOCK = new Object();
    private final Map<OlapSchema, IOlapSchemaPermission> cachedSchemaPermissionsWithPerspectives = new ConcurrentHashMap<OlapSchema, IOlapSchemaPermission>();
    private final Map<OlapSchema, IOlapSchemaPermission> cachedSchemaPermissionsWithoutPerspectives = new ConcurrentHashMap<OlapSchema, IOlapSchemaPermission>();
    @Nullable
    private OlapSchemaInformation loadingSchemaInformation;
    @Nullable
    private OlapBuilderContext builderContext;
    @Nullable
    private OlapBuilderTableRowReadingTaskExecutor builderReadingExecutor;
    @Nullable
    private OlapBuilderTableRowProcessingTaskExecutor builderProcessingExecutor;
    private boolean scriptStatementAppliedDeactivated;
    private boolean prepareExecutionMode;
    private OlapBuilderLoadEntityContext loadEntityContext;
    private OlapBuilderUnloadEntityContext unloadEntityContext;
    private int loadSchemaTask;
    private OlapSchemaLifeCycleStatus loadedSchemaStatusPhaseI;
    private OlapSchema loadedSchemaPhaseI;
    private OlapBuilderContext incrLoadedBuilderContextPhaseI;
    private OlapSchemaIncrLoadInfo incrLoadedInfoPhaseII;
    @Nullable
    private String frozenSchema;
    private IOlapContextLoggers loggers;
    private volatile boolean reportingMF;
    @Nullable
    private volatile List<OlapCellProperty> mdxDefaultRequestedCellProperties;
    private volatile boolean forTidyEvaluation;
    @Nullable
    private volatile Integer tidyMaxRowCount;
    @Nullable
    private volatile Integer mdxCellCountMax;
    @Nullable
    private volatile Integer mdxTimeoutS;
    @Nullable
    private volatile Integer loadTimeoutS;
    @Nullable
    private volatile IcCubeActiveRequestStatus activeRequestStatus;
    @Nullable
    private OlapMdxResultCacheInfos rebuildMdxResultCacheInfos;

    public OlapEngineRequestContext(OlapEngineSessionContext sessionContext, OlapRequestId requestId, boolean doNotUseResultCache) {
        this(sessionContext, requestId, null, CdXmlaCaller.Generic, sessionContext.getUserPermissions(requestId), null, null, null, null, false, false, doNotUseResultCache, null, null, null);
    }

    public OlapEngineRequestContext(OlapEngineSessionContext sessionContext, OlapRequestId requestId, OlapRolePermissions permissions, boolean doNotUseResultCache) {
        this(sessionContext, requestId, null, CdXmlaCaller.Generic, permissions, null, null, null, null, false, false, doNotUseResultCache, null, null, null);
    }

    public OlapEngineRequestContext(OlapEngineSessionContext sessionContext, OlapRequestId requestId, OlapRolePermissions permissions, @Nullable Locale locale, boolean doNotUseResultCache) {
        this(sessionContext, requestId, locale, CdXmlaCaller.Generic, permissions, null, null, null, null, false, false, doNotUseResultCache, null, null, null);
    }

    public OlapEngineRequestContext(OlapEngineSessionContext sessionContext, OlapRequestId requestId, OlapRolePermissions permissions, @Nullable Locale locale, CdXmlaCaller caller, boolean prepareExecutionMode, boolean doNotUseResultCache) {
        this(sessionContext, requestId, locale, caller, permissions, null, null, null, null, false, prepareExecutionMode, doNotUseResultCache, null, null, null);
    }

    public OlapEngineRequestContext(OlapEngineSessionContext sessionContext, OlapRequestId requestId, @Nullable Locale locale, boolean doNotUseResultCache) {
        this(sessionContext, requestId, locale, CdXmlaCaller.Generic, sessionContext.getUserPermissions(requestId), null, null, null, null, false, false, doNotUseResultCache, null, null, null);
    }

    private OlapEngineRequestContext(OlapEngineSessionContext sessionContext, OlapRequestId requestId, @Nullable Locale locale, CdXmlaCaller caller, OlapRolePermissions permissions, @Nullable OlapSchemaInformation loadingSchemaInformation, @Nullable IcCubeSchemaAccessLock schemaAccessLock, @Nullable OlapBuilderTableRowReadingTaskExecutor builderReadingExecutor, @Nullable OlapBuilderTableRowProcessingTaskExecutor builderProcessingExecutor, boolean scriptStatementAppliedDeactivated, boolean prepareExecutionMode, boolean doNotUseResultCache, @Nullable Integer mdxCellCountMax, @Nullable Integer mdxTimeoutS, @Nullable Integer loadTimeoutS) {
        this.sessionContext = sessionContext;
        this.requestId = requestId;
        this.locale = OlapEngineRequestContext.setupLocale(sessionContext, locale);
        this.caller = caller;
        this.namingService = new OlapRequestNamesContext(this.locale);
        this.permissions = permissions;
        this.loadingSchemaInformation = loadingSchemaInformation;
        this.schemaAccessLock.set(schemaAccessLock);
        this.builderReadingExecutor = builderReadingExecutor;
        this.builderProcessingExecutor = builderProcessingExecutor;
        this.scriptStatementAppliedDeactivated = scriptStatementAppliedDeactivated;
        this.prepareExecutionMode = prepareExecutionMode;
        this.doNotUseResultCache = new AtomicBoolean(doNotUseResultCache);
        this.categoryMemberManager = new OlapRequestCategoryMemberManager(this, sessionContext.getSessionCategoryMemberManager());
        this.loggers = sessionContext.getLoggers();
        this.mdxCellCountMax = mdxCellCountMax;
        this.mdxTimeoutS = mdxTimeoutS;
        this.loadTimeoutS = loadTimeoutS;
    }

    private static Locale setupLocale(OlapEngineSessionContext sessionContext, @Nullable Locale locale) {
        if (locale != null) {
            return locale;
        }
        return sessionContext.getUserLocale();
    }

    public void onRequestDone() {
    }

    @Override
    public OlapRequestId getRequestId() {
        return this.requestId;
    }

    public boolean isSessionLess() {
        return this.sessionContext.isSessionLess();
    }

    public CdXmlaCaller getXmlaCaller() {
        return this.caller;
    }

    @Nullable
    private IcCubeActiveRequestStatus resolveActiveRequestStatus() {
        IcCubeRequestStatusManager statusManager;
        if (this.activeRequestStatus == null && (statusManager = this.getRequestStatusManager()) != null) {
            this.activeRequestStatus = statusManager.getActiveRequestStatus_(this.getRequestClientUUID());
        }
        return this.activeRequestStatus;
    }

    @Override
    public boolean isCancelling() {
        IcCubeActiveRequestStatus status = this.resolveActiveRequestStatus();
        if (status != null) {
            return status.isCancelling();
        }
        return false;
    }

    @Override
    public void assertNotCancelling(String message) {
        IcCubeActiveRequestStatus status = this.resolveActiveRequestStatus();
        if (status != null) {
            status.assertNotCancelling(message);
        }
    }

    public OlapProperties getOlapEngineProperties() {
        return this.sessionContext.getOlapEngineProperties();
    }

    public OlapEngineSessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void doNotUseResultCache() {
        this.doNotUseResultCache.set(true);
    }

    public boolean canUseResultCache(OlapSchema schema) {
        if (this.isCancelling()) {
            this.onDetailAdded("MDX (cache)", "Result NOT stored into cache (CANCELLED)");
            if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
                OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)("[result-cache] MDX " + this.getRequestId().getId() + " result NOT stored into cache (CANCELLED)"));
            }
            return false;
        }
        return !this.doNotUseResultCache.get() && !this.hasSessionSet(schema) && !this.hasSessionCategory(schema);
    }

    private boolean hasSessionSet(OlapSchema schema) {
        return this.sessionContext.hasSessionSet(schema);
    }

    private boolean hasSessionCategory(OlapSchema schema) {
        return this.getSessionCategoryMemberManager().hasCategoryHierarchy(schema);
    }

    public void setupBuilderLoadExecutors(boolean forTableBrowsing) {
        if (this.builderReadingExecutor != null) {
            throw new RuntimeException("internal error : multiple builder-reading-executor not expected");
        }
        if (this.builderProcessingExecutor != null) {
            throw new RuntimeException("internal error : multiple builder-processing-executor not expected");
        }
        OlapEngineComponent engine = this.getOlapEngineComponent();
        OlapBuilderTableExecutorPool pool = engine.getBuilderTableExecutorPool();
        if (forTableBrowsing) {
            this.builderReadingExecutor = pool.getOrCreateTableReadingTaskExecutorForTableBrowsing(this.getOlapEngineProperties());
            this.builderProcessingExecutor = pool.getOrCreateTableProcessingTaskExecutorForTableBrowsing(this.getOlapEngineProperties());
        } else {
            this.builderReadingExecutor = pool.getOrCreateTableReadingTaskExecutor(this.isAsyncLoadReadLicensed(), this.getOlapEngineProperties());
            this.builderProcessingExecutor = pool.getOrCreateTableProcessingTaskExecutor(this.isAsyncLoadProcLicensed(), this.getOlapEngineProperties());
        }
    }

    public OlapBuilderTableRowReadingTaskExecutor getBuilderLoadReadingExecutor() {
        if (this.builderReadingExecutor == null) {
            throw new RuntimeException("internal error : missing builder-reading-executor");
        }
        return this.builderReadingExecutor;
    }

    public OlapBuilderTableRowProcessingTaskExecutor getBuilderLoadProcessingExecutor() {
        if (this.builderProcessingExecutor == null) {
            throw new RuntimeException("internal error : missing builder-processing-executor");
        }
        return this.builderProcessingExecutor;
    }

    @Nullable
    public OlapBuilderTableRowProcessingTaskExecutor getBuilderLoadProcessingExecutorX() {
        return this.builderProcessingExecutor;
    }

    public void releaseBuilderLoadExecutors(boolean forTableBrowsing) {
        OlapEngineComponent engine = this.getOlapEngineComponent();
        OlapBuilderTableExecutorPool pool = engine.getBuilderTableExecutorPool();
        if (forTableBrowsing) {
            pool.releaseTableReadingTaskExecutorForTableBrowsing(this.builderReadingExecutor);
            pool.releaseTableProcessingTaskExecutorForTableBrowsing(this.builderProcessingExecutor);
        } else {
            pool.releaseTableReadingTaskExecutor(this.builderReadingExecutor);
            pool.releaseTableProcessingTaskExecutor(this.builderProcessingExecutor);
        }
        this.builderReadingExecutor = null;
        this.builderProcessingExecutor = null;
    }

    public OlapRequestCategoryMemberManager getRequestCategoryMemberManager() {
        return this.categoryMemberManager;
    }

    public OlapSessionCategoryMemberManager getSessionCategoryMemberManager() {
        return this.sessionContext.getSessionCategoryMemberManager();
    }

    public M_BackupManager getOrCreateBackupManager() {
        return this.sessionContext.getOrCreateBackupManager(this.asRuntimeContext());
    }

    public OlapCacheManager getCacheManager() {
        return this.sessionContext.getCacheManager();
    }

    @Nullable
    public OlapResultCache getOrCreateResultCache(IOlapProtocol protocol, OlapSchema schema) {
        OlapCacheManager cacheManager = this.getCacheManager();
        if (!cacheManager.isResultCacheEnabled(protocol)) {
            return null;
        }
        String roleName = this.getUserRoleName();
        Locale locale = this.getLocale();
        IOlapSchemaPermission perms = this.getSchemaPermissions(schema);
        OlapResultCacheKey key = new OlapResultCacheKey(roleName, locale, schema, perms);
        return cacheManager.getOrCreateResultCache(this, protocol, key);
    }

    @Nullable
    public OlapResultCache getOrCreateResultCacheForAlerts(OlapSchema schema) {
        OlapCacheManager cacheManager = this.getCacheManager();
        if (!cacheManager.isResultCacheEnabledForAlerts()) {
            return null;
        }
        String roleName = this.getUserRoleName();
        Locale locale = this.getLocale();
        IOlapSchemaPermission perms = this.getSchemaPermissions(schema);
        OlapResultCacheKey key = new OlapResultCacheKey(roleName, locale, schema, perms);
        return cacheManager.getOrCreateResultCacheForAlerts(this, key);
    }

    public OlapFileCleaner getFileCleaner() {
        return this.sessionContext.getFileCleaner();
    }

    public OlapMdxExecutors getMdxExecutors() {
        return this.sessionContext.getMdxExecutors();
    }

    public String getRequestClientUUID() {
        return this.requestId.getClientUUID();
    }

    public String getUserName() {
        return this.sessionContext.getUserName();
    }

    public String getUserRoleName() {
        return this.sessionContext.getUserRoleName();
    }

    @Nullable
    public OlapTenant getUserTenant() {
        return this.sessionContext.getUserTenant();
    }

    public void resetUserTenant(@Nullable OlapTenant tenant) {
        this.sessionContext.resetUserTenant(tenant);
    }

    public OlapPrincipal getUser() {
        return this.sessionContext.getUser();
    }

    public OlapBabylonService getBabylonService() {
        Locale locale = this.getLocale();
        return new OlapBabylonService(locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getLocaleForFormattingNumeric(Locale locale) {
        if (locale.getLanguage().equals("fr") && locale.getCountry().equals("CH")) {
            return CdLocaleUtils.fromName((String)"de_CH", (Locale)locale);
        }
        return locale;
    }

    public OlapRolePermissions getCurrentPermissions() {
        return this.permissions;
    }

    public OlapRoleApplicationPermissions getApplicationPermissions() {
        return this.permissions.getApplicationPermissions();
    }

    public IOlapSchemasPermission getSchemasPermissions() {
        return this.permissions.getSchemasPermissions();
    }

    public IOlapSchemaPermission getSchemaPermissions(OlapSchema schema) {
        return this.cachedSchemaPermissionsWithPerspectives.computeIfAbsent(schema, this::doGetSchemaPermissions);
    }

    private IOlapSchemaPermission doGetSchemaPermissions(OlapSchema schema) {
        return this.getSchemasPermissions().getSchemaPermissions(this, schema, true);
    }

    public IOlapSchemaPermission getSchemaPermissionsWithoutPerspective(OlapSchema schema) {
        return this.cachedSchemaPermissionsWithoutPerspectives.computeIfAbsent(schema, this::doGetSchemaPermissionsWithoutPerspective);
    }

    private IOlapSchemaPermission doGetSchemaPermissionsWithoutPerspective(OlapSchema schema) {
        return this.getSchemasPermissions().getSchemaPermissions(this, schema, false);
    }

    @Nullable
    public OlapCube getCubeByName(OlapNameContext nameContext, OlapSchema schema, String cubeName) {
        IOlapSchemaPermission schemaPermissions = this.getSchemaPermissions(schema);
        OlapCube cube = schema.lookupCubeByName(schemaPermissions, nameContext, cubeName);
        return cube;
    }

    public OlapCube getExistingCubeByName(OlapNameContext nameContext, @Nullable OlapErrorLocation location, OlapSchema schema, String cubeName) {
        OlapCube cube = this.getCubeByName(nameContext, schema, cubeName);
        if (cube == null) {
            IOlapSchemaPermission schemaPermissions = this.getSchemaPermissions(schema);
            String availableCubeNames = CdCollections.toString(schema.getCubes(schemaPermissions), (String)"'");
            throw new OlapEvaluationException(location, OlapErrorCode.CUBE_UNKNOWN, new Serializable[]{cubeName, schema.getName(), availableCubeNames});
        }
        return cube;
    }

    public OlapEngineApplicationContext getApplicationContext() {
        return this.sessionContext.getApplicationContext();
    }

    public M_LocalCluster getCluster() {
        OlapEngineApplicationContext appContext = this.getApplicationContext();
        return appContext.getCluster();
    }

    public void deleteMdxStatementContext(@Nullable S_MdxStatementRequestContextRef mdxStatementContextRef) {
        if (mdxStatementContextRef != null) {
            M_LocalCluster cluster = this.getCluster();
            S_MdxSessionContextRef sessionContextRef = this.getSessionContext().getClusterContextRef();
            cluster.deleteMdxStatementRequestContext(sessionContextRef, mdxStatementContextRef);
        }
    }

    public IcCubeRequestStatusManager getRequestStatusManager() {
        return this.sessionContext.getRequestStatusManager();
    }

    public OlapEngineComponent getOlapEngineComponent() {
        return this.getApplicationContext().getOlapEngineComponent();
    }

    public OlapExpressionEvaluationContext setupCubeExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext) {
        return new OlapCubeExpressionEvaluationContext(scontext);
    }

    public OlapExpressionEvaluationContext setupFlatAuthorizationExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext, Map<String, OlapTupleSet> sets, Map<String, OlapDeclaredFunction> functions, @Nullable MdxAuthorizationCurrent current) {
        return new OlapFlatAuthorizationExpressionEvaluationContext(scontext, sets, functions, current);
    }

    public OlapExpressionEvaluationContext setupPerspectiveExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext, IOlapBuilderPerspectiveDef perspective) {
        return new OlapPerspectiveExpressionEvaluationContext(scontext, perspective);
    }

    public OlapExpressionEvaluationContext setupSchemaExpressionExecutionContext(OlapMdxStatementWithCubeSelectExecutionContext scontext) {
        return new OlapSchemaExpressionEvaluationContext(scontext);
    }

    public void onTableReadStarted(boolean facts, String tableName, int partitionCount, Date timestamp) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onTableReadStarted(this.getRequestClientUUID(), facts, tableName, partitionCount, timestamp);
        }
    }

    public void onTablePartitionReadStarted(boolean facts, String tableName, String partitionName, Date timestamp) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onTablePartitionReadStarted(this.getRequestClientUUID(), facts, tableName, partitionName, timestamp);
        }
    }

    public void onTablePartitionReadProgress(boolean facts, String tableName, String partitionName, Date timestamp, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onTablePartitionReadProgress(this.getRequestClientUUID(), facts, tableName, partitionName, timestamp, readRowCount, readRowCountPerSec, processingQueuedTaskCount, processingQueueTaskSize);
        }
    }

    public void onTablePartitionReadCompleted(boolean facts, String tableName, String partitionName, Date timestamp, long rowCount) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onTablePartitionReadCompleted(this.getRequestClientUUID(), facts, tableName, partitionName, timestamp, rowCount);
        }
    }

    public void onTableReadCompleted(OlapBuilderContext context, boolean facts, String tableName, Date timestamp, long rowCount) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onTableReadCompleted(context, this.getRequestClientUUID(), facts, tableName, timestamp, rowCount);
        }
    }

    public void onTableProcessingCompleted(OlapBuilderContext context, boolean facts, String tableName, Date timestamp, long rowCount) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onTableProcessingCompleted(context, this.getRequestClientUUID(), facts, tableName, timestamp, rowCount);
        }
    }

    public void onTablePartitionProcessingCompleted(boolean facts, String tableName, String partitionName, Date timestamp) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onTablePartitionProcessingCompleted(this.getRequestClientUUID(), facts, tableName, partitionName, timestamp);
        }
    }

    public void onProgressEvent(String messageTag, Serializable ... params) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onRequestProgress(this.getRequestClientUUID(), messageTag, params);
        }
    }

    public void onProgressPhase(String messageTag, Serializable ... params) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        if (statusManager != null) {
            statusManager.onRequestProgressPhase(this.getRequestClientUUID(), messageTag, params);
        }
    }

    public void onDetailAdded(String name, String value) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        statusManager.onRequestDetailAdded(this.getRequestClientUUID(), name, value);
    }

    public void onMdxDetailAdded(String name, String schema, String mdx) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        statusManager.onRequestMdxDetailAdded(this.getRequestClientUUID(), name, schema, mdx);
    }

    public void onSqlDetailAdded(String name, String schema, String jdbcDataSource, String mdx) {
        IcCubeRequestStatusManager statusManager = this.getRequestStatusManager();
        statusManager.onRequestSqlDetailAdded(this.getRequestClientUUID(), name, schema, jdbcDataSource, mdx);
    }

    public OlapRolePermissions elevateForBuilderPermissions() {
        return OlapRolePermissions.createElevatedPermissionsForBuilder();
    }

    public OlapEngineRequestContext elevateForBuilder() {
        return new OlapEngineRequestContext(this.sessionContext, this.requestId, this.locale, this.caller, this.elevateForBuilderPermissions(), this.loadingSchemaInformation, this.schemaAccessLock.get(), this.builderReadingExecutor, this.builderProcessingExecutor, this.scriptStatementAppliedDeactivated, this.prepareExecutionMode, true, this.mdxCellCountMax, this.mdxTimeoutS, this.loadTimeoutS);
    }

    public OlapEngineRequestContext elevateForApplyPermissions() {
        OlapRolePermissions elevatedPermissions = OlapRolePermissions.createElevatedPermissionsForApplyPermissions();
        return new OlapEngineRequestContext(this.sessionContext, this.requestId, this.locale, this.caller, elevatedPermissions, this.loadingSchemaInformation, this.schemaAccessLock.get(), this.builderReadingExecutor, this.builderProcessingExecutor, this.scriptStatementAppliedDeactivated, this.prepareExecutionMode, true, this.mdxCellCountMax, this.mdxTimeoutS, this.loadTimeoutS);
    }

    public OlapEngineRequestContext impersonate(String roleName, @Nullable Locale locale) {
        OlapPrincipal reqUser = this.getUser();
        if (!reqUser.isAdministrator()) {
            throw new RuntimeException("internal error: (" + reqUser.getName() + "/" + reqUser.getRoleName() + ") impersonation error (administrator credentials required)");
        }
        OlapEngineApplicationContext appContext = this.getApplicationContext();
        IOlapPermissionsService authorizationService = appContext.getAuthorizationService();
        OlapRolePermissions perms = authorizationService.getRolePermissions(roleName);
        if (perms == null) {
            throw new OlapEvaluationException(IOlapEvaluationExceptionContext.NULL, OlapErrorCode.IMPERSONATION_ROLE_UNKNOWN, new Serializable[]{roleName});
        }
        Locale uLocale = locale == null ? this.locale : locale;
        OlapEngineRequestContext impersonated = new OlapEngineRequestContext(this.sessionContext, this.requestId, uLocale, this.caller, perms, this.loadingSchemaInformation, this.schemaAccessLock.get(), this.builderReadingExecutor, this.builderProcessingExecutor, this.scriptStatementAppliedDeactivated, this.prepareExecutionMode, this.doNotUseResultCache.get(), this.mdxCellCountMax, this.mdxTimeoutS, this.loadTimeoutS);
        impersonated.setupMdxRequestProperties(this.reportingMF, this.mdxDefaultRequestedCellProperties, this.forTidyEvaluation, this.tidyMaxRowCount, this.mdxCellCountMax, this.mdxTimeoutS, this.loadTimeoutS);
        return impersonated;
    }

    public OlapEngineRequestContext createForRestoringActivity() {
        return new OlapEngineRequestContext(this.sessionContext, this.requestId, this.locale, this.caller, this.permissions, this.loadingSchemaInformation, null, null, null, false, false, true, this.mdxCellCountMax, this.mdxTimeoutS, this.loadTimeoutS);
    }

    public OlapEngineRequestContext createForTestWithBackup() {
        return new OlapEngineRequestContext(this.sessionContext, this.requestId, this.locale, this.caller, this.permissions, this.loadingSchemaInformation, null, null, null, false, false, true, this.mdxCellCountMax, this.mdxTimeoutS, this.loadTimeoutS);
    }

    public boolean isDrillthroughDenied(OlapSchema schema) {
        IOlapSchemasPermission schemasPerms = this.getSchemasPermissions();
        IOlapSchemaPermission perms = schemasPerms.getSchemaPermissions(this, schema, true);
        return perms.isDrillthroughDenied();
    }

    public int getIncrLoadCountPerDayLimit() {
        return this.sessionContext.getIncrLoadCountPerDayLimit();
    }

    public boolean isCommunity() {
        return this.sessionContext.isCommunity();
    }

    public boolean isMissing() {
        return this.sessionContext.isMissing();
    }

    public boolean isBackupLicensed() {
        return this.sessionContext.isBackupLicensed();
    }

    public boolean isOfflineCubeLicensed() {
        return this.sessionContext.isOfflineCubeLicensed();
    }

    public boolean isAccessRightsLicensed() {
        return this.sessionContext.isAccessRightsLicensed();
    }

    public boolean isGviLicensed() {
        return this.sessionContext.isGviLicensed();
    }

    public boolean isMmapFactsLicensed() {
        return this.sessionContext.isMmapFactsLicensed();
    }

    public boolean isRealTimeLicensed() {
        return this.sessionContext.isRealTimeLicensed();
    }

    public boolean isIncrLoadLicensed() {
        return this.sessionContext.isIncrLoadLicensed();
    }

    public boolean isSchedulerLicensed() {
        return this.sessionContext.isSchedulerLicensed();
    }

    public boolean isReportServerLicensed() {
        return this.sessionContext.isReportServerLicensed();
    }

    public boolean isPrintServerLicensed() {
        return this.sessionContext.isPrintServerLicensed();
    }

    public boolean isMultithreadedMdxQueryLicensed() {
        return this.sessionContext.isMultithreadedMdxQueryLicensed();
    }

    public boolean isAsyncLoadReadLicensed() {
        return this.sessionContext.isAsyncLoadReadLicensed();
    }

    public boolean isAsyncLoadProcLicensed() {
        return this.sessionContext.isAsyncLoadProcLicensed();
    }

    public boolean isTablePartitioningLicensed() {
        return this.sessionContext.isTablePartitioningLicensed();
    }

    public boolean isFactsPartitioningLicensed() {
        return this.sessionContext.isFactsPartitioningLicensed();
    }

    public boolean isAllDataSourcesLicensed() {
        return this.sessionContext.isAllDataSourcesLicensed();
    }

    public boolean isPerspectivesLicensed() {
        return this.sessionContext.isPerspectivesLicensed();
    }

    @Nullable
    public String getPoweredBy() {
        return this.sessionContext.getPoweredBy();
    }

    public boolean isPrepareExecutionMode() {
        return this.prepareExecutionMode;
    }

    @Nullable
    public OlapSchemaInformation getLoadingSchemaInformation() {
        return this.loadingSchemaInformation;
    }

    public void setLoadingSchemaInformation(OlapSchemaInformation schemaInfo) {
        this.loadingSchemaInformation = schemaInfo;
    }

    public boolean isMethodsModuleAuthorized(String moduleName) {
        return this.sessionContext.isMethodsModuleAuthorized(moduleName);
    }

    public void setSchemaAccessLock(@Nullable IcCubeSchemaAccessLock lock) {
        if (!this.schemaAccessLock.compareAndSet(null, lock)) {
            throw new RuntimeException("internal error: schema read/write lock inconsistency (already set)");
        }
    }

    public void clearAccessReadWriteLock(@Nullable IcCubeSchemaAccessLock lock) {
        if (!this.schemaAccessLock.compareAndSet(lock, null)) {
            throw new RuntimeException("internal error: schema read/write lock inconsistency (unexpected lock)");
        }
    }

    public void assertSchemaAccessLock(IcCubeSchemaAccessLockMode mode, String schema) {
        IcCubeSchemaAccessLock lock = this.schemaAccessLock.get();
        if (lock == null) {
            throw new RuntimeException("internal error: schema [" + schema + "] read/write lock inconsistency (missing lock)");
        }
        if (mode == IcCubeSchemaAccessLockMode.NONE) {
            throw new RuntimeException("internal error: schema [" + schema + "] read/write lock inconsistency (no read/write lock)");
        }
        if (!lock.isAllSchema() && !schema.equals(lock.getSchema())) {
            throw new RuntimeException("internal error: schema [" + schema + "] read/write lock inconsistency (unexpected schema lock [" + lock.getSchema() + "])");
        }
        if (mode == IcCubeSchemaAccessLockMode.WRITE && !lock.isWrite()) {
            throw new RuntimeException("internal error: schema [" + schema + "] read/write lock inconsistency (read lock / expected write lock)");
        }
        if (mode == IcCubeSchemaAccessLockMode.READ && lock.isNone()) {
            throw new RuntimeException("internal error: schema [" + schema + "] read/write lock inconsistency (read lock / expected read lock)");
        }
    }

    public void assertAllSchemaAccessLock(IcCubeSchemaAccessLockMode mode) {
        IcCubeSchemaAccessLock lock = this.schemaAccessLock.get();
        if (lock == null) {
            throw new RuntimeException("internal error: all-schema read/write lock inconsistency (missing lock)");
        }
        if (mode == IcCubeSchemaAccessLockMode.NONE) {
            throw new RuntimeException("internal error: all-schema read/write lock inconsistency (no read/write lock)");
        }
        if (!lock.isAllSchema()) {
            throw new RuntimeException("internal error: all-schema read/write lock inconsistency (unexpected schema lock [" + lock.getSchema() + "])");
        }
        if (mode == IcCubeSchemaAccessLockMode.WRITE && !lock.isWrite()) {
            throw new RuntimeException("internal error: all-schema read/write lock inconsistency (read lock / expected write lock)");
        }
    }

    public String dumpSchemaIndex(String schema) throws IOException {
        return this.getOlapEngineComponent().dumpSchemaIndex(this, schema);
    }

    @Nullable
    public OlapSchemaStats refreshSchemaStatistics(String schema) {
        return this.getOlapEngineComponent().refreshSchemaStatistics(this, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchemaFactoryForLoad(IOlapBuilderSchemaDefFactory factory) {
        File factoryFile = factory.getXmlFile();
        if (factoryFile == null) {
            throw new RuntimeException("internal error: missing schema factory file [" + factory.getSchemaName() + "]");
        }
        Map<String, IOlapBuilderSchemaDefFactory> map = this.schemaFactoryForLoad;
        synchronized (map) {
            try {
                String path = factoryFile.getCanonicalPath();
                Logger logger = this.loggers.builder();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[builder] [schema-factory] set [" + factory.getSchemaName() + "] [" + path + "]"));
                }
                this.schemaFactoryForLoad.put(path, factory);
            }
            catch (IOException ex) {
                String error = "invalid schema factory file name [" + factoryFile.getAbsolutePath() + "]";
                OlapLoggers.GENERAL.error((Object)error, (Throwable)ex);
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{error});
            }
        }
    }

    public IOlapBuilderSchemaDefFactory getOrCreateSchemaFactoryForLoad(File factoryFile) throws OlapBuilderErrorException {
        Map<String, IOlapBuilderSchemaDefFactory> map = this.schemaFactoryForLoad;
        synchronized (map) {
            try {
                IOlapBuilderSchemaDefFactory factory = this.unmarshallSchemaFactoryForLoad(factoryFile);
                return factory;
            }
            catch (IOException ex) {
                String error = "invalid schema factory file name [" + factoryFile.getAbsolutePath() + "]";
                OlapLoggers.GENERAL.error((Object)error, (Throwable)ex);
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{error});
            }
        }
    }

    public File getOrCreateSchemaFactoryForLoad(String schema) throws OlapBuilderErrorException {
        Map<String, IOlapBuilderSchemaDefFactory> map = this.schemaFactoryForLoad;
        synchronized (map) {
            try {
                File factoryFile = this.getFactoryFileFromSchemaName(schema);
                if (factoryFile == null) {
                    String error = "missing schema factory [" + schema + "]";
                    OlapLoggers.GENERAL.error((Object)error);
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{error});
                }
                IOlapBuilderSchemaDefFactory factory = this.unmarshallSchemaFactoryForLoad(factoryFile);
                return factoryFile;
            }
            catch (IOException ex) {
                String error = "invalid schema factory [" + schema + "]";
                OlapLoggers.GENERAL.error((Object)error, (Throwable)ex);
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{error});
            }
        }
    }

    public File getOrCreateSchemaFactoryForRestore(String schema, String timestamp) throws OlapBuilderErrorException {
        if (!this.isBackupLicensed()) {
            OlapLoggers.GENERAL.error((Object)("Not authorized to access (backup) schema definitions [" + schema + "] [" + timestamp + "]"));
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{"Missing schema definitions [" + schema + "] [" + timestamp + "]"});
        }
        Map<String, IOlapBuilderSchemaDefFactory> map = this.schemaFactoryForLoad;
        synchronized (map) {
            try {
                M_BackupManager backupManager = this.getOrCreateBackupManager();
                File factoryFile = backupManager.getSchemaFactoryFileForRestore(schema, timestamp);
                IOlapBuilderSchemaDefFactory factory = this.unmarshallSchemaFactoryForLoad(factoryFile);
                return factoryFile;
            }
            catch (IOException ex) {
                String error = "invalid schema factory [" + schema + "]";
                OlapLoggers.GENERAL.error((Object)error, (Throwable)ex);
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.IO_ERROR, new Serializable[]{error});
            }
        }
    }

    private IOlapBuilderSchemaDefFactory unmarshallSchemaFactoryForLoad(File factoryFile) throws IOException {
        Logger logger = this.loggers.builder();
        String path = factoryFile.getCanonicalPath();
        IOlapBuilderSchemaDefFactory factory = this.schemaFactoryForLoad.get(path);
        if (factory == null) {
            OlapEngineComponent olapEngine = this.getOlapEngineComponent();
            factory = olapEngine.unmarshallXmlFactory(this.asRuntimeContext(), factoryFile);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[builder] [schema-factory] get [+] [" + factory.getSchemaName() + "] [" + path + "]"));
            }
            this.schemaFactoryForLoad.put(path, factory);
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("[builder] [schema-factory] get [-] [" + factory.getSchemaName() + "] [" + path + "]"));
        }
        return factory;
    }

    @Nullable
    public IOlapBuilderSchemaDefFactory getSchemaFactoryForMergeTo(String mergeToSchema) throws OlapBuilderErrorException {
        OlapEngineComponent olapEngine = this.getOlapEngineComponent();
        return olapEngine.getLoadedSchemaFactory(this.asRuntimeContext(), mergeToSchema);
    }

    @Nullable
    public File getFactoryFileFromSchemaName(String schemaName) {
        OlapEngineComponent olapEngine = this.getOlapEngineComponent();
        File file = olapEngine.getSchemaFactoryFile(this.asRuntimeContext(), schemaName);
        return file;
    }

    @Nullable
    public OlapBuilderContext getBuilderContext_() {
        if (this.incrLoadedBuilderContextPhaseI != null) {
            return this.incrLoadedBuilderContextPhaseI;
        }
        return this.builderContext;
    }

    @Nullable
    public OlapBuilderContext getBuilderContext() {
        return this.builderContext;
    }

    public void setBuilderContext(@Nullable OlapBuilderContext builderContext) {
        this.builderContext = builderContext;
    }

    public void deactivateScriptStatementApplied() {
        this.scriptStatementAppliedDeactivated = true;
    }

    public boolean isScriptStatementAppliedDeactivated() {
        return this.scriptStatementAppliedDeactivated;
    }

    public OlapBuilderLoadEntityContext getOrCreateLoadEntityContext(OlapBuilderContextMode mode) {
        if (this.loadEntityContext == null) {
            switch (mode) {
                case LOAD_PARTITIONS: {
                    this.loadEntityContext = new OlapBuilderLoadPartitionsContext(this.loggers.schema(), this.getFileCleaner());
                    break;
                }
                case LOAD_MEASURE_GROUPS: {
                    this.loadEntityContext = new OlapBuilderLoadMeasureGroupContext(this.loggers.schema(), this.getFileCleaner());
                    break;
                }
                default: {
                    throw new RuntimeException("internal error: unsupported mode [" + String.valueOf((Object)mode) + "]");
                }
            }
        }
        return this.loadEntityContext;
    }

    public OlapBuilderUnloadEntityContext getOrCreateUnloadEntityContext(OlapBuilderContextMode mode) {
        if (this.unloadEntityContext == null) {
            switch (mode) {
                case UNLOAD_PARTITIONS: {
                    this.unloadEntityContext = new OlapBuilderUnloadPartitionsContext(this, this.loggers.schema(), this.getFileCleaner());
                    break;
                }
                default: {
                    throw new RuntimeException("internal error: unsupported mode [" + String.valueOf((Object)mode) + "]");
                }
            }
        }
        return this.unloadEntityContext;
    }

    public int getLoadSchemaTask() {
        return this.loadSchemaTask;
    }

    public void setLoadSchemaTask(int val) {
        this.loadSchemaTask = val;
    }

    public OlapSchemaLifeCycleStatus getLoadedSchemaStatusPhaseI() {
        return this.loadedSchemaStatusPhaseI;
    }

    public void setLoadedSchemaStatusPhaseI(OlapSchemaLifeCycleStatus status) {
        this.loadedSchemaStatusPhaseI = status;
    }

    public OlapSchema getLoadedSchemaPhaseI() {
        return this.loadedSchemaPhaseI;
    }

    public void setLoadedSchemaPhaseI(OlapSchema schema) {
        this.loadedSchemaPhaseI = schema;
    }

    public OlapBuilderContext getIncrLoadedBuilderContextPhaseI() {
        return this.incrLoadedBuilderContextPhaseI;
    }

    public void setIncrLoadedBuilderContextPhaseI(OlapBuilderContext builderContext) {
        this.incrLoadedBuilderContextPhaseI = builderContext;
    }

    public void __setIncrLoadedInfoPhaseII(OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.incrLoadedInfoPhaseII = incrLoadInfo;
    }

    public OlapSchemaIncrLoadInfo __getIncrLoadedInfoPhaseII() {
        return this.incrLoadedInfoPhaseII;
    }

    public OlapSchemaFunctionRepositorySnapshot getAuthorizedSchemaFunctionRepositorySnapshot(String schema) {
        OlapEngineComponent olapEngine = this.getOlapEngineComponent();
        OlapRoleApplicationPermissions applicationPermissions = this.getApplicationPermissions();
        IOlapSchemasPermission schemasPermissions = this.getSchemasPermissions();
        return olapEngine.getAuthorizedSchemaFunctionRepositorySnapshot(this.asRuntimeContext(), applicationPermissions, schemasPermissions, schema);
    }

    public OlapRequestNamesContext getNameContext() {
        return this.namingService;
    }

    public IOlapContextLoggers getLoggers() {
        return this.loggers;
    }

    @Nullable
    public OlapSchemaDataUpdate getSchemaNullableLastDataUpdate(String schema) {
        OlapEngineComponent engine = this.getOlapEngineComponent();
        return engine.getSchemaNullableLastDataUpdate(this, schema);
    }

    public long getSchemaLastDataUpdatedTime(String schema) {
        OlapEngineComponent engine = this.getOlapEngineComponent();
        long timestamp = engine.getSchemaLastDataUpdatedTime(this, schema);
        return timestamp;
    }

    public void freezeTaskExecutorForSchema(String schema, int waitS, int cancelS) {
        if (waitS <= 0 || cancelS <= 0) {
            return;
        }
        OlapEngineComponent engine = this.getOlapEngineComponent();
        boolean schemaLoaded = engine.isSchemaLoaded(this.asRuntimeContext(), schema);
        Logger logger = this.loggers.schemaLock();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] freeze (context) for loading schema [" + schema + "] [loaded:" + schemaLoaded + "] [wait:" + waitS + "] [cancel:" + cancelS + "]"));
        }
        if (!schemaLoaded) {
            return;
        }
        IOlapExecutor taskExecutor = this.getApplicationContext().getTaskExecutor();
        if (taskExecutor == null || this.loadedSchemaStatusPhaseI == null) {
            return;
        }
        OlapSchemaLoadStatus loadStatus = this.loadedSchemaStatusPhaseI.getLoadStatus();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] freeze (context) for loading schema [" + schema + "] [status:" + String.valueOf((Object)loadStatus) + "]"));
        }
        switch (loadStatus) {
            case INCREMENTAL_LOADED: 
            case PARTITIONS_LOADED: 
            case UNLOADED: 
            case LOADED: {
                taskExecutor.freezeForSchema(this.loggers.schemaLock(), this.getRequestClientUUID(), schema);
                this.frozenSchema = schema;
            }
        }
        IcCubeRequestStatusManager requestManager = this.getRequestStatusManager();
        requestManager.syncForSchemaLoad(this, logger, this.getRequestClientUUID(), schema, waitS, cancelS);
    }

    public void unfreezeTaskExecutorForSchema() {
        IOlapExecutor taskExecutor;
        Logger logger = this.loggers.schemaLock();
        if (this.frozenSchema == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"[tasks] un-freeze (context) for loading schema not required (no frozen schema)");
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[tasks] un-freeze (context) for loading schema [" + this.frozenSchema + "]"));
        }
        if ((taskExecutor = this.getApplicationContext().getTaskExecutor()) == null) {
            return;
        }
        taskExecutor.unfreezeForSchema(this.loggers.schemaLock(), this.getRequestClientUUID(), this.frozenSchema);
    }

    public void setupMdxRequestProperties(boolean reportingMF, @Nullable List<OlapCellProperty> mdxDefaultRequestedCellProperties, boolean forTidyEvaluation, @Nullable Integer tidyMaxRowCount, @Nullable Integer mdxCellCountMax, @Nullable Integer mdxTimeoutS, @Nullable Integer loadTimeoutS) {
        this.reportingMF = reportingMF;
        this.mdxDefaultRequestedCellProperties = mdxDefaultRequestedCellProperties;
        this.forTidyEvaluation = forTidyEvaluation;
        this.tidyMaxRowCount = tidyMaxRowCount;
        this.mdxCellCountMax = mdxCellCountMax;
        this.mdxTimeoutS = mdxTimeoutS;
        this.loadTimeoutS = loadTimeoutS;
    }

    public boolean isReportingMF() {
        return this.reportingMF;
    }

    @Nullable
    public List<OlapCellProperty> getMdxDefaultRequestedCellProperties() {
        return this.mdxDefaultRequestedCellProperties;
    }

    public boolean isForTidyEvaluation() {
        return CdTestUtils.FORCED_TIDY_EVALUATION || this.forTidyEvaluation;
    }

    public void setTidyMaxRowCount(int tidyMaxRowCount) {
        this.tidyMaxRowCount = tidyMaxRowCount;
    }

    @Nullable
    public Integer getInternalTupleListCount() {
        return null;
    }

    @Nullable
    public Integer getInternalTupleListCountCJ() {
        return null;
    }

    @Nullable
    public Integer getTidyMaxRowCount() {
        return this.tidyMaxRowCount;
    }

    @Nullable
    public Integer getMdxCellCountMax() {
        return this.mdxCellCountMax;
    }

    @Nullable
    public Integer getMdxTimeoutS() {
        return this.mdxTimeoutS;
    }

    public int getLoadTimeoutS() {
        Integer timeout = this.loadTimeoutS;
        return timeout != null ? timeout : -1;
    }

    public GFStaticTupleEvaluator getStaticTupleEvaluator(OlapSchema schema) {
        OlapCacheManager mgr = this.getCacheManager();
        IOlapSchemaPermission perms = this.getSchemaPermissions(schema);
        GFStaticTupleEvaluator evaluator = mgr.getOrCreateStaticTupleEvaluator(perms, schema);
        return evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupRebuildMdxResultCacheInfos() {
        OlapSchemaLoadStatus status;
        if (this.prepareExecutionMode) {
            return;
        }
        if (this.loadedSchemaStatusPhaseI != null && (status = this.loadedSchemaStatusPhaseI.getLoadStatus()) == OlapSchemaLoadStatus.INCREMENTAL_LOADED) {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[builder] MDX result cache rebuild setup");
            }
            Object object = this.rebuildMdxResultCacheInfosLOCK;
            synchronized (object) {
                this.rebuildMdxResultCacheInfos = new OlapMdxResultCacheInfos();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OlapMdxResultCacheInfos getRebuildMdxResultCacheInfos() {
        Object object = this.rebuildMdxResultCacheInfosLOCK;
        synchronized (object) {
            return this.rebuildMdxResultCacheInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMdxResultCacheRemoved(OlapResultCacheKey cache, OlapResultStoreReferenceKey result) {
        try {
            Object object = this.rebuildMdxResultCacheInfosLOCK;
            synchronized (object) {
                OlapMdxResultCacheInfo info;
                OlapSchema cacheSchema;
                OlapSchema schema;
                if (this.rebuildMdxResultCacheInfos != null && this.incrLoadedBuilderContextPhaseI != null && (schema = this.incrLoadedBuilderContextPhaseI.getSchema()).equals(cacheSchema = cache.getSchema()) && (info = result.asMdxResultCacheInfo(cache)) != null) {
                    this.rebuildMdxResultCacheInfos.add(info);
                    if (OlapLoggers.BUILDER.isDebugEnabled()) {
                        OlapLoggers.BUILDER.debug((Object)("[builder] MDX result cache rebuild : MDX count [" + this.rebuildMdxResultCacheInfos.size() + "]"));
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.warn((Object)"[builder] MDX result cache error : could not register the MDX result", (Throwable)ex);
        }
    }

    public boolean isForMdxCacheRebuild() {
        return this.sessionContext.isForMdxCacheRebuild();
    }

    public boolean isJavaViewActivated() {
        return this.getApplicationContext().isJavaViewActivated();
    }

    public boolean isJavaMdxNativesActivated() {
        return this.getApplicationContext().isJavaMdxNativesActivated();
    }

    public void onLoadSchemaStartedPhaseI(String command, OlapSchema schema) {
        OlapEngineComponent engine = this.getOlapEngineComponent();
        engine.loadSchemaStartedPhaseI(this, schema, command);
    }

    public void onLoadSchemaStartedPhaseII(String command, OlapSchema schema) {
        OlapEngineComponent engine = this.getOlapEngineComponent();
        engine.loadSchemaStartedPhaseII(this, schema, command);
    }

    public OlapRuntimeContext asRuntimeContext() {
        return OlapRuntimeContext.create(this);
    }

    public boolean isInCluster() {
        return this.getApplicationContext().isInCluster();
    }

    public OlapEngineResultSerializationConfiguration getResultSerializationConfiguration() {
        OlapEngineComponent engine = this.getOlapEngineComponent();
        OlapEngineComponentConfiguration configuration = engine.getConfiguration();
        return configuration.getResultSerializationConfiguration();
    }
}

