/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.context;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.permissions.service.OlapRolePermissionsServiceWrapper;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.backup.save.M_BackupManagerContainer;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.common.OlapListenerList;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalConfiguration;
import crazydev.iccube.configuration.component.OlapUserDefinedProperties;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.directories.OlapClusterConfiguration;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.housekeeper.M_HouseKeeper;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.notification.OlapNotificationService;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.bigbrother.IOlapBigBrotherMgr;
import crazydev.iccube.olap.component.context.IGCActivityListener;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.mdx.OlapMdxAuditManager;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.executor.IOlapExecutor;
import crazydev.iccube.olap.goodies.incrload.IncrLoadRealTimeInstanceManager;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.colors.OlapEmptySchemaColors;
import crazydev.iccube.olap.schema.localization.OlapEmptySchemaLocalization;
import crazydev.iccube.pub.authentication.OlapAuthenticationServiceException;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.authorization.IOlapRoleDefinitionProvider;
import crazydev.iccube.pub.common.IOlapServiceConfiguration;
import crazydev.iccube.pub.context.IOlapEngineApplicationContext;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.tenants.OlapTenantManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapEngineApplicationContext
implements IOlapEngineApplicationContext {
    public static final String FAKE_SCHEMA_NAME = "ic3_Fake_Schema";
    private static OlapEngineApplicationContext INSTANCE;
    private final OlapClusterConfiguration clusterConfiguration;
    private final boolean withMultiTenant;
    private final OlapTenantManager tenants;
    private final OlapSchema schemaForMdxWithNoSchema;
    private final boolean javaMdxActive;
    private final boolean javaMdxNativeActive;
    private final OlapNotificationService notificationService;
    private final OlapRuntime runtime;
    @Nullable
    private final File fileSystemRoot;
    private final OlapDirectories directories;
    private final IOlapPermissionsService authorizationServiceWrapper;
    private final IcCubeRequestStatusManager serverRequestStatusManager;
    private final M_HouseKeeper houseKeeper;
    private final M_BackupManagerContainer backupManager;
    private final OlapMdxAuditManager mdxAuditManager = new OlapMdxAuditManager();
    private final OlapEngineComponent olapEngineComponent;
    private final OlapMdxExecutorsManager mdxExecutorsManager;
    private final OlapCacheManager cacheManager;
    private final OlapListenerList gcActivityListeners = new OlapListenerList();
    private final Map<String, Object> userDefinedObjects = new HashMap<String, Object>();
    private final OlapUserDefinedProperties userDefinedProperties;
    private final Object getOrCreateSchemaDataDirectoryLOCK = new Object();
    private final Object getOrCreateSchemaFactsMemoryMappedDataDirectoryLOCK = new Object();
    private final Object getOrCreateSchemaIndexMemoryMappedDataDirectoryLOCK = new Object();
    private final Object getOrCreateSchemaTableCacheMemoryMappedDataDirectoryLOCK = new Object();
    private final M_LocalCluster cluster;
    private final ConcurrentHashMap userData = new ConcurrentHashMap();
    private final Map<String, ReentrantLock> locksForTasks = new ConcurrentHashMap<String, ReentrantLock>();
    @Nullable
    private IOlapExecutor taskExecutor;

    public OlapEngineApplicationContext(OlapClusterConfiguration clusterConfiguration, boolean withMultiTenant, OlapTenantManager tenants, boolean javaMdxActive, boolean javaMdxNativeActive, OlapNotificationService notificationService, OlapRuntime runtime, @Nullable File fileSystemRoot, OlapDirectories directories, OlapUserDefinedProperties userDefinedProperties, IOlapPermissionsService authorizationService, final IOlapServiceConfiguration authorizationServiceConfiguration, OlapCacheManager cacheManager, OlapEngineComponent olapEngineComponent, OlapMdxExecutorsManager mdxExecutorsManager, IcCubeRequestStatusManager serverRequestStatusManager, M_BackupManagerContainer backupManager, M_HouseKeeper houseKeeper) throws OlapAuthenticationServiceException {
        this.clusterConfiguration = clusterConfiguration;
        this.withMultiTenant = withMultiTenant;
        this.tenants = tenants;
        this.javaMdxActive = javaMdxActive;
        this.javaMdxNativeActive = javaMdxNativeActive;
        this.notificationService = notificationService;
        this.runtime = runtime;
        this.fileSystemRoot = fileSystemRoot;
        this.directories = directories;
        this.userDefinedProperties = userDefinedProperties;
        this.cacheManager = cacheManager;
        this.olapEngineComponent = olapEngineComponent;
        this.mdxExecutorsManager = mdxExecutorsManager;
        this.serverRequestStatusManager = serverRequestStatusManager;
        this.backupManager = backupManager;
        this.houseKeeper = houseKeeper;
        this.authorizationServiceWrapper = new OlapRolePermissionsServiceWrapper(olapEngineComponent, authorizationService);
        IOlapServiceConfiguration authConfiguration = new IOlapServiceConfiguration(this){
            final /* synthetic */ OlapEngineApplicationContext this$0;
            {
                OlapEngineApplicationContext olapEngineApplicationContext = this$0;
                Objects.requireNonNull(olapEngineApplicationContext);
                this.this$0 = olapEngineApplicationContext;
            }

            @Override
            public List<String> getConfigurationProperties() {
                ArrayList<String> names = new ArrayList<String>();
                names.add("olapEngineAppContext");
                names.addAll(authorizationServiceConfiguration.getConfigurationProperties());
                return names;
            }

            @Override
            public Object getConfigurationProperty(String name) {
                if ("olapEngineAppContext".equals(name)) {
                    return this.this$0;
                }
                return authorizationServiceConfiguration.getConfigurationProperty(name);
            }
        };
        this.authorizationServiceWrapper.configure(authConfiguration);
        if (olapEngineComponent != null) {
            this.cluster = M_LocalCluster.create(olapEngineComponent.getConfiguration(), olapEngineComponent.getCleaner(), serverRequestStatusManager);
            this.schemaForMdxWithNoSchema = new OlapSchema(this, this.getOlapEngineProperties(), new IncrLoadRealTimeInstanceManager(), FAKE_SCHEMA_NAME, "A fake schema used for command processing via an MDX statement", "Fake Schemas", new OlapFunctionRepository(), new OlapEmptySchemaLocalization(), new OlapEmptySchemaColors());
        } else {
            this.cluster = null;
            this.schemaForMdxWithNoSchema = null;
        }
        INSTANCE = this;
    }

    public static OlapEngineApplicationContext get() {
        return INSTANCE;
    }

    public OlapRuntime getRuntime() {
        return this.runtime;
    }

    @Nullable
    public File getFileSystemRoot() {
        return this.fileSystemRoot;
    }

    public OlapDirectories getDirectories() {
        return this.directories;
    }

    public OlapMdxAuditManager getMdxAuditManager() {
        return this.mdxAuditManager;
    }

    @Nullable
    public IOlapExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(IOlapExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public OlapMdxExecutorsManager getMdxExecutorsManager() {
        return this.mdxExecutorsManager;
    }

    public int getLoadedSchemaCount(OlapRuntimeContext context) {
        return this.olapEngineComponent.getLoadedSchemaCount(context);
    }

    @Nullable
    public IOlapBigBrotherMgr getBigBrotherMgr() {
        return this.olapEngineComponent.getBigBrotherMgr();
    }

    public OlapNotificationService getNotificationService() {
        return this.notificationService;
    }

    public M_HouseKeeper getHouseKeeper() {
        return this.houseKeeper;
    }

    public M_BackupManager getOrCreateBackupManager(OlapRuntimeContext runtimeContext) {
        return this.backupManager.getOrCreateBackupManager(runtimeContext);
    }

    public OlapCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void onGCActivity(String name, long elapsedMS, long freeM, long totalM, long maxM) {
        this.fireGCActivity(name, elapsedMS, freeM, totalM, maxM);
    }

    private void fireGCActivity(String name, long elapsedMS, long freeM, long totalM, long maxM) {
        Object[] listeners = this.gcActivityListeners.getListenerList();
        for (int ii = listeners.length - 2; ii >= 0; ii -= 2) {
            if (listeners[ii] != IGCActivityListener.class) continue;
            ((IGCActivityListener)listeners[ii + 1]).onGCActivity(name, elapsedMS, freeM, totalM, maxM);
        }
    }

    public void addGCActivityListener(IGCActivityListener listener) {
        this.gcActivityListeners.add(IGCActivityListener.class, listener);
    }

    public void removeGCActivityListener(IGCActivityListener listener) {
        this.gcActivityListeners.remove(IGCActivityListener.class, listener);
    }

    public OlapFileCleaner getFileCleaner() {
        return this.olapEngineComponent.getCleaner();
    }

    public OlapUserDefinedProperties getUserDefinedProperties() {
        return this.userDefinedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUserDefinedObject(String key) {
        Map<String, Object> map = this.userDefinedObjects;
        synchronized (map) {
            return this.userDefinedObjects.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getUserDefinedObject(String key) {
        Map<String, Object> map = this.userDefinedObjects;
        synchronized (map) {
            Object userDefinedObject = this.userDefinedObjects.get(key);
            if (userDefinedObject == null) {
                throw new CdProgrammingException("internal error : missing object for key [" + key + "]");
            }
            return (T)userDefinedObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setUserDefinedObject(String key, T userDefinedObject) {
        Map<String, Object> map = this.userDefinedObjects;
        synchronized (map) {
            this.userDefinedObjects.put(key, userDefinedObject);
        }
    }

    public int getAuthUserCount() {
        return this.authorizationServiceWrapper.getAuthUserCount();
    }

    public IOlapPermissionsService getAuthorizationService() {
        return this.authorizationServiceWrapper;
    }

    public OlapProperties getOlapEngineProperties() {
        return this.olapEngineComponent.getProperties();
    }

    public OlapEngineComponent getOlapEngineComponent() {
        return this.olapEngineComponent;
    }

    public boolean isIDEA() {
        return this.runtime.isIDEA();
    }

    public boolean isCI() {
        return this.runtime.isCI();
    }

    public File getTmpDirectory() {
        return this.olapEngineComponent.getTmpDirectory();
    }

    public M_LocalCluster getCluster() {
        return this.cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOrCreateSchemaDataDirectory(OlapRuntimeContext context, String schemaName) {
        OlapDirectoriesResolved directories = context.getDirectoriesResolved();
        CdVFileSystem vfs = directories.getVfs();
        File schemaDataDirectory = directories.getSchemaDataDirectory();
        String tenant = directories.getTenantDirectory();
        Object prefix = tenant != null ? tenant + "-" : "";
        File directory = new File(schemaDataDirectory, (String)prefix + CdVFileSystem.toFileName((String)schemaName));
        Object object = this.getOrCreateSchemaDataDirectoryLOCK;
        synchronized (object) {
            vfs.mkdir(directory);
        }
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOrCreateSchemaTableCacheMemoryMappedDataDirectory(OlapRuntimeContext context, String schemaName) {
        File createSchemaDataDirectory = this.getOrCreateSchemaDataDirectory(context, schemaName);
        Object object = this.getOrCreateSchemaTableCacheMemoryMappedDataDirectoryLOCK;
        synchronized (object) {
            return OlapEngineApplicationContext.getOrCreateDirectory(context, new File(createSchemaDataDirectory, "table_cache"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOrCreateSchemaFactsMemoryMappedDataDirectory(OlapRuntimeContext context, String schemaName) {
        File schemaDataDirectory = this.getOrCreateSchemaDataDirectory(context, schemaName);
        Object object = this.getOrCreateSchemaFactsMemoryMappedDataDirectoryLOCK;
        synchronized (object) {
            return OlapEngineApplicationContext.getOrCreateDirectory(context, new File(schemaDataDirectory, "facts_mmap"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOrCreateSchemaIndexMemoryMappedDataDirectory(OlapRuntimeContext context, String schemaName) {
        File schemaDataDirectory = this.getOrCreateSchemaDataDirectory(context, schemaName);
        Object object = this.getOrCreateSchemaIndexMemoryMappedDataDirectoryLOCK;
        synchronized (object) {
            return OlapEngineApplicationContext.getOrCreateDirectory(context, new File(schemaDataDirectory, "index_mmap"));
        }
    }

    private static File getOrCreateDirectory(OlapRuntimeContext context, File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new RuntimeException(String.format("The (existing) requested directory [%s] is not a directory", directory.getPath()));
            }
            return directory;
        }
        CdVFileSystem vfs = context.getVfs();
        if (!vfs.mkdir(directory)) {
            throw new RuntimeException(String.format("Could not created the requested directory [%s]", directory.getPath()));
        }
        return directory;
    }

    public File createCacheTableDirectory(OlapRuntimeContext context, String schemaName) {
        File where = this.getOrCreateSchemaTableCacheMemoryMappedDataDirectory(context, schemaName);
        File directory = this.createDirectoryIntoSchemaDataDirectory(context, where, CdVFileSystemTmpReason.SCHEMA_DATA_TABLE_CACHE);
        return directory;
    }

    public File createFactsColumnDirectory(OlapRuntimeContext context, String schemaName) {
        File where = this.getOrCreateSchemaFactsMemoryMappedDataDirectory(context, schemaName);
        File directory = this.createDirectoryIntoSchemaDataDirectory(context, where, CdVFileSystemTmpReason.SCHEMA_DATA_FACTS_COLUMN);
        return directory;
    }

    public File createFactsIndexDirectory(OlapRuntimeContext context, String schemaName) {
        File where = this.getOrCreateSchemaIndexMemoryMappedDataDirectory(context, schemaName);
        File directory = this.createDirectoryIntoSchemaDataDirectory(context, where, CdVFileSystemTmpReason.SCHEMA_DATA_FACTS_INDEX);
        return directory;
    }

    private File createDirectoryIntoSchemaDataDirectory(OlapRuntimeContext context, File where, CdVFileSystemTmpReason reason) {
        try {
            CdVFileSystem vfs = context.getVfs();
            return vfs.createTmpDirectory(reason, where);
        }
        catch (IOException ex) {
            throw new RuntimeException("could not create the schema data directory for " + String.valueOf(reason));
        }
    }

    public IcCubeRequestStatusManager getRequestStatusManager() {
        return this.serverRequestStatusManager;
    }

    public boolean isInCluster() {
        return this.clusterConfiguration.isActive();
    }

    @Override
    public OlapClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public boolean isWithMultiTenant() {
        return this.withMultiTenant;
    }

    public OlapTenantManager getTenants() {
        return this.tenants;
    }

    protected OlapLixContent getLixContent() {
        OlapLixContent lix;
        OlapLixContent olapLixContent = lix = this.olapEngineComponent != null ? this.olapEngineComponent.getLixContent() : null;
        if (lix == null) {
            throw new RuntimeException("internal error : icCube engine not setup properly");
        }
        return lix;
    }

    public int getIncrLoadCountPerDayLimit() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.getIncrLoadCountPerDayLimit();
    }

    public boolean isAccessRightsLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isAccessRightsAvailable();
    }

    public boolean isPerspectivesLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isPerspectiveAvailable();
    }

    public boolean isOfflineCubeLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isOfflineCubesAvailable();
    }

    public boolean isSchedulerLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isSchedulerAvailable();
    }

    public boolean isManagementApiLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isManagementApiAvailable();
    }

    public boolean isGviLicenced() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isGviAvailable();
    }

    public boolean isMmapFactsLicenced() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isMmapFactsAvailable();
    }

    public boolean isRealTimeLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isRealTimeAvailable();
    }

    public boolean isIncrLoadLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isIncrLoadAvailable();
    }

    public boolean isReportServerLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isReportServerAvailable();
    }

    public boolean isPrintServerLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isPrintServerAvailable();
    }

    public boolean isMultithreadedMdxQueryLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isMultithreadedMdxQueryAvailable();
    }

    public boolean isAsyncLoadReadLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isAsyncLoadReadAvailable();
    }

    public boolean isAsyncLoadProcLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isAsyncLoadProcAvailable();
    }

    public boolean isCommunity() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isCommunity();
    }

    public boolean isMissing() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isMissing();
    }

    public boolean isBackupLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isBackupAvailable();
    }

    public boolean isDocsDbLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isDocsDbAvailable();
    }

    public boolean isTablePartitioningLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isTablePartitioningAvailable();
    }

    public boolean isFactsPartitioningLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isFactsPartitioningAvailable();
    }

    public boolean isAllDataSourcesLicensed() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.isAllDataSourcesAvailable();
    }

    @Nullable
    public String getPoweredBy() {
        OlapLixContent lixContent = this.getLixContent();
        return lixContent.getPoweredByX();
    }

    public OlapEngineMdxEvalConfiguration getMdxEvalConfiguration() {
        OlapEngineComponentConfiguration configuration = this.olapEngineComponent.getConfiguration();
        return configuration.getMdxEvalConfiguration();
    }

    public boolean isMethodsModuleAuthorized(String moduleName) {
        if ("J".equalsIgnoreCase(moduleName)) {
            return this.javaMdxActive || this.javaMdxNativeActive;
        }
        return false;
    }

    public boolean isJavaViewActivated() {
        return this.olapEngineComponent.isJavaViewActivated();
    }

    public boolean isJavaMdxNativesActivated() {
        return this.olapEngineComponent.isJavaMdxNativesActivated();
    }

    public OlapSchema getSchemaForMdxWithNoSchema() {
        return this.schemaForMdxWithNoSchema;
    }

    public IOlapRoleDefinitionProvider getRoleDefinitions() {
        return name -> {
            OlapRoleDefinition def = this.authorizationServiceWrapper.getRoleDefinitionByName(name);
            if (def != null) {
                return def.copy();
            }
            return def;
        };
    }

    @Override
    public <V, K> V computeUserDataIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.userData.computeIfAbsent(key, mappingFunction);
    }

    public <V, K> V get(K key) {
        return this.userData.get(key);
    }

    @Override
    public <V, K> V removeUserData(K key) {
        return this.userData.remove(key);
    }

    @Override
    @Nullable
    public String getUserDefinedProperty(String key) {
        return this.userDefinedProperties.getProperty(key);
    }

    public void executeLockableTaskAsync(Logger logger, String lockUniqueName, Runnable runnable, int timeOutMinutes) {
        ReentrantLock lock = this.locksForTasks.computeIfAbsent(lockUniqueName, key -> new ReentrantLock());
        try (ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "executeLockableTaskAsync : " + lockUniqueName));){
            CompletableFuture<String> futureTask = CompletableFuture.supplyAsync(() -> {
                logger.debug((Object)("[builder] executeLockableTask: in queue " + lockUniqueName));
                try {
                    lock.lockInterruptibly();
                }
                catch (InterruptedException ex) {
                    logger.info((Object)"[builder] executeLockableTask cancelled", (Throwable)ex);
                }
                logger.debug((Object)("[builder] executeLockableTask: starting " + lockUniqueName));
                try {
                    runnable.execute();
                }
                catch (Exception ex) {
                    logger.error((Object)"[builder] executeLockableTask error", (Throwable)ex);
                }
                finally {
                    lock.unlock();
                    logger.debug((Object)("[builder] executeLockableTask : completed " + lockUniqueName));
                }
                return "";
            }, executor);
            if (timeOutMinutes > 0) {
                futureTask = futureTask.orTimeout(timeOutMinutes, TimeUnit.MINUTES);
            }
            futureTask.exceptionally(ex -> {
                if (ex instanceof TimeoutException) {
                    System.out.println("[builder] executeLockableTask : Task timed out and was cancelled.");
                } else {
                    System.out.println("[builder] executeLockableTask : Task encountered an error: " + String.valueOf(ex));
                }
                return null;
            });
        }
    }

    @FunctionalInterface
    public static interface Runnable {
        public void execute() throws Exception;
    }
}

