/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.component.command.builtin;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.OlapBuilderUnloadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.olap.component.command.builtin.OlapEngineUnloadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapLoadEntityHelper;
import crazydev.iccube.olap.component.command.builtin.OlapLoadPartitionsHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapUnloadEntityHelper;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class OlapUnloadPartitionsHelper
extends OlapUnloadEntityHelper<OlapBuilderUnloadPartitionsContext, OlapEngineUnloadPartitionsParams> {
    public OlapUnloadPartitionsHelper(OlapEngineRequestContext olapEngineRequestContext) {
        super(olapEngineRequestContext);
    }

    public OlapSchemaLifeCycleStatus unloadPartitions(OlapEngineUnloadPartitionsParams params) {
        OlapSchemaLifeCycleStatus status = this.unloadEntity(params);
        return status;
    }

    @Override
    protected OlapBuilderContext createBuilderContext(OlapEngineUnloadPartitionsParams params, OlapSchema loadedSchema) {
        return new OlapBuilderContext(this.olapEngineRequestContext, params, OlapBuilderContextMode.UNLOAD_PARTITIONS, null, loadedSchema, loadedSchema.getSchemaDefinition());
    }

    @Override
    protected void unsafeUnloadPhaseI(OlapBuilderUnloadPartitionsContext eContext, OlapEngineUnloadPartitionsParams params, OlapBuilderContext context, OlapSchema loadedSchema) {
        if (!loadedSchema.useFactsPartitioning()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LOAD_PARTITIONS_SCHEMA_NO_PARTITION, new Serializable[]{loadedSchema.getName()});
        }
        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
        IOlapBuilderSchemaDefFactory schemaDefFactory = loadedSchema.getDefinitionFactory();
        IOlapBuilderSchemaDef schemaDef = schemaDefFactory.createSchemaDefinition(connectionPool, errorManager);
        OlapBuilderReferenceSolver referenceSolver = OlapBuilderSchemaMain.createReferenceSolver(errorManager, schemaDef);
        OlapBuilderSchemaMain.solveReferences(errorManager, schemaDef, referenceSolver);
        IOlapBuilderDataTableDef requestedPartitionsTable = OlapLoadPartitionsHelper.setupRequestedPartitionTableDef(params.getDataSourceName(), params.getDataTableName(), schemaDef);
        if (this.schemaLogger.isInfoEnabled()) {
            this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested partitions table [" + requestedPartitionsTable.getName() + "]"));
        }
        Set<IOlapBuilderBaseFactsDef> requestedFactsDefs = OlapLoadPartitionsHelper.setupRequestFactsDefs(this.schemaLogger, eContext.commandForLogsAndErrors(), params.getDataSourceName(), params.getDataTableName(), schemaDef, requestedPartitionsTable);
        if (this.schemaLogger.isInfoEnabled()) {
            for (IOlapBuilderBaseFactsDef requestedFactsDef : requestedFactsDefs) {
                this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested facts [" + requestedFactsDef.getName() + "]"));
            }
        }
        List<OlapBuilderUnloadEntityContext.RequestedCube> requestedCubes = this.setupRequestedCubes(eContext, loadedSchema, requestedFactsDefs);
        if (this.schemaLogger.isInfoEnabled()) {
            for (OlapBuilderUnloadEntityContext.RequestedCube regularCube : requestedCubes) {
                this.schemaLogger.info((Object)("[schema] " + eContext.commandForLogsAndErrors() + " requested cube [" + regularCube.getNameX() + "]"));
            }
        }
    }

    private List<OlapBuilderUnloadEntityContext.RequestedCube> setupRequestedCubes(OlapBuilderUnloadPartitionsContext eContext, OlapSchema schema, Set<IOlapBuilderBaseFactsDef> requestedFactsDefs) {
        List<OlapRegularCube> cubes = schema.getCubes();
        for (OlapRegularCube cube : cubes) {
            List<OlapFactMeasureGroupBaseManager> measureGroups = cube.getMeasureGroups(requestedFactsDefs);
            if (measureGroups.isEmpty()) continue;
            eContext.addRequestedCubes(cube, measureGroups);
        }
        return eContext.getRequestedCubes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsafeUnloadPhaseII(OlapBuilderUnloadPartitionsContext eContext, OlapEngineUnloadPartitionsParams params, OlapSchema schema) {
        try {
            OlapUnresolvedRowsManager uRowsManager = schema.getUnresolvedRowsManager();
            OlapBuilderTableRequestedPartitionKeys partitions = params.getPartitions();
            List<String> partitionKeys = partitions.getKeys();
            for (OlapBuilderUnloadEntityContext.RequestedCube requestedCube : eContext.getRequestedCubes()) {
                OlapRegularCube cube = requestedCube.cube;
                List<OlapFactMeasureGroupBaseManager> measureGroups = requestedCube.measureGroups;
                for (OlapFactMeasureGroupBaseManager measureGroup : measureGroups) {
                    boolean unloadedR = uRowsManager.unloadPartitions(cube, measureGroup, partitionKeys);
                    boolean unloadedC = cube.unloadPartitions(eContext, measureGroup, partitionKeys);
                    if (!unloadedR && !unloadedC) continue;
                    schema.setLastDataUpdatedTime(cube.getLastDataUpdatedTime());
                }
            }
        }
        finally {
            OlapLoadEntityHelper.setupSchemaStatistics(schema);
        }
    }
}

